/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.Utils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchBar
extends JToolBar {
    private static final long serialVersionUID = 1836871286618633003L;
    private static final Logger LOG = LoggerFactory.getLogger(SearchBar.class);
    private static final Color COLOR_BG_ERROR = new Color(0xFFDFDE);
    private static final Color COLOR_BG_WARN = new Color(0xFFFDD9);
    private static final Color COLOR_BG_NORMAL = new Color(0xFFFFFF);
    private static final Icon ICON_UP = Utils.openIcon("arrow_up");
    private static final Icon ICON_DOWN = Utils.openIcon("arrow_down");
    private static final Icon ICON_CLOSE = Utils.openIcon("cross");
    private final RSyntaxTextArea rTextArea;
    private final JTextField searchField;
    private final JCheckBox markAllCB;
    private final JCheckBox regexCB;
    private final JCheckBox wholeWordCB;
    private final JCheckBox matchCaseCB;

    public SearchBar(RSyntaxTextArea textArea) {
        this.rTextArea = textArea;
        JLabel findLabel = new JLabel(NLS.str("search.find") + ":");
        this.add(findLabel);
        this.searchField = new JTextField(30);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        break;
                    }
                    case 27: {
                        SearchBar.this.toggle();
                        break;
                    }
                    default: {
                        SearchBar.this.search(0);
                    }
                }
            }
        });
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.search(1);
            }
        });
        new TextStandardActions(this.searchField);
        this.add(this.searchField);
        JButton prevButton = new JButton(NLS.str("search.previous"));
        prevButton.setIcon(ICON_UP);
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.search(-1);
            }
        });
        prevButton.setBorderPainted(false);
        this.add(prevButton);
        JButton nextButton = new JButton(NLS.str("search.next"));
        nextButton.setIcon(ICON_DOWN);
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.search(1);
            }
        });
        nextButton.setBorderPainted(false);
        this.add(nextButton);
        this.markAllCB = new JCheckBox(NLS.str("search.mark_all"));
        this.markAllCB.addActionListener(new ForwardListener());
        this.add(this.markAllCB);
        this.regexCB = new JCheckBox(NLS.str("search.regex"));
        this.regexCB.addActionListener(new ForwardListener());
        this.add(this.regexCB);
        this.matchCaseCB = new JCheckBox(NLS.str("search.match_case"));
        this.matchCaseCB.addActionListener(new ForwardListener());
        this.add(this.matchCaseCB);
        this.wholeWordCB = new JCheckBox(NLS.str("search.whole_word"));
        this.wholeWordCB.addActionListener(new ForwardListener());
        this.add(this.wholeWordCB);
        JButton closeButton = new JButton();
        closeButton.setIcon(ICON_CLOSE);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.toggle();
            }
        });
        closeButton.setBorderPainted(false);
        this.add(closeButton);
        this.setFloatable(false);
        this.setVisible(false);
    }

    public boolean toggle() {
        boolean visible = !this.isVisible();
        this.setVisible(visible);
        if (visible) {
            this.searchField.requestFocus();
            this.searchField.selectAll();
        } else {
            this.rTextArea.requestFocus();
        }
        return visible;
    }

    private void search(int direction) {
        SearchResult result;
        String searchText = this.searchField.getText();
        if (searchText == null || searchText.length() == 0 || this.rTextArea.getText() == null) {
            return;
        }
        boolean forward = direction >= 0;
        boolean matchCase = this.matchCaseCB.isSelected();
        boolean regex = this.regexCB.isSelected();
        boolean wholeWord = this.wholeWordCB.isSelected();
        SearchContext context = new SearchContext();
        context.setSearchFor(searchText);
        context.setMatchCase(matchCase);
        context.setRegularExpression(regex);
        context.setSearchForward(forward);
        context.setWholeWord(wholeWord);
        context.setMarkAll(this.markAllCB.isSelected());
        if (direction == 0 && !COLOR_BG_ERROR.equals(this.searchField.getBackground())) {
            try {
                int caretPos = this.rTextArea.getCaretPosition();
                int lineNum = this.rTextArea.getLineOfOffset(caretPos) - 1;
                if (lineNum > 1) {
                    this.rTextArea.setCaretPosition(this.rTextArea.getLineStartOffset(lineNum));
                }
            }
            catch (BadLocationException e) {
                LOG.error("Caret move error", (Throwable)e);
            }
        }
        if (!(result = SearchEngine.find((JTextArea)this.rTextArea, (SearchContext)context)).wasFound()) {
            int pos = SearchEngine.getNextMatchPos((String)searchText, (String)this.rTextArea.getText(), (boolean)forward, (boolean)matchCase, (boolean)wholeWord);
            if (pos != -1) {
                this.rTextArea.setCaretPosition(forward ? 0 : this.rTextArea.getDocument().getLength() - 1);
                this.search(direction);
                this.searchField.setBackground(COLOR_BG_WARN);
                return;
            }
            this.searchField.setBackground(COLOR_BG_ERROR);
        } else {
            this.searchField.setBackground(COLOR_BG_NORMAL);
        }
    }

    private class ForwardListener
    implements ActionListener {
        private ForwardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchBar.this.search(0);
        }
    }
}

