/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.util.Tensor;

public class Ellipsoid {
    public short colix = (short)23;
    public boolean visible;
    public boolean isValid;
    public P3 center = P3.new3((float)0.0f, (float)0.0f, (float)0.0f);
    public Tensor tensor;
    public String options;
    boolean isOn = true;
    String id;
    int modelIndex;
    byte pid;
    float[] lengths;
    float scale = 1.0f;
    int percent;
    private static final float[] crtval = new float[]{0.3389f, 0.4299f, 0.4951f, 0.5479f, 0.5932f, 0.6334f, 0.6699f, 0.7035f, 0.7349f, 0.7644f, 0.7924f, 0.8192f, 0.8447f, 0.8694f, 0.8932f, 0.9162f, 0.9386f, 0.9605f, 0.9818f, 1.0026f, 1.023f, 1.043f, 1.0627f, 1.0821f, 1.1012f, 1.12f, 1.1386f, 1.157f, 1.1751f, 1.1932f, 1.211f, 1.2288f, 1.2464f, 1.2638f, 1.2812f, 1.2985f, 1.3158f, 1.333f, 1.3501f, 1.3672f, 1.3842f, 1.4013f, 1.4183f, 1.4354f, 1.4524f, 1.4695f, 1.4866f, 1.5037f, 1.5209f, 1.5382f, 1.5555f, 1.5729f, 1.5904f, 1.608f, 1.6257f, 1.6436f, 1.6616f, 1.6797f, 1.698f, 1.7164f, 1.7351f, 1.754f, 1.773f, 1.7924f, 1.8119f, 1.8318f, 1.8519f, 1.8724f, 1.8932f, 1.9144f, 1.936f, 1.958f, 1.9804f, 2.0034f, 2.0269f, 2.051f, 2.0757f, 2.1012f, 2.1274f, 2.1544f, 2.1824f, 2.2114f, 2.2416f, 2.273f, 2.3059f, 2.3404f, 2.3767f, 2.4153f, 2.4563f, 2.5003f, 2.5478f, 2.5997f, 2.6571f, 2.7216f, 2.7955f, 2.8829f, 2.9912f, 3.1365f, 3.3682f};

    private Ellipsoid() {
    }

    public static Ellipsoid getEmptyEllipsoid(String id, int modelIndex) {
        Ellipsoid e = new Ellipsoid();
        e.id = id;
        e.modelIndex = modelIndex;
        return e;
    }

    public static Ellipsoid getEllipsoidForAtomTensor(Tensor t, Atom center) {
        Ellipsoid e = new Ellipsoid();
        e.tensor = t;
        e.modelIndex = t.modelIndex;
        e.colix = 0;
        e.center = center;
        return e;
    }

    public void setCenter(P3 center) {
        this.center = center;
        this.validate(false);
    }

    public float getLength(int i) {
        if (this.lengths == null) {
            this.setLengths();
        }
        return this.lengths == null ? Float.NaN : this.lengths[i];
    }

    public void setLengths() {
        if (this.tensor == null) {
            return;
        }
        if (this.lengths == null) {
            this.lengths = new float[3];
        }
        for (int i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = this.tensor.getFactoredValue(i) * this.scale;
        }
    }

    public void setScale(float scale, boolean isPercent) {
        if (scale <= 0.0f) {
            this.isValid = false;
            return;
        }
        if (isPercent) {
            if (scale == 2.1474836E9f) {
                scale = this.tensor.forThermalEllipsoid ? 50 : 100;
            }
            this.percent = (int)scale;
            scale = this.tensor.forThermalEllipsoid ? Ellipsoid.getThermalRadius(this.percent) : (this.percent < 1 ? 0.0f : (float)this.percent / 100.0f);
        }
        this.scale = scale;
        this.validate(true);
    }

    public static final float getThermalRadius(int prob) {
        return crtval[prob < 1 ? 0 : (prob > 99 ? 98 : prob - 1)];
    }

    protected void setTensor(Tensor tensor) {
        this.isValid = false;
        this.tensor = tensor;
        this.validate(tensor != null);
    }

    private void validate(boolean andSetLengths) {
        if (this.tensor == null) {
            return;
        }
        if (andSetLengths) {
            this.setLengths();
        }
        this.isValid = true;
    }

    public static void getEquationForQuadricWithCenter(float x, float y, float z, M3 mToElliptical, V3 vTemp, M3 mTemp, double[] coef, M4 mDeriv) {
        vTemp.set(x, y, z);
        mToElliptical.rotate((T3)vTemp);
        double f = 1.0f - vTemp.dot((T3)vTemp);
        mTemp.transposeM(mToElliptical);
        mTemp.rotate((T3)vTemp);
        mTemp.mul(mToElliptical);
        coef[0] = (double)mTemp.m00 / f;
        coef[1] = (double)mTemp.m11 / f;
        coef[2] = (double)mTemp.m22 / f;
        coef[3] = (double)(mTemp.m01 * 2.0f) / f;
        coef[4] = (double)(mTemp.m02 * 2.0f) / f;
        coef[5] = (double)(mTemp.m12 * 2.0f) / f;
        coef[6] = (double)(-2.0f * vTemp.x) / f;
        coef[7] = (double)(-2.0f * vTemp.y) / f;
        coef[8] = (double)(-2.0f * vTemp.z) / f;
        coef[9] = -1.0;
        if (mDeriv == null) {
            return;
        }
        mDeriv.setIdentity();
        mDeriv.m00 = (float)(2.0 * coef[0]);
        mDeriv.m11 = (float)(2.0 * coef[1]);
        mDeriv.m22 = (float)(2.0 * coef[2]);
        mDeriv.m01 = mDeriv.m10 = (float)coef[3];
        mDeriv.m02 = mDeriv.m20 = (float)coef[4];
        mDeriv.m12 = mDeriv.m21 = (float)coef[5];
        mDeriv.m03 = (float)coef[6];
        mDeriv.m13 = (float)coef[7];
        mDeriv.m23 = (float)coef[8];
    }
}

