/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;

public class DefaultTlsDHConfigVerifier
implements TlsDHConfigVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dHGroup) {
        DEFAULT_GROUPS.addElement(dHGroup);
    }

    public DefaultTlsDHConfigVerifier() {
        this(2048);
    }

    public DefaultTlsDHConfigVerifier(int n) {
        this(DEFAULT_GROUPS, n);
    }

    public DefaultTlsDHConfigVerifier(Vector vector, int n) {
        this.groups = vector;
        this.minimumPrimeBits = n;
    }

    public boolean accept(TlsDHConfig tlsDHConfig) {
        return this.checkMinimumPrimeBits(tlsDHConfig) && this.checkGroup(tlsDHConfig);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup dHGroup, DHGroup dHGroup2) {
        return dHGroup == dHGroup2 || this.areParametersEqual(dHGroup.getP(), dHGroup2.getP()) && this.areParametersEqual(dHGroup.getG(), dHGroup2.getG());
    }

    protected boolean areParametersEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger == bigInteger2 || bigInteger.equals(bigInteger2);
    }

    protected boolean checkGroup(TlsDHConfig tlsDHConfig) {
        if (NamedGroup.refersToASpecificFiniteField(tlsDHConfig.getNamedGroup())) {
            return true;
        }
        DHGroup dHGroup = tlsDHConfig.getExplicitGroup();
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dHGroup, (DHGroup)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(TlsDHConfig tlsDHConfig) {
        int n = this.getMinimumPrimeBits();
        int n2 = tlsDHConfig.getNamedGroup();
        if (n2 >= 0) {
            return NamedGroup.getFiniteFieldBits(n2) >= n;
        }
        DHGroup dHGroup = tlsDHConfig.getExplicitGroup();
        return dHGroup.getP().bitLength() >= n;
    }

    static {
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
    }
}

