/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyBinding instance = new RubyBinding(runtime2, klass);
            return instance;
        }
    };

    public RubyBinding(Ruby runtime2, RubyClass rubyClass, Binding binding2) {
        super(runtime2, rubyClass);
        this.binding = binding2;
    }

    private RubyBinding(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createBindingClass(Ruby runtime2) {
        RubyClass bindingClass = runtime2.defineClass("Binding", runtime2.getObject(), BINDING_ALLOCATOR);
        runtime2.setBinding(bindingClass);
        bindingClass.setClassIndex(ClassIndex.BINDING);
        bindingClass.setReifiedClass(RubyBinding.class);
        bindingClass.defineAnnotatedMethods(RubyBinding.class);
        bindingClass.getSingletonClass().undefineMethod("new");
        return bindingClass;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby runtime2, Binding binding2) {
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding());
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2, IRubyObject self2) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding(self2));
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.binding = context.currentBinding();
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyBinding otherBinding = (RubyBinding)other;
        this.binding = otherBinding.binding.clone();
        return this;
    }

    @JRubyMethod(name={"eval"}, required=1, optional=2)
    public IRubyObject eval(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        newArgs[0] = args2[0];
        newArgs[1] = this;
        if (args2.length > 1) {
            newArgs[2] = args2[1];
            if (args2.length > 2) {
                newArgs[3] = args2[2];
            }
        }
        return RubyKernel.eval(context, this, newArgs, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"local_variable_defined?"})
    public IRubyObject local_variable_defined_p(ThreadContext context, IRubyObject symbol) {
        return context.runtime.newBoolean(this.binding.getEvalScope(context.runtime).getStaticScope().isDefined(symbol.asJavaString()) != -1);
    }

    @JRubyMethod
    public IRubyObject local_variable_get(ThreadContext context, IRubyObject symbol) {
        String name2 = symbol.asJavaString().intern();
        DynamicScope evalScope = this.binding.getEvalScope(context.runtime);
        int slot = evalScope.getStaticScope().isDefined(name2);
        if (slot == -1) {
            throw context.runtime.newNameError("local variable `" + name2 + "' not defined for " + this.inspect(), name2);
        }
        return evalScope.getValue(slot & 0xFFFF, slot >> 16);
    }

    @JRubyMethod
    public IRubyObject local_variable_set(ThreadContext context, IRubyObject symbol, IRubyObject value2) {
        String name2 = symbol.asJavaString().intern();
        DynamicScope evalScope = this.binding.getEvalScope(context.runtime);
        int slot = evalScope.getStaticScope().isDefined(name2);
        if (slot == -1) {
            slot = evalScope.getStaticScope().addVariable(name2.intern());
            evalScope.growIfNeeded();
        }
        return evalScope.setValue(slot & 0xFFFF, value2, slot >> 16);
    }

    @JRubyMethod
    public IRubyObject local_variables(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        HashSet<String> encounteredLocalVariables = new HashSet<String>();
        RubyArray allLocalVariables = runtime2.newArray();
        for (DynamicScope currentScope = this.binding.getEvalScope(context.runtime); currentScope != null; currentScope = currentScope.getParentScope()) {
            for (String name2 : currentScope.getStaticScope().getVariables()) {
                if (!IdUtil.isLocal(name2) || encounteredLocalVariables.contains(name2)) continue;
                allLocalVariables.push(runtime2.newSymbol(name2));
                encounteredLocalVariables.add(name2);
            }
        }
        return allLocalVariables;
    }

    @JRubyMethod(name={"receiver"})
    public IRubyObject receiver(ThreadContext context) {
        return this.binding.getSelf();
    }
}

