/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.EmbeddedObject;
import writer2latex.office.FontDeclaration;
import writer2latex.office.FormsReader;
import writer2latex.office.ListStyle;
import writer2latex.office.LoftReader;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeDocument;
import writer2latex.office.OfficeStyle;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageLayout;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.office.TocReader;
import writer2latex.util.Misc;

public class OfficeReader {
    private OfficeDocument oooDoc = null;
    private OfficeStyleFamily font = new OfficeStyleFamily(FontDeclaration.class);
    private OfficeStyleFamily text = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily par = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily section = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily table = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily column = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily row = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily cell = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily frame = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily presentation = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily drawingPage = new OfficeStyleFamily(StyleWithProperties.class);
    private OfficeStyleFamily list = new OfficeStyleFamily(ListStyle.class);
    private OfficeStyleFamily pageLayout = new OfficeStyleFamily(PageLayout.class);
    private OfficeStyleFamily masterPage = new OfficeStyleFamily(MasterPage.class);
    private ListStyle outline = new ListStyle();
    private PropertySet footnotes = null;
    private PropertySet endnotes = null;
    private Element bibliographyConfiguration = null;
    private List<Element> bibliographyMarks = new ArrayList<Element>();
    private StyleWithProperties[] heading = new StyleWithProperties[11];
    private MasterPage firstMasterPage = null;
    private Map<Element, Object> indexes = new Hashtable<Element, Object>();
    private Set<String> indexSourceStyles = new HashSet<String>();
    private Set<String> figureSequenceNames = new HashSet<String>();
    private Set<String> tableSequenceNames = new HashSet<String>();
    private String sAutoFigureSequenceName = null;
    private String sAutoTableSequenceName = null;
    private Map<Element, String> sequenceNames = new Hashtable<Element, String>();
    private Map<String, String> seqrefNames = new Hashtable<String, String>();
    private Set<String> footnoteRef = new HashSet<String>();
    private Set<String> endnoteRef = new HashSet<String>();
    private Set<String> referenceRef = new HashSet<String>();
    private Set<String> bookmarkRef = new HashSet<String>();
    private Set<String> sequenceRef = new HashSet<String>();
    private Map<String, Integer> referenceHeading = new HashMap<String, Integer>();
    private Map<String, Integer> bookmarkHeading = new HashMap<String, Integer>();
    private Map<String, String> bookmarkList = new HashMap<String, String>();
    private Map<String, Integer> bookmarkListLevel = new HashMap<String, Integer>();
    private Set<String> links = new HashSet<String>();
    private FormsReader forms = new FormsReader();
    private Element content = null;
    private Element firstImage = null;
    private boolean bOpenDocument = false;
    private boolean bText = false;
    private boolean bSpreadsheet = false;
    private boolean bPresentation = false;

    public static boolean isTextElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("text:");
    }

    public static boolean isTableElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("table:");
    }

    public static boolean isDrawElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("draw:");
    }

    public static boolean isNoteElement(Node node) {
        return node.getNodeType() == 1 && (node.getNodeName().equals("text:note") || node.getNodeName().equals("text:footnote") || node.getNodeName().equals("text:endnote"));
    }

    public static Element getParagraph(Element node) {
        Element parent = (Element)node.getParentNode();
        if (parent.getTagName().equals("text:p") || parent.getTagName().equals("text:h")) {
            return parent;
        }
        return OfficeReader.getParagraph(parent);
    }

    public static boolean isSingleParagraph(Node node) {
        boolean bFoundPar = false;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("text:p")) {
                if (bFoundPar) {
                    return false;
                }
                bFoundPar = true;
                continue;
            }
            return false;
        }
        return bFoundPar;
    }

    public static boolean isNoTextPar(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child.getNodeType() == 1 ? OfficeReader.isTextElement(child) && !OfficeReader.isWhitespaceContent(child) : child.getNodeType() == 3 && !OfficeReader.isWhitespace(child.getNodeValue()))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespaceContent(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                if (OfficeReader.isTextElement(child)) {
                    if (OfficeReader.isWhitespaceContent(child)) continue;
                    return false;
                }
                return false;
            }
            if (child.getNodeType() != 3 || OfficeReader.isWhitespace(child.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        int nLen = s.length();
        for (int i = 0; i < nLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getCharacterCount(Node node) {
        int nCount = 0;
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 3: {
                    nCount += child.getNodeValue().length();
                    continue block4;
                }
                case 1: {
                    String sName = child.getNodeName();
                    if (sName.equals("text:s")) {
                        nCount += Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1);
                        continue block4;
                    }
                    if (sName.equals("text:tab-stop")) {
                        ++nCount;
                        continue block4;
                    }
                    if (sName.equals("text:tab")) {
                        ++nCount;
                        continue block4;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) continue block4;
                    nCount += OfficeReader.getCharacterCount(child);
                }
            }
        }
        return nCount;
    }

    public static String getTextContent(Node node) {
        String s = "";
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                s = s + OfficeReader.getTextContent(child);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            s = s + child.getNodeValue();
        }
        return s;
    }

    public static char getNextChar(Node node) {
        Node next = node;
        do {
            if ((next = OfficeReader.getNextNode(next)) == null || next.getNodeType() != 3 || next.getNodeValue().length() <= 0) continue;
            return next.getNodeValue().charAt(0);
        } while (next != null);
        return '\u0000';
    }

    private static Node getNextNode(Node node) {
        if (node.getNodeType() == 1 && node.hasChildNodes() && !OfficeReader.isDrawElement(node) && !OfficeReader.isNoteElement(node)) {
            return node.getFirstChild();
        }
        Node next = node;
        do {
            if (next.getNextSibling() != null) {
                return next.getNextSibling();
            }
            if ((next = next.getParentNode()) == null || next.getNodeType() != 1 || !next.getNodeName().equals("text:p")) continue;
            return null;
        } while (next != null);
        return null;
    }

    public boolean isPackageFormat() {
        return this.oooDoc.isPackageFormat();
    }

    public boolean isInPackage(String sUrl) {
        if (!this.bOpenDocument && sUrl.startsWith("#")) {
            return true;
        }
        if (sUrl.startsWith("./")) {
            sUrl = sUrl.substring(2);
        }
        return this.oooDoc.getEmbeddedObject(sUrl) != null;
    }

    public String fixRelativeLink(String sLink) {
        if (this.isOpenDocument() && this.isPackageFormat() && sLink.startsWith("../")) {
            return sLink.substring(3);
        }
        return sLink;
    }

    public EmbeddedObject getEmbeddedObject(String sName) {
        return this.oooDoc.getEmbeddedObject(sName);
    }

    public OfficeStyleFamily getFontDeclarations() {
        return this.font;
    }

    public FontDeclaration getFontDeclaration(String sName) {
        return (FontDeclaration)this.font.getStyle(sName);
    }

    public OfficeStyleFamily getTextStyles() {
        return this.text;
    }

    public StyleWithProperties getTextStyle(String sName) {
        return (StyleWithProperties)this.text.getStyle(sName);
    }

    public OfficeStyleFamily getParStyles() {
        return this.par;
    }

    public StyleWithProperties getParStyle(String sName) {
        return (StyleWithProperties)this.par.getStyle(sName);
    }

    public StyleWithProperties getDefaultParStyle() {
        return (StyleWithProperties)this.par.getDefaultStyle();
    }

    public OfficeStyleFamily getSectionStyles() {
        return this.section;
    }

    public StyleWithProperties getSectionStyle(String sName) {
        return (StyleWithProperties)this.section.getStyle(sName);
    }

    public OfficeStyleFamily getTableStyles() {
        return this.table;
    }

    public StyleWithProperties getTableStyle(String sName) {
        return (StyleWithProperties)this.table.getStyle(sName);
    }

    public OfficeStyleFamily getColumnStyles() {
        return this.column;
    }

    public StyleWithProperties getColumnStyle(String sName) {
        return (StyleWithProperties)this.column.getStyle(sName);
    }

    public OfficeStyleFamily getRowStyles() {
        return this.row;
    }

    public StyleWithProperties getRowStyle(String sName) {
        return (StyleWithProperties)this.row.getStyle(sName);
    }

    public OfficeStyleFamily getCellStyles() {
        return this.cell;
    }

    public StyleWithProperties getCellStyle(String sName) {
        return (StyleWithProperties)this.cell.getStyle(sName);
    }

    public StyleWithProperties getDefaultCellStyle() {
        return (StyleWithProperties)this.cell.getDefaultStyle();
    }

    public OfficeStyleFamily getFrameStyles() {
        return this.frame;
    }

    public StyleWithProperties getFrameStyle(String sName) {
        return (StyleWithProperties)this.frame.getStyle(sName);
    }

    public StyleWithProperties getDefaultFrameStyle() {
        return (StyleWithProperties)this.frame.getDefaultStyle();
    }

    public OfficeStyleFamily getPresentationStyles() {
        return this.presentation;
    }

    public StyleWithProperties getPresentationStyle(String sName) {
        return (StyleWithProperties)this.presentation.getStyle(sName);
    }

    public StyleWithProperties getDefaultPresentationStyle() {
        return (StyleWithProperties)this.presentation.getDefaultStyle();
    }

    public OfficeStyleFamily getDrawingPageStyles() {
        return this.drawingPage;
    }

    public StyleWithProperties getDrawingPageStyle(String sName) {
        return (StyleWithProperties)this.drawingPage.getStyle(sName);
    }

    public StyleWithProperties getDefaultDrawingPageStyle() {
        return (StyleWithProperties)this.drawingPage.getDefaultStyle();
    }

    public OfficeStyleFamily getListStyles() {
        return this.list;
    }

    public ListStyle getListStyle(String sName) {
        return (ListStyle)this.list.getStyle(sName);
    }

    public OfficeStyleFamily getPageLayouts() {
        return this.pageLayout;
    }

    public PageLayout getPageLayout(String sName) {
        return (PageLayout)this.pageLayout.getStyle(sName);
    }

    public OfficeStyleFamily getMasterPages() {
        return this.masterPage;
    }

    public MasterPage getMasterPage(String sName) {
        return (MasterPage)this.masterPage.getStyle(sName);
    }

    public ListStyle getOutlineStyle() {
        return this.outline;
    }

    public PropertySet getFootnotesConfiguration() {
        return this.footnotes;
    }

    public PropertySet getEndnotesConfiguration() {
        return this.endnotes;
    }

    public StyleWithProperties getHeadingStyle(int nLevel) {
        return 1 <= nLevel && nLevel <= 10 ? this.heading[nLevel] : null;
    }

    public MasterPage getFirstMasterPage() {
        return this.firstMasterPage;
    }

    public String getMajorityLanguage() {
        Hashtable<String, Integer> langs = new Hashtable<String, Integer>();
        String sDefaultLang = null;
        StyleWithProperties style = this.getDefaultParStyle();
        if (style != null) {
            sDefaultLang = style.getProperty("fo:language");
        }
        Enumeration<OfficeStyle> enumeration = this.getParStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (StyleWithProperties)enumeration.nextElement();
            String sLang = style.getProperty("fo:language");
            if (sLang == null) {
                sLang = sDefaultLang;
            }
            if (sLang == null) continue;
            int nCount = 1;
            if (langs.containsKey(sLang)) {
                nCount = (Integer)langs.get(sLang) + 1;
            }
            langs.put(sLang, new Integer(nCount));
        }
        int nMaxCount = 0;
        String sMajorityLanguage = null;
        Enumeration langenum = langs.keys();
        while (langenum.hasMoreElements()) {
            String sLang = (String)langenum.nextElement();
            int nCount = (Integer)langs.get(sLang);
            if (nCount <= nMaxCount) continue;
            nMaxCount = nCount;
            sMajorityLanguage = sLang;
        }
        return sMajorityLanguage;
    }

    public TocReader getTocReader(Element onode) {
        if (this.indexes.containsKey(onode)) {
            return (TocReader)this.indexes.get(onode);
        }
        return null;
    }

    public boolean isIndexSourceStyle(String sStyleName) {
        return this.indexSourceStyles.contains(sStyleName);
    }

    public Element getBibliographyConfiguration() {
        return this.bibliographyConfiguration;
    }

    public boolean isFigureSequenceName(String sName) {
        return this.figureSequenceNames.contains(sName);
    }

    public boolean isTableSequenceName(String sName) {
        return this.tableSequenceNames.contains(sName);
    }

    public void addTableSequenceName(String sName) {
        this.tableSequenceNames.add(sName);
    }

    public void addFigureSequenceName(String sName) {
        this.figureSequenceNames.add(sName);
    }

    public String getSequenceName(Element par) {
        return this.sequenceNames.containsKey(par) ? this.sequenceNames.get(par) : null;
    }

    public String getSequenceFromRef(String sRefName) {
        return this.seqrefNames.get(sRefName);
    }

    public boolean hasNoteRefTo(String sId) {
        return this.footnoteRef.contains(sId) || this.endnoteRef.contains(sId);
    }

    public boolean hasFootnoteRefTo(String sId) {
        return this.footnoteRef.contains(sId);
    }

    public boolean hasEndnoteRefTo(String sId) {
        return this.endnoteRef.contains(sId);
    }

    public boolean referenceMarkInHeading(String sName) {
        return this.referenceHeading.containsKey(sName);
    }

    public boolean hasReferenceRefTo(String sName) {
        return this.referenceRef.contains(sName);
    }

    public boolean bookmarkInHeading(String sName) {
        return this.bookmarkHeading.containsKey(sName);
    }

    public int getBookmarkHeadingLevel(String sName) {
        return this.bookmarkHeading.get(sName);
    }

    public boolean bookmarkInList(String sName) {
        return this.bookmarkList.containsKey(sName);
    }

    public String getBookmarkListStyle(String sName) {
        if (this.bookmarkList.containsKey(sName)) {
            return this.bookmarkList.get(sName);
        }
        return null;
    }

    public int getBookmarkListLevel(String sName) {
        if (this.bookmarkListLevel.containsKey(sName)) {
            return this.bookmarkListLevel.get(sName);
        }
        return 0;
    }

    public boolean hasBookmarkRefTo(String sName) {
        return this.bookmarkRef.contains(sName);
    }

    public List<Element> getBibliographyMarks() {
        return this.bibliographyMarks;
    }

    public boolean hasSequenceRefTo(String sId) {
        return this.sequenceRef.contains(sId);
    }

    public boolean hasLinkTo(String sName) {
        return this.links.contains(sName);
    }

    public boolean isOpenDocument() {
        return this.bOpenDocument;
    }

    public boolean isText() {
        return this.bText;
    }

    public boolean isSpreadsheet() {
        return this.bSpreadsheet;
    }

    public boolean isPresentation() {
        return this.bPresentation;
    }

    public Element getContent() {
        return this.content;
    }

    public FormsReader getForms() {
        return this.forms;
    }

    public TableReader getTableReader(Element node) {
        return new TableReader(this, node);
    }

    public Element getFirstImage() {
        return this.firstImage;
    }

    public OfficeReader(OfficeDocument oooDoc, boolean bAllParagraphsAreSoft) {
        this.oooDoc = oooDoc;
        this.loadStylesFromDOM(oooDoc.getStyleDOM(), oooDoc.getContentDOM(), bAllParagraphsAreSoft);
        this.loadContentFromDOM(oooDoc.getContentDOM());
    }

    private void loadStylesFromDOM(Node node, boolean bAllParagraphsAreSoft) {
        boolean bAutomatic = "office:automatic-styles".equals(node.getNodeName());
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                String sFamily;
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                if (child.getNodeName().equals("style:style")) {
                    sFamily = Misc.getAttribute(child, "style:family");
                    if ("text".equals(sFamily)) {
                        this.text.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("paragraph".equals(sFamily)) {
                        this.par.loadStyleFromDOM(child, bAutomatic && !bAllParagraphsAreSoft);
                        continue;
                    }
                    if ("section".equals(sFamily)) {
                        this.section.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("table".equals(sFamily)) {
                        this.table.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("table-column".equals(sFamily)) {
                        this.column.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("table-row".equals(sFamily)) {
                        this.row.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("table-cell".equals(sFamily)) {
                        this.cell.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("graphics".equals(sFamily)) {
                        this.frame.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("graphic".equals(sFamily)) {
                        this.frame.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if ("presentation".equals(sFamily)) {
                        this.presentation.loadStyleFromDOM(child, bAutomatic);
                        continue;
                    }
                    if (!"drawing-page".equals(sFamily) || this.drawingPage.getStyle(Misc.getAttribute(child, "style:name")) != null) continue;
                    this.drawingPage.loadStyleFromDOM(child, bAutomatic);
                    continue;
                }
                if (child.getNodeName().equals("style:page-master")) {
                    this.pageLayout.loadStyleFromDOM(child, bAutomatic);
                    continue;
                }
                if (child.getNodeName().equals("style:page-layout")) {
                    this.pageLayout.loadStyleFromDOM(child, bAutomatic);
                    continue;
                }
                if (child.getNodeName().equals("style:master-page")) {
                    this.masterPage.loadStyleFromDOM(child, bAutomatic);
                    if (this.firstMasterPage != null) continue;
                    this.firstMasterPage = (MasterPage)this.masterPage.getStyle(Misc.getAttribute(child, "style:name"));
                    continue;
                }
                if (child.getNodeName().equals("text:list-style")) {
                    this.list.loadStyleFromDOM(child, bAutomatic);
                    continue;
                }
                if (child.getNodeName().equals("text:outline-style")) {
                    this.outline.loadStyleFromDOM(child);
                    continue;
                }
                if (!child.getNodeName().equals("style:default-style")) continue;
                sFamily = Misc.getAttribute(child, "style:family");
                if ("paragraph".equals(sFamily)) {
                    StyleWithProperties defaultPar = new StyleWithProperties();
                    defaultPar.loadStyleFromDOM(child);
                    this.par.setDefaultStyle(defaultPar);
                    continue;
                }
                if ("graphics".equals(sFamily) || "graphic".equals(sFamily)) {
                    StyleWithProperties defaultFrame = new StyleWithProperties();
                    defaultFrame.loadStyleFromDOM(child);
                    this.frame.setDefaultStyle(defaultFrame);
                    continue;
                }
                if (!"table-cell".equals(sFamily)) continue;
                StyleWithProperties defaultCell = new StyleWithProperties();
                defaultCell.loadStyleFromDOM(child);
                this.cell.setDefaultStyle(defaultCell);
            }
        }
    }

    private void loadStylesFromDOM(Document stylesDOM, Document contentDOM, boolean bAllParagraphsAreSoft) {
        Node node;
        NodeList list = stylesDOM == null ? contentDOM.getElementsByTagName("office:font-decls") : stylesDOM.getElementsByTagName("office:font-decls");
        if (list.getLength() == 0) {
            list = stylesDOM == null ? contentDOM.getElementsByTagName("office:font-face-decls") : stylesDOM.getElementsByTagName("office:font-face-decls");
        }
        if (list.getLength() != 0 && (node = list.item(0)).hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                if (child.getNodeName().equals("style:font-decl")) {
                    this.font.loadStyleFromDOM(child, false);
                    continue;
                }
                if (!child.getNodeName().equals("style:font-face")) continue;
                this.font.loadStyleFromDOM(child, false);
            }
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:styles") : stylesDOM.getElementsByTagName("office:styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:master-styles") : stylesDOM.getElementsByTagName("office:master-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if (stylesDOM != null && (list = stylesDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = contentDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:footnotes-configuration") : stylesDOM.getElementsByTagName("text:footnotes-configuration")).getLength() != 0) {
            this.footnotes = new PropertySet();
            this.footnotes.loadFromDOM(list.item(0));
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:endnotes-configuration") : stylesDOM.getElementsByTagName("text:endnotes-configuration")).getLength() != 0) {
            this.endnotes = new PropertySet();
            this.endnotes.loadFromDOM(list.item(0));
        }
        if (this.footnotes == null || this.endnotes == null) {
            list = stylesDOM == null ? contentDOM.getElementsByTagName("text:notes-configuration") : stylesDOM.getElementsByTagName("text:notes-configuration");
            int nLen = list.getLength();
            for (int i = 0; i < nLen; ++i) {
                String sClass = Misc.getAttribute(list.item(i), "text:note-class");
                if ("endnote".equals(sClass)) {
                    this.endnotes = new PropertySet();
                    this.endnotes.loadFromDOM(list.item(i));
                    continue;
                }
                this.footnotes = new PropertySet();
                this.footnotes.loadFromDOM(list.item(i));
            }
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:bibliography-configuration") : stylesDOM.getElementsByTagName("text:bibliography-configuration")).getLength() != 0) {
            this.bibliographyConfiguration = (Element)list.item(0);
        }
    }

    private void loadContentFromDOM(Document contentDOM) {
        NodeList list = contentDOM.getElementsByTagName("office:body");
        if (list.getLength() > 0) {
            Element body = (Element)list.item(0);
            this.content = Misc.getChildByTagName(body, "office:text");
            if (this.content != null) {
                this.bOpenDocument = true;
                this.bText = true;
            } else {
                this.content = Misc.getChildByTagName(body, "office:spreadsheet");
                if (this.content != null) {
                    this.bOpenDocument = true;
                    this.bSpreadsheet = true;
                } else {
                    this.content = Misc.getChildByTagName(body, "office:presentation");
                    if (this.content != null) {
                        this.bOpenDocument = true;
                        this.bPresentation = true;
                    } else {
                        this.content = body;
                        this.bSpreadsheet = true;
                        this.bPresentation = false;
                        for (Node child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (child.getNodeType() != 1) continue;
                            String sName = child.getNodeName();
                            if ("text:p".equals(sName)) {
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if ("text:h".equals(sName)) {
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if ("text:ordered-list".equals(sName)) {
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if ("text:ordered-list".equals(sName)) {
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if ("text:section".equals(sName)) {
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if ("draw:page".equals(sName)) {
                                this.bPresentation = true;
                                this.bSpreadsheet = false;
                                continue;
                            }
                            if (!"draw:page".equals(sName)) continue;
                            this.bSpreadsheet = false;
                        }
                        this.bText = !this.bSpreadsheet && !this.bPresentation;
                    }
                }
            }
            this.traverseContent(body, null, 0, -1);
            if (this.sAutoFigureSequenceName != null) {
                this.addFigureSequenceName(this.sAutoFigureSequenceName);
            }
            if (this.sAutoTableSequenceName != null) {
                this.addTableSequenceName(this.sAutoTableSequenceName);
            }
        }
    }

    private void traverseContent(Element node, String sListStyleName, int nListLevel, int nParLevel) {
        Element image;
        String sName = node.getTagName();
        if (sName.equals("text:p")) {
            nParLevel = 0;
        } else if (sName.equals("text:h")) {
            int nLevel = node.hasAttribute("text:outline-level") ? Misc.getPosInteger(node.getAttribute("text:outline-level"), 1) : Misc.getPosInteger(node.getAttribute("text:level"), 1);
            nParLevel = nLevel;
            StyleWithProperties style = this.getParStyle(node.getAttribute("text:style-name"));
            if (1 <= nLevel && nLevel <= 10 && this.heading[nLevel] == null) {
                this.heading[nLevel] = style != null && style.isAutomatic() ? this.getParStyle(style.getParentName()) : style;
            }
        } else if (sName.equals("text:list") || sName.equals("text:ordered-list") || sName.equals("text:unordered-list")) {
            ++nListLevel;
            String sStyleName = Misc.getAttribute(node, "text:style-name");
            if (sStyleName != null) {
                sListStyleName = sStyleName;
            }
        } else if (sName.equals("text:note") || sName.equals("text:footnote") || sName.equals("text:endnote") || sName.equals("table:table")) {
            sListStyleName = null;
            nListLevel = 0;
            nParLevel = -1;
        } else if (sName.equals("text:sequence")) {
            String sSeqName = Misc.getAttribute(node, "text:name");
            String sRefName = Misc.getAttribute(node, "text:ref-name");
            if (sSeqName != null) {
                Element par = OfficeReader.getParagraph(node);
                if (!this.sequenceNames.containsKey(par)) {
                    this.sequenceNames.put(par, sSeqName);
                }
                if (sRefName != null) {
                    this.seqrefNames.put(sRefName, sSeqName);
                }
            }
        } else if (sName.equals("text:footnote-ref")) {
            this.collectRefName(this.footnoteRef, node);
        } else if (sName.equals("text:endnote-ref")) {
            this.collectRefName(this.endnoteRef, node);
        } else if (sName.equals("text:note-ref")) {
            String sClass = Misc.getAttribute(node, "text:note-class");
            if ("footnote".equals(sClass)) {
                this.collectRefName(this.footnoteRef, node);
            } else if ("endnote".equals(sClass)) {
                this.collectRefName(this.endnoteRef, node);
            }
        } else if (sName.equals("text:reference-mark")) {
            this.collectMarkByPosition(this.referenceHeading, null, null, node, sListStyleName, nListLevel, nParLevel);
        } else if (sName.equals("text:reference-mark-start")) {
            this.collectMarkByPosition(this.referenceHeading, null, null, node, sListStyleName, nListLevel, nParLevel);
        } else if (sName.equals("text:reference-ref")) {
            this.collectRefName(this.referenceRef, node);
        } else if (sName.equals("text:bookmark")) {
            this.collectMarkByPosition(this.bookmarkHeading, this.bookmarkList, this.bookmarkListLevel, node, sListStyleName, nListLevel, nParLevel);
        } else if (sName.equals("text:bookmark-start")) {
            this.collectMarkByPosition(this.bookmarkHeading, this.bookmarkList, this.bookmarkListLevel, node, sListStyleName, nListLevel, nParLevel);
        } else if (sName.equals("text:bookmark-ref")) {
            this.collectRefName(this.bookmarkRef, node);
        } else if (sName.equals("text:bibliography-mark")) {
            this.bibliographyMarks.add(node);
        } else if (sName.equals("text:sequence-ref")) {
            this.collectRefName(this.sequenceRef, node);
        } else if (sName.equals("text:a")) {
            String sHref = node.getAttribute("xlink:href");
            if (sHref != null && sHref.startsWith("#")) {
                this.links.add(sHref.substring(1));
            }
        } else if (sName.equals("office:forms")) {
            this.forms.read(node);
        } else if (sName.equals("text:table-of-content")) {
            TocReader tocReader = new TocReader(node);
            this.indexes.put(node, tocReader);
            this.indexSourceStyles.addAll(tocReader.getIndexSourceStyles());
        } else if (sName.equals("text:table-index") || sName.equals("text:illustration-index")) {
            LoftReader loftReader = new LoftReader(node);
            this.indexes.put(node, loftReader);
            if (loftReader.useCaption()) {
                if (loftReader.isTableIndex()) {
                    this.tableSequenceNames.add(loftReader.getCaptionSequenceName());
                } else {
                    this.figureSequenceNames.add(loftReader.getCaptionSequenceName());
                }
            }
        } else if (this.firstImage == null && sName.equals("draw:frame") && (image = Misc.getChildByTagName(node, "draw:image")) != null) {
            this.firstImage = image;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.traverseContent((Element)child, sListStyleName, nListLevel, nParLevel);
        }
        if ((this.sAutoFigureSequenceName == null || this.sAutoTableSequenceName == null) && sName.equals("text:p")) {
            String sStyleName = this.getParStyles().getDisplayName(node.getAttribute("text:style-name"));
            if (this.sAutoFigureSequenceName == null && "Illustration".equals(sStyleName)) {
                this.sAutoFigureSequenceName = this.getSequenceName(node);
            }
            if (this.sAutoTableSequenceName == null && "Table".equals(sStyleName)) {
                this.sAutoTableSequenceName = this.getSequenceName(node);
            }
        }
    }

    private void collectRefName(Set<String> ref, Element node) {
        String sRefName = node.getAttribute("text:ref-name");
        if (sRefName != null && sRefName.length() > 0) {
            ref.add(sRefName);
        }
    }

    private void collectMarkByPosition(Map<String, Integer> headingmarklevels, Map<String, String> listmarknames, Map<String, Integer> listmarklevels, Element node, String sListStyleName, int nListLevel, int nParLevel) {
        String sName = node.getAttribute("text:name");
        if (sName != null && sName.length() > 0) {
            if (nParLevel > 0) {
                headingmarklevels.put(sName, nParLevel);
            } else if (listmarknames != null && nListLevel > 0) {
                listmarknames.put(sName, sListStyleName);
                listmarklevels.put(sName, nListLevel);
            }
        }
    }
}

