/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyExpressionEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLEquivalentObjectPropertiesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLEquivalentObjectPropertiesAxiomFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression> {
    public static final String LABEL = "Equivalent To";
    private Set<OWLEquivalentObjectPropertiesAxiom> added = new HashSet<OWLEquivalentObjectPropertiesAxiom>();

    public OWLEquivalentObjectPropertiesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(editorKit, LABEL, "Equivalent object property", frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        this.added.clear();
        for (OWLEquivalentObjectPropertiesAxiom ax : ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)this.getRootObject())) {
            this.addRow(new OWLEquivalentObjectPropertiesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_OBJECT_PROPERTIES, () -> {
            OWLEquivalentObjectPropertiesAxiom ax;
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            Node equivalentObjectProperties = this.getReasoner().getEquivalentObjectProperties((OWLObjectPropertyExpression)this.getRootObject());
            if (!equivalentObjectProperties.getEntitiesMinus((OWLObject)this.getRootObject()).isEmpty() && !this.added.contains(ax = this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(equivalentObjectProperties.getEntities()))) {
                this.addInferredRowIfNontrivial(new OWLEquivalentObjectPropertiesAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLObjectProperty)this.getRootObject(), ax));
            }
        });
    }

    @Override
    protected OWLEquivalentObjectPropertiesAxiom createAxiom(OWLObjectPropertyExpression object) {
        return this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{(OWLObjectPropertyExpression)this.getRootObject(), object}));
    }

    @Override
    public OWLObjectEditor<OWLObjectPropertyExpression> getObjectEditor() {
        return new OWLObjectPropertyExpressionEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<OWLObjectPropertyExpression> editor) {
        Set<OWLObjectPropertyExpression> equivalents = editor.getEditedObjects();
        return equivalents.size() != 1 || !equivalents.contains(this.getRootObject());
    }

    @Override
    public void handleEditingFinished(Set<OWLObjectPropertyExpression> editedObjects) {
        editedObjects = new HashSet<OWLObjectPropertyExpression>(editedObjects);
        editedObjects.remove(this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLEquivalentObjectPropertiesAxiom && ((OWLEquivalentObjectPropertiesAxiom)change.getAxiom()).getProperties().contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression>> getRowComparator() {
        return null;
    }
}

