/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.framelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.axiom.AxiomAnnotationPanel;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameListener;
import org.protege.editor.owl.ui.frame.OWLFrameObject;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.framelist.AxiomAnnotationButton;
import org.protege.editor.owl.ui.framelist.ExplainButton;
import org.protege.editor.owl.ui.framelist.MoveAxiomsToOntologyAction;
import org.protege.editor.owl.ui.framelist.OWLFrameListInferredSectionRowBorder;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.protege.editor.owl.ui.framelist.OWLFrameListRenderer;
import org.protege.editor.owl.ui.framelist.PullIntoActiveOntologyAction;
import org.protege.editor.owl.ui.framelist.SwitchToDefiningOntologyAction;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponentMediator;
import org.protege.editor.owl.ui.transfer.OWLObjectDataFlavor;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.Copyable;
import org.protege.editor.owl.ui.view.Cuttable;
import org.protege.editor.owl.ui.view.Deleteable;
import org.protege.editor.owl.ui.view.Pasteable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLFrameList<R>
extends MList
implements LinkedObjectComponent,
DropTargetListener,
Copyable,
Pasteable,
Cuttable,
Deleteable,
RefreshableComponent {
    private static final int EDITOR_SCREEN_MARGIN = 100;
    private final Logger logger = LoggerFactory.getLogger(OWLFrameList.class);
    private static final Border inferredBorder = new OWLFrameListInferredSectionRowBorder();
    public static final Color INFERRED_BG_COLOR = new Color(255, 255, 215);
    public static final int BUTTON_DIMENSION = 14;
    public static final int BUTTON_MARGIN = 3;
    private final OWLModelManagerListener modelManagerListener;
    private OWLEditorKit editorKit;
    private OWLFrame<R> frame;
    private OWLFrameListener listener;
    private LinkedObjectComponentMediator mediator;
    private List<MListButton> inferredRowButtons;
    private AxiomAnnotationButton axiomAnnotationButton;
    private ChangeListenerMediator changeListenerMediator;
    private JPopupMenu popupMenu;
    private List<OWLFrameListPopupMenuAction<R>> actions;
    private OWLFrameListRenderer cellRenderer;
    private ListSelectionListener selListener = event -> this.handleSelectionEvent(event);
    private boolean axiomSelectionGlobal = true;
    private boolean dragOver;

    public OWLFrameList(OWLEditorKit editorKit, OWLFrame<R> frame) {
        this.editorKit = editorKit;
        this.frame = frame;
        this.cellRenderer = new OWLFrameListRenderer(editorKit);
        this.setCellRenderer(this.cellRenderer);
        this.getSelectionModel().setSelectionMode(2);
        this.mediator = new LinkedObjectComponentMediator(editorKit, this);
        this.setupFrameListener();
        this.setupKeyboardHandlers();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OWLFrameList.this.setFixedCellWidth(OWLFrameList.this.getWidth());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                OWLFrameList.this.repaint();
            }
        });
        this.createPopupMenu();
        this.inferredRowButtons = new ArrayList<MListButton>();
        this.inferredRowButtons.add(new ExplainButton(e -> this.invokeExplanationHandler()));
        this.axiomAnnotationButton = new AxiomAnnotationButton(event -> this.invokeAxiomAnnotationHandler());
        this.changeListenerMediator = new ChangeListenerMediator();
        this.addListSelectionListener(this.selListener);
        this.setUI(new OWLFrameListUI());
        this.modelManagerListener = event -> {
            if (event.isType(EventType.ONTOLOGY_CLASSIFIED) || event.isType(EventType.REASONER_CHANGED)) {
                this.setRootObject(this.getRootObject());
            }
        };
        editorKit.getOWLModelManager().addListener(this.modelManagerListener);
    }

    public void refreshComponent() {
        this.refillRows();
    }

    public OWLFrame<R> getFrame() {
        return this.frame;
    }

    private void setupFrameListener() {
        this.listener = () -> this.refillRows();
        this.frame.addFrameListener(this.listener);
    }

    public void setHighlightUnsatifiableClasses(boolean b) {
        this.cellRenderer.setHighlightUnsatisfiableClasses(b);
    }

    public void setHighlightUnsatisfiableProperties(boolean b) {
        this.cellRenderer.setHighlightUnsatisfiableProperties(b);
    }

    public void setCrossedOutEntities(Set<OWLEntity> entities) {
        this.cellRenderer.setCrossedOutEntities(entities);
    }

    public void updateUI() {
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OWLFrameSectionRow row;
        Border border = super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
        if (value instanceof OWLFrameSectionRow && (row = (OWLFrameSectionRow)value).isInferred()) {
            border = BorderFactory.createCompoundBorder(border, inferredBorder);
        }
        return border;
    }

    protected List<MListButton> getButtons(Object value) {
        List<MListButton> additional;
        ArrayList<MListButton> buttons = new ArrayList<MListButton>(super.getButtons(value));
        if (value instanceof OWLFrameSectionRow) {
            OWLFrameSectionRow frameRow = (OWLFrameSectionRow)value;
            buttons.add(this.axiomAnnotationButton);
            this.axiomAnnotationButton.setAnnotationPresent(this.isAnnotationPresent(frameRow));
            if (this.getExplanationManager().hasExplanation((OWLAxiom)frameRow.getAxiom())) {
                buttons.addAll(this.inferredRowButtons);
            }
        }
        if (value instanceof AbstractOWLFrameSectionRow && !(additional = ((AbstractOWLFrameSectionRow)value).getAdditionalButtons()).isEmpty()) {
            buttons.addAll(additional);
        }
        if (value instanceof AbstractOWLFrameSection) {
            buttons.addAll(((AbstractOWLFrameSection)value).getAdditionalButtons());
        }
        return buttons;
    }

    protected String getRowName(Object rowObject) {
        if (rowObject instanceof OWLFrameSectionRow) {
            return ((OWLFrameSectionRow)rowObject).getFrameSection().getRowLabel((OWLFrameSectionRow)rowObject);
        }
        return null;
    }

    protected Color getItemBackgroundColor(MListItem item) {
        if (item instanceof AbstractOWLFrameSectionRow && ((AbstractOWLFrameSectionRow)item).isInferred()) {
            return INFERRED_BG_COLOR;
        }
        return super.getItemBackgroundColor(item);
    }

    private void setupKeyboardHandlers() {
        InputMap im = this.getInputMap(0);
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(127, 0), "DELETE_SEL");
        am.put("DELETE_SEL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLFrameList.this.handleDelete();
            }
        });
        im.put(KeyStroke.getKeyStroke(10, 0), "ADD");
        am.put("ADD", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLFrameList.this.handleEdit();
            }
        });
    }

    public void setWrap(boolean b) {
        this.cellRenderer.setWrap(b);
    }

    private void showPopupMenu(MouseEvent e) {
        for (OWLFrameListPopupMenuAction<R> action : this.actions) {
            action.updateState();
        }
        this.popupMenu.show((Component)((Object)this), e.getX(), e.getY());
    }

    private void createPopupMenu() {
        this.actions = new ArrayList<OWLFrameListPopupMenuAction<R>>();
        this.popupMenu = new JPopupMenu();
        this.addToPopupMenu(new SwitchToDefiningOntologyAction());
        this.addToPopupMenu(new PullIntoActiveOntologyAction());
        this.addToPopupMenu(new MoveAxiomsToOntologyAction());
    }

    public void addToPopupMenu(OWLFrameListPopupMenuAction<R> action) {
        this.setupMenuItem(action);
        this.popupMenu.add(action);
    }

    private void setupMenuItem(OWLFrameListPopupMenuAction<R> action) {
        action.setup(this.editorKit, this);
        try {
            action.initialise();
            this.actions.add(action);
        }
        catch (Exception e) {
            this.logger.debug("An error occurred whilst setting up a menu item in the popup menu in a Frame List.  The menu item will not be displayed in the popup menu.", (Throwable)e);
        }
    }

    public void setRootObject(R rootObject) {
        this.frame.setRootObject(rootObject);
        this.changeListenerMediator.fireStateChanged(this);
    }

    public R getRootObject() {
        return this.frame.getRootObject();
    }

    public void dispose() {
        this.removeListSelectionListener(this.selListener);
        this.frame.removeFrameListener(this.listener);
        for (OWLFrameListPopupMenuAction<R> action : this.actions) {
            try {
                action.dispose();
            }
            catch (Exception e) {
                this.logger.debug("An error occurred whilst disposing of a menu item in the popup menu in a Frame List", (Throwable)e);
            }
        }
        this.frame.dispose();
        this.editorKit.getOWLModelManager().removeListener(this.modelManagerListener);
    }

    private void refillRows() {
        ArrayList rows = new ArrayList();
        for (OWLFrameSection section : this.frame.getFrameSections()) {
            rows.add(section);
            for (OWLFrameSectionRow row : section.getRows()) {
                rows.add(row);
            }
        }
        this.setListData(rows.toArray());
    }

    @Override
    public boolean canDelete() {
        return this.getSelectedIndex() != -1;
    }

    @Override
    public void handleDelete() {
        int[] selIndices = this.getSelectedIndices();
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (int selIndex : selIndices) {
            Object val = this.getModel().getElementAt(selIndex);
            if (!(val instanceof OWLFrameSectionRow)) continue;
            OWLFrameSectionRow row = (OWLFrameSectionRow)val;
            changes.addAll(row.getDeletionChanges());
        }
        this.editorKit.getModelManager().applyChanges(changes);
    }

    protected void handleAdd() {
        this.handleEdit();
    }

    protected void handleEdit() {
        if (this.getRootObject() == null) {
            return;
        }
        Object val = this.getSelectedValue();
        if (val instanceof OWLFrameObject) {
            if (val instanceof OWLFrameSection ? !((OWLFrameSection)val).canAdd() : !((OWLFrameSectionRow)val).isEditable()) {
                return;
            }
            OWLFrameObject row = (OWLFrameObject)val;
            this.showEditorDialog(row, editor -> editor.getHandler().handleEditingFinished(editor.getEditedObjects()));
        }
    }

    protected void handleSelectionEvent(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            OWLFrameSectionRow row;
            Object ax;
            Object sel;
            if (this.isAxiomSelectionSyncronized() && (sel = this.getSelectedValue()) instanceof OWLFrameSectionRow && (ax = (row = (OWLFrameSectionRow)sel).getAxiom()) != null && row.getOntology() != null) {
                this.editorKit.getWorkspace().getOWLSelectionModel().setSelectedAxiom(new OWLAxiomInstance((OWLAxiom)ax, row.getOntology()));
            }
            this.changeListenerMediator.fireStateChanged(this);
        }
    }

    public boolean isAxiomSelectionSyncronized() {
        return this.axiomSelectionGlobal;
    }

    public void setAxiomSelectionSyncronized(boolean sync) {
        this.axiomSelectionGlobal = sync;
    }

    private void showEditorDialog(final OWLFrameObject frameObject, final EditHandler handler) {
        final boolean isRowEditor = frameObject instanceof OWLFrameSectionRow;
        final OWLObjectEditor editor = frameObject.getEditor();
        if (editor == null) {
            return;
        }
        if (editor instanceof JWindow) {
            ((JWindow)((Object)editor)).setVisible(true);
            return;
        }
        if (editor instanceof Wizard) {
            int ret = ((Wizard)editor).showModalDialog();
            if (ret == 0) {
                handler.handleEditFinished(editor);
            }
            return;
        }
        final JComponent editorComponent = editor.getEditorComponent();
        final VerifyingOptionPane optionPane = new VerifyingOptionPane(editorComponent){

            public void selectInitialValue() {
            }
        };
        final InputVerificationStatusChangedListener verificationListener = verified -> optionPane.setOKEnabled(verified && frameObject.checkEditorResults(editor));
        if (editor instanceof VerifiedInputEditor) {
            ((VerifiedInputEditor)editor).addStatusChangedListener(verificationListener);
        }
        Component parent = this.getDialogParent();
        JDialog dlg = optionPane.createDialog(parent, null);
        dlg.setModal(false);
        dlg.setResizable(true);
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Object retVal = optionPane.getValue();
                editorComponent.setPreferredSize(editorComponent.getSize());
                if (retVal != null && retVal.equals(0)) {
                    handler.handleEditFinished(editor);
                }
                OWLFrameList.this.setSelectedValue(frameObject, true);
                if (editor instanceof VerifiedInputEditor) {
                    ((VerifiedInputEditor)editor).removeStatusChangedListener(verificationListener);
                }
                if (isRowEditor) {
                    editor.dispose();
                }
            }
        });
        Object rootObject = null;
        if (frameObject instanceof OWLFrameSectionRow) {
            rootObject = ((OWLFrameSectionRow)frameObject).getFrameSection().getRootObject();
        } else if (frameObject instanceof OWLFrameSection) {
            rootObject = ((OWLFrameSection)frameObject).getRootObject();
        }
        if (rootObject instanceof OWLObject) {
            dlg.setTitle(this.editorKit.getModelManager().getRendering((OWLObject)rootObject));
        } else if (rootObject != null) {
            dlg.setTitle(rootObject.toString());
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dlg.getSize();
        if (dlg.getHeight() > screenSize.height - 100) {
            dlgSize.height = screenSize.height - 100;
        }
        if (dlg.getWidth() > screenSize.width - 100) {
            dlgSize.width = screenSize.width - 100;
        }
        dlg.setSize(dlgSize);
        dlg.setVisible(true);
    }

    private Component getDialogParent() {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        return prefs.getBoolean("DIALOGS_ALWAYS_CENTRED", false) ? SwingUtilities.getAncestorOfClass(Frame.class, this.getParent()) : this.getParent();
    }

    protected void invokeExplanationHandler() {
        Object obj = this.getSelectedValue();
        if (!(obj instanceof OWLFrameSectionRow)) {
            return;
        }
        OWLFrameSectionRow row = (OWLFrameSectionRow)obj;
        Object ax = row.getAxiom();
        if (this.getExplanationManager().hasExplanation((OWLAxiom)ax)) {
            WorkspaceFrame frame = ProtegeManager.getInstance().getFrame((Workspace)this.editorKit.getWorkspace());
            this.getExplanationManager().handleExplain((Frame)frame, (OWLAxiom)ax);
        }
    }

    protected ExplanationManager getExplanationManager() {
        return this.editorKit.getModelManager().getExplanationManager();
    }

    private void invokeAxiomAnnotationHandler() {
        OWLAxiomInstance axiomInstance;
        Object obj = this.getSelectedValue();
        if (!(obj instanceof OWLFrameSectionRow)) {
            return;
        }
        OWLFrameSectionRow row = (OWLFrameSectionRow)obj;
        Object ax = row.getAxiom();
        AxiomAnnotationPanel axiomAnnotationPanel = new AxiomAnnotationPanel(this.editorKit);
        OWLOntology ontology = row.getOntology();
        if (ontology != null) {
            axiomInstance = new OWLAxiomInstance((OWLAxiom)ax, ontology);
        } else {
            OWLOntology activeOntology = this.editorKit.getOWLModelManager().getActiveOntology();
            axiomInstance = new OWLAxiomInstance((OWLAxiom)ax, activeOntology);
        }
        axiomAnnotationPanel.setAxiomInstance(axiomInstance);
        new UIHelper(this.editorKit).showDialog("Annotations for " + ax.getAxiomType().toString(), (JComponent)axiomAnnotationPanel, -1);
        axiomAnnotationPanel.dispose();
    }

    private boolean isAnnotationPresent(OWLFrameSectionRow<?, ?, ?> row) {
        Object ax = row.getAxiom();
        return !ax.getAnnotations().isEmpty();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public OWLObject getLinkedObject() {
        return this.mediator.getLinkedObject();
    }

    @Override
    public Point getMouseCellLocation() {
        Point mouseLoc = this.getMousePosition();
        if (mouseLoc == null) {
            return null;
        }
        int index = this.locationToIndex(mouseLoc);
        Rectangle cellRect = this.getCellBounds(index, index);
        return new Point(mouseLoc.x - cellRect.x, mouseLoc.y - cellRect.y);
    }

    @Override
    public Rectangle getMouseCellRect() {
        Point loc = this.getMousePosition();
        if (loc == null) {
            return null;
        }
        int index = this.locationToIndex(loc);
        return this.getCellBounds(index, index);
    }

    @Override
    public void setLinkedObject(OWLObject object) {
        this.mediator.setLinkedObject(object);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver = true;
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.dragOver = true;
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.dragOver = false;
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (dtde.getTransferable().isDataFlavorSupported(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR)) {
            try {
                List object = (List)dtde.getTransferable().getTransferData(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR);
                OWLFrameObject frameObject = (OWLFrameObject)this.getModel().getElementAt(this.locationToIndex(dtde.getLocation()));
                dtde.dropComplete(frameObject.dropObjects(object));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dragOver = false;
    }

    @Override
    public boolean canPaste(List<OWLObject> objects) {
        if (this.getRootObject() == null) {
            return false;
        }
        return this.getSelectedValue() instanceof OWLFrameSection && ((OWLFrameSection)this.getSelectedValue()).canAcceptDrop(objects);
    }

    @Override
    public void pasteObjects(List<OWLObject> objects) {
        OWLFrameSection section;
        Object selObject = this.getSelectedValue();
        if (selObject instanceof OWLFrameSection && (section = (OWLFrameSection)selObject).canAcceptDrop(objects)) {
            section.dropObjects(objects);
        }
    }

    @Override
    public boolean canCopy() {
        return this.getRootObject() != null && this.getSelectedIndex() != -1;
    }

    @Override
    public List<OWLObject> getObjectsToCopy() {
        ArrayList<OWLObject> manipulatableObjects = new ArrayList<OWLObject>();
        for (Object selObject : this.getSelectedValues()) {
            if (!(selObject instanceof OWLFrameSectionRow)) continue;
            OWLFrameSectionRow row = (OWLFrameSectionRow)selObject;
            manipulatableObjects.addAll(row.getManipulatableObjects());
        }
        return manipulatableObjects;
    }

    @Override
    public boolean canCut() {
        return !this.getCuttableObjects().isEmpty();
    }

    private List<OWLObject> getCuttableObjects() {
        ArrayList<OWLObject> manipulatableObjects = new ArrayList<OWLObject>();
        for (Object selObject : this.getSelectedValues()) {
            if (!(selObject instanceof OWLFrameSectionRow)) continue;
            OWLFrameSectionRow row = (OWLFrameSectionRow)selObject;
            manipulatableObjects.addAll(row.getManipulatableObjects());
        }
        return manipulatableObjects;
    }

    @Override
    public List<OWLObject> cutObjects() {
        ArrayList<OWLObject> manipulatableObjects = new ArrayList<OWLObject>();
        ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
        for (Object selObject : this.getSelectedValues()) {
            OWLFrameSectionRow row;
            if (!(selObject instanceof OWLFrameSectionRow) || (row = (OWLFrameSectionRow)selObject).isInferred()) continue;
            manipulatableObjects.addAll(row.getManipulatableObjects());
            changes.add(new RemoveAxiom(row.getOntology(), row.getAxiom()));
        }
        this.editorKit.getModelManager().applyChanges(changes);
        return manipulatableObjects;
    }

    public boolean canPerformAction() {
        return !this.getCuttableObjects().isEmpty();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListenerMediator.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListenerMediator.removeChangeListener(changeListener);
    }

    public void setLayoutOrientation(int layoutOrientation) {
        throw new OWLRuntimeException("NOT ALLOWED");
    }

    public class OWLFrameListUI
    extends BasicListUI {
        private Point lastMouseDownPoint;
        private int[] cumulativeCellHeight;

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new BasicListUI.MouseInputHandler(){
                boolean showingPopup;
                {
                    this.showingPopup = false;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showingPopup = false;
                    OWLFrameListUI.this.lastMouseDownPoint = e.getPoint();
                    if (e.isPopupTrigger()) {
                        this.showingPopup = true;
                        OWLFrameList.this.showPopupMenu(e);
                    } else if ((e.getModifiersEx() & 0x100) != 0) {
                        int sel = OWLFrameListUI.this.locationToIndex((JList<?>)((Object)OWLFrameList.this), OWLFrameListUI.this.lastMouseDownPoint);
                        OWLFrameListUI.this.handleModifiedSelectionEvent(sel);
                    } else {
                        super.mousePressed(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showingPopup = true;
                        OWLFrameList.this.showPopupMenu(e);
                    } else if (e.getClickCount() == 2) {
                        if (!this.showingPopup) {
                            OWLFrameList.this.handleEdit();
                        }
                    } else {
                        super.mouseReleased(e);
                    }
                }
            };
        }

        private void handleModifiedSelectionEvent(int index) {
            if (OWLFrameList.this.isSelectedIndex(index)) {
                OWLFrameList.this.removeSelectionInterval(index, index);
            } else if (OWLFrameList.this.getSelectionMode() == 2 || OWLFrameList.this.getSelectedIndex() == -1) {
                OWLFrameList.this.addSelectionInterval(index, index);
            }
        }

        protected boolean isFixedCellHeightRow(int index) {
            Object value = OWLFrameList.this.getModel().getElementAt(index);
            if (!(value instanceof AbstractOWLFrameSectionRow)) {
                return false;
            }
            AbstractOWLFrameSectionRow row = (AbstractOWLFrameSectionRow)value;
            if (index < OWLFrameList.this.getModel().getSize() - 1 && OWLFrameList.this.getModel().getElementAt(index + 1) instanceof AbstractOWLFrameSection) {
                return false;
            }
            return row.isFixedHeight();
        }

        @Override
        protected void updateLayoutState() {
            block13: {
                this.cumulativeCellHeight = new int[this.list.getModel().getSize()];
                int fixedCellHeight = this.list.getFixedCellHeight();
                int fixedCellWidth = this.list.getFixedCellWidth();
                int n = this.cellWidth = fixedCellWidth != -1 ? fixedCellWidth : -1;
                if (fixedCellHeight != -1) {
                    this.cellHeight = fixedCellHeight;
                    this.cellHeights = null;
                } else {
                    this.cellHeight = -1;
                    this.cellHeights = new int[this.list.getModel().getSize()];
                }
                if (fixedCellWidth != -1 && fixedCellHeight != -1) break block13;
                ListModel dataModel = this.list.getModel();
                int dataModelSize = dataModel.getSize();
                ListCellRenderer renderer = this.list.getCellRenderer();
                if (renderer != null) {
                    int cumulativeHeight = 0;
                    for (int index = 0; index < dataModelSize; ++index) {
                        Object value = dataModel.getElementAt(index);
                        if (this.isFixedCellHeightRow(index)) {
                            if (fixedCellHeight == -1) {
                                this.cellHeights[index] = 22;
                            }
                        } else {
                            Component c = renderer.getListCellRendererComponent(this.list, value, index, false, false);
                            this.rendererPane.add(c);
                            Dimension cellSize = c.getPreferredSize();
                            if (fixedCellWidth == -1) {
                                this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                            }
                            if (fixedCellHeight == -1) {
                                this.cellHeights[index] = cellSize.height;
                            }
                        }
                        this.cumulativeCellHeight[index] = cumulativeHeight += this.cellHeights[index];
                    }
                } else {
                    if (this.cellWidth == -1) {
                        this.cellWidth = 0;
                    }
                    if (this.cellHeights == null) {
                        this.cellHeights = new int[dataModelSize];
                    }
                    for (int index = 0; index < dataModelSize; ++index) {
                        this.cellHeights[index] = 0;
                    }
                }
            }
        }

        public Rectangle getCellBounds(JList list, int index1, int index2) {
            this.maybeUpdateLayoutState();
            int minIndex = Math.min(index1, index2);
            int maxIndex = Math.max(index1, index2);
            if (minIndex >= list.getModel().getSize()) {
                return null;
            }
            Rectangle minBounds = this.getCellBounds(list, minIndex);
            if (minBounds == null) {
                return null;
            }
            if (minIndex == maxIndex) {
                return minBounds;
            }
            Rectangle maxBounds = this.getCellBounds(list, maxIndex);
            if (maxBounds != null) {
                if (minBounds.x != maxBounds.x) {
                    minBounds.y = 0;
                    minBounds.height = list.getHeight();
                }
                minBounds.add(maxBounds);
            }
            return minBounds;
        }

        private Rectangle getCellBounds(JList list, int index) {
            if (index < 0) {
                return new Rectangle();
            }
            this.maybeUpdateLayoutState();
            if (index >= this.cumulativeCellHeight.length) {
                return null;
            }
            Insets insets = list.getInsets();
            int x = insets.left;
            int y = index >= this.cellHeights.length ? 0 : this.cumulativeCellHeight[index] - this.cellHeights[index];
            int w = list.getWidth() - (insets.left + insets.right);
            int h = this.cellHeights[index];
            return new Rectangle(x, y, w, h);
        }

        protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
            Object value = dataModel.getElementAt(row);
            boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
            boolean isSelected = selModel.isSelectedIndex(row);
            Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
            int cx = rowBounds.x;
            int cy = rowBounds.y;
            int cw = rowBounds.width;
            int ch = rowBounds.height;
            this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
    }

    private static interface EditHandler {
        public void handleEditFinished(OWLObjectEditor var1);
    }
}

