from pybtex.bibtex.interpreter import (
    Integer, String, QuotedVar, Identifier, FunctionLiteral,
)

bst = [['FUNCTION',
  [Identifier('identify.apacite.version')],
  [String('apacite.bst'),
   String(' [2009/03/01 v4.05 APA bibliography style]'),
   Identifier('*'),
   Identifier('top$')]],
 ['ENTRY',
  [Identifier('address'),
   Identifier('annote'),
   Identifier('annotate'),
   Identifier('author'),
   Identifier('booktitle'),
   Identifier('chair'),
   Identifier('chapter'),
   Identifier('day'),
   Identifier('edition'),
   Identifier('editor'),
   Identifier('englishtitle'),
   Identifier('firstkey'),
   Identifier('howpublished'),
   Identifier('institution'),
   Identifier('journal'),
   Identifier('key'),
   Identifier('lastchecked'),
   Identifier('month'),
   Identifier('note'),
   Identifier('number'),
   Identifier('organization'),
   Identifier('originaladdress'),
   Identifier('originalbooktitle'),
   Identifier('originaledition'),
   Identifier('originaleditor'),
   Identifier('originaljournal'),
   Identifier('originalnumber'),
   Identifier('originalpages'),
   Identifier('originalpublisher'),
   Identifier('originalvolume'),
   Identifier('originalyear'),
   Identifier('pages'),
   Identifier('publisher'),
   Identifier('school'),
   Identifier('series'),
   Identifier('symposium'),
   Identifier('text'),
   Identifier('title'),
   Identifier('translator'),
   Identifier('type'),
   Identifier('url'),
   Identifier('volume'),
   Identifier('year')],
  [Identifier('title.number'),
   Identifier('cite.initials'),
   Identifier('cite.num.names.full'),
   Identifier('cite.num.names.short'),
   Identifier('add.to.year')],
  [Identifier('year.label'),
   Identifier('author.year.sort.label'),
   Identifier('title.sort.label'),
   Identifier('type.2')]],
 ['INTEGERS',
  [Identifier('len'),
   Identifier('pos'),
   Identifier('name.max'),
   Identifier('old.number'),
   Identifier('numnames'),
   Identifier('numnames.old'),
   Identifier('nameptr'),
   Identifier('lastname'),
   Identifier('format.num.names'),
   Identifier('cite.initials.old'),
   Identifier('cite.num.names.old'),
   Identifier('add.to.year.old'),
   Identifier('forward'),
   Identifier('multiresult'),
   Identifier('dot'),
   Identifier('brace.level')]],
 ['STRINGS',
  [Identifier('s'),
   Identifier('t'),
   Identifier('u'),
   Identifier('old.label'),
   Identifier('field'),
   Identifier('aut1f'),
   Identifier('aut1s'),
   Identifier('aut1f.old'),
   Identifier('aut1s.old'),
   Identifier('aut2'),
   Identifier('aut2.old'),
   Identifier('aut3'),
   Identifier('aut3.old'),
   Identifier('aut4'),
   Identifier('aut4.old'),
   Identifier('aut5'),
   Identifier('aut5.old'),
   Identifier('aut6'),
   Identifier('aut6.old'),
   Identifier('year.label.old')]],
 ['FUNCTION', [Identifier('test')], [Integer(0)]],
 ['FUNCTION', [Identifier('make.index')], [Integer(0)]],
 ['MACRO', [Identifier('jan')], [String('{\\APACmonth{01}}')]],
 ['MACRO', [Identifier('feb')], [String('{\\APACmonth{02}}')]],
 ['MACRO', [Identifier('mar')], [String('{\\APACmonth{03}}')]],
 ['MACRO', [Identifier('apr')], [String('{\\APACmonth{04}}')]],
 ['MACRO', [Identifier('may')], [String('{\\APACmonth{05}}')]],
 ['MACRO', [Identifier('jun')], [String('{\\APACmonth{06}}')]],
 ['MACRO', [Identifier('jul')], [String('{\\APACmonth{07}}')]],
 ['MACRO', [Identifier('aug')], [String('{\\APACmonth{08}}')]],
 ['MACRO', [Identifier('sep')], [String('{\\APACmonth{09}}')]],
 ['MACRO', [Identifier('oct')], [String('{\\APACmonth{10}}')]],
 ['MACRO', [Identifier('nov')], [String('{\\APACmonth{11}}')]],
 ['MACRO', [Identifier('dec')], [String('{\\APACmonth{12}}')]],
 ['MACRO', [Identifier('winter')], [String('{\\APACmonth{13}}')]],
 ['MACRO', [Identifier('spring')], [String('{\\APACmonth{14}}')]],
 ['MACRO', [Identifier('summer')], [String('{\\APACmonth{15}}')]],
 ['MACRO', [Identifier('fall')], [String('{\\APACmonth{16}}')]],
 ['FUNCTION',
  [Identifier('not')],
  [FunctionLiteral([Integer(0)]),
   FunctionLiteral([Integer(1)]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('and')],
  [QuotedVar('skip$'),
   FunctionLiteral([Identifier('pop$'), Integer(0)]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('or')],
  [FunctionLiteral([Identifier('pop$'), Integer(1)]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('warning.if.empty')],
  [Identifier('empty$'),
   FunctionLiteral([String('No '), Identifier('swap$'), Identifier('*'), String(' in '), Identifier('*'), Identifier('cite$'), Identifier('*'), Identifier('warning$')]),
   FunctionLiteral([Identifier('pop$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('check.relevant.fields')],
  [Identifier('title'),
   Identifier('empty$'),
   Identifier('type'),
   Identifier('empty$'),
   Identifier('and'),
   Identifier('howpublished'),
   Identifier('empty$'),
   Identifier('and'),
   FunctionLiteral([String('No title, type, and howpublished in '), Identifier('cite$'), Identifier('*'), Identifier('warning$')]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('editor.ne.trans')],
  [Identifier('translator'),
   Identifier('empty$'),
   FunctionLiteral([Integer(0)]),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Integer(0)]), FunctionLiteral([Identifier('translator'), Identifier('editor'), Identifier('='), FunctionLiteral([Integer(0)]), FunctionLiteral([Integer(1)]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('conv.int.to.str')],
  [Identifier('duplicate$'),
   Integer(10),
   Identifier('<'),
   FunctionLiteral([String('0000'), Identifier('swap$'), Identifier('int.to.str$'), Identifier('*')]),
   FunctionLiteral([Identifier('duplicate$'), Integer(100), Identifier('<'), FunctionLiteral([String('000'), Identifier('swap$'), Identifier('int.to.str$'), Identifier('*')]), FunctionLiteral([Identifier('duplicate$'), Integer(1000), Identifier('<'), FunctionLiteral([String('00'), Identifier('swap$'), Identifier('int.to.str$'), Identifier('*')]), FunctionLiteral([Identifier('duplicate$'), Integer(10000), Identifier('<'), FunctionLiteral([String('0'), Identifier('swap$'), Identifier('int.to.str$'), Identifier('*')]), FunctionLiteral([Identifier('int.to.str$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('ref.type')],
  [Identifier('type$'),
   String('article'),
   Identifier('='),
   Identifier('type$'),
   String('magazine'),
   Identifier('='),
   Identifier('type$'),
   String('newspaper'),
   Identifier('='),
   Identifier('type$'),
   String('book'),
   Identifier('='),
   Identifier('type$'),
   String('techreport'),
   Identifier('='),
   Identifier('type$'),
   String('unpublished'),
   Identifier('='),
   Identifier('type$'),
   String('misc'),
   Identifier('='),
   Identifier('type$'),
   String('booklet'),
   Identifier('='),
   Identifier('type$'),
   String('manual'),
   Identifier('='),
   Identifier('type$'),
   String('proceedings'),
   Identifier('='),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   FunctionLiteral([Integer(1)]),
   FunctionLiteral([Identifier('type$'), String('incollection'), Identifier('='), Identifier('type$'), String('phdthesis'), Identifier('='), Identifier('type$'), String('mastersthesis'), Identifier('='), Identifier('type$'), String('lecture'), Identifier('='), Identifier('type$'), String('inbook'), Identifier('='), Identifier('type$'), String('inproceedings'), Identifier('='), Identifier('type$'), String('conference'), Identifier('='), Identifier('type$'), String('intechreport'), Identifier('='), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), FunctionLiteral([Integer(2)]), FunctionLiteral([Identifier('type$'), String('literal'), Identifier('='), FunctionLiteral([Integer(3)]), FunctionLiteral([Integer(0)]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('is.atype')],
  [Identifier('type$'),
   String('article'),
   Identifier('='),
   Identifier('type$'),
   String('magazine'),
   Identifier('='),
   Identifier('type$'),
   String('newspaper'),
   Identifier('='),
   Identifier('type$'),
   String('incollection'),
   Identifier('='),
   Identifier('type$'),
   String('inbook'),
   Identifier('='),
   Identifier('type$'),
   String('inproceedings'),
   Identifier('='),
   Identifier('type$'),
   String('conference'),
   Identifier('='),
   Identifier('type$'),
   String('intechreport'),
   Identifier('='),
   Identifier('type$'),
   String('manual'),
   Identifier('='),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   Identifier('or'),
   FunctionLiteral([Integer(1)]),
   FunctionLiteral([Identifier('journal'), Identifier('empty$'), Identifier('not'), Identifier('type$'), String('phdthesis'), Identifier('='), Identifier('type$'), String('mastersthesis'), Identifier('='), Identifier('or'), Identifier('and'), FunctionLiteral([Integer(1)]), FunctionLiteral([Identifier('type$'), String('misc'), Identifier('='), Identifier('type'), Identifier('empty$'), Identifier('not'), Identifier('and'), FunctionLiteral([Identifier('type'), String('\\bibmessage'), Identifier('='), Identifier('type'), String('\\bibcomputerprogram'), Identifier('='), Identifier('type'), String('\\bibcomputerprogrammanual'), Identifier('='), Identifier('type'), String('\\bibcomputerprogramandmanual'), Identifier('='), Identifier('type'), String('\\bibcomputersoftware'), Identifier('='), Identifier('type'), String('\\bibcomputersoftwaremanual'), Identifier('='), Identifier('type'), String('\\bibcomputersoftwareandmanual'), Identifier('='), Identifier('type'), String('\\bibprogramminglanguage'), Identifier('='), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), Identifier('or'), FunctionLiteral([Integer(1)]), FunctionLiteral([Integer(0)]), Identifier('if$')]), FunctionLiteral([Integer(0)]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('connect.check')],
  [QuotedVar('u'),
   Identifier(':='),
   Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), Identifier('duplicate$'), Identifier('empty$'), FunctionLiteral([Identifier('pop$'), String('')]), QuotedVar('skip$'), Identifier('if$')]),
   FunctionLiteral([Identifier('swap$'), Identifier('duplicate$'), Identifier('empty$'), FunctionLiteral([Identifier('pop$')]), FunctionLiteral([Identifier('u'), Identifier('*'), Identifier('swap$'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('tie.or.space.connect')],
  [Identifier('duplicate$'),
   Identifier('text.length$'),
   Integer(4),
   Identifier('<'),
   FunctionLiteral([String('~')]),
   FunctionLiteral([String('\\ ')]),
   Identifier('if$'),
   Identifier('swap$'),
   Identifier('*'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('connect.with.comma.check')],
  [String(', '), Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('connect.with.semicolon.check')],
  [String('; '), Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('connect.with.colon.check')],
  [String(': '), Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('connect.with.space.check')],
  [String('\\ '), Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('enclose.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), Identifier('pop$'), Identifier('pop$'), String('')]),
   FunctionLiteral([Identifier('swap$'), Identifier('*'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('emphasize.check')],
  [String('\\Bem{'),
   Identifier('swap$'),
   String('}'),
   Identifier('swap$'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('bracket.check')],
  [String('['),
   Identifier('swap$'),
   String(']'),
   Identifier('swap$'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('parenthesize.check')],
  [String('('),
   Identifier('swap$'),
   String(')'),
   Identifier('swap$'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('multi.result.check')],
  [QuotedVar('t'),
   Identifier(':='),
   Integer(0),
   QuotedVar('multiresult'),
   Identifier(':='),
   FunctionLiteral([Identifier('multiresult'), Identifier('not'), Identifier('t'), Identifier('text.length$'), Integer(1), Identifier('>'), Identifier('and')]),
   FunctionLiteral([Identifier('t'), Integer(1), Integer(2), Identifier('substring$'), QuotedVar('s'), Identifier(':='), String('--'), Identifier('s'), Identifier('='), FunctionLiteral([Integer(1), QuotedVar('multiresult'), Identifier(':=')]), FunctionLiteral([Identifier('t'), Integer(1), Integer(1), Identifier('substring$'), QuotedVar('s'), Identifier(':='), String('+'), Identifier('s'), Identifier('='), String(','), Identifier('s'), Identifier('='), Identifier('or'), FunctionLiteral([Integer(1), QuotedVar('multiresult'), Identifier(':=')]), FunctionLiteral([Identifier('t'), Integer(2), Identifier('global.max$'), Identifier('substring$'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('multiresult')]],
 ['FUNCTION',
  [Identifier('is.bibcorporate')],
  [Integer(1),
   Integer(14),
   Identifier('substring$'),
   String('{\\bibcorporate'),
   Identifier('=')]],
 ['FUNCTION',
  [Identifier('sortify')],
  [Identifier('purify$'), String('l'), Identifier('change.case$')]],
 ['FUNCTION',
  [Identifier('remove.spaces')],
  [QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   Identifier('text.length$'),
   QuotedVar('len'),
   Identifier(':='),
   String(''),
   QuotedVar('t'),
   Identifier(':='),
   Integer(0),
   QuotedVar('pos'),
   Identifier(':='),
   FunctionLiteral([Identifier('pos'), Identifier('len'), Identifier('<')]),
   FunctionLiteral([Identifier('pos'), Integer(1), Identifier('+'), QuotedVar('pos'), Identifier(':='), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), QuotedVar('u'), Identifier(':='), Identifier('u'), String(' '), Identifier('='), QuotedVar('skip$'), FunctionLiteral([Identifier('t'), Identifier('u'), Identifier('*'), QuotedVar('t'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('t')]],
 ['FUNCTION',
  [Identifier('output.end.block')],
  [Identifier('write$'), Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('output.new.block')],
  [Identifier('output.end.block'),
   String('\\newblock'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('output.dot.new.block')],
  [Identifier('add.period$'), Identifier('output.new.block')]],
 ['FUNCTION',
  [Identifier('start.new.block')],
  [Identifier('newline$'),
   String('\\unskip\\ '),
   Identifier('write$'),
   Identifier('newline$'),
   String('\\newblock '),
   Identifier('write$'),
   Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('fin.entry')],
  [Identifier('output.end.block'),
   String('\\PrintBackRefs{\\CurrentBib}'),
   Identifier('write$'),
   Identifier('newline$'),
   Identifier('test'),
   FunctionLiteral([String('\\vspace{\\baselineskip}'), Identifier('write$'), Identifier('newline$')]),
   QuotedVar('skip$'),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('sort.name.format')],
  [String('{ll{}}{  f{}}{  vv{}}{  jj{}}')]],
 ['FUNCTION', [Identifier('cite.name.format')], [String('{ll}')]],
 ['FUNCTION',
  [Identifier('cite.initials.name.format')],
  [String('{f{\\BPBI }.~~}{vv }{ll}{ jj}')]],
 ['FUNCTION',
  [Identifier('author.name.format')],
  [String('{ll}{, f{\\BPBI }.}{ vv}{, jj}')]],
 ['FUNCTION',
  [Identifier('editor.name.format')],
  [String('{f{\\BPBI }.~~}{vv }{ll}{ jj}')]],
 ['FUNCTION',
  [Identifier('index.name.format')],
  [String('{ll}{, f{\\BPBI }.}{ vv}{, jj}')]],
 ['FUNCTION',
  [Identifier('init.initials')],
  [String('yyyyy'),
   QuotedVar('aut1f.old'),
   Identifier(':='),
   String('yyyyy'),
   QuotedVar('aut1s.old'),
   Identifier(':='),
   Integer(0),
   QuotedVar('cite.initials.old'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('update.no.initials')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   QuotedVar('aut1f.old'),
   Identifier(':='),
   Identifier('field'),
   QuotedVar('aut1s.old'),
   Identifier(':='),
   Integer(0),
   QuotedVar('cite.initials.old'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('check.add.initials.aut')],
  [Identifier('aut1s'),
   Identifier('aut1s.old'),
   Identifier('='),
   FunctionLiteral([Identifier('aut1f'), Identifier('aut1f.old'), Identifier('='), FunctionLiteral([Identifier('cite.initials.old'), QuotedVar('cite.initials'), Identifier(':=')]), FunctionLiteral([Integer(1), QuotedVar('cite.initials'), Identifier(':='), Identifier('aut1f'), QuotedVar('aut1f.old'), Identifier(':='), Identifier('aut1s'), QuotedVar('aut1s.old'), Identifier(':='), Identifier('cite.initials'), QuotedVar('cite.initials.old'), Identifier(':=')]), Identifier('if$')]),
   FunctionLiteral([Identifier('aut1f'), QuotedVar('aut1f.old'), Identifier(':='), Identifier('aut1s'), QuotedVar('aut1s.old'), Identifier(':='), Identifier('cite.initials'), QuotedVar('cite.initials.old'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('check.add.initials.field')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Integer(1),
   Identifier('cite.initials.name.format'),
   Identifier('format.name$'),
   QuotedVar('aut1f'),
   Identifier(':='),
   Identifier('field'),
   Integer(1),
   Identifier('cite.name.format'),
   Identifier('format.name$'),
   QuotedVar('aut1s'),
   Identifier(':='),
   Identifier('check.add.initials.aut')]],
 ['FUNCTION',
  [Identifier('check.add.initials')],
  [Identifier('firstkey'),
   Identifier('empty$'),
   Identifier('not'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('firstkey'), Identifier('sortify'), Identifier('remove.spaces'), QuotedVar('aut1f'), Identifier(':='), Identifier('key'), Identifier('sortify'), Identifier('remove.spaces'), QuotedVar('aut1s'), Identifier(':='), Identifier('check.add.initials.aut')]), FunctionLiteral([Identifier('firstkey'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('update.no.initials')]), Identifier('if$')]),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('key'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('update.no.initials')]), FunctionLiteral([Identifier('ref.type'), Integer(2), Identifier('='), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('update.no.initials')]), FunctionLiteral([Identifier('author'), Identifier('check.add.initials.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('update.no.initials')]), FunctionLiteral([Identifier('editor'), Identifier('check.add.initials.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('check.add.initials.field')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('tentative.cite.num.names.field')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   Integer(3),
   Identifier('<'),
   FunctionLiteral([Identifier('numnames'), QuotedVar('cite.num.names.full'), Identifier(':='), Identifier('numnames'), QuotedVar('cite.num.names.short'), Identifier(':=')]),
   FunctionLiteral([Identifier('numnames'), Integer(6), Identifier('<'), FunctionLiteral([Identifier('numnames'), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Integer(1), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('tentative.cite.num.names')],
  [Identifier('firstkey'),
   Identifier('empty$'),
   Identifier('not'),
   FunctionLiteral([Integer(1), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Integer(1), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('ref.type'), Integer(2), Identifier('='), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Integer(1), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('author'), Identifier('tentative.cite.num.names.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Integer(1), QuotedVar('cite.num.names.full'), Identifier(':='), Integer(1), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('editor'), Identifier('tentative.cite.num.names.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('tentative.cite.num.names.field')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('init.cite.num.names')],
  [Integer(0),
   QuotedVar('cite.num.names.old'),
   Identifier(':='),
   Integer(0),
   QuotedVar('numnames.old'),
   Identifier(':='),
   String('yyyy'),
   QuotedVar('year.label.old'),
   Identifier(':='),
   Integer(0),
   QuotedVar('add.to.year.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut1f.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut2.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut3.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut4.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut5.old'),
   Identifier(':='),
   String(''),
   QuotedVar('aut6.old'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('update.cite.num.names')],
  [Identifier('cite.num.names.short'),
   QuotedVar('cite.num.names.old'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('numnames.old'),
   Identifier(':='),
   Identifier('year.label'),
   QuotedVar('year.label.old'),
   Identifier(':='),
   Identifier('add.to.year'),
   QuotedVar('add.to.year.old'),
   Identifier(':='),
   Identifier('aut1f'),
   QuotedVar('aut1f.old'),
   Identifier(':='),
   Identifier('aut2'),
   QuotedVar('aut2.old'),
   Identifier(':='),
   Identifier('aut3'),
   QuotedVar('aut3.old'),
   Identifier(':='),
   Identifier('aut4'),
   QuotedVar('aut4.old'),
   Identifier(':='),
   Identifier('aut5'),
   QuotedVar('aut5.old'),
   Identifier(':='),
   Identifier('aut6'),
   QuotedVar('aut6.old'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('format.6.authors')],
  [Identifier('field'),
   Integer(1),
   Identifier('cite.initials.name.format'),
   Identifier('format.name$'),
   QuotedVar('aut1f'),
   Identifier(':='),
   Identifier('numnames'),
   Integer(1),
   Identifier('>'),
   Identifier('name.max'),
   Integer(1),
   Identifier('>'),
   Identifier('and'),
   FunctionLiteral([Identifier('field'), Integer(2), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('aut2'), Identifier(':='), Identifier('numnames'), Integer(2), Identifier('>'), Identifier('name.max'), Integer(2), Identifier('>'), Identifier('and'), FunctionLiteral([Identifier('field'), Integer(3), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('aut3'), Identifier(':='), Identifier('numnames'), Integer(3), Identifier('>'), Identifier('name.max'), Integer(3), Identifier('>'), Identifier('and'), FunctionLiteral([Identifier('field'), Integer(4), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('aut4'), Identifier(':='), Identifier('numnames'), Integer(4), Identifier('>'), Identifier('name.max'), Integer(4), Identifier('>'), Identifier('and'), FunctionLiteral([Identifier('field'), Integer(5), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('aut5'), Identifier(':='), Identifier('numnames'), Integer(5), Identifier('>'), Identifier('name.max'), Integer(5), Identifier('>'), Identifier('and'), FunctionLiteral([Identifier('field'), Integer(6), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('aut6'), Identifier(':=')]), FunctionLiteral([String(''), QuotedVar('aut6'), Identifier(':=')]), Identifier('if$')]), FunctionLiteral([String(''), QuotedVar('aut5'), Identifier(':='), String(''), QuotedVar('aut6'), Identifier(':=')]), Identifier('if$')]), FunctionLiteral([String(''), QuotedVar('aut4'), Identifier(':='), String(''), QuotedVar('aut5'), Identifier(':='), String(''), QuotedVar('aut6'), Identifier(':=')]), Identifier('if$')]), FunctionLiteral([String(''), QuotedVar('aut3'), Identifier(':='), String(''), QuotedVar('aut4'), Identifier(':='), String(''), QuotedVar('aut5'), Identifier(':='), String(''), QuotedVar('aut6'), Identifier(':=')]), Identifier('if$')]),
   FunctionLiteral([String(''), QuotedVar('aut2'), Identifier(':='), String(''), QuotedVar('aut3'), Identifier(':='), String(''), QuotedVar('aut4'), Identifier(':='), String(''), QuotedVar('aut5'), Identifier(':='), String(''), QuotedVar('aut6'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('change.add.to.year')],
  [Identifier('forward'),
   Integer(1),
   Identifier('='),
   FunctionLiteral([Identifier('add.to.year.old'), Integer(0), Identifier('>'), FunctionLiteral([Identifier('add.to.year.old'), Integer(1), Identifier('+'), QuotedVar('add.to.year'), Identifier(':=')]), FunctionLiteral([Integer(2), QuotedVar('add.to.year'), Identifier(':=')]), Identifier('if$')]),
   FunctionLiteral([Identifier('add.to.year.old'), Integer(1), Identifier('-'), QuotedVar('add.to.year'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('definitive.cite.num.names.1.or.2')],
  [Identifier('numnames'),
   Identifier('numnames.old'),
   Identifier('='),
   FunctionLiteral([Identifier('aut1f'), Identifier('aut1f.old'), Identifier('='), FunctionLiteral([Identifier('aut2'), Identifier('aut2.old'), Identifier('='), Identifier('numnames'), Integer(2), Identifier('='), Identifier('and'), Identifier('numnames'), Integer(1), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('change.add.to.year')]), FunctionLiteral([Identifier('skip$')]), Identifier('if$')]), FunctionLiteral([Identifier('skip$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('skip$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('definitive.cite.num.names.3.or.more')],
  [Identifier('aut1f'),
   Identifier('aut1f.old'),
   Identifier('='),
   FunctionLiteral([Identifier('aut2'), Identifier('aut2.old'), Identifier('='), FunctionLiteral([Identifier('aut3'), Identifier('aut3.old'), Identifier('='), FunctionLiteral([Identifier('numnames.old'), Integer(3), Identifier('='), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('='), FunctionLiteral([Identifier('change.add.to.year'), Identifier('cite.num.names.short'), Identifier('cite.num.names.old'), Identifier('<'), FunctionLiteral([Identifier('cite.num.names.old'), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(4), Identifier('<'), FunctionLiteral([Integer(4), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('='), FunctionLiteral([Identifier('numnames'), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('aut4'), Identifier('aut4.old'), Identifier('='), FunctionLiteral([Identifier('numnames.old'), Integer(4), Identifier('='), FunctionLiteral([Identifier('numnames'), Integer(4), Identifier('='), FunctionLiteral([Identifier('change.add.to.year'), Identifier('cite.num.names.short'), Identifier('cite.num.names.old'), Identifier('<'), FunctionLiteral([Identifier('cite.num.names.old'), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(5), Identifier('<'), FunctionLiteral([Integer(5), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('numnames'), Integer(4), Identifier('='), FunctionLiteral([Identifier('numnames'), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('aut5'), Identifier('aut5.old'), Identifier('='), FunctionLiteral([Identifier('numnames.old'), Integer(5), Identifier('='), FunctionLiteral([Identifier('numnames'), Integer(5), Identifier('='), FunctionLiteral([Identifier('change.add.to.year'), Identifier('cite.num.names.short'), Identifier('cite.num.names.old'), Identifier('<'), FunctionLiteral([Identifier('cite.num.names.old'), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(6), Identifier('<'), FunctionLiteral([Integer(6), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('numnames'), Integer(5), Identifier('='), FunctionLiteral([Identifier('numnames'), QuotedVar('cite.num.names.short'), Identifier(':=')]), FunctionLiteral([Identifier('numnames'), Integer(6), Identifier('>'), Identifier('numnames.old'), Integer(6), Identifier('='), Identifier('and'), Identifier('numnames'), Integer(6), Identifier('='), Identifier('numnames.old'), Integer(6), Identifier('>'), Identifier('and'), Identifier('or'), Identifier('aut6'), Identifier('aut6.old'), Identifier('='), Identifier('not'), Identifier('or'), FunctionLiteral([Integer(6), Identifier('cite.num.names.short'), Identifier('<'), FunctionLiteral([Integer(6), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), FunctionLiteral([Identifier('change.add.to.year'), Identifier('cite.num.names.short'), Identifier('cite.num.names.old'), Identifier('<'), FunctionLiteral([Identifier('cite.num.names.old'), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(5), Identifier('<'), FunctionLiteral([Integer(5), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(4), Identifier('<'), FunctionLiteral([Integer(4), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(3), Identifier('<'), FunctionLiteral([Integer(3), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('cite.num.names.short'), Integer(2), Identifier('<'), FunctionLiteral([Integer(2), QuotedVar('cite.num.names.short'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('skip$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('definitive.cite.num.names.field')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('format.6.authors'),
   Identifier('cite.num.names.short'),
   Identifier('numnames.old'),
   Identifier('>'),
   FunctionLiteral([Identifier('skip$')]),
   FunctionLiteral([Identifier('year.label'), Identifier('year.label.old'), Identifier('='), FunctionLiteral([Identifier('numnames'), Integer(3), Identifier('<'), Identifier('numnames.old'), Integer(3), Identifier('<'), Identifier('or'), FunctionLiteral([Identifier('definitive.cite.num.names.1.or.2')]), FunctionLiteral([Identifier('definitive.cite.num.names.3.or.more')]), Identifier('if$')]), FunctionLiteral([Identifier('skip$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('cite.num.names.short'),
   Identifier('name.max'),
   Identifier('>'),
   FunctionLiteral([Identifier('name.max'), QuotedVar('cite.num.names.short'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('cite.num.names.full'),
   Identifier('cite.num.names.short'),
   Identifier('<'),
   FunctionLiteral([Identifier('cite.num.names.short'), QuotedVar('cite.num.names.full'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('update.cite.num.names')]],
 ['FUNCTION',
  [Identifier('definitive.cite.no.names')],
  [QuotedVar('aut1f'),
   Identifier(':='),
   String(''),
   QuotedVar('aut2'),
   Identifier(':='),
   String(''),
   QuotedVar('aut3'),
   Identifier(':='),
   String(''),
   QuotedVar('aut4'),
   Identifier(':='),
   String(''),
   QuotedVar('aut5'),
   Identifier(':='),
   String(''),
   QuotedVar('aut6'),
   Identifier(':='),
   Integer(1),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('year.label'),
   Identifier('year.label.old'),
   Identifier('='),
   FunctionLiteral([Identifier('definitive.cite.num.names.1.or.2')]),
   FunctionLiteral([Identifier('skip$')]),
   Identifier('if$'),
   Identifier('update.cite.num.names')]],
 ['FUNCTION',
  [Identifier('definitive.cite.num.names')],
  [Identifier('firstkey'),
   Identifier('empty$'),
   Identifier('not'),
   FunctionLiteral([Identifier('firstkey'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('definitive.cite.no.names')]),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('key'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('definitive.cite.no.names')]), FunctionLiteral([Identifier('ref.type'), Integer(2), Identifier('='), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('definitive.cite.no.names')]), FunctionLiteral([Identifier('author'), Identifier('definitive.cite.num.names.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('empty$'), FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('definitive.cite.no.names')]), FunctionLiteral([Identifier('editor'), Identifier('definitive.cite.num.names.field')]), Identifier('if$')]), FunctionLiteral([Identifier('author'), Identifier('definitive.cite.num.names.field')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.tentative.year.sort.label')],
  [Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([String('0000'), QuotedVar('year.label'), Identifier(':=')]),
   FunctionLiteral([Identifier('year'), String('\\bibnodate'), Identifier('='), Identifier('year'), String('n.d.'), Identifier('='), Identifier('or'), FunctionLiteral([String('0000'), QuotedVar('year.label'), Identifier(':=')]), FunctionLiteral([Identifier('year'), String('\\BIP'), Identifier('='), FunctionLiteral([String('9999'), QuotedVar('year.label'), Identifier(':=')]), FunctionLiteral([Identifier('year'), Identifier('sortify'), Identifier('remove.spaces'), QuotedVar('year.label'), Identifier(':=')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('year.label')]],
 ['FUNCTION',
  [Identifier('month.number.day')],
  [Identifier('month'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('month'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('day'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([String('/'), Identifier('*'), Identifier('day'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.name.sort.label')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('field'),
   Integer(1),
   Identifier('sort.name.format'),
   Identifier('format.name$'),
   Identifier('numnames'),
   Integer(1),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('numnames'), Integer(2), Identifier('='), FunctionLiteral([Identifier('field'), Integer(2), String('{ll{}}'), Identifier('format.name$'), QuotedVar('s'), Identifier(':='), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([String('   zzzz'), Identifier('*')]), FunctionLiteral([String('   '), Identifier('*'), Identifier('s'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String('   zzzz'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$'),
   String('    '),
   Identifier('*'),
   Identifier('make.tentative.year.sort.label'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('numnames'),
   Integer(3),
   Identifier('<'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('numnames'), Identifier('name.max'), Identifier('>'), FunctionLiteral([Identifier('name.max'), QuotedVar('lastname'), Identifier(':='), String('   zzzz')]), FunctionLiteral([Identifier('numnames'), QuotedVar('lastname'), Identifier(':='), String('')]), Identifier('if$'), String(''), Integer(2), QuotedVar('nameptr'), Identifier(':='), FunctionLiteral([Identifier('nameptr'), Identifier('lastname'), Identifier('<')]), FunctionLiteral([Identifier('field'), Identifier('nameptr'), String('{ll{}}'), Identifier('format.name$'), Identifier('*'), String('   '), Identifier('*'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':=')]), Identifier('while$'), Identifier('field'), Identifier('lastname'), String('{ll{}}'), Identifier('format.name$'), QuotedVar('s'), Identifier(':='), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([String('zzzz'), Identifier('*')]), FunctionLiteral([Identifier('s'), Identifier('*')]), Identifier('if$'), Identifier('swap$'), Identifier('*'), Identifier('*')]),
   Identifier('if$'),
   String('    '),
   Identifier('*'),
   Identifier('title.number'),
   Identifier('conv.int.to.str'),
   Identifier('*'),
   Identifier('sortify'),
   String('    '),
   Identifier('*'),
   Identifier('month.number.day'),
   Identifier('*'),
   QuotedVar('author.year.sort.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.field.year.sort.label')],
  [String('    '),
   Identifier('*'),
   Identifier('make.tentative.year.sort.label'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('title.number'),
   Identifier('conv.int.to.str'),
   Identifier('*'),
   Identifier('sortify'),
   String('    '),
   Identifier('*'),
   Identifier('month.number.day'),
   Identifier('*'),
   QuotedVar('author.year.sort.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.author.editor.sort.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('make.field.year.sort.label')]), FunctionLiteral([Identifier('editor'), Identifier('make.name.sort.label')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('make.name.sort.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.author.sort.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('title.sort.label'), Identifier('make.field.year.sort.label')]),
   FunctionLiteral([Identifier('author'), Identifier('make.name.sort.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.tentative.sort.label')],
  [Identifier('firstkey'),
   Identifier('empty$'),
   Identifier('not'),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('key'), Identifier('sortify'), Identifier('remove.spaces'), String('  '), Identifier('*'), Identifier('firstkey'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('*'), Identifier('make.field.year.sort.label')]), FunctionLiteral([Identifier('firstkey'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('make.field.year.sort.label')]), Identifier('if$')]),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('key'), Identifier('sortify'), Identifier('remove.spaces'), Identifier('make.field.year.sort.label')]), FunctionLiteral([Identifier('ref.type'), Identifier('duplicate$'), Integer(1), Identifier('='), FunctionLiteral([Identifier('pop$'), Identifier('make.author.editor.sort.label')]), FunctionLiteral([Identifier('duplicate$'), Integer(2), Identifier('='), FunctionLiteral([Identifier('pop$'), Identifier('make.author.sort.label')]), FunctionLiteral([Integer(3), Identifier('='), FunctionLiteral([String('no key in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), Identifier('make.author.editor.sort.label')]), FunctionLiteral([Identifier('make.author.editor.sort.label')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('author.year.sort.label'),
   QuotedVar('sort.key$'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.definitive.name.sort.label')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   Identifier('name.max'),
   Identifier('>'),
   FunctionLiteral([Identifier('name.max'), QuotedVar('format.num.names'), Identifier(':=')]),
   FunctionLiteral([Identifier('numnames'), QuotedVar('format.num.names'), Identifier(':=')]),
   Identifier('if$'),
   String(''),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   FunctionLiteral([Identifier('nameptr'), Identifier('format.num.names'), Identifier('<')]),
   FunctionLiteral([Identifier('field'), Identifier('nameptr'), Identifier('sort.name.format'), Identifier('format.name$'), Identifier('*'), String('   '), Identifier('*'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':=')]),
   Identifier('while$'),
   Identifier('field'),
   Identifier('nameptr'),
   Identifier('sort.name.format'),
   Identifier('format.name$'),
   Identifier('*'),
   Identifier('nameptr'),
   Identifier('numnames'),
   Identifier('<'),
   FunctionLiteral([String('   zzzz'), Identifier('*')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('sortify'),
   String('    '),
   Identifier('*'),
   Identifier('year.label'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('title.number'),
   Identifier('conv.int.to.str'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('month.number.day'),
   Identifier('*'),
   QuotedVar('author.year.sort.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.definitive.field.year.sort.label')],
  [String('    '),
   Identifier('*'),
   Identifier('year.label'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('title.number'),
   Identifier('conv.int.to.str'),
   Identifier('*'),
   String('    '),
   Identifier('*'),
   Identifier('month.number.day'),
   Identifier('*'),
   QuotedVar('author.year.sort.label'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.definitive.author.editor.sort.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('title.sort.label'), Identifier('make.definitive.field.year.sort.label')]), FunctionLiteral([Identifier('editor'), Identifier('make.definitive.name.sort.label')]), Identifier('if$')]),
   FunctionLiteral([Identifier('author'), Identifier('make.definitive.name.sort.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.definitive.author.sort.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('title.sort.label'), Identifier('make.definitive.field.year.sort.label')]),
   FunctionLiteral([Identifier('author'), Identifier('make.definitive.name.sort.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.final.sort.key')],
  [Identifier('ref.type'),
   Integer(2),
   Identifier('='),
   FunctionLiteral([Identifier('make.definitive.author.sort.label')]),
   FunctionLiteral([Identifier('make.definitive.author.editor.sort.label')]),
   Identifier('if$'),
   Identifier('author.year.sort.label'),
   QuotedVar('sort.key$'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('chop.word')],
  [QuotedVar('s'),
   Identifier(':='),
   QuotedVar('len'),
   Identifier(':='),
   Identifier('s'),
   Integer(1),
   Identifier('len'),
   Identifier('substring$'),
   Identifier('='),
   FunctionLiteral([Identifier('s'), Identifier('len'), Integer(1), Identifier('+'), Identifier('global.max$'), Identifier('substring$')]),
   FunctionLiteral([Identifier('s')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('chop.articles')],
  [QuotedVar('s'),
   Identifier(':='),
   String('a '),
   Integer(2),
   String('an '),
   Integer(3),
   String('the '),
   Integer(4),
   Identifier('s'),
   Identifier('chop.word'),
   Identifier('chop.word'),
   Identifier('chop.word')]],
 ['FUNCTION',
  [Identifier('format.sort.title')],
  [Identifier('sortify'),
   Identifier('chop.articles'),
   Integer(1),
   Identifier('entry.max$'),
   Identifier('substring$')]],
 ['FUNCTION',
  [Identifier('make.sort.title')],
  [Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('text'), Identifier('empty$'), FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([Identifier('howpublished'), Identifier('empty$'), FunctionLiteral([Identifier('note'), Identifier('empty$'), FunctionLiteral([Identifier('url'), Identifier('empty$'), FunctionLiteral([String(' ')]), FunctionLiteral([Identifier('url'), Identifier('format.sort.title')]), Identifier('if$')]), FunctionLiteral([Identifier('note'), Identifier('format.sort.title')]), Identifier('if$')]), FunctionLiteral([Identifier('howpublished'), Identifier('format.sort.title')]), Identifier('if$')]), FunctionLiteral([Identifier('type'), Identifier('format.sort.title')]), Identifier('if$')]), FunctionLiteral([Identifier('text'), Identifier('format.sort.title')]), Identifier('if$')]),
   FunctionLiteral([Identifier('title'), Identifier('format.sort.title')]),
   Identifier('if$'),
   Identifier('remove.spaces'),
   QuotedVar('title.sort.label'),
   Identifier(':='),
   Identifier('title.sort.label'),
   QuotedVar('sort.key$'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('make.title.number')],
  [Identifier('title.sort.label'),
   Identifier('old.label'),
   Identifier('='),
   FunctionLiteral([Identifier('old.number'), QuotedVar('title.number'), Identifier(':=')]),
   FunctionLiteral([Identifier('old.number'), Integer(1), Identifier('+'), QuotedVar('title.number'), Identifier(':='), Identifier('title.number'), QuotedVar('old.number'), Identifier(':='), Identifier('title.sort.label'), QuotedVar('old.label'), Identifier(':=')]),
   Identifier('if$')]],
 ['FUNCTION', [Identifier('last.part.name.format')], [String('{ll}')]],
 ['FUNCTION',
  [Identifier('initials.with.space.name.format')],
  [String('{f.}')]],
 ['FUNCTION',
  [Identifier('von.last.junior.name.format')],
  [String('{vv }{ll}{ jj}')]],
 ['FUNCTION',
  [Identifier('von.junior.name.format')],
  [String('{ vv}{, jj}')]],
 ['FUNCTION',
  [Identifier('one.complete.name.format')],
  [String('{vv }{ll}{, jj}{, ff}')]],
 ['FUNCTION',
  [Identifier('string.length')],
  [Integer(0),
   QuotedVar('pos'),
   Identifier(':='),
   FunctionLiteral([Identifier('duplicate$'), Identifier('pos'), Integer(1), Identifier('+'), Integer(1), Identifier('substring$'), String(''), Identifier('='), Identifier('not')]),
   FunctionLiteral([Identifier('pos'), Integer(1), Identifier('+'), QuotedVar('pos'), Identifier(':=')]),
   Identifier('while$'),
   Identifier('pop$'),
   Identifier('pos')]],
 ['FUNCTION',
  [Identifier('transform.spaces.and.hyphens')],
  [QuotedVar('s'),
   Identifier(':='),
   Identifier('s'),
   Identifier('string.length'),
   QuotedVar('len'),
   Identifier(':='),
   String(''),
   QuotedVar('t'),
   Identifier(':='),
   Integer(1),
   QuotedVar('pos'),
   Identifier(':='),
   Integer(0),
   QuotedVar('brace.level'),
   Identifier(':='),
   FunctionLiteral([Identifier('pos'), Identifier('len'), Identifier('<')]),
   FunctionLiteral([Identifier('brace.level'), Integer(0), Identifier('='), FunctionLiteral([Identifier('s'), Identifier('pos'), Integer(2), Identifier('substring$'), String('. '), Identifier('='), Identifier('s'), Identifier('pos'), Integer(2), Identifier('substring$'), String('.~'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('t'), String('\\BPBI '), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('pos'), Integer(2), Identifier('+'), QuotedVar('pos'), Identifier(':=')]), FunctionLiteral([Identifier('s'), Identifier('pos'), Integer(2), Identifier('substring$'), String('.-'), Identifier('='), FunctionLiteral([Identifier('t'), String('\\BHBI '), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('pos'), Integer(2), Identifier('+'), QuotedVar('pos'), Identifier(':=')]), FunctionLiteral([Identifier('t'), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), String('{'), Identifier('='), FunctionLiteral([Identifier('brace.level'), Integer(1), Identifier('+'), QuotedVar('brace.level'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$'), Identifier('pos'), Integer(1), Identifier('+'), QuotedVar('pos'), Identifier(':=')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('t'), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), Identifier('*'), QuotedVar('t'), Identifier(':='), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), String('{'), Identifier('='), FunctionLiteral([Identifier('brace.level'), Integer(1), Identifier('+'), QuotedVar('brace.level'), Identifier(':=')]), FunctionLiteral([Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), String('}'), Identifier('='), FunctionLiteral([Identifier('brace.level'), Integer(1), Identifier('-'), QuotedVar('brace.level'), Identifier(':=')]), QuotedVar('skip$'), Identifier('if$')]), Identifier('if$'), Identifier('pos'), Integer(1), Identifier('+'), QuotedVar('pos'), Identifier(':=')]), Identifier('if$')]),
   Identifier('while$'),
   Identifier('pos'),
   Identifier('len'),
   Identifier('='),
   FunctionLiteral([Identifier('t'), Identifier('s'), Identifier('pos'), Integer(1), Identifier('substring$'), Identifier('*'), QuotedVar('t'), Identifier(':=')]),
   FunctionLiteral([Identifier('s'), Identifier('len'), Integer(1), Identifier('-'), Integer(2), Identifier('substring$'), Identifier('t'), Identifier('text.length$'), QuotedVar('len'), Identifier(':='), Identifier('t'), Integer(1), Identifier('len'), Integer(6), Identifier('-'), Identifier('substring$'), Identifier('swap$'), Identifier('*'), QuotedVar('t'), Identifier(':=')]),
   Identifier('if$'),
   Identifier('t')]],
 ['FUNCTION',
  [Identifier('format.initials.with.hyphen')],
  [Identifier('initials.with.space.name.format'),
   Identifier('format.name$'),
   Identifier('transform.spaces.and.hyphens')]],
 ['FUNCTION',
  [Identifier('format.last.part.name')],
  [Identifier('last.part.name.format'), Identifier('format.name$')]],
 ['FUNCTION',
  [Identifier('format.von.last.junior.name')],
  [Identifier('von.last.junior.name.format'), Identifier('format.name$')]],
 ['FUNCTION',
  [Identifier('format.von.junior.name')],
  [Identifier('von.junior.name.format'), Identifier('format.name$')]],
 ['FUNCTION',
  [Identifier('format.cite.initials.name')],
  [Identifier('one.complete.name.format'),
   Identifier('format.name$'),
   Identifier('duplicate$'),
   Integer(1),
   Identifier('format.initials.with.hyphen'),
   Identifier('swap$'),
   Integer(1),
   Identifier('format.von.last.junior.name'),
   String('~'),
   Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('format.author.name')],
  [Identifier('one.complete.name.format'),
   Identifier('format.name$'),
   Identifier('duplicate$'),
   Identifier('duplicate$'),
   Integer(1),
   Identifier('format.last.part.name'),
   Identifier('swap$'),
   Integer(1),
   Identifier('format.initials.with.hyphen'),
   Identifier('connect.with.comma.check'),
   Identifier('swap$'),
   Integer(1),
   Identifier('format.von.junior.name'),
   String(''),
   Identifier('connect.check')]],
 ['FUNCTION',
  [Identifier('format.editor.name')],
  [Identifier('format.cite.initials.name')]],
 ['FUNCTION',
  [Identifier('format.index.name')],
  [Identifier('format.author.name')]],
 ['FUNCTION', [Identifier('comma.between.two')], [String('\\BCBT{}')]],
 ['FUNCTION', [Identifier('comma.between.names')], [String(', ')]],
 ['FUNCTION', [Identifier('comma.before.last')], [String('\\BCBL{}')]],
 ['FUNCTION', [Identifier('and.before.last')], [String('\\ \\BBA{} ')]],
 ['FUNCTION',
  [Identifier('et.al.string.cite')],
  [String('\\ \\protect\\BOthers{.}')]],
 ['FUNCTION', [Identifier('et.al.string')], [String('\\ \\BOthers{.}')]],
 ['FUNCTION',
  [Identifier('et.al.string.period')],
  [String('\\ \\BOthersPeriod{.}')]],
 ['FUNCTION',
  [Identifier('add.name.index')],
  [Identifier('make.index'),
   FunctionLiteral([String('%'), Identifier('*'), Identifier('write$'), Identifier('newline$'), Identifier('field'), Identifier('is.bibcorporate'), FunctionLiteral([String('\\corporateAX{')]), FunctionLiteral([String('\\AX{')]), Identifier('if$'), Identifier('write$'), Identifier('field'), Identifier('nameptr'), Identifier('sort.name.format'), Identifier('format.name$'), Identifier('sortify'), Identifier('write$'), Identifier('newline$'), String('@'), Identifier('write$'), Identifier('field'), Identifier('nameptr'), Identifier('format.index.name'), String('}%'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   FunctionLiteral([String('%'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.name.cite.label')],
  [QuotedVar('field'),
   Identifier(':='),
   QuotedVar('format.num.names'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('format.num.names'),
   Identifier('numnames'),
   Integer(1),
   Identifier('-'),
   Identifier('='),
   FunctionLiteral([Identifier('numnames'), QuotedVar('format.num.names'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('cite.initials'),
   Integer(1),
   Identifier('='),
   FunctionLiteral([Identifier('field'), Identifier('nameptr'), Identifier('format.cite.initials.name')]),
   FunctionLiteral([Identifier('field'), Identifier('nameptr'), Identifier('cite.name.format'), Identifier('format.name$')]),
   Identifier('if$'),
   Identifier('add.name.index'),
   Identifier('numnames'),
   Integer(1),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.num.names'), Integer(1), Identifier('='), FunctionLiteral([Identifier('et.al.string.cite'), Identifier('write$')]), FunctionLiteral([Identifier('numnames'), Integer(2), Identifier('='), FunctionLiteral([Integer(2), QuotedVar('nameptr'), Identifier(':='), Identifier('field'), Identifier('nameptr'), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('s'), Identifier(':='), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('et.al.string.cite'), Identifier('write$')]), FunctionLiteral([Identifier('and.before.last'), Identifier('write$'), Identifier('s'), Identifier('add.name.index')]), Identifier('if$')]), FunctionLiteral([Integer(2), QuotedVar('nameptr'), Identifier(':='), FunctionLiteral([Identifier('nameptr'), Identifier('format.num.names'), Identifier('<')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('write$'), Identifier('field'), Identifier('nameptr'), Identifier('cite.name.format'), Identifier('format.name$'), Identifier('add.name.index'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':=')]), Identifier('while$'), Identifier('field'), Identifier('nameptr'), Identifier('cite.name.format'), Identifier('format.name$'), QuotedVar('s'), Identifier(':='), Identifier('format.num.names'), Identifier('numnames'), Identifier('='), FunctionLiteral([Identifier('comma.before.last'), Identifier('write$'), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('et.al.string.cite'), Identifier('write$')]), FunctionLiteral([Identifier('and.before.last'), Identifier('write$'), Identifier('s'), Identifier('add.name.index')]), Identifier('if$')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('write$'), Identifier('s'), Identifier('add.name.index'), Identifier('comma.before.last'), Identifier('et.al.string.cite'), Identifier('*'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.title.cite.label')],
  [Identifier('is.atype'),
   FunctionLiteral([String('\\APACciteatitle{')]),
   FunctionLiteral([String('\\APACcitebtitle{')]),
   Identifier('if$'),
   Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('text'), Identifier('empty$'), FunctionLiteral([Identifier('type'), Identifier('empty$'), FunctionLiteral([Identifier('howpublished'), Identifier('empty$'), FunctionLiteral([Identifier('note'), Identifier('empty$'), FunctionLiteral([Identifier('url'), Identifier('empty$'), FunctionLiteral([Identifier('cite$')]), FunctionLiteral([Identifier('url')]), Identifier('if$')]), FunctionLiteral([Identifier('note')]), Identifier('if$')]), FunctionLiteral([Identifier('howpublished')]), Identifier('if$')]), FunctionLiteral([Identifier('type')]), Identifier('if$')]), FunctionLiteral([Identifier('text')]), Identifier('if$')]),
   FunctionLiteral([Identifier('title')]),
   Identifier('if$'),
   Identifier('*'),
   String('}'),
   Identifier('*'),
   Identifier('write$')]],
 ['FUNCTION',
  [Identifier('make.author.editor.cite.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('make.title.cite.label'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('make.title.cite.label')]), FunctionLiteral([Identifier('cite.num.names.full'), Identifier('editor'), Identifier('make.name.cite.label'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('cite.num.names.short'), Identifier('editor'), Identifier('make.name.cite.label')]), Identifier('if$')]),
   FunctionLiteral([Identifier('cite.num.names.full'), Identifier('author'), Identifier('make.name.cite.label'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('cite.num.names.short'), Identifier('author'), Identifier('make.name.cite.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.author.cite.label')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('make.title.cite.label'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('make.title.cite.label')]),
   FunctionLiteral([Identifier('cite.num.names.full'), Identifier('author'), Identifier('make.name.cite.label'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('cite.num.names.short'), Identifier('author'), Identifier('make.name.cite.label')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.definitive.year.supplement')],
  [Identifier('add.to.year'),
   Integer(0),
   Identifier('='),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('{\\protect'), Identifier('year'), Identifier('empty$'), FunctionLiteral([String('\\BCntND'), Identifier('*')]), FunctionLiteral([Identifier('year'), String('\\bibnodate'), Identifier('='), FunctionLiteral([String('\\BCntND'), Identifier('*')]), FunctionLiteral([Identifier('year'), String('\\BIP'), Identifier('='), FunctionLiteral([String('\\BCntIP'), Identifier('*')]), FunctionLiteral([String('\\BCnt'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$'), String('{'), Identifier('*'), Identifier('add.to.year'), Identifier('int.to.str$'), Identifier('*'), String('}}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('protect.year')],
  [Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([String('{\\protect\\bibnodate{}}')]),
   FunctionLiteral([Identifier('year'), String('\\bibnodate'), Identifier('='), FunctionLiteral([String('{\\protect\\bibnodate{}}')]), FunctionLiteral([Identifier('year'), String('\\BIP'), Identifier('='), FunctionLiteral([String('{\\protect\\BIP{}}')]), FunctionLiteral([Identifier('year')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('make.definitive.year.label')],
  [String('{\\protect\\APACyear{'),
   Identifier('originalyear'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('protect.year')]),
   FunctionLiteral([Identifier('originalyear'), String('\\bibnodate'), Identifier('='), FunctionLiteral([Identifier('translator'), Identifier('empty$'), FunctionLiteral([Identifier('protect.year')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([String('{\\protect\\BTRANSL{}~\\protect\\bibnodate{}}')]), FunctionLiteral([String('{\\protect\\BTRANSL{}}~'), Identifier('protect.year'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('year'), Identifier('empty$'), FunctionLiteral([Identifier('originalyear'), String('/{\\protect\\bibnodate{}}'), Identifier('*')]), FunctionLiteral([Identifier('originalyear'), Identifier('year'), Identifier('='), FunctionLiteral([Identifier('protect.year')]), FunctionLiteral([Identifier('originalyear'), String('/'), Identifier('*'), Identifier('protect.year'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('*'),
   String('}}%'),
   Identifier('*'),
   Identifier('write$'),
   Identifier('newline$'),
   String('{\\protect\\APACexlab{'),
   String('}}'),
   Identifier('make.definitive.year.supplement'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('make.cite.labels')],
  [Identifier('newline$'),
   Identifier('test'),
   FunctionLiteral([String('\\bibitem[]{} \\fullciteA{'), Identifier('cite$'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$'), Identifier('newline$'), String('\\bibitem[]{} \\citeA{'), Identifier('cite$'), Identifier('*'), String('}'), Identifier('*'), Identifier('write$'), Identifier('newline$')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   String('\\bibitem[\\protect\\citeauthoryear{%'),
   Identifier('write$'),
   Identifier('newline$'),
   Identifier('firstkey'),
   Identifier('empty$'),
   Identifier('not'),
   FunctionLiteral([Identifier('firstkey'), Identifier('write$'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('cite.initials'), Integer(0), Identifier('='), Identifier('key'), Identifier('empty$'), Identifier('not'), Identifier('and'), FunctionLiteral([Identifier('key')]), FunctionLiteral([Identifier('firstkey')]), Identifier('if$'), Identifier('write$')]),
   FunctionLiteral([Identifier('key'), Identifier('empty$'), Identifier('not'), FunctionLiteral([Identifier('key'), Identifier('write$'), String('}{%'), Identifier('write$'), Identifier('newline$'), Identifier('key'), Identifier('write$')]), FunctionLiteral([Identifier('ref.type'), Integer(2), Identifier('='), FunctionLiteral([Identifier('make.author.cite.label')]), FunctionLiteral([Identifier('make.author.editor.cite.label')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$'),
   String('}{%'),
   Identifier('write$'),
   Identifier('newline$'),
   Identifier('make.definitive.year.label'),
   Identifier('write$'),
   String('}]{%'),
   Identifier('write$'),
   Identifier('newline$'),
   Identifier('cite$'),
   Identifier('write$'),
   String('}%'),
   Identifier('write$'),
   Identifier('newline$'),
   String('\\APACinsertmetastar{%'),
   Identifier('write$'),
   Identifier('newline$'),
   Identifier('cite$'),
   Identifier('write$'),
   String('}%'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('editor.postfix')],
  [Identifier('editor'),
   Identifier('num.names$'),
   Integer(1),
   Identifier('>'),
   FunctionLiteral([String('(\\BEDS)')]),
   FunctionLiteral([String('(\\BED)')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('editor.trans.postfix')],
  [Identifier('editor'),
   Identifier('num.names$'),
   Integer(1),
   Identifier('>'),
   FunctionLiteral([String('(\\BEDS{} \\BAnd{} \\BTRANSS)')]),
   FunctionLiteral([String('(\\BED{} \\BAnd{} \\BTRANS)')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('trans.postfix')],
  [Identifier('translator'),
   Identifier('num.names$'),
   Integer(1),
   Identifier('>'),
   FunctionLiteral([String('(\\BTRANSS)')]),
   FunctionLiteral([String('(\\BTRANS)')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.author.names')],
  [QuotedVar('field'),
   Identifier(':='),
   QuotedVar('dot'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('format.num.names'),
   Identifier(':='),
   Identifier('format.num.names'),
   Identifier('name.max'),
   Identifier('>'),
   FunctionLiteral([Identifier('dot'), FunctionLiteral([Identifier('name.max'), QuotedVar('format.num.names'), Identifier(':=')]), FunctionLiteral([Identifier('cite.num.names.full'), QuotedVar('format.num.names'), Identifier(':=')]), Identifier('if$')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Integer(1),
   QuotedVar('nameptr'),
   Identifier(':='),
   Identifier('field'),
   Identifier('nameptr'),
   Identifier('format.author.name'),
   Identifier('numnames'),
   Integer(1),
   Identifier('='),
   Identifier('dot'),
   Identifier('and'),
   FunctionLiteral([Identifier('add.period$')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('add.name.index'),
   Identifier('numnames'),
   Integer(1),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.num.names'), Integer(1), Identifier('='), FunctionLiteral([Identifier('comma.between.two'), Identifier('dot'), FunctionLiteral([Identifier('et.al.string.period'), Identifier('*')]), FunctionLiteral([Identifier('et.al.string'), Identifier('*')]), Identifier('if$'), Identifier('write$')]), FunctionLiteral([Identifier('numnames'), Integer(2), Identifier('='), FunctionLiteral([Identifier('comma.between.two'), Identifier('write$'), Integer(2), QuotedVar('nameptr'), Identifier(':='), Identifier('field'), Identifier('nameptr'), Identifier('format.author.name'), QuotedVar('s'), Identifier(':='), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('dot'), FunctionLiteral([Identifier('et.al.string.period')]), FunctionLiteral([Identifier('et.al.string')]), Identifier('if$'), Identifier('write$')]), FunctionLiteral([Identifier('and.before.last'), Identifier('write$'), Identifier('dot'), FunctionLiteral([Identifier('s'), Identifier('add.period$')]), FunctionLiteral([Identifier('s')]), Identifier('if$'), Identifier('add.name.index')]), Identifier('if$')]), FunctionLiteral([Integer(2), QuotedVar('nameptr'), Identifier(':='), FunctionLiteral([Identifier('nameptr'), Identifier('format.num.names'), Identifier('<')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('write$'), Identifier('field'), Identifier('nameptr'), Identifier('format.author.name'), Identifier('add.name.index'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':=')]), Identifier('while$'), Identifier('field'), Identifier('nameptr'), Identifier('format.author.name'), QuotedVar('s'), Identifier(':='), Identifier('format.num.names'), Identifier('numnames'), Identifier('='), FunctionLiteral([Identifier('comma.before.last'), Identifier('write$'), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('dot'), FunctionLiteral([Identifier('et.al.string.period')]), FunctionLiteral([Identifier('et.al.string')]), Identifier('if$'), Identifier('write$')]), FunctionLiteral([Identifier('and.before.last'), Identifier('write$'), Identifier('dot'), FunctionLiteral([Identifier('s'), Identifier('add.period$')]), FunctionLiteral([Identifier('s')]), Identifier('if$'), Identifier('add.name.index')]), Identifier('if$')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('write$'), Identifier('s'), Identifier('add.name.index'), Identifier('comma.before.last'), Identifier('dot'), FunctionLiteral([Identifier('et.al.string.period'), Identifier('*')]), FunctionLiteral([Identifier('et.al.string'), Identifier('*')]), Identifier('if$'), Identifier('write$')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.authors')],
  [Integer(1),
   Identifier('author'),
   Identifier('format.author.names'),
   String('%'),
   Identifier('write$')]],
 ['FUNCTION',
  [Identifier('format.editors.as.authors')],
  [Integer(0),
   Identifier('editor'),
   Identifier('format.author.names'),
   String('\\ '),
   Identifier('editor.postfix'),
   Identifier('*'),
   Identifier('add.period$'),
   Identifier('write$')]],
 ['FUNCTION',
  [Identifier('format.ed.trans.as.authors')],
  [Integer(0),
   Identifier('editor'),
   Identifier('format.author.names'),
   String('\\ '),
   Identifier('editor.trans.postfix'),
   Identifier('*'),
   Identifier('add.period$'),
   Identifier('write$')]],
 ['FUNCTION',
  [Identifier('format.editor.names')],
  [QuotedVar('field'),
   Identifier(':='),
   Identifier('field'),
   Identifier('num.names$'),
   QuotedVar('numnames'),
   Identifier(':='),
   Identifier('numnames'),
   QuotedVar('format.num.names'),
   Identifier(':='),
   Identifier('format.num.names'),
   Identifier('name.max'),
   Identifier('>'),
   FunctionLiteral([Integer(1), QuotedVar('format.num.names'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('field'),
   Integer(1),
   Identifier('format.editor.name'),
   Identifier('numnames'),
   Integer(1),
   Identifier('='),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.num.names'), Integer(1), Identifier('='), FunctionLiteral([Identifier('et.al.string'), Identifier('*')]), FunctionLiteral([Identifier('numnames'), Integer(2), Identifier('='), FunctionLiteral([Identifier('field'), Integer(2), Identifier('format.editor.name'), QuotedVar('s'), Identifier(':='), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('et.al.string'), Identifier('*')]), FunctionLiteral([Identifier('and.before.last'), Identifier('*'), Identifier('s'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Integer(2), QuotedVar('nameptr'), Identifier(':='), FunctionLiteral([Identifier('nameptr'), Identifier('format.num.names'), Identifier('<')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('*'), Identifier('field'), Identifier('nameptr'), Identifier('format.editor.name'), Identifier('*'), Identifier('nameptr'), Integer(1), Identifier('+'), QuotedVar('nameptr'), Identifier(':=')]), Identifier('while$'), Identifier('field'), Identifier('nameptr'), Identifier('format.editor.name'), QuotedVar('s'), Identifier(':='), Identifier('format.num.names'), Identifier('numnames'), Identifier('='), FunctionLiteral([Identifier('comma.before.last'), Identifier('*'), Identifier('s'), String('others'), Identifier('='), FunctionLiteral([Identifier('et.al.string'), Identifier('*')]), FunctionLiteral([Identifier('and.before.last'), Identifier('*'), Identifier('s'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([Identifier('comma.between.names'), Identifier('*'), Identifier('s'), Identifier('*'), Identifier('comma.before.last'), Identifier('*'), Identifier('et.al.string'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.editors.in.line')],
  [Identifier('editor'),
   Identifier('format.editor.names'),
   Identifier('editor.postfix'),
   Identifier('connect.with.space.check')]],
 ['FUNCTION',
  [Identifier('format.editors.trans.in.line')],
  [Identifier('editor'),
   Identifier('format.editor.names'),
   Identifier('editor.trans.postfix'),
   Identifier('connect.with.space.check')]],
 ['FUNCTION',
  [Identifier('format.translators.in.line')],
  [Identifier('translator'),
   Identifier('format.editor.names'),
   Identifier('trans.postfix'),
   Identifier('connect.with.space.check')]],
 ['FUNCTION',
  [Identifier('format.translators.in.paren.check')],
  [Identifier('translator'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('translator'), Identifier('format.editor.names'), Identifier('translator'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(', \\BTRANSS{}'), Identifier('*')]), FunctionLiteral([String(', \\BTRANS{}'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.editors.translators.in.paren.check')],
  [Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('translator'), Identifier('empty$'), FunctionLiteral([String('')]), FunctionLiteral([Identifier('translator'), Identifier('format.editor.names'), Identifier('translator'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(', \\BTRANSS{}'), Identifier('*')]), FunctionLiteral([String(', \\BTRANS{}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('editor'), Identifier('format.editor.names'), Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(', \\BEDS{}'), Identifier('*')]), FunctionLiteral([String(', \\BED{}'), Identifier('*')]), Identifier('if$'), Identifier('translator'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('editor'), Identifier('translator'), Identifier('='), FunctionLiteral([Identifier('editor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(' \\BAnd{} \\BTRANSS'), Identifier('*')]), FunctionLiteral([String(' \\BAnd{} \\BTRANS'), Identifier('*')]), Identifier('if$')]), FunctionLiteral([String(' \\BAnd{} '), Identifier('*'), Identifier('translator'), Identifier('format.editor.names'), Identifier('*'), Identifier('translator'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String(', \\BTRANSS{}'), Identifier('*')]), FunctionLiteral([String(', \\BTRANS{}'), Identifier('*')]), Identifier('if$')]), Identifier('if$')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.atrans.check')],
  [Identifier('format.translators.in.paren.check'),
   Identifier('parenthesize.check')]],
 ['FUNCTION',
  [Identifier('format.in.editors')],
  [String('\\BIn{} '),
   Identifier('editor'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.editors.in.line'), Identifier('*'), String(', '), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.in.trans')],
  [String('\\BIn{} '),
   Identifier('translator'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('format.translators.in.line'), Identifier('*'), String(', '), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.in.editors.trans')],
  [String('\\BIn{} '),
   Identifier('editor'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('translator'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('format.translators.in.line'), Identifier('*'), String(', '), Identifier('*')]), Identifier('if$')]),
   FunctionLiteral([Identifier('translator'), Identifier('empty$'), FunctionLiteral([Identifier('format.editors.in.line'), Identifier('*')]), FunctionLiteral([Identifier('editor'), Identifier('translator'), Identifier('='), FunctionLiteral([Identifier('format.editors.trans.in.line'), Identifier('*')]), FunctionLiteral([Identifier('format.editors.in.line'), Identifier('*')]), Identifier('if$')]), Identifier('if$'), String(', '), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.year.check')],
  [String('\\APACrefYear{'),
   Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([String('\\bibnodate{}'), Identifier('*')]),
   FunctionLiteral([Identifier('year'), Identifier('*')]),
   Identifier('if$'),
   Identifier('make.definitive.year.supplement'),
   Identifier('*'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.year.month.day.check')],
  [String('\\APACrefYearMonthDay{'),
   Identifier('year'),
   Identifier('empty$'),
   FunctionLiteral([String('\\bibnodate{}'), Identifier('*')]),
   FunctionLiteral([Identifier('year'), Identifier('*')]),
   Identifier('if$'),
   Identifier('make.definitive.year.supplement'),
   Identifier('*'),
   String('}{'),
   Identifier('*'),
   Identifier('month'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('month'), Identifier('*')]),
   Identifier('if$'),
   String('}{'),
   Identifier('*'),
   Identifier('day'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('day'), Identifier('*')]),
   Identifier('if$'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.atitle.no.dot')],
  [String('\\BBOQ{}'),
   Identifier('swap$'),
   String('\\BBCQ{}'),
   Identifier('swap$'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), String('\\APACrefatitle{'), Identifier('swap$'), Identifier('*'), String('}{'), Identifier('*'), Identifier('swap$'), String('t'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('format.atitle.dot')],
  [String('\\BBOQ{}'),
   Identifier('swap$'),
   String('\\BBCQ{}'),
   Identifier('swap$'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), String('\\APACrefatitle{'), Identifier('swap$'), Identifier('*'), String('}{'), Identifier('*'), Identifier('swap$'), String('t'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('format.atitle.connect')],
  [Identifier('swap$'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), Identifier('format.atitle.dot')]),
   FunctionLiteral([Identifier('swap$'), Identifier('format.atitle.no.dot'), Identifier('swap$'), Identifier('connect.with.space.check'), Identifier('add.period$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.btitle.no.dot')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), String('\\APACrefbtitle{'), Identifier('swap$'), Identifier('*'), String('}{'), Identifier('*'), Identifier('swap$'), String('t'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.btitle.dot')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('add.period$'), Identifier('format.btitle.no.dot')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.btitle.connect')],
  [Identifier('swap$'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), Identifier('format.btitle.dot')]),
   FunctionLiteral([Identifier('swap$'), Identifier('format.btitle.no.dot'), Identifier('swap$'), Identifier('connect.with.space.check'), Identifier('add.period$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.btitle.connect.no.dot')],
  [Identifier('swap$'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('pop$'), Identifier('format.btitle.no.dot')]),
   FunctionLiteral([Identifier('swap$'), Identifier('format.btitle.no.dot'), Identifier('swap$'), Identifier('connect.with.space.check')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.aetitle.check')],
  [Identifier('englishtitle'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('\\APACrefaetitle{'), Identifier('englishtitle'), Identifier('*'), String('}{'), Identifier('*'), Identifier('englishtitle'), String('t'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.betitle.check')],
  [Identifier('englishtitle'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([String('\\APACrefbetitle{'), Identifier('englishtitle'), Identifier('*'), String('}{'), Identifier('*'), Identifier('englishtitle'), String('t'), Identifier('change.case$'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.atype.check')],
  [Identifier('type'), Identifier('bracket.check')]],
 ['FUNCTION',
  [Identifier('format.atitle.check')],
  [Identifier('format.aetitle.check'),
   Identifier('title'),
   Identifier('format.atitle.connect')]],
 ['FUNCTION',
  [Identifier('format.atitle.type.check')],
  [Identifier('format.aetitle.check'),
   Identifier('format.atype.check'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.atitle.connect')]],
 ['FUNCTION',
  [Identifier('format.atitle.trans.check')],
  [Identifier('format.aetitle.check'),
   Identifier('format.atrans.check'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.atitle.connect')]],
 ['FUNCTION',
  [Identifier('format.atitle.type.trans.check')],
  [Identifier('format.aetitle.check'),
   Identifier('format.atype.check'),
   Identifier('connect.with.space.check'),
   Identifier('format.atrans.check'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.atitle.connect')]],
 ['FUNCTION',
  [Identifier('format.journal.vol.num.pages.check')],
  [String('journal'),
   Identifier('journal'),
   Identifier('warning.if.empty'),
   Identifier('duplicate$'),
   Identifier('empty$'),
   Identifier('journal'),
   Identifier('empty$'),
   Identifier('and'),
   Identifier('volume'),
   Identifier('empty$'),
   Identifier('and'),
   Identifier('number'),
   Identifier('empty$'),
   Identifier('and'),
   FunctionLiteral([Identifier('pop$'), String('')]),
   FunctionLiteral([String('\\APACjournalVolNumPages{'), Identifier('journal'), String(''), Identifier('connect.check'), String('}{'), Identifier('*'), Identifier('volume'), String(''), Identifier('connect.check'), String('}{'), Identifier('*'), Identifier('number'), String(''), Identifier('connect.check'), String('}{'), Identifier('*'), Identifier('swap$'), String(''), Identifier('connect.check'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.bvolume.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('multi.result.check'), FunctionLiteral([String('\\BVOLS'), Identifier('swap$'), Identifier('tie.or.space.connect')]), FunctionLiteral([String('\\BVOL'), Identifier('swap$'), Identifier('tie.or.space.connect')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.edition.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\PrintOrdinal{'), Identifier('swap$'), Identifier('*'), String('}'), Identifier('*'), String('\\BEd'), Identifier('connect.with.space.check')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.bvol.edition.check')],
  [Identifier('edition'),
   Identifier('format.edition.check'),
   Identifier('volume'),
   Identifier('format.bvolume.check'),
   Identifier('connect.with.comma.check')]],
 ['FUNCTION',
  [Identifier('format.bvol.edition')],
  [Identifier('format.bvol.edition.check'),
   Identifier('parenthesize.check')]],
 ['FUNCTION',
  [Identifier('format.bvol.edition.trans')],
  [Identifier('format.bvol.edition.check'),
   Identifier('format.translators.in.paren.check'),
   Identifier('connect.with.semicolon.check'),
   Identifier('parenthesize.check')]],
 ['FUNCTION',
  [Identifier('format.bvol.edition.editor.trans')],
  [Identifier('format.bvol.edition.check'),
   Identifier('format.editors.translators.in.paren.check'),
   Identifier('connect.with.semicolon.check'),
   Identifier('parenthesize.check')]],
 ['FUNCTION',
  [Identifier('format.bpages.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('multi.result.check'), FunctionLiteral([String('\\BPGS'), Identifier('swap$'), Identifier('tie.or.space.connect')]), FunctionLiteral([String('\\BPG~'), Identifier('swap$'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.bchapter.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('multi.result.check'), FunctionLiteral([String('\\BCHAPS'), Identifier('swap$'), Identifier('tie.or.space.connect')]), FunctionLiteral([String('\\BCHAP'), Identifier('swap$'), Identifier('tie.or.space.connect')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.bvol.edition.pages')],
  [Identifier('format.bvol.edition.check'),
   Identifier('pages'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('chapter'), Identifier('format.bchapter.check'), Identifier('connect.with.comma.check')]),
   FunctionLiteral([Identifier('pages'), Identifier('format.bpages.check'), Identifier('connect.with.comma.check')]),
   Identifier('if$'),
   Identifier('parenthesize.check')]],
 ['FUNCTION',
  [Identifier('format.btitle.vol.edition')],
  [Identifier('format.betitle.check'),
   Identifier('format.bvol.edition'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.btitle.connect.no.dot')]],
 ['FUNCTION',
  [Identifier('format.btitle.vol.edition.trans')],
  [Identifier('format.betitle.check'),
   Identifier('format.bvol.edition.trans'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.btitle.connect.no.dot')]],
 ['FUNCTION',
  [Identifier('format.btitle.vol.edition.editor.trans')],
  [Identifier('format.betitle.check'),
   Identifier('format.bvol.edition.editor.trans'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.btitle.connect.no.dot')]],
 ['FUNCTION',
  [Identifier('format.address.publisher')],
  [Identifier('author'),
   Identifier('empty$'),
   Identifier('publisher'),
   Identifier('empty$'),
   Identifier('or'),
   FunctionLiteral([Identifier('publisher'), String('\\APACaddressPublisher{')]),
   FunctionLiteral([Identifier('author'), Identifier('publisher'), Identifier('='), String('author'), Identifier('publisher'), Identifier('='), Identifier('or'), String('Author'), Identifier('publisher'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('author'), String('\\APACaddressPublisherEqAuth{')]), FunctionLiteral([Identifier('publisher'), String('\\APACaddressPublisher{')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('address'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('swap$'),
   String(''),
   Identifier('connect.check'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.address.publisher.check')],
  [String('publisher'),
   Identifier('publisher'),
   Identifier('warning.if.empty'),
   String('address'),
   Identifier('address'),
   Identifier('warning.if.empty'),
   Identifier('publisher'),
   Identifier('empty$'),
   Identifier('address'),
   Identifier('empty$'),
   Identifier('and'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.address.publisher')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.rnumber.check')],
  [Identifier('duplicate$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('multi.result.check'), FunctionLiteral([String('\\BNUMS'), Identifier('swap$'), Identifier('tie.or.space.connect')]), FunctionLiteral([String('\\BNUM'), Identifier('swap$'), Identifier('tie.or.space.connect')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.type.number')],
  [Identifier('type'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('type.2')]),
   FunctionLiteral([Identifier('type')]),
   Identifier('if$'),
   Identifier('number'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('bracket.check')]),
   FunctionLiteral([Identifier('number'), Identifier('format.rnumber.check'), Identifier('connect.with.space.check'), Identifier('parenthesize.check')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.howpublished')],
  [Identifier('howpublished'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('pop$'), FunctionLiteral([Identifier('output.dot.new.block')]), Identifier('if$'), String('\\APAChowpublished{'), Identifier('howpublished'), Identifier('*'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('output.howpublished')],
  [Identifier('howpublished'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('\\APAChowpublished{'), Identifier('howpublished'), Identifier('*'), String('}'), Identifier('*'), Identifier('output.dot.new.block')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('begin.end.url.env')],
  [String(' \\begin{APACrefURL} '),
   Identifier('lastchecked'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([String('[{'), Identifier('*'), Identifier('lastchecked'), Identifier('*'), String('}]'), Identifier('*')]),
   Identifier('if$'),
   String(' \\end{APACrefURL} ')]],
 ['FUNCTION',
  [Identifier('begin.end.msg.env')],
  [String(' \\begin{APACrefURLmsg} '), String(' \\end{APACrefURLmsg} ')]],
 ['FUNCTION',
  [Identifier('format.url')],
  [Identifier('type.2'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('begin.end.url.env')]),
   FunctionLiteral([Identifier('type.2'), String('\\bibmessage'), Identifier('='), FunctionLiteral([Identifier('begin.end.msg.env')]), FunctionLiteral([Identifier('begin.end.url.env')]), Identifier('if$')]),
   Identifier('if$'),
   String('\\url{'),
   Identifier('url'),
   Identifier('*'),
   String('}'),
   Identifier('*'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('format.note')],
  [String('\\APACrefnote{'),
   String('}'),
   Identifier('note'),
   Identifier('enclose.check')]],
 ['FUNCTION',
  [Identifier('format.orig.year.note')],
  [Identifier('originalyear'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.note')]),
   FunctionLiteral([String('\\APACorigyearnote{'), Identifier('originalyear'), String(''), Identifier('connect.check'), String('}{'), Identifier('*'), Identifier('note'), String(''), Identifier('connect.check'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.orig.journal.note')],
  [String('\\APACorigjournalnote{'),
   Identifier('originalyear'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originaljournal'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalvolume'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalnumber'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalpages'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('note'),
   String(''),
   Identifier('connect.check'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.orig.book.note')],
  [String('\\APACorigbooknote{'),
   Identifier('originalyear'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originaleditor'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('originaleditor'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('\\APACorigEDS{'), Identifier('*'), Identifier('originaleditor'), Identifier('format.editor.names'), Identifier('*'), String('}'), Identifier('*')]), FunctionLiteral([String('\\APACorigED{'), Identifier('*'), Identifier('originaleditor'), Identifier('format.editor.names'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$'),
   String('}{'),
   Identifier('*'),
   Identifier('originalbooktitle'),
   Identifier('format.btitle.no.dot'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originaledition'),
   Identifier('format.edition.check'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalvolume'),
   Identifier('format.bvolume.check'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalpages'),
   Identifier('format.bpages.check'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originaladdress'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('originalpublisher'),
   String(''),
   Identifier('connect.check'),
   String('}{'),
   Identifier('*'),
   Identifier('note'),
   String(''),
   Identifier('connect.check'),
   String('}'),
   Identifier('*')]],
 ['FUNCTION',
  [Identifier('format.orig.note')],
  [Identifier('originaljournal'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('originalbooktitle'), Identifier('empty$'), FunctionLiteral([Identifier('note'), Identifier('empty$'), FunctionLiteral([Identifier('originalyear'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('originalyear'), String('\\bibnodate'), Identifier('='), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block'), Identifier('format.orig.year.note')]), Identifier('if$')]), Identifier('if$')]), FunctionLiteral([Identifier('output.new.block'), Identifier('format.orig.year.note')]), Identifier('if$')]), FunctionLiteral([Identifier('output.new.block'), Identifier('format.orig.book.note')]), Identifier('if$')]),
   FunctionLiteral([Identifier('output.new.block'), Identifier('format.orig.journal.note')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('periodical')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.atitle.type.trans.check'), Identifier('output.new.block'), Identifier('output.dot.new.block')]), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('output.dot.new.block'), Identifier('format.atitle.type.trans.check'), Identifier('output.new.block')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('output.dot.new.block'), Identifier('format.atitle.type.trans.check'), Identifier('output.new.block')]),
   Identifier('if$'),
   Identifier('format.journal.vol.num.pages.check'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('format.orig.note'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('article')],
  [Identifier('pages'),
   Identifier('format.year.month.day.check'),
   Identifier('periodical')]],
 ['FUNCTION',
  [Identifier('magazine')],
  [Identifier('pages'),
   Identifier('format.year.month.day.check'),
   Identifier('periodical')]],
 ['FUNCTION',
  [Identifier('newspaper')],
  [Identifier('pages'),
   Identifier('format.bpages.check'),
   Identifier('format.year.month.day.check'),
   Identifier('periodical')]],
 ['FUNCTION',
  [Identifier('book')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.btitle.vol.edition.trans'), Identifier('format.type.number'), Identifier('connect.with.space.check'), Identifier('output.dot.new.block'), Identifier('format.year.check'), Identifier('add.period$')]), FunctionLiteral([Identifier('translator'), Identifier('empty$'), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('format.year.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.vol.edition')]), FunctionLiteral([Identifier('translator'), Identifier('editor'), Identifier('='), Identifier('not'), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('format.year.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.vol.edition.trans')]), FunctionLiteral([Identifier('format.ed.trans.as.authors'), Identifier('start.new.block'), Identifier('format.year.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.vol.edition')]), Identifier('if$')]), Identifier('if$'), Identifier('format.type.number'), Identifier('connect.with.space.check'), Identifier('add.period$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.vol.edition.editor.trans'), Identifier('format.type.number'), Identifier('connect.with.space.check'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('format.address.publisher.check'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('format.orig.note'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('incollection')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor.ne.trans'), FunctionLiteral([Identifier('format.atitle.type.trans.check')]), FunctionLiteral([Identifier('format.atitle.type.check')]), Identifier('if$'), Identifier('output.new.block'), Identifier('format.year.month.day.check'), Identifier('add.period$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('editor.ne.trans'), FunctionLiteral([Identifier('format.atitle.type.trans.check')]), FunctionLiteral([Identifier('format.atitle.type.check')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('output.new.block'),
   Identifier('format.in.editors.trans'),
   Identifier('format.bvol.edition.pages'),
   Identifier('booktitle'),
   Identifier('format.btitle.connect'),
   Identifier('*'),
   Identifier('add.period$'),
   Identifier('format.address.publisher.check'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('format.orig.note'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('format.tr.number')],
  [Identifier('type'),
   Identifier('empty$'),
   FunctionLiteral([String('\\BTR{}')]),
   FunctionLiteral([Identifier('type'), String('\\bibnotype'), Identifier('='), FunctionLiteral([String('')]), FunctionLiteral([Identifier('type')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('number'),
   Identifier('format.rnumber.check'),
   Identifier('connect.with.space.check')]],
 ['FUNCTION',
  [Identifier('format.tr.title.number')],
  [Identifier('format.betitle.check'),
   Identifier('type'),
   Identifier('empty$'),
   FunctionLiteral([String('\\APACbVolEdTR{'), Identifier('format.bvol.edition.check'), Identifier('*'), String('}{'), Identifier('*'), Identifier('format.tr.number'), Identifier('*'), String('}'), Identifier('*')]),
   FunctionLiteral([Identifier('type'), String('\\bibnotype'), Identifier('='), Identifier('number'), Identifier('empty$'), Identifier('volume'), Identifier('empty$'), Identifier('edition'), Identifier('empty$'), Identifier('and'), Identifier('and'), Identifier('and'), FunctionLiteral([String('')]), FunctionLiteral([String('\\APACbVolEdTR{'), Identifier('format.bvol.edition.check'), Identifier('*'), String('}{'), Identifier('*'), Identifier('format.tr.number'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$')]),
   Identifier('if$'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('format.btitle.connect')]],
 ['FUNCTION',
  [Identifier('format.address.institution.check')],
  [String('institution'),
   Identifier('institution'),
   Identifier('warning.if.empty'),
   String('address'),
   Identifier('address'),
   Identifier('warning.if.empty'),
   Identifier('institution'),
   Identifier('empty$'),
   Identifier('address'),
   Identifier('empty$'),
   Identifier('and'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('author'), Identifier('empty$'), Identifier('institution'), Identifier('empty$'), Identifier('or'), FunctionLiteral([Identifier('institution'), String('\\APACaddressInstitution{')]), FunctionLiteral([Identifier('author'), Identifier('institution'), Identifier('='), String('author'), Identifier('institution'), Identifier('='), Identifier('or'), String('Author'), Identifier('institution'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('author'), String('\\APACaddressInstitutionEqAuth{')]), FunctionLiteral([Identifier('institution'), String('\\APACaddressInstitution{')]), Identifier('if$')]), Identifier('if$'), Identifier('address'), String(''), Identifier('connect.check'), String('}{'), Identifier('*'), Identifier('swap$'), String(''), Identifier('connect.check'), String('}'), Identifier('*')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('techreport')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.tr.title.number'), Identifier('output.dot.new.block'), Identifier('format.year.month.day.check'), Identifier('add.period$')]), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('format.tr.title.number'), Identifier('add.period$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('format.tr.title.number'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('format.address.institution.check'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('intechreport')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor.ne.trans'), FunctionLiteral([Identifier('format.atitle.trans.check')]), FunctionLiteral([Identifier('format.atitle.check')]), Identifier('if$'), Identifier('output.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('editor.ne.trans'), FunctionLiteral([Identifier('format.atitle.trans.check')]), FunctionLiteral([Identifier('format.atitle.check')]), Identifier('if$'), Identifier('output.new.block')]),
   Identifier('if$'),
   Identifier('format.in.editors.trans'),
   String('\\APACbVolEdTRpgs{'),
   Identifier('format.bvol.edition.check'),
   Identifier('*'),
   String('}{'),
   Identifier('*'),
   Identifier('format.tr.number'),
   Identifier('*'),
   String('}{'),
   Identifier('*'),
   Identifier('pages'),
   Identifier('format.bpages.check'),
   Identifier('*'),
   String('}'),
   Identifier('*'),
   Identifier('booktitle'),
   Identifier('format.btitle.connect'),
   Identifier('*'),
   Identifier('add.period$'),
   Identifier('format.address.institution.check'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('format.orig.note'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('lecture')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([String('author'), Identifier('author'), Identifier('warning.if.empty')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block')]),
   Identifier('if$'),
   Identifier('format.year.month.day.check'),
   Identifier('output.dot.new.block'),
   Identifier('symposium'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.betitle.check'), Identifier('title'), Identifier('format.btitle.connect'), Identifier('output.new.block'), Identifier('howpublished'), Identifier('empty$'), FunctionLiteral([String('symposium and howpublished missing in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('\\APAChowpublished{'), Identifier('howpublished'), Identifier('*'), String('}'), Identifier('*')]), Identifier('if$'), Identifier('address'), Identifier('connect.with.comma.check')]),
   FunctionLiteral([Identifier('format.atitle.type.check'), Identifier('output.new.block'), String('\\BIn{} '), Identifier('chair'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('chair'), Identifier('format.editor.names'), Identifier('chair'), Identifier('num.names$'), Integer(1), Identifier('>'), FunctionLiteral([String('(\\BCHAIRS)')]), FunctionLiteral([String('(\\BCHAIR)')]), Identifier('if$'), Identifier('connect.with.space.check'), Identifier('*'), String(', '), Identifier('*')]), Identifier('if$'), Identifier('symposium'), Identifier('format.btitle.no.dot'), Identifier('*'), Identifier('format.howpublished'), Identifier('address'), Identifier('connect.with.comma.check')]),
   Identifier('if$'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('format.type.school')],
  [Identifier('type'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('pop$'), Identifier('type'), String('t'), Identifier('change.case$')]),
   Identifier('if$'),
   Identifier('school'),
   Identifier('connect.with.comma.check')]],
 ['FUNCTION',
  [Identifier('thesis')],
  [Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([String('author'), Identifier('author'), Identifier('warning.if.empty')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block')]),
   Identifier('if$'),
   Identifier('format.year.check'),
   Identifier('output.dot.new.block'),
   Identifier('journal'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.btitle.vol.edition'), Identifier('output.dot.new.block'), Identifier('swap$'), Identifier('pop$'), Identifier('format.type.school'), Identifier('address'), Identifier('connect.with.comma.check')]),
   FunctionLiteral([Identifier('pop$'), Identifier('type'), Identifier('empty$'), Identifier('school'), Identifier('empty$'), Identifier('originalyear'), Identifier('empty$'), Identifier('and'), Identifier('and'), FunctionLiteral([Identifier('pop$'), String('')]), FunctionLiteral([Identifier('format.type.school'), Identifier('originalyear'), Identifier('connect.with.comma.check'), Identifier('parenthesize.check')]), Identifier('if$'), Identifier('format.aetitle.check'), Identifier('swap$'), Identifier('connect.with.space.check'), String('title'), Identifier('title'), Identifier('warning.if.empty'), Identifier('title'), Identifier('format.atitle.connect'), Identifier('output.new.block'), Identifier('pages'), Identifier('format.journal.vol.num.pages.check')]),
   Identifier('if$'),
   Identifier('format.howpublished'),
   Identifier('add.period$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('phdthesis')],
  [String('\\BPhD'), String('\\BUPhD'), Identifier('thesis')]],
 ['FUNCTION',
  [Identifier('mastersthesis')],
  [String('\\BMTh'), String('\\BUMTh'), Identifier('thesis')]],
 ['FUNCTION',
  [Identifier('format.btitle.type.num')],
  [Identifier('format.betitle.check'),
   Identifier('format.bvol.edition'),
   Identifier('connect.with.space.check'),
   Identifier('format.type.number'),
   Identifier('connect.with.space.check'),
   Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('add.period$')]),
   FunctionLiteral([Identifier('title'), Identifier('format.btitle.connect')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('format.mtitle.type.num')],
  [Identifier('format.aetitle.check'),
   Identifier('format.bvol.edition'),
   Identifier('connect.with.space.check'),
   Identifier('type.2'),
   String('\\bibmessage'),
   Identifier('='),
   FunctionLiteral([Identifier('number'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('type.2'), Identifier('number'), Identifier('tie.or.space.connect'), Identifier('bracket.check'), Identifier('connect.with.space.check')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.type.number'), Identifier('connect.with.space.check')]),
   Identifier('if$'),
   Identifier('title'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('add.period$')]),
   FunctionLiteral([Identifier('title'), Identifier('format.atitle.connect')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('output.misctitle.type.num')],
  [Identifier('type.2'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('format.btitle.type.num')]),
   FunctionLiteral([Identifier('type.2'), String('\\bibmessage'), Identifier('='), Identifier('type.2'), String('\\bibcomputerprogram'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibcomputerprogrammanual'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibcomputerprogramandmanual'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibcomputersoftware'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibcomputersoftwaremanual'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibcomputersoftwareandmanual'), Identifier('='), Identifier('or'), Identifier('type.2'), String('\\bibprogramminglanguage'), Identifier('='), Identifier('or'), FunctionLiteral([Identifier('format.mtitle.type.num')]), FunctionLiteral([Identifier('format.btitle.type.num')]), Identifier('if$')]),
   Identifier('if$')]],
 ['FUNCTION',
  [Identifier('unpublished')],
  [Identifier('check.relevant.fields'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('format.btitle.type.num'), Identifier('output.new.block'), Identifier('format.year.month.day.check'), Identifier('add.period$')]), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.type.num')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('format.btitle.type.num')]),
   Identifier('if$'),
   Identifier('howpublished'),
   Identifier('empty$'),
   Identifier('organization'),
   Identifier('empty$'),
   Identifier('and'),
   Identifier('address'),
   Identifier('empty$'),
   Identifier('and'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('output.new.block'), String('\\APAChowpublished{'), String('}'), Identifier('howpublished'), Identifier('enclose.check'), Identifier('organization'), Identifier('connect.with.comma.check'), Identifier('address'), Identifier('connect.with.comma.check'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('misc')],
  [Identifier('type.2'),
   Identifier('empty$'),
   Identifier('type'),
   Identifier('empty$'),
   Identifier('not'),
   Identifier('and'),
   FunctionLiteral([Identifier('type'), QuotedVar('type.2'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('author'),
   Identifier('empty$'),
   FunctionLiteral([Identifier('editor'), Identifier('empty$'), FunctionLiteral([Identifier('title'), Identifier('empty$'), Identifier('type.2'), Identifier('empty$'), Identifier('and'), FunctionLiteral([Identifier('howpublished'), Identifier('empty$'), FunctionLiteral([String('No author, editor, title, type, and howpublished in '), Identifier('cite$'), Identifier('*'), Identifier('warning$'), String('')]), FunctionLiteral([String('\\APAChowpublished{'), Identifier('howpublished'), Identifier('*'), String('}'), Identifier('*'), Identifier('add.period$')]), Identifier('if$'), Identifier('format.year.month.day.check'), Identifier('add.period$')]), FunctionLiteral([Identifier('output.misctitle.type.num'), Identifier('output.new.block'), Identifier('format.year.month.day.check'), Identifier('add.period$'), Identifier('format.howpublished'), Identifier('add.period$')]), Identifier('if$')]), FunctionLiteral([Identifier('format.editors.as.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('output.misctitle.type.num'), Identifier('format.howpublished'), Identifier('add.period$')]), Identifier('if$')]),
   FunctionLiteral([Identifier('format.authors'), Identifier('start.new.block'), Identifier('format.year.month.day.check'), Identifier('output.dot.new.block'), Identifier('output.misctitle.type.num'), Identifier('format.howpublished'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('address'),
   Identifier('empty$'),
   Identifier('publisher'),
   Identifier('empty$'),
   Identifier('and'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.address.publisher'), Identifier('add.period$')]),
   Identifier('if$'),
   Identifier('url'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.url')]),
   Identifier('if$'),
   Identifier('note'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('duplicate$'), Identifier('empty$'), QuotedVar('skip$'), FunctionLiteral([Identifier('output.new.block')]), Identifier('if$'), Identifier('format.note')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('literal')],
  [String('key'),
   Identifier('key'),
   Identifier('warning.if.empty'),
   String('text'),
   Identifier('text'),
   Identifier('warning.if.empty'),
   Identifier('text'),
   Identifier('empty$'),
   FunctionLiteral([String('')]),
   FunctionLiteral([Identifier('text')]),
   Identifier('if$'),
   Identifier('fin.entry')]],
 ['FUNCTION',
  [Identifier('manual')],
  [Identifier('type'),
   Identifier('empty$'),
   FunctionLiteral([String('\\bibcomputersoftwaremanual'), QuotedVar('type.2'), Identifier(':=')]),
   QuotedVar('skip$'),
   Identifier('if$'),
   Identifier('misc')]],
 ['FUNCTION', [Identifier('booklet')], [Identifier('misc')]],
 ['FUNCTION', [Identifier('inbook')], [Identifier('incollection')]],
 ['FUNCTION', [Identifier('inproceedings')], [Identifier('incollection')]],
 ['FUNCTION', [Identifier('conference')], [Identifier('inproceedings')]],
 ['FUNCTION', [Identifier('proceedings')], [Identifier('misc')]],
 ['FUNCTION', [Identifier('default.type')], [Identifier('misc')]],
 ['FUNCTION',
  [Identifier('initialize')],
  [Integer(6), QuotedVar('name.max'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('init.old.number')],
  [Integer(0), QuotedVar('old.number'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('init.old.label')],
  [String('zzzzzz'), QuotedVar('old.label'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('init.cite.initials.add.to.year')],
  [Integer(0),
   QuotedVar('cite.initials'),
   Identifier(':='),
   Integer(0),
   QuotedVar('add.to.year'),
   Identifier(':=')]],
 ['FUNCTION',
  [Identifier('move.forward')],
  [Integer(1), QuotedVar('forward'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('move.backward')],
  [Integer(0), QuotedVar('forward'), Identifier(':=')]],
 ['FUNCTION',
  [Identifier('begin.bib')],
  [Identifier('preamble$'),
   Identifier('empty$'),
   QuotedVar('skip$'),
   FunctionLiteral([Identifier('preamble$'), Identifier('write$'), Identifier('newline$')]),
   Identifier('if$'),
   String('\\begin{thebibliography}{}'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('end.bib')],
  [Identifier('newline$'),
   String('\\end{thebibliography}'),
   Identifier('write$'),
   Identifier('newline$')]],
 ['FUNCTION',
  [Identifier('write.bbl.entry')],
  [Identifier('make.cite.labels'), Identifier('call.type$')]],
 ['READ'],
 ['EXECUTE', [Identifier('identify.apacite.version')]],
 ['EXECUTE', [Identifier('initialize')]],
 ['ITERATE', [Identifier('make.sort.title')]],
 ['SORT'],
 ['EXECUTE', [Identifier('init.old.number')]],
 ['EXECUTE', [Identifier('init.old.label')]],
 ['ITERATE', [Identifier('make.title.number')]],
 ['ITERATE', [Identifier('make.tentative.sort.label')]],
 ['SORT'],
 ['ITERATE', [Identifier('init.cite.initials.add.to.year')]],
 ['EXECUTE', [Identifier('init.initials')]],
 ['ITERATE', [Identifier('check.add.initials')]],
 ['EXECUTE', [Identifier('init.initials')]],
 ['REVERSE', [Identifier('check.add.initials')]],
 ['ITERATE', [Identifier('tentative.cite.num.names')]],
 ['EXECUTE', [Identifier('init.cite.num.names')]],
 ['EXECUTE', [Identifier('move.forward')]],
 ['ITERATE', [Identifier('definitive.cite.num.names')]],
 ['EXECUTE', [Identifier('init.cite.num.names')]],
 ['EXECUTE', [Identifier('move.backward')]],
 ['REVERSE', [Identifier('definitive.cite.num.names')]],
 ['ITERATE', [Identifier('make.final.sort.key')]],
 ['SORT'],
 ['EXECUTE', [Identifier('begin.bib')]],
 ['ITERATE', [Identifier('write.bbl.entry')]],
 ['EXECUTE', [Identifier('end.bib')]]]
