/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;

public class CalibrationDataFileIO {
    private static final String CALIBRATION_FILE_NOT_EXIST_MSG;
    private static final String CALIBRATION_FILE_NOT_READABLE_MSG;
    private static final String CALIBRATION_DATA_CORRUPTED_PREFIX;
    private static final String SHORTER_THAN_EXPECTED_STRING;
    private static final String ORIGINAL_MESSAGE_STRING;
    private static final String RERUN_CALIBRATION_MSG;
    private static final String ERROR_WRITING_CALIBRATION_FILE_PREFIX;
    private static final String REEXECUTE_CALIBRATION_MSG;
    private static String errorMessage;

    public static String getErrorMessage() {
        String string = errorMessage;
        errorMessage = null;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readSavedCalibrationData(ProfilingSessionStatus profilingSessionStatus) {
        String string = null;
        try {
            string = CalibrationDataFileIO.getCalibrationDataFileName(profilingSessionStatus.targetJDKVersionString);
        }
        catch (IOException iOException) {
            errorMessage = iOException.getMessage();
            return -1;
        }
        File file = new File(string);
        if (!file.exists()) {
            errorMessage = MessageFormat.format(CALIBRATION_FILE_NOT_EXIST_MSG, file.toString());
            return 1;
        }
        if (!file.canRead()) {
            errorMessage = MessageFormat.format(CALIBRATION_FILE_NOT_READABLE_MSG, file.toString());
            return -1;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            profilingSessionStatus.methodEntryExitCallTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.methodEntryExitInnerTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.methodEntryExitOuterTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.timerCountsInSecond = (long[])objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (Exception exception) {
            errorMessage = exception.getMessage();
            String string2 = CALIBRATION_DATA_CORRUPTED_PREFIX;
            if (errorMessage == null) {
                if (exception instanceof EOFException) {
                    errorMessage = string2 + " " + SHORTER_THAN_EXPECTED_STRING;
                }
            } else {
                errorMessage = string2 + "\n" + ORIGINAL_MESSAGE_STRING + " " + errorMessage;
            }
            errorMessage = errorMessage + "\n" + RERUN_CALIBRATION_MSG + "\n";
            int n = -2;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    public static boolean saveCalibrationData(ProfilingSessionStatus profilingSessionStatus) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CalibrationDataFileIO.getCalibrationDataFileName(profilingSessionStatus.targetJDKVersionString));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitCallTime);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitInnerTime);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitOuterTime);
            objectOutputStream.writeObject(profilingSessionStatus.timerCountsInSecond);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            errorMessage = iOException.getMessage();
            String string = ERROR_WRITING_CALIBRATION_FILE_PREFIX;
            errorMessage = string + "\n" + ORIGINAL_MESSAGE_STRING + "\n" + errorMessage;
            if (!profilingSessionStatus.remoteProfiling) {
                errorMessage = errorMessage + "\n" + REEXECUTE_CALIBRATION_MSG + "\n";
            }
            return false;
        }
        return true;
    }

    public static boolean validateCalibrationInput(String string, String string2) {
        return string != null && string2 != null && ("jdk15".equals(string) || "jdk16".equals(string) || "jdk17".equals(string) || "jdk18".equals(string) || "jdk19".equals(string) || "jdk100".equals(string)) && new File(string2).exists();
    }

    public static String getCalibrationDataFileName(String string) throws IOException {
        String string2 = "machinedata." + string;
        return Platform.getProfilerUserDir() + File.separator + string2;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.global.Bundle");
        CALIBRATION_FILE_NOT_EXIST_MSG = resourceBundle.getString("CalibrationDataFileIO_CalibrationFileNotExistMsg");
        CALIBRATION_FILE_NOT_READABLE_MSG = resourceBundle.getString("CalibrationDataFileIO_CalibrationFileNotReadableMsg");
        CALIBRATION_DATA_CORRUPTED_PREFIX = resourceBundle.getString("CalibrationDataFileIO_CalibrationDataCorruptedPrefix");
        SHORTER_THAN_EXPECTED_STRING = resourceBundle.getString("CalibrationDataFileIO_ShorterThanExpectedString");
        ORIGINAL_MESSAGE_STRING = resourceBundle.getString("CalibrationDataFileIO_OriginalMessageString");
        RERUN_CALIBRATION_MSG = resourceBundle.getString("CalibrationDataFileIO_ReRunCalibrationMsg");
        ERROR_WRITING_CALIBRATION_FILE_PREFIX = resourceBundle.getString("CalibrationDataFileIO_ErrorWritingCalibrationFilePrefix");
        REEXECUTE_CALIBRATION_MSG = resourceBundle.getString("CalibrationDataFileIO_ReExecuteCalibrationMsg");
    }
}

