/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public final class ClusterShardHealth
implements Writeable,
ToXContentFragment {
    private static final String STATUS = "status";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String PRIMARY_ACTIVE = "primary_active";
    public static final ConstructingObjectParser<ClusterShardHealth, Integer> PARSER = new ConstructingObjectParser("cluster_shard_health", true, (parsedObjects, shardId) -> {
        int i = 0;
        boolean primaryActive = (Boolean)parsedObjects[i++];
        int activeShards = (Integer)parsedObjects[i++];
        int relocatingShards = (Integer)parsedObjects[i++];
        int initializingShards = (Integer)parsedObjects[i++];
        int unassignedShards = (Integer)parsedObjects[i++];
        String statusStr = (String)parsedObjects[i];
        ClusterHealthStatus status = ClusterHealthStatus.fromString(statusStr);
        return new ClusterShardHealth((int)shardId, status, activeShards, relocatingShards, initializingShards, unassignedShards, primaryActive);
    });
    private final int shardId;
    private final ClusterHealthStatus status;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final boolean primaryActive;

    public ClusterShardHealth(int shardId, IndexShardRoutingTable shardRoutingTable) {
        this.shardId = shardId;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ShardRouting shardRouting : shardRoutingTable) {
            if (shardRouting.active()) {
                ++computeActiveShards;
                if (!shardRouting.relocating()) continue;
                ++computeRelocatingShards;
                continue;
            }
            if (shardRouting.initializing()) {
                ++computeInitializingShards;
                continue;
            }
            if (!shardRouting.unassigned()) continue;
            ++computeUnassignedShards;
        }
        ShardRouting primaryRouting = shardRoutingTable.primaryShard();
        ClusterHealthStatus computeStatus = primaryRouting.active() ? (computeActiveShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterShardHealth.getInactivePrimaryHealth(primaryRouting);
        this.status = computeStatus;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.primaryActive = primaryRouting.active();
    }

    public ClusterShardHealth(StreamInput in) throws IOException {
        this.shardId = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.primaryActive = in.readBoolean();
    }

    ClusterShardHealth(int shardId, ClusterHealthStatus status, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, boolean primaryActive) {
        this.shardId = shardId;
        this.status = status;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.primaryActive = primaryActive;
    }

    public int getShardId() {
        return this.shardId;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public boolean isPrimaryActive() {
        return this.primaryActive;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardId);
        out.writeByte(this.status.value());
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeBoolean(this.primaryActive);
    }

    public static ClusterHealthStatus getInactivePrimaryHealth(ShardRouting shardRouting) {
        assert (shardRouting.primary()) : "cannot invoke on a replica shard: " + shardRouting;
        assert (!shardRouting.active()) : "cannot invoke on an active shard: " + shardRouting;
        assert (shardRouting.unassignedInfo() != null) : "cannot invoke on a shard with no UnassignedInfo: " + shardRouting;
        assert (shardRouting.recoverySource() != null) : "cannot invoke on a shard that has no recovery source" + shardRouting;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        RecoverySource.Type recoveryType = shardRouting.recoverySource().getType();
        if (unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.DECIDERS_NO && unassignedInfo.getNumFailedAllocations() == 0 && (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.LOCAL_SHARDS || recoveryType == RecoverySource.Type.SNAPSHOT)) {
            return ClusterHealthStatus.YELLOW;
        }
        return ClusterHealthStatus.RED;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.getShardId()));
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(PRIMARY_ACTIVE, this.isPrimaryActive());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.endObject();
        return builder;
    }

    static ClusterShardHealth innerFromXContent(XContentParser parser, Integer shardId) {
        return (ClusterShardHealth)PARSER.apply(parser, (Object)shardId);
    }

    public static ClusterShardHealth fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, () -> ((XContentParser)parser).getTokenLocation());
        String shardIdStr = parser.currentName();
        ClusterShardHealth parsed = ClusterShardHealth.innerFromXContent(parser, Integer.valueOf(shardIdStr));
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        return parsed;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterShardHealth)) {
            return false;
        }
        ClusterShardHealth that = (ClusterShardHealth)o;
        return this.shardId == that.shardId && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.primaryActive == that.primaryActive && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.status, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.primaryActive);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(PRIMARY_ACTIVE, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(RELOCATING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(INITIALIZING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATUS, new String[0]));
    }
}

