/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterService
extends AbstractLifecycleComponent {
    private final MasterService masterService;
    private final ClusterApplierService clusterApplierService;
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_logging_threshold", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterName clusterName;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private final Map<String, Supplier<ClusterState.Custom>> initialClusterStateCustoms;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, Map<String, Supplier<ClusterState.Custom>> initialClusterStateCustoms) {
        super(settings);
        this.masterService = new MasterService(settings, threadPool);
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.clusterSettings.addSettingsUpdateConsumer(CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
        this.initialClusterStateCustoms = initialClusterStateCustoms;
        this.clusterApplierService = new ClusterApplierService(settings, clusterSettings, threadPool, this::newClusterStateBuilder);
    }

    public ClusterState.Builder newClusterStateBuilder() {
        ClusterState.Builder builder = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(this.settings));
        for (Map.Entry<String, Supplier<ClusterState.Custom>> entry : this.initialClusterStateCustoms.entrySet()) {
            builder.putCustom(entry.getKey(), entry.getValue().get());
        }
        return builder;
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.masterService.setSlowTaskLoggingThreshold(slowTaskLoggingThreshold);
        this.clusterApplierService.setSlowTaskLoggingThreshold(slowTaskLoggingThreshold);
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        this.clusterApplierService.setNodeConnectionsService(nodeConnectionsService);
    }

    @Override
    protected synchronized void doStart() {
        this.clusterApplierService.start();
        this.masterService.start();
    }

    @Override
    protected synchronized void doStop() {
        this.masterService.stop();
        this.clusterApplierService.stop();
    }

    @Override
    protected synchronized void doClose() {
        this.masterService.close();
        this.clusterApplierService.close();
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.state().getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        return this.clusterApplierService.state();
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addHighPriorityApplier(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addLowPriorityApplier(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addStateApplier(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.clusterApplierService.removeApplier(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterApplierService.addListener(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterApplierService.removeListener(listener);
    }

    public void removeTimeoutListener(TimeoutClusterStateListener listener) {
        this.clusterApplierService.removeTimeoutListener(listener);
    }

    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.clusterApplierService.addLocalNodeMasterListener(listener);
    }

    public void removeLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.clusterApplierService.removeLocalNodeMasterListener(listener);
    }

    public void addTimeoutListener(@Nullable TimeValue timeout, TimeoutClusterStateListener listener) {
        this.clusterApplierService.addTimeoutListener(timeout, listener);
    }

    public MasterService getMasterService() {
        return this.masterService;
    }

    public ClusterApplierService getClusterApplierService() {
        return this.clusterApplierService;
    }

    public static boolean assertClusterOrMasterStateThread() {
        assert (Thread.currentThread().getName().contains("clusterApplierService#updateTask") || Thread.currentThread().getName().contains("masterService#updateTask")) : "not called from the master/cluster state update thread";
        return true;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        this.masterService.submitStateUpdateTasks(source, tasks, config, executor);
    }
}

