# Giada - Your Hardcore Loopmachine

Official website: http://www.giadamusic.com | Travis CI status: [![Build Status](https://travis-ci.org/monocasual/giada.svg?branch=master)](https://travis-ci.org/monocasual/giada)

## What is Giada?

Giada is a free, minimal, hardcore audio tool for DJs, live performers and electronic musicians. How does it work? Just pick up your channel, fill it with samples or MIDI events and start the show by using this tiny piece of software as a loop machine, drum machine, sequencer, live sampler or yet as a plugin/effect host. Giada aims to be a compact and portable virtual device for Linux, Mac OS X and Windows for production use and live sets.

➔➔➔ [See Giada in action!](http://www.youtube.com/user/GiadaLoopMachine)

![Giada Loop Machine screenshot](http://giadamusic.com/public/img/screenshots/giada-loop-machine-screenshot-14-carousel.jpg)

## Main features

* Ultra-lightweight internal design;
* multi-thread/multi-core support;
* 32-bit floating point audio engine;
* ALSA, JACK + Transport, CoreAudio, ASIO and DirectSound full support;
* high quality internal resampler;
* unlimited number of channels (controllable via computer keyboard);
* several playback modes and combinations;
* BPM and beat sync with sample-accurate loop engine;
* VST and VSTi (instrument) plug-in support;
* MIDI input and output support, featuring custom [MIDI lightning messages](https://github.com/monocasual/giada-midimaps);
* super-sleek, built-in wave editor;
* live sampler from external inputs;
* live action recorder with automatic quantizer;
* piano Roll editor;
* portable patch storage system, based on super-hackable JSON files;
* support for all major uncompressed file formats;
* test-driven development style supported by [Travis CI](https://travis-ci.org/monocasual/giada) and [Catch](https://github.com/philsquared/Catch)
* under a constant stage of development;
* 100% open-source GPL v3.

## License

Giada is available under the terms of the GNU General Public License.
Take a look at the COPYING file for further informations.

## Documentation

Docs are available online on the official website:

http://www.giadamusic.com/documentation

Found a typo or a terrible mistake? Feel free to clone the [website repository](https://github.com/monocasual/giada-www) and send us your pull requests.

## Build Giada from source

We do our best to make the compilation process as simple as possible. You can find all the information in the [official docs page](http://giadamusic.com/documentation/show/compiling-from-source).

Something went wrong? Try our new [Docker image](https://github.com/monocasual/giada-docker) for building and running Giada without hurdles. 

## Bugs, requests and questions for non-developers

Feel free to ask anything on our end-user forum:

http://www.giadamusic.com/forum

## Copyright

Giada is Copyright (C) 2010-2018 by Giovanni A. Zuliani | Monocasual

Giada - Your Hardcore Loopmachine is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

Giada - Your Hardcore Loopmachine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with Giada - Your Hardcore Loopmachine. If not, see <http://www.gnu.org/licenses/>.
