#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: http-media
version: 0.7.1.2
id: http-media-0.7.1.2-2agRPy8NKmR6zMh072NVzf
key: http-media-0.7.1.2-2agRPy8NKmR6zMh072NVzf
license: MIT
copyright: (c) 2012-2017 Timothy Jones
maintainer: Timothy Jones <tim@zmthy.net>
author: Timothy Jones
homepage: https://github.com/zmthy/http-media
synopsis: Processing HTTP Content-Type and Accept headers
description:
    This library is intended to be a comprehensive solution to parsing and
    selecting quality-indexed values in HTTP headers.  It is capable of
    parsing both media types and language parameters from the Accept and
    Content header families, and can be extended to match against other
    accept headers as well.  Selecting the appropriate header value is
    achieved by comparing a list of server options against the
    quality-indexed values supplied by the client.
    .
    In the following example, the Accept header is parsed and then matched
    against a list of server options to serve the appropriate media using
    '\''mapAcceptMedia'\'':
    .
    > getHeader >>= maybe send406Error sendResourceWith . mapAcceptMedia
    >     [ ("text/html",        asHtml)
    >     , ("application/json", asJson)
    >     ]
    .
    Similarly, the Content-Type header can be used to produce a parser for
    request bodies based on the given content type with '\''mapContentMedia'\'':
    .
    > getContentType >>= maybe send415Error readRequestBodyWith . mapContentMedia
    >     [ ("application/json", parseJson)
    >     , ("text/plain",       parseText)
    >     ]
    .
    The API is agnostic to your choice of server.
category: Web
abi: 483bd81a950f6e9e13c6265205a34bbd
exposed: True
exposed-modules:
    Network.HTTP.Media Network.HTTP.Media.Accept
    Network.HTTP.Media.Language Network.HTTP.Media.MediaType
    Network.HTTP.Media.RenderHeader
hidden-modules: Network.HTTP.Media.Language.Internal
                Network.HTTP.Media.MediaType.Internal Network.HTTP.Media.Quality
                Network.HTTP.Media.Utils
import-dirs: /usr/lib/ghc-8.4.3/site-local/http-media-0.7.1.2
library-dirs: /usr/lib/ghc-8.4.3/site-local/http-media-0.7.1.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/http-media-0.7.1.2
hs-libraries: HShttp-media-0.7.1.2-2agRPy8NKmR6zMh072NVzf
depends:
    base-4.11.1.0 bytestring-0.10.8.2
    case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra
    containers-0.5.11.0 utf8-string-1.0.1.1-LRSjvSC6FZkKPp48Qszoj8
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra=0a5994e39a32f328ff4f350b25844411
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             utf8-string-1.0.1.1-LRSjvSC6FZkKPp48Qszoj8=03d2b6edbbe4042d502eabc2ba3840fc
haddock-interfaces: /usr/share/doc/haskell-http-media/html/http-media.haddock
haddock-html: /usr/share/doc/haskell-http-media/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

