#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.3.1
id: semigroupoids-5.3.1-CeMZ4nWzebBGv5gAlve2hz
key: semigroupoids-5.3.1-CeMZ4nWzebBGv5gAlve2hz
license: BSD-3-Clause
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
author: Edward A. Kmett
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
abi: 603c5acfe7d6290aa15d3051aa8734ec
exposed: True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
import-dirs: /usr/lib/ghc-8.4.3/site-local/semigroupoids-5.3.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/semigroupoids-5.3.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/semigroupoids-5.3.1
hs-libraries: HSsemigroupoids-5.3.1-CeMZ4nWzebBGv5gAlve2hz
depends:
    base-4.11.1.0 base-orphans-0.8-4huH01MmiV449ptUKInvC8
    bifunctors-5.5.3-BIgJKb8FSuPAayKoWZoZXs template-haskell-2.13.0.0
    transformers-0.5.5.0
    transformers-compat-0.6.2-EZ0ZvADLUlc4V8RuKaJX5W
    containers-0.5.11.0 contravariant-1.5-5VBqEYOPGpyDW8QIali4BA
    distributive-0.6-8yrDTpYI7z3GBlcGm7xBun
    comonad-5.0.4-G74MNGthp8MIbDjNAMuYxQ
    tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO
    hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             base-orphans-0.8-4huH01MmiV449ptUKInvC8=e9fa092af04cd58ebcb8cdf33f10dac9
             bifunctors-5.5.3-BIgJKb8FSuPAayKoWZoZXs=0426fbb9242519da49cd2883092459ef
             template-haskell-2.13.0.0=ac7dfd04924d4ebfa90a119ad22a36cc
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             transformers-compat-0.6.2-EZ0ZvADLUlc4V8RuKaJX5W=8fe746d31ebcf312c14c2777ca0f137c
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             contravariant-1.5-5VBqEYOPGpyDW8QIali4BA=02e9ed60b8864056c6af15ff76a262ef
             distributive-0.6-8yrDTpYI7z3GBlcGm7xBun=a079785a4964933ed2c7b4e8ef9f7443
             comonad-5.0.4-G74MNGthp8MIbDjNAMuYxQ=6066a8b25d542e863756d32fb8ed7569
             tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO=92d44612a64675b8cba7ce44e507a395
             hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg=0f14342a1ffe8710d31657335cf81134
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

