/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.AbstractEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;

public abstract class MultiByteEncoding
extends AbstractEncoding {
    protected final int[] EncLen;
    protected static final int A = -1;
    protected static final int F = -2;
    protected final int[][] Trans;
    protected final int[] TransZero;

    protected MultiByteEncoding(String name2, int minLength, int maxLength, int[] EncLen, int[][] Trans, short[] CTypeTable) {
        super(name2, minLength, maxLength, CTypeTable);
        this.EncLen = EncLen;
        this.Trans = Trans;
        this.TransZero = Trans != null ? Trans[0] : null;
    }

    @Override
    public int length(byte c) {
        return this.EncLen[c & 0xFF];
    }

    protected final int missing(int n) {
        return -1 - n;
    }

    protected final int missing(int b2, int delta) {
        return this.missing(this.EncLen[b2] - delta);
    }

    protected final int safeLengthForUptoFour(byte[] bytes2, int p2, int end2) {
        int b2 = bytes2[p2] & 0xFF;
        int s2 = this.TransZero[b2];
        if (s2 < 0) {
            return s2 == -1 ? 1 : -1;
        }
        return this.lengthForTwoUptoFour(bytes2, p2, end2, b2, s2);
    }

    protected final int lengthForTwoUptoFour(byte[] bytes2, int p2, int end2, int b2, int s2) {
        if (++p2 == end2) {
            return this.missing(b2, 1);
        }
        if ((s2 = this.Trans[s2][bytes2[p2] & 0xFF]) < 0) {
            return s2 == -1 ? 2 : -1;
        }
        return this.lengthForThreeUptoFour(bytes2, p2, end2, b2, s2);
    }

    private int lengthForThreeUptoFour(byte[] bytes2, int p2, int end2, int b2, int s2) {
        if (++p2 == end2) {
            return this.missing(b2, 2);
        }
        if ((s2 = this.Trans[s2][bytes2[p2] & 0xFF]) < 0) {
            return s2 == -1 ? 3 : -1;
        }
        if (++p2 == end2) {
            return this.missing(b2, 3);
        }
        return (s2 = this.Trans[s2][bytes2[p2] & 0xFF]) == -1 ? 4 : -1;
    }

    protected final int safeLengthForUptoThree(byte[] bytes2, int p2, int end2) {
        int b2 = bytes2[p2] & 0xFF;
        int s2 = this.TransZero[b2];
        if (s2 < 0) {
            return s2 == -1 ? 1 : -1;
        }
        return this.lengthForTwoUptoThree(bytes2, p2, end2, b2, s2);
    }

    private int lengthForTwoUptoThree(byte[] bytes2, int p2, int end2, int b2, int s2) {
        if (++p2 == end2) {
            return this.missing(b2, 1);
        }
        if ((s2 = this.Trans[s2][bytes2[p2] & 0xFF]) < 0) {
            return s2 == -1 ? 2 : -1;
        }
        return this.lengthForThree(bytes2, p2, end2, b2, s2);
    }

    private int lengthForThree(byte[] bytes2, int p2, int end2, int b2, int s2) {
        if (++p2 == end2) {
            return this.missing(b2, 2);
        }
        return (s2 = this.Trans[s2][bytes2[p2] & 0xFF]) == -1 ? 3 : -1;
    }

    protected final int safeLengthForUptoTwo(byte[] bytes2, int p2, int end2) {
        int b2 = bytes2[p2] & 0xFF;
        int s2 = this.TransZero[b2];
        if (s2 < 0) {
            return s2 == -1 ? 1 : -1;
        }
        return this.lengthForTwo(bytes2, p2, end2, b2, s2);
    }

    private int lengthForTwo(byte[] bytes2, int p2, int end2, int b2, int s2) {
        if (++p2 == end2) {
            return this.missing(b2, 1);
        }
        return (s2 = this.Trans[s2][bytes2[p2] & 0xFF]) == -1 ? 2 : -1;
    }

    protected final int mbnMbcToCode(byte[] bytes2, int p2, int end2) {
        int len = this.length(bytes2, p2, end2);
        int n = bytes2[p2++] & 0xFF;
        if (len == 1) {
            return n;
        }
        for (int i2 = 1; i2 < len && p2 < end2; ++i2) {
            int c = bytes2[p2++] & 0xFF;
            n <<= 8;
            n += c;
        }
        return n;
    }

    protected final int mbnMbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] lower) {
        int p2 = pp.value++;
        int lowerP = 0;
        if (MultiByteEncoding.isAscii(bytes2[p2] & 0xFF)) {
            lower[lowerP] = AsciiTables.ToLowerCaseTable[bytes2[p2] & 0xFF];
            return 1;
        }
        int len = this.length(bytes2, p2, end2);
        for (int i2 = 0; i2 < len; ++i2) {
            lower[lowerP++] = bytes2[p2++];
        }
        pp.value += len;
        return len;
    }

    protected final int mb2CodeToMbcLength(int code) {
        return (code & 0xFF00) != 0 ? 2 : 1;
    }

    protected final int mb4CodeToMbcLength(int code) {
        if ((code & 0xFF000000) != 0) {
            return 4;
        }
        if ((code & 0xFF0000) != 0) {
            return 3;
        }
        if ((code & 0xFF00) != 0) {
            return 2;
        }
        return 1;
    }

    protected final int mb2CodeToMbc(int code, byte[] bytes2, int p2) {
        int p_ = p2;
        if ((code & 0xFF00) != 0) {
            bytes2[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes2[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes2, p2, p_) != p_ - p2) {
            return -400;
        }
        return p_ - p2;
    }

    protected final int mb4CodeToMbc(int code, byte[] bytes2, int p2) {
        int p_ = p2;
        if ((code & 0xFF000000) != 0) {
            bytes2[p_++] = (byte)(code >>> 24 & 0xFF);
        }
        if ((code & 0xFF0000) != 0 || p_ != p2) {
            bytes2[p_++] = (byte)(code >>> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0 || p_ != p2) {
            bytes2[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes2[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes2, p2, p_) != p_ - p2) {
            return -400;
        }
        return p_ - p2;
    }

    protected final boolean mb2IsCodeCType(int code, int ctype) {
        if (((long)code & 0xFFFFFFFFL) < 128L) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (MultiByteEncoding.isWordGraphPrint(ctype)) {
            return this.codeToMbcLength(code) > 1;
        }
        return false;
    }

    protected final boolean mb4IsCodeCType(int code, int ctype) {
        return this.mb2IsCodeCType(code, ctype);
    }

    @Override
    public int strLength(byte[] bytes2, int p2, int end2) {
        int n = 0;
        int q = p2;
        while (q < end2) {
            q += this.length(bytes2, q, end2);
            ++n;
        }
        return n;
    }

    @Override
    public int strCodeAt(byte[] bytes2, int p2, int end2, int index2) {
        int n = 0;
        int q = p2;
        while (q < end2) {
            if (n == index2) {
                return this.mbcToCode(bytes2, q, end2);
            }
            q += this.length(bytes2, q, end2);
            ++n;
        }
        return -1;
    }
}

