/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ast.Node;
import org.joni.exception.InternalException;

public final class ListNode
extends Node {
    public Node value;
    public ListNode tail;

    private ListNode(Node value2, ListNode tail, int type2) {
        super(type2);
        this.value = value2;
        if (value2 != null) {
            value2.parent = this;
        }
        this.tail = tail;
        if (tail != null) {
            tail.parent = this;
        }
    }

    public static ListNode newAlt(Node value2, ListNode tail) {
        return new ListNode(value2, tail, 9);
    }

    public static ListNode newList(Node value2, ListNode tail) {
        return new ListNode(value2, tail, 8);
    }

    public static ListNode listAdd(ListNode list2, Node value2) {
        ListNode n = ListNode.newList(value2, null);
        if (list2 != null) {
            while (list2.tail != null) {
                list2 = list2.tail;
            }
            list2.setTail(n);
        }
        return n;
    }

    public void toListNode() {
        this.type = 8;
    }

    protected void setChild(Node child) {
        this.value = child;
    }

    protected Node getChild() {
        return this.value;
    }

    public void setValue(Node value2) {
        this.value = value2;
        value2.parent = this;
    }

    public void setTail(ListNode tail) {
        this.tail = tail;
    }

    public String getName() {
        switch (this.type) {
            case 9: {
                return "Alt";
            }
            case 8: {
                return "List";
            }
        }
        throw new InternalException("internal parser error (bug)");
    }

    public String toString(int level2) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  value: " + ListNode.pad(this.value, level2 + 1));
        sb.append("\n  tail: " + (this.tail == null ? "NULL" : this.tail.toString()));
        return sb.toString();
    }
}

