/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return module.getBuiltIns().getCharType();
    }

    @Override
    @NotNull
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    private final String getPrintablePart(char c) {
        String string;
        switch (c) {
            case '\b': {
                string = "\\b";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\f': {
                string = "\\f";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            default: {
                String string2 = this.isPrintableUnicode(c) ? Character.toString(c) : "?";
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (isPrintableUnicode(c\u2026cter.toString(c) else \"?\"");
            }
        }
        return string;
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public CharValue(char value) {
        super(Character.valueOf(value));
    }
}

