/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.cli.common.JitCompilationMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bJ\"\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J \u0010$\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0003H\u0016J\b\u0010%\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u0016H\u0002J\b\u0010'\u001a\u00020\u0016H\u0002J\b\u0010(\u001a\u00020\u0016H\u0002J\b\u0010)\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "", "presentableName", "", "(Ljava/lang/String;)V", "analysisStart", "", "generationStart", "initStartNanos", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "measurements", "", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "getMeasurements", "()Ljava/util/List;", "createPerformanceReport", "", "dumpPerformanceReport", "", "destination", "Ljava/io/File;", "enableCollectingPerformanceStatistics", "getMeasurementResults", "", "notifyAnalysisFinished", "files", "", "lines", "additionalDescription", "notifyAnalysisStarted", "notifyCompilationFinished", "notifyCompilerInitialized", "notifyGenerationFinished", "notifyGenerationStarted", "recordGcTime", "recordInitializationTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "cli"})
public abstract class CommonCompilerPerformanceManager {
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    private boolean isEnabled;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    private final String presentableName;

    @NotNull
    protected final List<PerformanceMeasurement> getMeasurements() {
        return this.measurements;
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return this.measurements;
    }

    public final void enableCollectingPerformanceStatistics() {
        this.isEnabled = true;
        PerformanceCounter.Companion.setTimeCounterEnabled(true);
    }

    public void notifyCompilerInitialized() {
        if (!this.isEnabled) {
            return;
        }
        this.recordInitializationTime();
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        this.recordPerfCountersMeasurements();
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyAnalysisFinished(int files2, int lines, @Nullable String additionalDescription) {
        long time = PerformanceCounter.Companion.currentTime() - this.analysisStart;
        Collection collection = this.measurements;
        CodeAnalysisMeasurement codeAnalysisMeasurement = new CodeAnalysisMeasurement(files2, lines, TimeUnit.NANOSECONDS.toMillis(time), additionalDescription);
        collection.add(codeAnalysisMeasurement);
    }

    public void notifyGenerationStarted() {
        this.generationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyGenerationFinished(int lines, int files2, @NotNull String additionalDescription) {
        Intrinsics.checkParameterIsNotNull(additionalDescription, "additionalDescription");
        long time = PerformanceCounter.Companion.currentTime() - this.generationStart;
        Collection collection = this.measurements;
        CodeGenerationMeasurement codeGenerationMeasurement = new CodeGenerationMeasurement(lines, files2, TimeUnit.NANOSECONDS.toMillis(time), additionalDescription);
        collection.add(codeGenerationMeasurement);
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull(destination, "destination");
        FilesKt.writeBytes(destination, this.createPerformanceReport());
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list2, "ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            Collection collection = this.measurements;
            GarbageCollectorMXBean garbageCollectorMXBean = it;
            Intrinsics.checkExpressionValueIsNotNull(garbageCollectorMXBean, "it");
            String string = garbageCollectorMXBean.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
            GarbageCollectionMeasurement garbageCollectionMeasurement = new GarbageCollectionMeasurement(string, it.getCollectionTime());
            collection.add(garbageCollectionMeasurement);
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        Collection collection = this.measurements;
        JitCompilationMeasurement jitCompilationMeasurement = new JitCompilationMeasurement(bean.getTotalCompilationTime());
        collection.add(jitCompilationMeasurement);
    }

    private final void recordInitializationTime() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        Collection collection = this.measurements;
        CompilerInitializationMeasurement compilerInitializationMeasurement = new CompilerInitializationMeasurement(time);
        collection.add(compilerInitializationMeasurement);
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(this){
            final /* synthetic */ CommonCompilerPerformanceManager this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull(s, "s");
                Collection collection = this.this$0.getMeasurements();
                PerformanceCounterMeasurement performanceCounterMeasurement = new PerformanceCounterMeasurement(s);
                collection.add(performanceCounterMeasurement);
            }
            {
                this.this$0 = commonCompilerPerformanceManager;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] createPerformanceReport() {
        void $receiver$iv$iv;
        StringBuilder $receiver;
        CharSequence charSequence = new StringBuilder();
        StringBuilder stringBuilder = $receiver = charSequence;
        Iterator iterator2 = this.presentableName + " performance report";
        StringBuilder stringBuilder2 = stringBuilder.append((String)((Object)iterator2));
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
        Iterable $receiver$iv = this.measurements;
        iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.render();
            collection.add(string);
        }
        $receiver$iv = CollectionsKt.sorted((List)destination$iv$iv);
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            StringBuilder stringBuilder3 = $receiver;
            StringBuilder stringBuilder4 = stringBuilder3.append(it);
            Intrinsics.checkExpressionValueIsNotNull(stringBuilder4, "append(value)");
            StringsKt.appendln(stringBuilder4);
        }
        String string = ((StringBuilder)charSequence).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        charSequence = string;
        Charset charset = Charsets.UTF_8;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)charSequence2).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public CommonCompilerPerformanceManager(@NotNull String presentableName2) {
        List list2;
        Intrinsics.checkParameterIsNotNull(presentableName2, "presentableName");
        this.presentableName = presentableName2;
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        commonCompilerPerformanceManager.measurements = list2 = (List)new ArrayList();
        this.initStartNanos = PerformanceCounter.Companion.currentTime();
    }
}

