/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public class ItemAt
extends SystemFunction {
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        NumericValue val;
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.argument[1] instanceof Literal && ((val = (NumericValue)((Literal)this.argument[1]).getValue()).compareTo(1L) < 0 || val.compareTo(Integer.MAX_VALUE) > 0 || !val.isWholeNumber())) {
            return new Literal(EmptySequence.getInstance());
        }
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        NumericValue index = (NumericValue)this.argument[1].evaluateItem(context);
        if (index == null) {
            return null;
        }
        if (index.compareTo(Integer.MAX_VALUE) <= 0 && index.isWholeNumber()) {
            int intindex = (int)index.longValue();
            if (intindex < 1) {
                return null;
            }
            SequenceIterator base = this.argument[0].iterate(context);
            if (intindex == 1) {
                return base.next();
            }
            if (base instanceof GroundedIterator) {
                GroundedValue value = ((GroundedIterator)base).materialize();
                return value.itemAt(intindex - 1);
            }
            SequenceIterator tail = TailIterator.make(base, intindex);
            return tail.next();
        }
        return null;
    }
}

