/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.pojo.EntityPOJOClass;
import org.hibernate.tool.ide.completion.EntityNameReference;
import org.hibernate.tool.ide.completion.HQLAnalyzer;
import org.hibernate.tool.ide.completion.HQLCompletionProposal;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;

class ConfigurationCompletion {
    private final Configuration cfg;

    public ConfigurationCompletion(Configuration cfg) {
        this.cfg = cfg;
    }

    public void getMatchingImports(String prefix, IHQLCompletionRequestor collector) {
        this.getMatchingImports(prefix, prefix.length(), collector);
    }

    public void getMatchingImports(String prefix, int cursorPosition, IHQLCompletionRequestor collector) {
        for (Map.Entry entry : this.cfg.getImports().entrySet()) {
            String entityImport = (String)entry.getKey();
            String entityName = (String)entry.getValue();
            if (!entityImport.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            HQLCompletionProposal proposal = this.createStartWithCompletionProposal(prefix, cursorPosition, 1, entityImport);
            proposal.setShortEntityName(entityImport);
            proposal.setEntityName(entityName);
            collector.accept(proposal);
        }
    }

    public void getMatchingKeywords(String prefix, int cursorPosition, IHQLCompletionRequestor collector) {
        this.findMatchingWords(cursorPosition, prefix, HQLAnalyzer.getHQLKeywords(), 3, collector);
    }

    public void getMatchingFunctions(String prefix, int cursorPosition, IHQLCompletionRequestor collector) {
        this.findMatchingWords(cursorPosition, prefix, HQLAnalyzer.getHQLFunctionNames(), 4, collector);
    }

    public void getMatchingProperties(String path, String prefix, IHQLCompletionRequestor hcc) {
        this.getMatchingProperties(path, prefix, prefix.length(), hcc);
    }

    public void getMatchingProperties(String path, String prefix, int cursorPosition, IHQLCompletionRequestor hcc) {
        int idx = path.indexOf(47);
        if (idx == -1) {
            PersistentClass cmd = this.getPersistentClass(path);
            if (cmd == null) {
                return;
            }
            this.addPropertiesToList(cmd, prefix, cursorPosition, hcc);
        } else {
            String propertyPath;
            String baseEntityName = path.substring(0, idx);
            Value value = this.getNextAttributeType(baseEntityName, propertyPath = path.substring(idx + 1));
            if (value == null) {
                return;
            }
            idx = propertyPath.indexOf(47);
            path = idx == -1 ? "" : propertyPath.substring(idx + 1);
            if (path.length() == 0) {
                if (value instanceof Component) {
                    this.addPropertiesToList((Component)value, prefix, cursorPosition, hcc);
                } else if (value instanceof Collection && ((Collection)value).getElement() instanceof Component) {
                    this.addPropertiesToList((Component)((Collection)value).getElement(), prefix, cursorPosition, hcc);
                } else {
                    this.addPropertiesToList(this.getPersistentClass(this.getReferencedEntityName(value)), prefix, cursorPosition, hcc);
                }
            } else if (value instanceof Component) {
                while (value instanceof Component && path.length() > 0) {
                    if ((value = this.getNextAttributeType((Component)value, path)) == null) continue;
                    idx = path.indexOf(47);
                    if (idx != -1) {
                        path = path.substring(idx + 1);
                        continue;
                    }
                    path = "";
                }
                if (value instanceof Component) {
                    this.addPropertiesToList((Component)value, prefix, cursorPosition, hcc);
                } else if (value != null) {
                    path = path.length() > 0 ? this.getReferencedEntityName(value) + "/" + path : this.getReferencedEntityName(value);
                    this.getMatchingProperties(path, prefix, cursorPosition, hcc);
                }
            } else {
                this.getMatchingProperties(this.getReferencedEntityName(value) + "/" + path, prefix, cursorPosition, hcc);
            }
        }
    }

    private String getReferencedEntityName(Value value) {
        if (value instanceof ToOne) {
            return ((ToOne)value).getReferencedEntityName();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Value element = collection.getElement();
            String elementType = this.getReferencedEntityName(element);
            if (collection.isIndexed()) {
                // empty if block
            }
            return elementType;
        }
        if (value instanceof OneToMany) {
            return ((OneToMany)value).getReferencedEntityName();
        }
        return null;
    }

    private void addPropertiesToList(PersistentClass cmd, String prefix, int cursorPosition, IHQLCompletionRequestor hcc) {
        if (cmd == null) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        while (cmd != null) {
            EntityPOJOClass pc = new EntityPOJOClass(cmd, new Cfg2JavaTool());
            Iterator allPropertiesIterator = pc.getAllPropertiesIterator();
            while (allPropertiesIterator.hasNext()) {
                Property property = (Property)allPropertiesIterator.next();
                String candidate = property.getName();
                if (prefix.length() != 0 && !candidate.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                HQLCompletionProposal proposal = this.createStartWithCompletionProposal(prefix, cursorPosition, 2, candidate);
                proposal.setEntityName(cmd.getEntityName());
                proposal.setProperty(property);
                proposal.setPropertyName(candidate);
                hcc.accept(proposal);
            }
            cmd = cmd.getSuperclass();
        }
    }

    private HQLCompletionProposal createStartWithCompletionProposal(String prefix, int cursorPosition, int kind, String candidate) {
        HQLCompletionProposal proposal = new HQLCompletionProposal(kind, cursorPosition);
        if (candidate.startsWith(prefix)) {
            proposal.setCompletion(candidate.substring(prefix.length()));
            proposal.setSimpleName(candidate);
            proposal.setReplaceStart(cursorPosition);
            proposal.setReplaceEnd(cursorPosition);
        } else {
            proposal.setCompletion(candidate);
            proposal.setSimpleName(candidate);
            proposal.setReplaceStart(cursorPosition - prefix.length());
            proposal.setReplaceEnd(cursorPosition);
        }
        return proposal;
    }

    private PersistentClass getPersistentClass(String path) {
        if (path == null) {
            return null;
        }
        String entityName = (String)this.cfg.getImports().get(path);
        if (entityName == null) {
            return this.cfg.getClassMapping(path);
        }
        return this.cfg.getClassMapping(entityName);
    }

    public String getCanonicalPath(List qts, String name) {
        HashMap<String, String> alias2Type = new HashMap<String, String>();
        for (EntityNameReference qt : qts) {
            alias2Type.put(qt.getAlias(), qt.getEntityName());
        }
        if (qts.size() == 1) {
            EntityNameReference visible = (EntityNameReference)qts.get(0);
            String alias = visible.getAlias();
            if (name.equals(alias)) {
                return visible.getEntityName();
            }
            if (alias == null || alias.length() == 0 || alias.equals(visible.getEntityName())) {
                return visible.getEntityName() + "/" + name;
            }
        }
        return this.getCanonicalPath(new HashSet(), alias2Type, name);
    }

    private String getCanonicalPath(Set resolved, Map alias2Type, String name) {
        if (resolved.contains(name)) {
            return name;
        }
        resolved.add(name);
        String type = (String)alias2Type.get(name);
        if (type != null) {
            return name.equals(type) ? name : this.getCanonicalPath(resolved, alias2Type, type);
        }
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return type != null ? type : name;
        }
        String baseName = name.substring(0, idx);
        String prop = name.substring(idx + 1);
        if (ConfigurationCompletion.isAliasKnown(alias2Type, baseName)) {
            return this.getCanonicalPath(resolved, alias2Type, baseName) + "/" + prop;
        }
        return name;
    }

    private static boolean isAliasKnown(Map alias2Type, String alias) {
        if (alias2Type.containsKey(alias)) {
            return true;
        }
        int idx = alias.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        return ConfigurationCompletion.isAliasKnown(alias2Type, alias.substring(0, idx));
    }

    private Value getNextAttributeType(String type, String attributePath) {
        String idName;
        PersistentClass cmd = this.getPersistentClass(type);
        if (cmd == null) {
            return null;
        }
        int idx = attributePath.indexOf(47);
        String attribute = idx == -1 ? attributePath : attributePath.substring(0, idx);
        String string = idName = cmd.getIdentifierProperty() == null ? null : cmd.getIdentifierProperty().getName();
        if (attribute.equals(idName)) {
            return cmd.getIdentifierProperty().getValue();
        }
        try {
            Property property = cmd.getProperty(attribute);
            return property == null ? null : property.getValue();
        }
        catch (HibernateException he) {
            return null;
        }
    }

    private Value getNextAttributeType(Component t, String attributeName) {
        int idx = attributeName.indexOf(47);
        if (idx != -1) {
            attributeName = attributeName.substring(0, idx);
        }
        Iterator names = t.getPropertyIterator();
        int i = 0;
        while (names.hasNext()) {
            Property element = (Property)names.next();
            String name = element.getName();
            if (attributeName.equals(name)) {
                return element.getValue();
            }
            ++i;
        }
        return null;
    }

    void addPropertiesToList(Component t, String prefix, int cursorPosition, IHQLCompletionRequestor hcc) {
        if (t == null) {
            return;
        }
        Iterator props = t.getPropertyIterator();
        int i = 0;
        while (props.hasNext()) {
            Property element = (Property)props.next();
            String candidate = element.getName();
            if (candidate.toLowerCase().startsWith(prefix.toLowerCase())) {
                HQLCompletionProposal proposal = this.createStartWithCompletionProposal(prefix, cursorPosition, 2, candidate);
                proposal.setPropertyName(candidate);
                proposal.setProperty(element);
                hcc.accept(proposal);
            }
            ++i;
        }
    }

    private void findMatchingWords(int cursorPosition, String prefix, String[] words, int kind, IHQLCompletionRequestor hcc) {
        String word;
        int i = Arrays.binarySearch(words, prefix.toLowerCase());
        if (i < 0) {
            i = Math.abs(i + 1);
        }
        for (int cnt = i; cnt < words.length && (word = words[cnt]).toLowerCase().startsWith(prefix.toLowerCase()); ++cnt) {
            HQLCompletionProposal proposal = this.createStartWithCompletionProposal(prefix, cursorPosition, kind, word);
            hcc.accept(proposal);
        }
    }
}

