/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.LocalVariableTypeTable_attribute;
import com.sun.tools.classfile.Signature;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class LocalVariableTypeTableWriter
extends InstructionDetailWriter {
    private ClassWriter classWriter;
    private Code_attribute codeAttr;
    private Map<Integer, List<LocalVariableTypeTable_attribute.Entry>> pcMap;

    static LocalVariableTypeTableWriter instance(Context context) {
        LocalVariableTypeTableWriter instance = context.get(LocalVariableTypeTableWriter.class);
        if (instance == null) {
            instance = new LocalVariableTypeTableWriter(context);
        }
        return instance;
    }

    protected LocalVariableTypeTableWriter(Context context) {
        super(context);
        context.put(LocalVariableTypeTableWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute attr) {
        this.codeAttr = attr;
        this.pcMap = new HashMap<Integer, List<LocalVariableTypeTable_attribute.Entry>>();
        LocalVariableTypeTable_attribute lvt = (LocalVariableTypeTable_attribute)attr.attributes.get("LocalVariableTypeTable");
        if (lvt == null) {
            return;
        }
        for (int i = 0; i < lvt.local_variable_table.length; ++i) {
            LocalVariableTypeTable_attribute.Entry entry = lvt.local_variable_table[i];
            this.put(entry.start_pc, entry);
            this.put(entry.start_pc + entry.length, entry);
        }
    }

    @Override
    public void writeDetails(Instruction instr) {
        int pc = instr.getPC();
        this.writeLocalVariables(pc, NoteKind.END);
        this.writeLocalVariables(pc, NoteKind.START);
    }

    @Override
    public void flush() {
        int pc = this.codeAttr.code_length;
        this.writeLocalVariables(pc, NoteKind.END);
    }

    public void writeLocalVariables(int pc, NoteKind kind) {
        ConstantPool constant_pool = this.classWriter.getClassFile().constant_pool;
        String indent = this.space(2);
        List<LocalVariableTypeTable_attribute.Entry> entries = this.pcMap.get(pc);
        if (entries != null) {
            ListIterator<LocalVariableTypeTable_attribute.Entry> iter = entries.listIterator(kind == NoteKind.END ? entries.size() : 0);
            while (kind == NoteKind.END ? iter.hasPrevious() : iter.hasNext()) {
                LocalVariableTypeTable_attribute.Entry entry = kind == NoteKind.END ? iter.previous() : iter.next();
                if (!kind.match(entry, pc)) continue;
                this.print(indent);
                this.print(kind.text);
                this.print(" generic local ");
                this.print(entry.index);
                this.print(" // ");
                Signature d = new Signature(entry.signature_index);
                try {
                    this.print(((Descriptor)d).getFieldType(constant_pool).toString().replace("/", "."));
                }
                catch (Descriptor.InvalidDescriptor e) {
                    this.print(this.report(e));
                }
                catch (ConstantPoolException e) {
                    this.print(this.report(e));
                }
                this.print(" ");
                try {
                    this.print(constant_pool.getUTF8Value(entry.name_index));
                }
                catch (ConstantPoolException e) {
                    this.print(this.report(e));
                }
                this.println();
            }
        }
    }

    private void put(int pc, LocalVariableTypeTable_attribute.Entry entry) {
        List<LocalVariableTypeTable_attribute.Entry> list = this.pcMap.get(pc);
        if (list == null) {
            list = new ArrayList<LocalVariableTypeTable_attribute.Entry>();
            this.pcMap.put(pc, list);
        }
        if (!list.contains(entry)) {
            list.add(entry);
        }
    }

    public static enum NoteKind {
        START("start"){

            @Override
            public boolean match(LocalVariableTypeTable_attribute.Entry entry, int pc) {
                return pc == entry.start_pc;
            }
        }
        ,
        END("end"){

            @Override
            public boolean match(LocalVariableTypeTable_attribute.Entry entry, int pc) {
                return pc == entry.start_pc + entry.length;
            }
        };

        public final String text;

        private NoteKind(String text) {
            this.text = text;
        }

        public abstract boolean match(LocalVariableTypeTable_attribute.Entry var1, int var2);
    }
}

