/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineTooltipPainter;

final class TimelineTooltipOverlay
extends ChartOverlay
implements ActionListener {
    static final int TOOLTIP_OFFSET = 15;
    static final int TOOLTIP_MARGIN = 10;
    private static final int TOOLTIP_RESPONSE = 50;
    private static final int ANIMATION_STEPS = 5;
    private TimelineTooltipPainter.Model[] rowModels;
    private Set<Integer> selectedTimestamps = Collections.EMPTY_SET;
    private Timer timer;
    private int currentStep;
    private Point[] targetPositions;

    TimelineTooltipOverlay(final TimelineSupport support) {
        final TimelineChart chart = support.getChart();
        if (chart.getSelectionModel() == null) {
            throw new NullPointerException("No ChartSelectionModel set for " + (Object)((Object)chart));
        }
        if (!Utils.forceSpeed()) {
            this.timer = new Timer(10, this);
            this.timer.setInitialDelay(0);
        }
        this.setLayout(null);
        final Runnable tooltipUpdater = new Runnable(){

            @Override
            public void run() {
                TimelineTooltipOverlay.this.updateTooltip(chart);
            }
        };
        chart.getSelectionModel().addSelectionListener(new ChartSelectionListener(){

            public void selectionModeChanged(int newMode, int oldMode) {
            }

            public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
            }

            public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
                tooltipUpdater.run();
            }

            public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            }
        });
        chart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
                if (lastOffsetX != offsetX || lastOffsetY != offsetY || scaleX != lastScaleX || scaleY != lastScaleY) {
                    SwingUtilities.invokeLater(tooltipUpdater);
                }
            }
        });
        chart.addRowListener(new TimelineChart.RowListener(){

            @Override
            public void rowsAdded(List<TimelineChart.Row> rows) {
                tooltipUpdater.run();
            }

            @Override
            public void rowsRemoved(List<TimelineChart.Row> rows) {
                tooltipUpdater.run();
            }

            @Override
            public void rowsResized(List<TimelineChart.Row> rows) {
                tooltipUpdater.run();
            }
        });
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
                TimelineTooltipOverlay.this.selectedTimestamps = new TreeSet<Integer>(support.getSelectedTimestamps());
                tooltipUpdater.run();
            }
        });
    }

    void setupModel(TimelineTooltipPainter.Model[] rowModels) {
        this.removeAll();
        this.rowModels = rowModels;
        for (TimelineTooltipPainter.Model rowModel : rowModels) {
            TimelineTooltipPainter painter = new TimelineTooltipPainter(false);
            this.add(painter);
            painter.setVisible(false);
        }
        this.targetPositions = new Point[rowModels.length];
    }

    private void setPosition(Point p, TimelineTooltipPainter tooltipPainter, int index, boolean immediate) {
        if (this.getComponentCount() > 0) {
            if (p == null) {
                if (tooltipPainter.isVisible()) {
                    tooltipPainter.setVisible(false);
                }
                if (this.timer != null) {
                    this.timer.stop();
                }
            } else if (immediate || !tooltipPainter.isVisible() || this.timer == null) {
                tooltipPainter.setVisible(true);
                tooltipPainter.setLocation(p);
            } else {
                this.currentStep = 0;
                this.targetPositions[index] = p;
                this.timer.restart();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.rowModels.length; ++i) {
            TimelineTooltipPainter tooltipPainter = (TimelineTooltipPainter)this.getComponent(i);
            Point targetPosition = this.targetPositions[i];
            Point currentPosition = tooltipPainter.getLocation();
            currentPosition.x += (targetPosition.x - currentPosition.x) / (5 - this.currentStep);
            currentPosition.y += (targetPosition.y - currentPosition.y) / (5 - this.currentStep);
            tooltipPainter.setLocation(currentPosition);
        }
        if (++this.currentStep == 5) {
            this.timer.stop();
        }
    }

    private void checkAllocatedSelectionPainters() {
        int requiredPainters;
        int allocatedPainters = this.getComponentCount() - this.rowModels.length;
        if (allocatedPainters == (requiredPainters = this.rowModels.length * this.selectedTimestamps.size())) {
            return;
        }
        int diff = requiredPainters - allocatedPainters;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                this.add(new TimelineTooltipPainter(true));
            }
        } else {
            for (int i = 0; i > diff; --i) {
                this.remove(this.getComponentCount() - 1);
            }
            this.repaint();
        }
    }

    private void updateTooltip(TimelineChart chart) {
        if (this.rowModels == null) {
            return;
        }
        ChartSelectionModel selectionModel = chart.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        this.checkAllocatedSelectionPainters();
        int painterIndex = this.getComponentCount() - 1;
        for (int rowIndex = 0; rowIndex < chart.getRowsCount(); ++rowIndex) {
            TimelineChart.Row row = chart.getRow(rowIndex);
            ChartContext rowContext = row.getContext();
            int itemsCount = row.getItemsCount();
            TimelineTooltipPainter.Model model = this.rowModels[rowIndex];
            for (int mark : this.selectedTimestamps) {
                ArrayList<ItemSelection> selections = new ArrayList<ItemSelection>(itemsCount);
                for (int itemIndex = 0; itemIndex < itemsCount; ++itemIndex) {
                    SynchronousXYItem item = (SynchronousXYItem)row.getItem(itemIndex);
                    selections.add((ItemSelection)new XYItemSelection.Default((XYItem)item, mark, Integer.MAX_VALUE));
                }
                TimelineTooltipPainter tooltipPainter = (TimelineTooltipPainter)this.getComponent(painterIndex--);
                tooltipPainter.update(model, selections);
                tooltipPainter.setSize(tooltipPainter.getPreferredSize());
                this.setPosition(selections, chart.getPaintersModel(), rowContext, tooltipPainter, rowIndex, true);
            }
        }
        List highlightedItems = selectionModel.getHighlightedItems();
        boolean noSelection = highlightedItems.isEmpty();
        if (!noSelection) {
            XYItemSelection sel = (XYItemSelection)highlightedItems.get(0);
            noSelection = sel.getItem().getValuesCount() <= sel.getValueIndex();
        }
        int rowsCount = chart.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            TimelineTooltipPainter tooltipPainter = (TimelineTooltipPainter)this.getComponent(i);
            if (noSelection) {
                this.setPosition(null, tooltipPainter, i, false);
                continue;
            }
            TimelineChart.Row row = chart.getRow(i);
            ArrayList<ItemSelection> selections = new ArrayList<ItemSelection>(highlightedItems.size());
            for (ItemSelection sel : highlightedItems) {
                if (!row.containsItem(sel.getItem())) continue;
                selections.add(sel);
            }
            tooltipPainter.update(this.rowModels[i], selections);
            tooltipPainter.setSize(tooltipPainter.getPreferredSize());
            this.setPosition(selections, chart.getPaintersModel(), row.getContext(), tooltipPainter, i, false);
        }
    }

    private void setPosition(List<ItemSelection> selectedItems, PaintersModel paintersModel, ChartContext chartContext, TimelineTooltipPainter tooltipPainter, int index, boolean immediate) {
        LongRect bounds = null;
        for (ItemSelection selection : selectedItems) {
            ItemPainter painter = paintersModel.getPainter(selection.getItem());
            LongRect selBounds = painter.getSelectionBounds(selection, chartContext);
            if (bounds == null) {
                bounds = selBounds;
                continue;
            }
            LongRect.add((LongRect)bounds, (LongRect)selBounds);
        }
        this.setPosition(this.normalizePosition(Utils.checkedRectangle(bounds), tooltipPainter, chartContext), tooltipPainter, index, immediate);
    }

    private Point normalizePosition(Rectangle bounds, TimelineTooltipPainter tooltipPainter, ChartContext chartContext) {
        Point p = new Point();
        p.x = bounds.x + bounds.width + 15;
        if (p.x > chartContext.getViewportWidth() - tooltipPainter.getWidth() - 10) {
            p.x = bounds.x - tooltipPainter.getWidth() - 15;
        }
        int rowY = Utils.checkedInt((double)chartContext.getViewportOffsetY());
        int rowHeight = chartContext.getViewportHeight();
        p.y = rowY + (rowHeight - tooltipPainter.getHeight()) / 2;
        return p;
    }

    public void paint(Graphics g) {
        if (this.getComponentCount() == 0) {
            return;
        }
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            g.setClip(bounds);
        } else {
            g.setClip(clip.intersection(bounds));
        }
        super.paint(g);
    }
}

