/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.JavaJspCompletionProvider;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.ImageUtilities;

public class AttrSupports {
    private static final Logger logger = Logger.getLogger(AttrSupports.class.getName());

    public static class EncodingSupport
    extends AttributeValueSupport.Default {
        public EncodingSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator<String> iter = Charset.availableCharsets().keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return list;
        }
    }

    public static class PageLanguage
    extends AttributeValueSupport.Default {
        public PageLanguage() {
            super(false, "page", "language");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("java");
            return list;
        }
    }

    public static class TrueFalseSupport
    extends AttributeValueSupport.Default {
        public TrueFalseSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("false");
            list.add("true");
            return list;
        }
    }

    public static class FilenameSupport
    extends AttributeValueSupport.Default {
        static final ImageIcon PACKAGE_ICON = ImageUtilities.loadImageIcon((String)"org/openide/loaders/defaultFolder.gif", (boolean)false);

        public FilenameSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        public void result(JspCompletionQuery.CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            String path = "";
            String fileNamePart = valuePart;
            int lastSlash = valuePart.lastIndexOf(47);
            if (lastSlash == 0) {
                path = "/";
                fileNamePart = valuePart.substring(1);
            } else if (lastSlash > 0) {
                path = valuePart.substring(0, lastSlash);
                fileNamePart = lastSlash == valuePart.length() ? "" : valuePart.substring(lastSlash + 1);
            }
            int anchor = offset - valuePart.length() + lastSlash + 1;
            try {
                FileObject orig = sup.getFileObject();
                FileObject documentBase = JspUtils.guessWebModuleRoot(orig);
                String ctxPath = JspUtils.resolveRelativeURL("/" + orig.getPath(), path);
                ctxPath = path.startsWith("/") && documentBase != null ? documentBase.getPath() + path : ctxPath.substring(1);
                FileSystem fs = orig.getFileSystem();
                FileObject folder = fs.findResource(ctxPath);
                if (folder != null) {
                    result.addAllItems(this.files(anchor, folder, fileNamePart, sup));
                    if (!(folder.equals(documentBase) || path.startsWith("/") || path.length() != 0 && path.lastIndexOf("../") + 3 != path.length())) {
                        result.addItem(JspCompletionItem.createGoUpFileCompletionItem(anchor, Color.BLUE, PACKAGE_ICON));
                    }
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            result.setAnchorOffset(anchor);
        }

        private List<JspCompletionItem> files(int offset, FileObject folder, String prefix, JspSyntaxSupport sup) {
            ArrayList<JspCompletionItem> res = new ArrayList<JspCompletionItem>();
            TreeMap<String, JspCompletionItem> resFolders = new TreeMap<String, JspCompletionItem>();
            TreeMap<String, JspCompletionItem> resFiles = new TreeMap<String, JspCompletionItem>();
            Enumeration files = folder.getChildren(false);
            while (files.hasMoreElements()) {
                FileObject file = (FileObject)files.nextElement();
                String fname = file.getNameExt();
                if (!fname.startsWith(prefix) || "cvs".equalsIgnoreCase(fname)) continue;
                if (file.isFolder()) {
                    resFolders.put(file.getNameExt(), JspCompletionItem.createFileCompletionItem(file.getNameExt() + "/", offset, Color.BLUE, PACKAGE_ICON));
                    continue;
                }
                Image icon = JspUtils.getIcon(file);
                if (icon != null) {
                    resFiles.put(file.getNameExt(), JspCompletionItem.createFileCompletionItem(file.getNameExt(), offset, Color.BLACK, new ImageIcon(icon)));
                    continue;
                }
                resFiles.put(file.getNameExt(), JspCompletionItem.createFileCompletionItem(file.getNameExt(), offset, Color.BLACK, null));
            }
            res.addAll(resFolders.values());
            res.addAll(resFiles.values());
            return res;
        }
    }

    public static class TaglibTagdir
    extends AttributeValueSupport.Default {
        public TaglibTagdir() {
            super(false, "taglib", "tagdir");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            FileObject webInfTags;
            ArrayList<String> l = new ArrayList<String>();
            FileObject orig = sup.getFileObject();
            FileObject documentBase = JspUtils.guessWebModuleRoot(orig);
            if (documentBase != null && (webInfTags = JspUtils.findRelativeFileObject(documentBase, "WEB-INF/tags")) != null) {
                if (this.isValidTagDir(webInfTags)) {
                    l.add(JspUtils.findRelativeContextPath(documentBase, webInfTags));
                }
                Enumeration en = webInfTags.getFolders(true);
                while (en.hasMoreElements()) {
                    FileObject subF = (FileObject)en.nextElement();
                    if (!this.isValidTagDir(subF)) continue;
                    l.add(JspUtils.findRelativeContextPath(documentBase, subF));
                }
            }
            Collections.sort(l);
            return l;
        }

        private boolean isValidTagDir(FileObject subF) {
            return subF.getChildren(false).hasMoreElements();
        }
    }

    public static class TaglibURI
    extends AttributeValueSupport.Default {
        public TaglibURI() {
            super(false, "taglib", "uri");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            Map map = sup.getTagLibraryMappings();
            if (map != null) {
                for (String s : map.keySet()) {
                    list.add(s);
                }
            }
            Collections.sort(list);
            return list;
        }
    }

    public static class SetPropertyProperty
    extends GetSetPropertyProperty {
        public SetPropertyProperty() {
            super(true, "jsp:setProperty", "property");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            List<String> list = this.possibleValues(sup, item, true);
            list.add(0, "*");
            return list;
        }
    }

    public static class GetPropertyProperty
    extends GetSetPropertyProperty {
        public GetPropertyProperty() {
            super(true, "jsp:getProperty", "property");
        }

        @Override
        public List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return this.possibleValues(sup, item, false);
        }
    }

    public static abstract class GetSetPropertyProperty
    extends AttributeValueSupport.Default {
        public GetSetPropertyProperty(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item, boolean setter) {
            ArrayList<String> list = new ArrayList<String>();
            String namePropertyValue = (String)item.getAttributes().get("name");
            if (namePropertyValue != null) {
                String className = null;
                PageInfo.BeanData[] beanData = sup.getBeanData();
                for (int i = 0; i < beanData.length; ++i) {
                    if (beanData[i] == null || beanData[i].getId() == null || !beanData[i].getId().equals(namePropertyValue)) continue;
                    className = beanData[i].getClassName();
                    break;
                }
                if (className != null) {
                    URLClassLoader cld = null;
                    try {
                        FileObject fileObject = NbEditorUtilities.getDataObject((Document)sup.getDocument()).getPrimaryFile();
                        cld = JspUtils.getModuleClassLoader(fileObject);
                        Class<?> beanClass = Class.forName(className, false, cld);
                        Introspector.flushFromCaches(beanClass);
                        BeanInfo benInfo = Introspector.getBeanInfo(beanClass);
                        PropertyDescriptor[] properties = benInfo.getPropertyDescriptors();
                        for (int j = 0; j < properties.length; ++j) {
                            if (setter && properties[j].getWriteMethod() != null) {
                                list.add(properties[j].getName());
                            }
                            if (setter || properties[j].getReadMethod() == null || properties[j].getName().equals("class")) continue;
                            list.add(properties[j].getName());
                        }
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (IntrospectionException ex) {
                    }
                    finally {
                        if (cld != null && cld instanceof Closeable) {
                            try {
                                ((Closeable)cld).close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(AttrSupports.class.getName()).log(Level.INFO, null, ex);
                            }
                        }
                    }
                }
            }
            return list;
        }
    }

    public static class GetSetPropertyName
    extends AttributeValueSupport.Default {
        public GetSetPropertyName(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            PageInfo.BeanData[] beanData = sup.getBeanData();
            if (beanData != null) {
                for (int i = 0; i < beanData.length; ++i) {
                    list.add(beanData[i].getId());
                }
            }
            return list;
        }
    }

    @Deprecated
    public static class PackageListSupport
    extends ClassNameSupport {
        public PackageListSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected String getFakedClassBody(String prefix) {
            int commaPos = prefix.lastIndexOf(",");
            if (commaPos > -1) {
                prefix = prefix.substring(commaPos + 1);
            }
            return "import " + prefix;
        }
    }

    @Deprecated
    public static class ClassNameSupport
    extends AttributeValueSupport.Default {
        public ClassNameSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return new ArrayList();
        }

        protected String getFakedClassBody(String prefix) {
            return "class Foo extends " + prefix;
        }

        @Override
        public void result(JspCompletionQuery.CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            String fakedClassBody = this.getFakedClassBody(valuePart);
            int shiftedOffset = fakedClassBody.length();
            logger.fine("JSP CC: delegating CC query to java file:\n" + fakedClassBody.substring(0, shiftedOffset) + "|" + fakedClassBody.substring(shiftedOffset) + "\n");
            JavaJspCompletionProvider.CompletionQueryDelegatedToJava delegate = new JavaJspCompletionProvider.CompletionQueryDelegatedToJava(offset, shiftedOffset, 1);
            delegate.create(component.getDocument(), fakedClassBody);
            List<? extends CompletionItem> items = delegate.getCompletionItems();
            result.addAllItems(items);
            result.setAnchorOffset(offset - (valuePart.length() - valuePart.lastIndexOf(46)) + 1);
        }
    }

    public static class YesNoTrueFalseSupport
    extends AttributeValueSupport.Default {
        public YesNoTrueFalseSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("false");
            list.add("no");
            list.add("true");
            list.add("yes");
            return list;
        }
    }

    public static class VariableScopeSupport
    extends AttributeValueSupport.Default {
        public VariableScopeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("AT_BEGIN");
            list.add("AT_END");
            list.add("NESTED");
            return list;
        }
    }

    public static class PluginTypeSupport
    extends AttributeValueSupport.Default {
        public PluginTypeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("bean");
            list.add("applet");
            return list;
        }
    }

    public static class RootVersionSupport
    extends AttributeValueSupport.Default {
        public RootVersionSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1.2");
            list.add("2.0");
            return list;
        }
    }

    public static class BodyContentSupport
    extends AttributeValueSupport.Default {
        public BodyContentSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("scriptless");
            list.add("tagdependent");
            list.add("empty");
            return list;
        }
    }

    public static class ScopeSupport
    extends AttributeValueSupport.Default {
        public ScopeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("application");
            list.add("page");
            list.add("request");
            list.add("session");
            return list;
        }
    }
}

