/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ConfigurationModifier<T extends BaseDescriptorModel> {
    public final void modify(DescriptorModifier<T> modifier, DataObject dataObject, File file) throws ConfigurationException {
        Parameters.notNull((CharSequence)"dataObject", (Object)dataObject);
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Object newWeblogicWebApp = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newWeblogicWebApp = modifier.load(docString);
            }
            catch (RuntimeException e) {
                T oldWeblogicWebApp = modifier.load();
                if (oldWeblogicWebApp == null) {
                    String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_configFileCannotParse", (Object)file.getPath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_descriptorNotValid", (Object)file.getPath()), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newWeblogicWebApp = oldWeblogicWebApp;
            }
            modifier.modify(newWeblogicWebApp);
            boolean modified = dataObject.isModified();
            this.replaceDocument(doc, newWeblogicWebApp);
            if (!modified && (cookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            modifier.save(newWeblogicWebApp);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private void replaceDocument(final StyledDocument doc, T graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ((BaseDescriptorModel)graph).write(out);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    public static interface DescriptorModifier<T extends BaseDescriptorModel> {
        public void modify(T var1);

        public T load() throws IOException;

        public T load(byte[] var1) throws IOException;

        public void save(T var1);
    }
}

