/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.projects;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.projects.J2eeModuleProviderAccessor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.WebTargetModuleID;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class DeploymentTarget {
    private final J2eeModuleProvider moduleProvider;
    private final String clientName;
    private ServerString server;
    private TargetModule[] targetModules;

    public DeploymentTarget(J2eeModuleProvider moduleProvider, String clientName) {
        this.moduleProvider = moduleProvider;
        this.clientName = clientName;
    }

    public J2eeModule getModule() {
        return this.moduleProvider.getJ2eeModule();
    }

    public J2eeModuleProvider getModuleProvider() {
        return this.moduleProvider;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this.moduleProvider.getModuleChangeReporter();
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.moduleProvider.getResourceChangeReporter();
    }

    public String getClientUrl(String partUrl) {
        J2eeModule clientModule = null;
        String url = null;
        if (this.moduleProvider instanceof J2eeApplicationProvider) {
            J2eeApplicationProvider ear = (J2eeApplicationProvider)this.moduleProvider;
            J2eeModuleProvider clientProvider = this.getChildModuleProvider(ear, this.clientName);
            if (clientProvider != null) {
                clientModule = clientProvider.getJ2eeModule();
            } else {
                J2eeApplication jmc = (J2eeApplication)ear.getJ2eeModule();
                J2eeModule[] modules = jmc.getModules();
                for (int i = 0; i < modules.length; ++i) {
                    if (!J2eeModule.Type.WAR.equals(modules[i].getType())) continue;
                    clientModule = modules[i];
                    break;
                }
            }
        } else {
            clientModule = this.moduleProvider.getJ2eeModule();
        }
        if (clientModule != null && clientModule.getType().equals(J2eeModule.Type.WAR)) {
            url = this.findWebUrl(clientModule);
            if (url != null) {
                StringBuilder sb = new StringBuilder(url);
                int length = sb.length();
                if (length > 0 && sb.charAt(length - 1) == '/') {
                    sb.setLength(length - 1);
                }
                if (partUrl.startsWith("/") || partUrl.length() == 0) {
                    sb.append(partUrl);
                } else {
                    sb.append('/').append(partUrl);
                }
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    private J2eeModuleProvider getChildModuleProvider(J2eeModuleProvider jmp, String uri) {
        if (uri == null) {
            return null;
        }
        J2eeModuleProvider child = null;
        if (jmp instanceof J2eeApplicationProvider) {
            J2eeApplicationProvider jap = (J2eeApplicationProvider)jmp;
            child = jap.getChildModuleProvider(uri);
            if (child == null) {
                String root = "/";
                uri = uri.startsWith(root) ? uri.substring(1) : root + uri;
                child = jap.getChildModuleProvider(uri);
            }
            if (child == null) {
                Pattern pattern = Pattern.compile(Pattern.quote(DeploymentTarget.normalizeUri(uri) + ".") + "(war|jar)");
                for (J2eeModuleProvider prov : jap.getChildModuleProviders()) {
                    String childUri = prov.getJ2eeModule().getUrl();
                    if (childUri == null || !pattern.matcher(childUri).matches()) continue;
                    return prov;
                }
            }
        }
        return child;
    }

    private TargetModule getTargetModule() {
        TargetModule[] mods = this.getTargetModules();
        if (mods == null || mods.length == 0) {
            return null;
        }
        if (mods[0].delegate() != null) {
            return mods[0];
        }
        mods[0].initDelegate(J2eeModuleAccessor.getDefault().getJsrModuleType(this.getModule().getType()));
        return mods[0];
    }

    private String findWebUrl(J2eeModule client) {
        TargetModule module = this.getTargetModule();
        if (module == null) {
            return null;
        }
        if (this.getModule() == client) {
            return DeploymentTarget.getUrl(module);
        }
        ServerInstance instance = ServerRegistry.getInstance().getServerInstance(module.getInstanceUrl());
        IncrementalDeployment mur = instance.getIncrementalDeployment();
        String clientModuleUri = client == null ? "" : client.getUrl();
        clientModuleUri = DeploymentTarget.normalizeUri(clientModuleUri);
        TargetModuleID[] children = module.getChildTargetModuleID();
        String urlString = null;
        TargetModuleID tmid = null;
        for (int i = 0; children != null && i < children.length; ++i) {
            if (urlString == null || urlString.trim().equals("")) {
                urlString = DeploymentTarget.getUrl(children[i]);
            }
            String uri = children[i].getModuleID();
            if (mur != null) {
                uri = mur.getModuleUrl(children[i]);
            } else {
                int j = uri.indexOf(35);
                if (j > -1) {
                    uri = uri.substring(j + 1);
                }
            }
            uri = DeploymentTarget.normalizeUri(uri);
            if (!clientModuleUri.equalsIgnoreCase(uri)) continue;
            tmid = children[i];
            break;
        }
        if (tmid != null) {
            urlString = DeploymentTarget.getUrl(tmid);
        } else if (children == null || children.length == 0) {
            urlString = DeploymentTarget.getUrl(module);
        }
        return urlString;
    }

    private static String normalizeUri(String uri) {
        if (!uri.startsWith("/")) {
            return "/" + uri;
        }
        return uri;
    }

    private static String getUrl(TargetModuleID id) {
        URL u;
        if (id instanceof WebTargetModuleID && (u = ((WebTargetModuleID)id).resolveWebURL()) != null) {
            return u.toString();
        }
        return id.getWebURL();
    }

    public File getConfigurationFile() {
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider).getConfigurationFile();
    }

    public ServerString getServer() {
        if (this.server == null) {
            String instanceID = this.moduleProvider.getServerInstanceID();
            ServerInstance inst = ServerRegistry.getInstance().getServerInstance(instanceID);
            if (inst == null) {
                throw new RuntimeException(NbBundle.getMessage(DeploymentTarget.class, (String)"MSG_TargetServerNotFound", (Object)instanceID));
            }
            this.server = new ServerString(inst);
        }
        return this.server;
    }

    public TargetModule[] getTargetModules() {
        if (this.targetModules == null || this.targetModules.length == 0) {
            String fname = this.getTargetModuleFileName();
            if (fname == null) {
                return null;
            }
            this.targetModules = TargetModule.load(this.getServer(), fname);
        }
        return (TargetModule[])this.targetModules.clone();
    }

    public void setTargetModules(TargetModule[] targetModules) {
        this.targetModules = (TargetModule[])targetModules.clone();
        for (int i = 0; i < targetModules.length; ++i) {
            String fname = this.getTargetModuleFileName();
            if (fname == null) continue;
            targetModules[i].updateTimestamp();
            targetModules[i].save(fname);
        }
    }

    public ModuleConfigurationProvider getModuleConfigurationProvider() {
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider);
    }

    public J2eeModuleProvider.ConfigSupport getConfigSupport() {
        return this.moduleProvider.getConfigSupport();
    }

    private String getTargetModuleFileName() {
        File file;
        ConfigSupportImpl config = J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider);
        FileObject fo = config.getProjectDirectory();
        if (fo != null && (file = FileUtil.toFile((FileObject)fo)) != null) {
            return TargetModule.shortNameFromPath(file.getAbsolutePath());
        }
        try {
            if (this.getModule().getContentDirectory() != null && (file = FileUtil.toFile((FileObject)this.getModule().getContentDirectory())) != null) {
                return TargetModule.shortNameFromPath(file.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
        String name = this.moduleProvider.getDeploymentName();
        if (name != null) {
            return name;
        }
        return J2eeModuleProviderAccessor.getDefault().getConfigSupportImpl(this.moduleProvider).getDeploymentName();
    }

    public String getDeploymentName() {
        return this.moduleProvider.getDeploymentName();
    }
}

