/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.csv;

import com.mchange.v2.csv.MalformedCsvException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FastCsvUtils {
    private static final int ESCAPE_BIT = 0x1000000;
    private static final int SHIFT_BIT = 0x2000000;
    private static final int SHIFT_OFFSET = 8;

    public static String csvReadLine(BufferedReader br) throws IOException {
        String out;
        String s = br.readLine();
        if (s != null) {
            int quoteCount = FastCsvUtils.countQuotes(s);
            if (quoteCount % 2 != 0) {
                StringBuilder sb = new StringBuilder(s);
                do {
                    s = br.readLine();
                    sb.append(s);
                } while ((quoteCount += FastCsvUtils.countQuotes(s)) % 2 != 0);
                out = sb.toString();
            } else {
                out = s;
            }
        } else {
            out = null;
        }
        return out;
    }

    private static int countQuotes(String s) {
        char[] chars = s.toCharArray();
        int count = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (chars[i] != '\"') continue;
            ++count;
        }
        return count;
    }

    public static String[] splitRecord(String csvRecord) throws MalformedCsvException {
        int[] upshifted = FastCsvUtils.upshiftQuoteString(csvRecord);
        List upshiftedSplit = FastCsvUtils.splitShifted(upshifted);
        int len = upshiftedSplit.size();
        String[] out = new String[len];
        for (int i = 0; i < len; ++i) {
            out[i] = FastCsvUtils.downshift((int[])upshiftedSplit.get(i));
        }
        return out;
    }

    private static void debugPrint(int[] arr) {
        int len = arr.length;
        char[] cbuf = new char[len];
        for (int i = 0; i < len; ++i) {
            cbuf[i] = (char)(FastCsvUtils.isShifted(arr[i]) ? 95 : (char)arr[i]);
        }
        System.err.println(new String(cbuf));
    }

    private static List splitShifted(int[] shiftedQuoteString) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        int sstart = 0;
        int len = shiftedQuoteString.length;
        for (int finger = 0; finger <= len; ++finger) {
            int tstart;
            if (finger != len && shiftedQuoteString[finger] != 44) continue;
            int slen = finger - sstart;
            int tlen = -1;
            for (tstart = sstart; tstart <= finger; ++tstart) {
                if (tstart == finger) {
                    tlen = 0;
                    break;
                }
                if (shiftedQuoteString[tstart] != 32 && shiftedQuoteString[tstart] != 9) break;
            }
            if (tlen < 0) {
                if (tstart == finger - 1) {
                    tlen = 1;
                } else {
                    int index;
                    for (tlen = finger - tstart; tlen > 0 && (shiftedQuoteString[index = tstart + tlen - 1] == 32 || shiftedQuoteString[index] == 9); --tlen) {
                    }
                }
            }
            int[] trimsplit = new int[tlen];
            if (tlen > 0) {
                System.arraycopy(shiftedQuoteString, tstart, trimsplit, 0, tlen);
            }
            out.add(trimsplit);
            sstart = finger + 1;
        }
        return out;
    }

    private static String downshift(int[] maybeShifted) {
        int len = maybeShifted.length;
        char[] cbuf = new char[len];
        for (int i = 0; i < len; ++i) {
            int c = maybeShifted[i];
            cbuf[i] = (char)(FastCsvUtils.isShifted(c) ? c >>> 8 : c);
        }
        return new String(cbuf);
    }

    private static boolean isShifted(int c) {
        return (c & 0x2000000) != 0;
    }

    private static int[] upshiftQuoteString(String s) throws MalformedCsvException {
        char[] chars = s.toCharArray();
        int[] buf = new int[chars.length];
        EscapedCharReader rdr = new EscapedCharReader(chars);
        int finger = 0;
        boolean shift = false;
        int c = rdr.read(shift);
        while (c >= 0) {
            if (c == 34) {
                shift = !shift;
            } else {
                buf[finger++] = FastCsvUtils.findShiftyChar(c, shift);
            }
            c = rdr.read(shift);
        }
        int[] out = new int[finger];
        System.arraycopy(buf, 0, out, 0, finger);
        return out;
    }

    private static int findShiftyChar(int c, boolean shift) {
        return shift ? c << 8 | 0x2000000 : c;
    }

    private static int escape(int c) {
        return c | 0x1000000;
    }

    private static boolean isEscaped(int c) {
        return (c & 0x1000000) != 0;
    }

    private FastCsvUtils() {
    }

    private static class EscapedCharReader {
        char[] chars;
        int finger;

        EscapedCharReader(char[] chars) {
            this.chars = chars;
            this.finger = 0;
        }

        int read(boolean shift) throws MalformedCsvException {
            if (this.finger < this.chars.length) {
                char out;
                if ((out = this.chars[this.finger++]) == '\"' && shift) {
                    if (this.finger < this.chars.length) {
                        char next = this.chars[this.finger];
                        if (next == '\"') {
                            ++this.finger;
                            return FastCsvUtils.escape(next);
                        }
                        return out;
                    }
                    return out;
                }
                return out;
            }
            return -1;
        }
    }
}

