/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FixClassesSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadClasses(final JPDADebugger debugger, Map<String, FileObject> classes) {
        RequestProcessor rp;
        final HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String className : classes.keySet()) {
            FileObject fo = classes.get(className);
            InputStream is = null;
            try {
                is = fo.getInputStream();
                long fileSize = fo.getSize();
                byte[] bytecode = new byte[(int)fileSize];
                is.read(bytecode);
                map.put(className, bytecode);
                System.out.println(" " + className);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (map.isEmpty()) {
            return;
        }
        try {
            Session s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
            rp = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
            if (rp == null) {
                rp = new RequestProcessor(FixClassesSupport.class.getName());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                String error = null;
                try {
                    debugger.fixClasses(map);
                }
                catch (UnsupportedOperationException uoex) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixUnsupported", (Object)uoex.getLocalizedMessage());
                }
                catch (NoClassDefFoundError ncdfex) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixMismatch", (Object)ncdfex.getLocalizedMessage());
                }
                catch (VerifyError ver) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixVerifierProblems", (Object)ver.getLocalizedMessage());
                }
                catch (UnsupportedClassVersionError ucver) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixUnsupportedVersion", (Object)ucver.getLocalizedMessage());
                }
                catch (ClassFormatError cfer) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixNotValid", (Object)cfer.getLocalizedMessage());
                }
                catch (ClassCircularityError ccer) {
                    error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixCircularity", (Object)ccer.getLocalizedMessage());
                }
                catch (RuntimeException vmdisc) {
                    if ("com.sun.jdi.VMOutOfMemoryException".equals(vmdisc.getClass().getName())) {
                        error = NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixOOME");
                    }
                    if ("com.sun.jdi.VMDisconnectedException".equals(vmdisc.getClass().getName())) {
                        return;
                    }
                    throw vmdisc;
                }
                if (error != null) {
                    FixClassesSupport.notifyError(debugger, error);
                    FixClassesSupport.setStatusText(debugger, error);
                } else {
                    FixClassesSupport.setStatusText(debugger, NbBundle.getMessage(FixClassesSupport.class, (String)"MSG_FixSuccess"));
                }
            }
        });
    }

    static void notifyError(JPDADebugger debugger, String error) {
        try {
            debugger.getClass().getMethod("actionErrorMessageCallback", Object.class, String.class).invoke((Object)debugger, ActionsManager.ACTION_FIX, error);
        }
        catch (Error | Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        FixClassesSupport.setStatusText(debugger, error);
    }

    static void setStatusText(JPDADebugger debugger, String status) {
        try {
            debugger.getClass().getMethod("actionStatusDisplayCallback", Object.class, String.class).invoke((Object)debugger, ActionsManager.ACTION_FIX, status);
        }
        catch (Error | Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static final class ClassesToReload {
        private static ClassesToReload instance;
        private final Map<JPDADebugger, Map<FileObject, Map<String, FileObject>>> classesByDebugger = new WeakHashMap<JPDADebugger, Map<FileObject, Map<String, FileObject>>>();
        private final PropertyChangeSupport pch = new PropertyChangeSupport(this);

        private ClassesToReload() {
        }

        public static synchronized ClassesToReload getInstance() {
            if (instance == null) {
                instance = new ClassesToReload();
            }
            return instance;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pch.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pch.removePropertyChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClassToReload(JPDADebugger debugger, FileObject src, String className, FileObject fo) {
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<String, FileObject> classes;
                Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
                if (srcRoots == null) {
                    srcRoots = new HashMap<FileObject, Map<String, FileObject>>();
                    this.classesByDebugger.put(debugger, srcRoots);
                }
                if ((classes = srcRoots.get(src)) == null) {
                    classes = new HashMap<String, FileObject>();
                    srcRoots.put(src, classes);
                }
                classes.put(className, fo);
            }
            this.pch.firePropertyChange("classesToReload", null, className);
        }

        public synchronized boolean hasClassesToReload(JPDADebugger debugger, Set<FileObject> enabledSourceRoots) {
            Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
            if (srcRoots != null) {
                for (FileObject src : srcRoots.keySet()) {
                    if (!enabledSourceRoots.contains(src)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, FileObject> popClassesToReload(JPDADebugger debugger, Set<FileObject> enabledSourceRoots) {
            HashMap<String, FileObject> classes = new HashMap<String, FileObject>();
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
                if (srcRoots != null) {
                    HashSet<FileObject> sourceRoots = new HashSet<FileObject>(srcRoots.keySet());
                    for (FileObject src : sourceRoots) {
                        if (!enabledSourceRoots.contains(src)) continue;
                        classes.putAll(srcRoots.remove(src));
                    }
                }
            }
            if (classes.size() > 0) {
                this.pch.firePropertyChange("classesToReload", null, null);
            }
            return classes;
        }
    }
}

