/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ExtractSuperclassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractSuperclassRefactoring refactoring;
    private ElementHandle<TypeElement> classHandle;
    private String pkgName;

    ExtractSuperclassRefactoringPlugin(ExtractSuperclassRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 2);
        javac.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle sourceType = this.refactoring.getSourceType();
            Problem result = ExtractSuperclassRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Element sourceElm = sourceType.resolveElement((CompilationInfo)javac);
            result = JavaPluginUtils.isSourceElement(sourceElm, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (sourceElm == null) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            if (sourceElm.getKind() != ElementKind.CLASS) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ExtractSC_MustBeClass"));
                return problem;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)sourceElm));
            PackageElement pkgElm = (PackageElement)javac.getElementUtilities().outermostTypeElement(sourceElm).getEnclosingElement();
            this.pkgName = pkgElm.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getSuperClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return super.fastCheckParameters();
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        Problem result = null;
        String newName = this.refactoring.getSuperClassName();
        TypeMirror parsedType = javac.getTreeUtilities().parseType(newName, (TypeElement)this.classHandle.resolve((CompilationInfo)javac));
        if (parsedType != null && parsedType.getKind() != TypeKind.ERROR) {
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return super.fastCheckParameters(javac);
    }

    @Override
    public Problem checkParameters() {
        MemberInfo<ElementHandle<? extends Element>>[] members = this.refactoring.getMembers();
        if (members.length == 0) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_MembersNotAvailable"));
        }
        return super.checkParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        assert (sourceType != null);
        HashSet<? extends Element> members = new HashSet<Element>(sourceType.getEnclosedElements());
        this.fireProgressListenerStart(2, this.refactoring.getMembers().length);
        try {
            for (MemberInfo<ElementHandle<? extends Element>> info : this.refactoring.getMembers()) {
                Problem p = null;
                switch (info.getGroup()) {
                    case FIELD: {
                        ElementHandle<? extends Element> vehandle = info.getElementHandle();
                        VariableElement field = (VariableElement)vehandle.resolve((CompilationInfo)javac);
                        p = this.checkFieldParameter(javac, field, members);
                        break;
                    }
                    case METHOD: {
                        ElementHandle<? extends Element> eehandle = info.getElementHandle();
                        ExecutableElement method = (ExecutableElement)eehandle.resolve((CompilationInfo)javac);
                        p = this.checkMethodParameter(javac, method, members);
                    }
                }
                if (p != null) {
                    Problem problem = p;
                    return problem;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private Problem checkFieldParameter(CompilationController javac, VariableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.FIELD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    private Problem checkMethodParameter(CompilationController javac, ExecutableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.METHOD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        HashSet<FileObject> set = new HashSet<FileObject>();
        set.add(this.refactoring.getSourceType().getFileObject());
        return set;
    }

    private ClasspathInfo getClasspathInfo(Set<FileObject> a) {
        ClasspathInfo cpInfo = JavaRefactoringUtils.getClasspathInfoFor(a.toArray(new FileObject[a.size()]));
        return cpInfo;
    }

    public Problem prepare(RefactoringElementsBag bag) {
        ExtractSuperclassTransformer visitor = new ExtractSuperclassTransformer(this.refactoring, this.classHandle);
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size());
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, visitor, this.refactoring.getSourceType());
        Problem problem = this.createAndAddElements(a, transform, bag, this.refactoring, this.getClasspathInfo(a));
        this.fireProgressListenerStop();
        return problem;
    }

    private static final class ExtractSuperclassTransformer
    extends RefactoringVisitor {
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;
        private List<Tree> members;
        private boolean makeAbstract;
        private List<Tree> members2Remove;

        private ExtractSuperclassTransformer(ExtractSuperclassRefactoring refactoring, ElementHandle<TypeElement> sourceType) {
            this.sourceType = sourceType;
            this.refactoring = refactoring;
        }

        @Override
        public Tree visitClass(ClassTree classTree, Element p) {
            TypeElement clazz = (TypeElement)this.sourceType.resolve((CompilationInfo)this.workingCopy);
            assert (clazz != null);
            Element current = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (current == clazz) {
                Tree superClassTree;
                GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                this.makeAbstract = false;
                this.members = new LinkedList<Tree>();
                this.members2Remove = new LinkedList<Tree>();
                this.addConstructors(clazz);
                super.visitClass(classTree, p);
                ArrayList<Tree> implementsList = new ArrayList<Tree>();
                for (MemberInfo<ElementHandle<? extends Element>> member : this.refactoring.getMembers()) {
                    if (member.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                    TypeMirrorHandle handle = (TypeMirrorHandle)member.getElementHandle();
                    TypeMirror implMirror = handle.resolve((CompilationInfo)this.workingCopy);
                    implementsList.add(this.make.Type(implMirror));
                    this.makeAbstract |= true;
                }
                DeclaredType supType = (DeclaredType)clazz.getSuperclass();
                TypeElement supEl = (TypeElement)supType.asElement();
                Tree superClass = supEl.getSuperclass().getKind() == TypeKind.NONE ? null : this.make.Type((TypeMirror)supType);
                this.makeAbstract |= supEl.getModifiers().contains((Object)Modifier.ABSTRACT);
                ModifiersTree classModifiersTree = this.make.Modifiers(this.makeAbstract ? EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT) : EnumSet.of(Modifier.PUBLIC));
                List<TypeMirror> typeParams = this.findUsedGenericTypes(clazz);
                ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParams.size());
                for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                    TypeMirror origParam = typeParameterElement.asType();
                    for (TypeMirror newParam : typeParams) {
                        Tree t;
                        if (!this.workingCopy.getTypes().isSameType(origParam, newParam) || (t = this.workingCopy.getTrees().getTree(typeParameterElement)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                        TypeParameterTree typeParamTree = (TypeParameterTree)t;
                        if (!typeParamTree.getBounds().isEmpty()) {
                            typeParamTree = (TypeParameterTree)genUtils.importFQNs(t);
                        }
                        newTypeParams.add(typeParamTree);
                    }
                }
                ClassTree newClassTree = this.make.Class(classModifiersTree, (CharSequence)this.refactoring.getSuperClassName(), newTypeParams, superClass, implementsList, Collections.emptyList());
                newClassTree = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMembers(newClassTree, this.members);
                FileObject fileObject = this.refactoring.getSourceType().getFileObject();
                FileObject sourceRoot = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
                String relativePath = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)fileObject.getParent()) + "/" + this.refactoring.getSuperClassName() + ".java";
                CompilationUnitTree cu = JavaPluginUtils.createCompilationUnit(sourceRoot, relativePath, newClassTree, this.workingCopy, this.make);
                this.rewrite(null, cu);
                if (typeParams.isEmpty()) {
                    superClassTree = this.make.Identifier((CharSequence)this.refactoring.getSuperClassName());
                } else {
                    ArrayList<ExpressionTree> typeParamTrees = new ArrayList<ExpressionTree>(typeParams.size());
                    for (TypeMirror typeMirror : typeParams) {
                        Tree tree = this.make.Type(typeMirror);
                        typeParamTrees.add((ExpressionTree)tree);
                    }
                    superClassTree = this.make.ParameterizedType((Tree)this.make.Identifier((CharSequence)this.refactoring.getSuperClassName()), typeParamTrees);
                }
                HashSet<Tree> interfaces2Remove = new HashSet<Tree>();
                interfaces2Remove.addAll(this.getImplements2Remove((CompilationInfo)this.workingCopy, this.refactoring.getMembers(), clazz));
                ArrayList<Tree> newMembers = new ArrayList<Tree>();
                for (Tree tree : classTree.getMembers()) {
                    if (this.members2Remove.contains(tree)) continue;
                    newMembers.add(tree);
                }
                List<Tree> list = ExtractSuperclassTransformer.resolveImplements(classTree.getImplementsClause(), interfaces2Remove);
                ClassTree classTree2 = this.make.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), superClassTree, list, newMembers);
                this.rewrite(classTree, classTree2);
                return classTree;
            }
            return (Tree)super.visitClass(classTree, p);
        }

        @Override
        public Tree visitVariable(VariableTree variableTree, Element p) {
            Element current = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (current != null) {
                for (MemberInfo<ElementHandle<? extends Element>> memberInfo : this.refactoring.getMembers()) {
                    if (memberInfo.getGroup() != MemberInfo.Group.FIELD || memberInfo.getElementHandle().resolve((CompilationInfo)this.workingCopy) != current) continue;
                    GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                    this.members2Remove.add(variableTree);
                    VariableTree copy = (VariableTree)genUtils.importComments((Tree)variableTree, this.workingCopy.getCompilationUnit());
                    copy = (VariableTree)genUtils.importFQNs((Tree)copy);
                    ModifiersTree modifiers = copy.getModifiers();
                    if (modifiers.getFlags().contains((Object)Modifier.PRIVATE)) {
                        modifiers = this.make.removeModifiersModifier(modifiers, Modifier.PRIVATE);
                        modifiers = this.make.addModifiersModifier(modifiers, Modifier.PROTECTED);
                        copy = this.make.Variable(modifiers, (CharSequence)copy.getName(), copy.getType(), copy.getInitializer());
                        genUtils.copyComments((Tree)variableTree, (Tree)copy, false);
                        genUtils.copyComments((Tree)variableTree, (Tree)copy, true);
                    }
                    this.members.add(copy);
                    break;
                }
            }
            return variableTree;
        }

        @Override
        public Tree visitMethod(MethodTree methodTree, Element p) {
            Trees trees = this.workingCopy.getTrees();
            Element current = trees.getElement(this.getCurrentPath());
            if (current != null) {
                for (MemberInfo<ElementHandle<? extends Element>> memberInfo : this.refactoring.getMembers()) {
                    if (memberInfo.getGroup() != MemberInfo.Group.METHOD || memberInfo.getElementHandle().resolve((CompilationInfo)this.workingCopy) != current) continue;
                    if (!memberInfo.isMakeAbstract()) {
                        this.members2Remove.add(methodTree);
                    }
                    GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                    MethodTree newMethod = (MethodTree)genUtils.importComments((Tree)methodTree, this.workingCopy.getCompilationUnit());
                    ModifiersTree modifiers = methodTree.getModifiers();
                    if (modifiers.getFlags().contains((Object)Modifier.PRIVATE)) {
                        modifiers = this.make.removeModifiersModifier(modifiers, Modifier.PRIVATE);
                        modifiers = this.make.addModifiersModifier(modifiers, Modifier.PROTECTED);
                    }
                    newMethod = (MethodTree)genUtils.importFQNs((Tree)newMethod);
                    modifiers = (ModifiersTree)genUtils.importFQNs((Tree)modifiers);
                    List<? extends TypeMirror> thrownTypes = ((ExecutableElement)current).getThrownTypes();
                    ArrayList<ExpressionTree> newThrownTypes = new ArrayList<ExpressionTree>(thrownTypes.size());
                    for (TypeMirror typeMirror : thrownTypes) {
                        newThrownTypes.add((ExpressionTree)this.make.Type(typeMirror));
                    }
                    newMethod = memberInfo.isMakeAbstract() && !current.getModifiers().contains((Object)Modifier.ABSTRACT) ? this.make.Method(RefactoringUtils.makeAbstract(this.make, modifiers), (CharSequence)newMethod.getName(), newMethod.getReturnType(), newMethod.getTypeParameters(), newMethod.getParameters(), newThrownTypes, (BlockTree)null, null) : this.make.Method(modifiers, (CharSequence)newMethod.getName(), newMethod.getReturnType(), newMethod.getTypeParameters(), newMethod.getParameters(), newThrownTypes, newMethod.getBody(), (ExpressionTree)newMethod.getDefaultValue());
                    genUtils.copyComments((Tree)methodTree, (Tree)newMethod, false);
                    genUtils.copyComments((Tree)methodTree, (Tree)newMethod, true);
                    this.makeAbstract |= newMethod.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT);
                    this.members.add(newMethod);
                    break;
                }
            }
            return methodTree;
        }

        private List<Tree> getImplements2Remove(CompilationInfo javac, MemberInfo[] members, TypeElement clazz) {
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> memberTypes = new ArrayList<TypeMirror>(members.length);
            for (MemberInfo member : members) {
                if (member.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                TypeMirrorHandle typeMirrorHandle = (TypeMirrorHandle)member.getElementHandle();
                TypeMirror tm = typeMirrorHandle.resolve(javac);
                memberTypes.add(tm);
            }
            ClassTree classTree = javac.getTrees().getTree(clazz);
            ArrayList<Tree> result = new ArrayList<Tree>();
            Types types = javac.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror existingTM = javac.getTrees().getTypeMirror(path);
                for (TypeMirror tm : memberTypes) {
                    if (!types.isSameType(tm, existingTM)) continue;
                    result.add(tree);
                    continue block1;
                }
            }
            return result;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> allImpls, Set<Tree> impls2Remove) {
            ArrayList<Tree> ret;
            if (allImpls == null) {
                ret = new ArrayList<Tree>(1);
            } else {
                ret = new ArrayList(allImpls.size() + 1);
                ret.addAll(allImpls);
            }
            if (impls2Remove != null && !impls2Remove.isEmpty()) {
                ret.removeAll(impls2Remove);
            }
            return ret;
        }

        private List<TypeMirror> findUsedGenericTypes(TypeElement javaClass) {
            List<TypeMirror> typeArgs = JavaRefactoringUtils.elementsToTypes(javaClass.getTypeParameters());
            if (typeArgs.isEmpty()) {
                return typeArgs;
            }
            Types typeUtils = this.workingCopy.getTypes();
            Set<TypeMirror> used = Collections.newSetFromMap(new IdentityHashMap());
            TypeMirror superClass = javaClass.getSuperclass();
            RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, superClass);
            MemberInfo<ElementHandle<? extends Element>>[] members = this.refactoring.getMembers();
            for (int i = 0; i < members.length && !typeArgs.isEmpty(); ++i) {
                Element elm;
                ElementHandle<? extends Element> handle;
                if (members[i].getGroup() == MemberInfo.Group.METHOD) {
                    handle = members[i].getElementHandle();
                    elm = (ExecutableElement)handle.resolve((CompilationInfo)this.workingCopy);
                    RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, elm.getReturnType());
                    Iterator<? extends VariableElement> paramIter = elm.getParameters().iterator();
                    while (paramIter.hasNext() && !typeArgs.isEmpty()) {
                        VariableElement param = paramIter.next();
                        RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, param.asType());
                    }
                    continue;
                }
                if (members[i].getGroup() == MemberInfo.Group.FIELD) {
                    if (members[i].getModifiers().contains((Object)Modifier.STATIC)) continue;
                    handle = members[i].getElementHandle();
                    elm = (VariableElement)handle.resolve((CompilationInfo)this.workingCopy);
                    TypeMirror asType = elm.asType();
                    RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, asType);
                    continue;
                }
                if (members[i].getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                handle = members[i].getElementHandle();
                TypeMirror implemetz = handle.resolve((CompilationInfo)this.workingCopy);
                RefactoringUtils.findUsedGenericTypes(typeUtils, typeArgs, used, implemetz);
            }
            return RefactoringUtils.filterTypes(typeArgs, used);
        }

        private void addConstructors(TypeElement origClass) {
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            HashSet<Element> added = new HashSet<Element>();
            for (ExecutableElement constr : ElementFilter.constructorsIn(origClass.getEnclosedElements())) {
                StatementTree stmt;
                Iterator<? extends StatementTree> iterator;
                TreePath path;
                MethodTree mc;
                if (this.workingCopy.getElementUtilities().isSynthetic((Element)constr) || (mc = (MethodTree)((path = this.workingCopy.getTrees().getPath(constr)) != null ? path.getLeaf() : null)) == null || !(iterator = mc.getBody().getStatements().iterator()).hasNext() || (stmt = iterator.next()).getKind() != Tree.Kind.EXPRESSION_STATEMENT) continue;
                ExpressionStatementTree estmt = (ExpressionStatementTree)stmt;
                boolean isSyntheticSuper = this.workingCopy.getTreeUtilities().isSynthetic(this.workingCopy.getTrees().getPath(path.getCompilationUnit(), estmt));
                ExpressionTree expr = estmt.getExpression();
                TreePath expath = this.workingCopy.getTrees().getPath(path.getCompilationUnit(), expr);
                Element el = this.workingCopy.getTrees().getElement(expath);
                if (el == null || el.getKind() != ElementKind.CONSTRUCTOR || !added.add(el)) continue;
                ExecutableElement superclassConstr = (ExecutableElement)el;
                MethodInvocationTree invk = (MethodInvocationTree)expr;
                BlockTree block = isSyntheticSuper ? this.make.Block(Collections.emptyList(), false) : this.make.Block(Collections.singletonList(this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), invk.getMethodSelect(), ExtractSuperclassTransformer.params2Arguments(this.make, superclassConstr.getParameters())))), false);
                MethodTree newConstr = this.make.Method(superclassConstr, block);
                newConstr = ExtractSuperclassTransformer.removeRuntimeExceptions(this.workingCopy, superclassConstr, this.make, newConstr);
                newConstr = (MethodTree)genUtils.importFQNs((Tree)newConstr);
                this.members.add(newConstr);
            }
        }

        private static MethodTree removeRuntimeExceptions(WorkingCopy javac, ExecutableElement superclassConstr, TreeMaker make, MethodTree newConstr) {
            int i = 0;
            TypeMirror rte = javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
            ArrayList<Integer> rtes = new ArrayList<Integer>();
            for (TypeMirror typeMirror : superclassConstr.getThrownTypes()) {
                if (javac.getTypes().isSubtype(typeMirror, rte)) {
                    rtes.add(i);
                }
                ++i;
            }
            for (int j = rtes.size() - 1; j >= 0; --j) {
                newConstr = make.removeMethodThrows(newConstr, ((Integer)rtes.get(j)).intValue());
            }
            return newConstr;
        }

        private static List<? extends ExpressionTree> params2Arguments(TreeMaker make, List<? extends VariableElement> params) {
            if (params.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IdentifierTree> args = new ArrayList<IdentifierTree>(params.size());
            for (VariableElement variableElement : params) {
                args.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            return args;
        }
    }
}

