/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.completion;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.completion.BaseTask;

public final class JavaDocumentationTask<T>
extends BaseTask {
    private final ElementHandle<Element> element;
    private final DocumentationFactory factory;
    private T documentation;

    public static <I> JavaDocumentationTask<I> create(int caretOffset, @NullAllowed ElementHandle<Element> element, @NonNull DocumentationFactory<I> factory, @NullAllowed Callable<Boolean> cancel) {
        return new JavaDocumentationTask(caretOffset, element, factory, cancel);
    }

    private JavaDocumentationTask(int caretOffset, ElementHandle<Element> element, DocumentationFactory factory, Callable<Boolean> cancel) {
        super(caretOffset, cancel);
        this.element = element;
        this.factory = factory;
    }

    public T getDocumentation() {
        return this.documentation;
    }

    @Override
    protected void resolve(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.RESOLVED);
        Element el = null;
        if (this.element != null) {
            el = this.element.resolve((CompilationInfo)controller);
        } else {
            BaseTask.Env e = this.getCompletionEnvironment(controller, false);
            if (e != null) {
                el = controller.getTrees().getElement(e.getPath());
            }
        }
        if (el != null) {
            switch (el.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (el.asType().getKind() == TypeKind.ERROR) break;
                }
                case CONSTRUCTOR: 
                case ENUM_CONSTANT: 
                case FIELD: 
                case METHOD: {
                    this.documentation = this.factory.create((CompilationInfo)controller, el, this.cancel);
                }
            }
        }
    }

    public static interface DocumentationFactory<T> {
        public T create(CompilationInfo var1, Element var2, Callable<Boolean> var3);
    }
}

