/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class MkdirCommand
extends SvnCommand {
    private final String message;
    private final SVNUrl url;
    private final VCSFileProxy file;
    private final MkdirType type;

    public MkdirCommand(FileSystem fileSystem, SVNUrl url, String message) {
        super(fileSystem);
        this.message = message;
        this.url = url;
        this.file = null;
        this.type = MkdirType.url;
    }

    public MkdirCommand(FileSystem fileSystem, VCSFileProxy file) {
        super(fileSystem);
        this.file = file;
        this.message = null;
        this.url = null;
        this.type = MkdirType.file;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.MKDIR;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("mkdir");
        switch (this.type) {
            case url: {
                arguments.addMessage(this.message);
                arguments.add(this.url);
                break;
            }
            case file: {
                arguments.add(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal mkdirtype: " + (Object)((Object)this.type));
            }
        }
    }

    private static enum MkdirType {
        url,
        file;

    }
}

