/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.openide.util.CharSequences;

public final class APTIncludePathStorage {
    private final ConcurrentMap<CharSequence, List<IncludeDirEntry>> allIncludes = new ConcurrentHashMap<CharSequence, List<IncludeDirEntry>>();

    public List<IncludeDirEntry> get(CharSequence configID, List<IncludePath> includes) {
        CharSequence key = CharSequences.create((CharSequence)configID);
        List<IncludeDirEntry> list = (ArrayList<IncludeDirEntry>)this.allIncludes.get(key);
        if (list == null) {
            list = new ArrayList<IncludeDirEntry>(includes.size());
            for (IncludePath cs : includes) {
                IncludeDirEntry inclEntry = IncludeDirEntry.get(cs.getFSPath(), cs.isFramework(), cs.ignoreSysRoot());
                list.add(inclEntry);
            }
            List old = this.allIncludes.putIfAbsent(key, list);
            if (old != null) {
                list = old;
            }
        } else {
            for (IncludeDirEntry e : list) {
                e.resetNonExistanceFlag();
            }
        }
        return list;
    }

    public void dispose() {
        this.allIncludes.clear();
    }
}

