/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenProjectRestSupport
extends RestSupport {
    private static final String DEPLOYMENT_GOAL = "package";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    public static final String ACTION_PROPERTY_DEPLOY_OPEN = "netbeans.deploy.open.in.browser";
    private static final String TEST_SERVICES_HTML = "test-services.html";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public MavenProjectRestSupport(Project project) {
        super(project);
    }

    public String getBaseURL() {
        String applicationPath = this.getApplicationPath();
        if (applicationPath != null && !applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        return MiscUtilities.getContextRootURL((Project)this.getProject()) + "||" + applicationPath;
    }

    public boolean isRestSupportOn() {
        return this.getProjectProperty("rest.config.type") != null;
    }

    public FileObject generateTestClient(File testdir, String url) throws IOException {
        return this.generateMavenTester(testdir, url);
    }

    public void deploy() {
        RunConfig config = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (Project)this.getProject(), (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"MSG_Deploy", (Object)((ProjectInformation)this.getProject().getLookup().lookup(ProjectInformation.class)).getDisplayName()), Collections.singletonList(DEPLOYMENT_GOAL));
        config.setProperty(ACTION_PROPERTY_DEPLOY_OPEN, Boolean.FALSE.toString());
        ExecutorTask task = RunUtils.executeMaven((RunConfig)config);
        task.waitFinished();
    }

    public File getLocalTargetTestRest() {
        try {
            FileObject mainFolder = this.getProject().getProjectDirectory().getFileObject("src/main");
            if (mainFolder != null) {
                FileObject resourcesFolder = mainFolder.getFileObject("resources");
                if (resourcesFolder == null) {
                    resourcesFolder = mainFolder.createFolder("resources");
                }
                if (resourcesFolder != null) {
                    FileObject restFolder = resourcesFolder.getFileObject("rest");
                    if (restFolder == null) {
                        restFolder = resourcesFolder.createFolder("rest");
                    }
                    return FileUtil.toFile((FileObject)restFolder);
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(MavenProjectRestSupport.class.getName()).log(Level.WARNING, null, e);
        }
        return null;
    }

    private FileObject generateMavenTester(File testdir, String baseURL) throws IOException {
        String[] replaceKeys1 = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] replaceKeys2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed"};
        FileObject testFO = this.copyFileAndReplaceBaseUrl(testdir, TEST_SERVICES_HTML, replaceKeys1, baseURL);
        MiscUtilities.copyFile((File)testdir, (String)"test-resbeans.js", (String[])replaceKeys2, (boolean)false);
        MiscUtilities.copyFile((File)testdir, (String)"test-resbeans.css");
        MiscUtilities.copyFile((File)testdir, (String)"css_master-all.css");
        MiscUtilities.copyFile((File)testdir, (String)"expand.gif");
        MiscUtilities.copyFile((File)testdir, (String)"collapse.gif");
        MiscUtilities.copyFile((File)testdir, (String)"item.gif");
        MiscUtilities.copyFile((File)testdir, (String)"cc.gif");
        MiscUtilities.copyFile((File)testdir, (String)"og.gif");
        MiscUtilities.copyFile((File)testdir, (String)"cg.gif");
        MiscUtilities.copyFile((File)testdir, (String)"app.gif");
        File testdir2 = new File(testdir, "images");
        testdir2.mkdir();
        MiscUtilities.copyFile((File)testdir, (String)"images/background_border_bottom.gif");
        MiscUtilities.copyFile((File)testdir, (String)"images/pbsel.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/bg_gradient.gif");
        MiscUtilities.copyFile((File)testdir, (String)"images/pname.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/level1_selected-1lvl.jpg");
        MiscUtilities.copyFile((File)testdir, (String)"images/primary-enabled.gif");
        MiscUtilities.copyFile((File)testdir, (String)"images/masthead.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/primary-roll.gif");
        MiscUtilities.copyFile((File)testdir, (String)"images/pbdis.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/secondary-enabled.gif");
        MiscUtilities.copyFile((File)testdir, (String)"images/pbena.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/tbsel.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/pbmou.png");
        MiscUtilities.copyFile((File)testdir, (String)"images/tbuns.png");
        return testFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyFileAndReplaceBaseUrl(File testdir, String name, String[] replaceKeys, String baseURL) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)testdir);
        FileObject fo = dir.getFileObject(name);
        if (fo == null) {
            fo = dir.createData(name);
        }
        FileLock lock = null;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            int i;
            lock = fo.lock();
            OutputStream os = fo.getOutputStream(lock);
            writer = new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8")));
            InputStream is = RestSupport.class.getResourceAsStream("resources/" + name);
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            String[] replaceValues = null;
            if (replaceKeys != null) {
                replaceValues = new String[replaceKeys.length];
                for (i = 0; i < replaceKeys.length; ++i) {
                    replaceValues[i] = NbBundle.getMessage(RestSupport.class, (String)replaceKeys[i]);
                }
            }
            while ((line = reader.readLine()) != null) {
                for (i = 0; i < replaceKeys.length; ++i) {
                    line = line.replaceAll(replaceKeys[i], replaceValues[i]);
                }
                line = line.replace("${BASE_URL}", baseURL);
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return fo;
    }

    public void logResourceCreation() {
        Object[] params = new Object[]{"JAX-RS", this.getProject().getClass().getName(), "RESOURCE"};
        LogUtils.logWsDetect((Object[])params);
    }

    public String getProjectProperty(String name) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.getProject(), MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            return prefs.get(name, null);
        }
        return null;
    }

    public void setPrivateProjectProperty(String name, String value) {
        this.setProjectProperty(name, value);
    }

    public void setProjectProperty(String name, String value) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.getProject(), MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            prefs.put(name, value);
        }
    }

    public void removeProjectProperties(String[] propertyNames) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.getProject(), MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            for (String p : propertyNames) {
                prefs.remove(p);
            }
        }
    }

    public int getProjectType() {
        String packagingType;
        NbMavenProject nbMavenProject = (NbMavenProject)this.getProject().getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null && (packagingType = nbMavenProject.getPackagingType()) != null) {
            if ("jar".equals(packagingType)) {
                return 0;
            }
            if ("war".equals(packagingType)) {
                return 1;
            }
            if ("nbm".equals(packagingType) || "nbm-application".equals(packagingType)) {
                return 2;
            }
        }
        return 0;
    }

    public String getApplicationPathFromDialog(List<RestApplication> restApplications) {
        if (restApplications.size() == 1) {
            return restApplications.get(0).getApplicationPath();
        }
        return null;
    }

    protected void extendBuildScripts() throws IOException {
    }

    protected void handleSpring() throws IOException {
    }

    protected void extendJerseyClasspath() {
        if (!MiscUtilities.isJavaEE6AndHigher((Project)this.getProject())) {
            super.extendJerseyClasspath();
        }
    }
}

