/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.api;

import java.io.File;
import java.net.URL;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.RequestProcessor;

public class NBBugzillaUtils {
    public static void openIssue(String issueID) {
        Repository nbRepo = NBRepositorySupport.getInstance().getNBRepository(false);
        assert (nbRepo != null);
        if (nbRepo == null) {
            Bugzilla.LOG.warning("No bugzilla repository available for netbeans.org");
            return;
        }
        if (issueID != null) {
            Util.openIssue((Repository)nbRepo, (String)issueID);
        } else {
            Util.createNewIssue((Repository)nbRepo);
        }
    }

    public static void reportAnIssue() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Repository nbRepo = NBRepositorySupport.getInstance().getNBRepository(true);
                if (nbRepo != null) {
                    Util.createNewIssue((Repository)nbRepo);
                }
            }
        });
    }

    public static String getNBUsername() {
        return org.netbeans.modules.bugtracking.commons.NBBugzillaUtils.getNBUsername();
    }

    public static char[] getNBPassword() {
        return org.netbeans.modules.bugtracking.commons.NBBugzillaUtils.getNBPassword();
    }

    public static void saveNBUsername(String username) {
        org.netbeans.modules.bugtracking.commons.NBBugzillaUtils.saveNBUsername((String)username);
    }

    public static void saveNBPassword(char[] password) {
        org.netbeans.modules.bugtracking.commons.NBBugzillaUtils.saveNBPassword((char[])password);
    }

    public static boolean isNbRepository(URL url) {
        assert (url != null);
        return org.netbeans.modules.bugtracking.commons.NBBugzillaUtils.isNbRepository((String)url.toString());
    }

    public static Repository findNBRepository() {
        return NBRepositorySupport.getInstance().getNBRepository(false);
    }

    public static void attachFiles(String id, String comment, String[] desc, String[] contentType, File[] files) {
        assert (id != null);
        assert (desc != null);
        assert (files != null);
        assert (contentType != null);
        assert (desc.length == files.length);
        assert (contentType.length == files.length);
        BugzillaRepository nbRepo = NBRepositorySupport.getInstance().getNBBugzillaRepository(false);
        BugzillaIssue issue = nbRepo.getIssue(id);
        if (issue == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            issue.addAttachment(files[i], comment, desc[i], contentType[i], false);
        }
        BugzillaUtil.openIssue(issue);
    }
}

