/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class JsxAttributeNode
extends Expression {
    private final String name;
    private final Expression value;

    public JsxAttributeNode(String name, Expression value, long token, int finish) {
        super(token, finish);
        this.name = name;
        this.value = value;
    }

    public JsxAttributeNode(JsxAttributeNode node, String name, Expression value) {
        super(node);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    public JsxAttributeNode setValue(Expression value) {
        if (this.value == value) {
            return this;
        }
        return new JsxAttributeNode(this, this.name, value);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterJsxAttributeNode(this)) {
            Expression newValue = this.value == null ? null : (Expression)this.value.accept(visitor);
            return visitor.leaveJsxAttributeNode(this.setValue(newValue));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterJsxAttributeNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append(this.name);
        if (this.value != null) {
            sb.append('=');
            this.value.toString(sb, printType);
        }
    }
}

