/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.llvm.adt.RefCountedBase;
import org.llvm.adt.RefCountedBaseVPTR;
import org.llvm.adt.ThreadSafeRefCountedBase;

public class IntrusiveRefCntPtrInfo {
    public static <T> void retain(T obj) {
        if (obj instanceof RefCountedBase) {
            ((RefCountedBase)obj).Retain();
        } else if (obj instanceof RefCountedBaseVPTR) {
            ((RefCountedBaseVPTR)obj).Retain();
        } else if (obj instanceof ThreadSafeRefCountedBase) {
            ((ThreadSafeRefCountedBase)obj).Retain();
        } else {
            String msg = obj == null ? "Cannot retain null pointer" : "Cannot retain object of class " + obj.getClass() + " (must implement one of RefCountedBase, RefCountedBaseVPTR, ThreadSafeRefCountedBase)";
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> void release(T obj) {
        if (obj instanceof RefCountedBase) {
            ((RefCountedBase)obj).Release();
        } else if (obj instanceof RefCountedBaseVPTR) {
            ((RefCountedBaseVPTR)obj).Release();
        } else if (obj instanceof ThreadSafeRefCountedBase) {
            ((ThreadSafeRefCountedBase)obj).Release();
        } else {
            throw new IllegalArgumentException("Cannot release object of class" + (obj != null ? obj.getClass() : "null"));
        }
    }
}

