/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.util.HashMap;
import java.util.Map;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.adt.StatisticsADTSupport;
import org.llvm.support.raw_ostream;

public class MallocAllocator
implements Destructors.ClassWithDestructor,
NativeMemory.Allocator {
    private static final boolean USE_SLABS_POOL = Boolean.valueOf(System.getProperty("clank.slabs.pool", "true"));
    private static final int POOL_SIZE = 16;
    private static final char.ptr.array.stack[] POOL;
    private static final int SLAB_SIZE_MASK;
    private static final int SLAB_SIZE_INDEX_SHIFT_BY;
    private static long CharPtrSizeSlabAllocations;
    private static long CharPtrSizeAllocations;
    private static long CharPtrSlabsSizeDeAllocations;
    private static long CharPtrDiffInAllocDeallocSize;
    private static long CharPtrMaxDiffInAllocDeallocSize;
    private static final Map<Integer, Integer> SlabSizes;

    public void $destroy() {
    }

    public void Reset() {
    }

    public char.ptr Allocate(int Size, int Alignment) {
        if (NativeTrace.isDebugMode()) {
            throw new UnsupportedOperationException("Used for Slabs only");
        }
        MallocAllocator.trackAllocateNonSlab(Size);
        return NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)Size, (byte[])new byte[0]));
    }

    public char.ptr Allocate(int Size) {
        return this.Allocate(Size, 0);
    }

    public char.ptr AllocateSlab(int Size) {
        MallocAllocator.trackAllocateSlab(Size);
        return MallocAllocator.$getSlabWithSize(Size);
    }

    public <T> void.ptr Allocate(Class<T> cls, int Num) {
        if (NativeTrace.isDebugMode()) {
            throw new UnsupportedOperationException("Used for Slabs only");
        }
        return null;
    }

    public void Deallocate(Object Ptr) {
        throw new UnsupportedOperationException("Used for Slabs only");
    }

    public void Deallocate$NotSameRemoveCV(Object Ptr) {
        throw new UnsupportedOperationException("Used for Slabs only");
    }

    public void DeallocateSlab(char.ptr SlabStartPtr, int Size) {
        if (NativeTrace.STATISTICS) {
            MallocAllocator.trackDeallocateSlab(Size);
        }
        MallocAllocator.$releaseSlabWithSize(SlabStartPtr, Size);
    }

    public void PrintStats() {
    }

    public long getTotalMemory() {
        return CharPtrSizeAllocations + CharPtrSizeSlabAllocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char.ptr $getSlabWithSize(int Size) {
        char.ptr.array.stack stack2;
        char.ptr out = null;
        if (USE_SLABS_POOL && (stack2 = MallocAllocator.getPointersForSize(Size)) != null) {
            char.ptr.array.stack stack3 = stack2;
            synchronized (stack3) {
                out = stack2.pop_or_null();
            }
        }
        if (out == null) {
            out = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)Size, (byte[])new byte[0]));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void $releaseSlabWithSize(char.ptr SlabStartPtr, int Size) {
        char.ptr.array.stack stack2;
        char.ptr.array Ptr;
        if (NativeTrace.isDebugMode()) {
            Ptr = (char.ptr.array)SlabStartPtr;
            assert (Ptr.$array() != null) : "must has underlying array";
            assert (Ptr.$array().length == Size) : "must be the same size";
            assert (Ptr.$index() == 0) : "must point to the start of array";
        }
        Ptr = Native.$toConst((char.ptr)SlabStartPtr);
        if (USE_SLABS_POOL && (stack2 = MallocAllocator.getPointersForSize(Size)) != null) {
            char.ptr.array.stack stack3 = stack2;
            synchronized (stack3) {
                stack2.push(Ptr);
            }
        }
    }

    private static char.ptr.array.stack getPointersForSize(int Size) {
        assert (Size < Integer.MAX_VALUE);
        assert (Size >= 0) : Size;
        char.ptr.array.stack pointers = null;
        if ((Size & SLAB_SIZE_MASK) == 0) {
            int index = Size >>> SLAB_SIZE_INDEX_SHIFT_BY;
            assert (index >= 0) : index;
            if (index < 16) {
                pointers = POOL[index];
                assert (pointers != null);
            }
        }
        return pointers;
    }

    private static void trackAllocateNonSlab(int Size) {
        if (NativeTrace.STATISTICS) {
            CharPtrSizeAllocations += (long)Size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trackAllocateSlab(int Size) {
        if (NativeTrace.STATISTICS) {
            Integer key = Size;
            Map<Integer, Integer> map2 = SlabSizes;
            synchronized (map2) {
                Integer value = SlabSizes.get(key);
                if (value == null) {
                    value = 0;
                }
                value = value + 1;
                SlabSizes.put(key, value);
            }
            CharPtrSizeSlabAllocations += (long)Size;
            CharPtrMaxDiffInAllocDeallocSize = std.max((long)CharPtrMaxDiffInAllocDeallocSize, (long)(CharPtrDiffInAllocDeallocSize += (long)Size));
        }
    }

    private static void trackDeallocateSlab(int Size) {
        if (NativeTrace.STATISTICS) {
            CharPtrSlabsSizeDeAllocations += (long)Size;
            assert ((CharPtrDiffInAllocDeallocSize -= (long)Size) >= 0L);
        }
    }

    public static void clearStatistics() {
        CharPtrSizeSlabAllocations = 0L;
        CharPtrSlabsSizeDeAllocations = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long PrintStats(raw_ostream out) {
        out.$out("\t----MallocAllocator info----\n");
        out.$out(String.format("%18s   allocated:\t", "Not Slab")).$out(NativeTrace.formatNumber((long)CharPtrSizeAllocations)).$out(".\n");
        out.$out(String.format("%18s   allocated:\t", "    Slab")).$out(NativeTrace.formatNumber((long)CharPtrSizeSlabAllocations)).$out(".\n");
        out.$out(String.format("%18s deallocated:\t", "    Slab")).$out(NativeTrace.formatNumber((long)CharPtrSlabsSizeDeAllocations)).$out(".\n");
        out.$out(String.format("%18s memory leak:\t", "    Slab")).$out(NativeTrace.formatNumber((long)CharPtrDiffInAllocDeallocSize)).$out(".\n");
        out.$out(String.format("%18s max at once:\t", "    Slab")).$out(NativeTrace.formatNumber((long)CharPtrMaxDiffInAllocDeallocSize)).$out(".\n");
        Map<Integer, Integer> map2 = SlabSizes;
        synchronized (map2) {
            for (Map.Entry<Integer, Integer> entry : SlabSizes.entrySet()) {
                out.$out(String.format("%18s %11s:\t", "Slab Size", NativeTrace.formatNumber((long)entry.getKey().intValue()))).$out(NativeTrace.formatNumber((long)entry.getValue().intValue())).$out(NativePointer.$LF);
            }
        }
        for (int i = 0; i < 16; ++i) {
            char.ptr.array.stack stack2;
            char.ptr.array.stack stack3 = stack2 = POOL[i];
            synchronized (stack3) {
                if (stack2.size() > 0) {
                    out.$out(String.format("%18s %11s:\t", "Slabs Pool For", NativeTrace.formatNumber((long)(i * NativeMemory.Allocator.PageSize)))).$out(NativeTrace.formatNumber((long)stack2.size())).$out(NativePointer.$LF);
                }
                continue;
            }
        }
        long Value = CharPtrSizeAllocations + CharPtrSizeSlabAllocations;
        StatisticsADTSupport.dumpStatisticValue(out, "TotalMallocAllocatedBytes", Value);
        return Value;
    }

    static {
        if (USE_SLABS_POOL) {
            SLAB_SIZE_MASK = NativeMemory.Allocator.PageSize - 1;
            assert ((NativeMemory.Allocator.PageSize & SLAB_SIZE_MASK) == 0) : "must be power of two " + Integer.toBinaryString(NativeMemory.Allocator.PageSize);
            SLAB_SIZE_INDEX_SHIFT_BY = Integer.bitCount(SLAB_SIZE_MASK);
            POOL = new char.ptr.array.stack[16];
            for (int i = 0; i < 16; ++i) {
                MallocAllocator.POOL[i] = new char.ptr.array.stack(1024);
            }
        } else {
            POOL = null;
            SLAB_SIZE_MASK = 0;
            SLAB_SIZE_INDEX_SHIFT_BY = 0;
        }
        CharPtrSizeSlabAllocations = 0L;
        CharPtrSizeAllocations = 0L;
        CharPtrSlabsSizeDeAllocations = 0L;
        CharPtrDiffInAllocDeallocSize = 0L;
        CharPtrMaxDiffInAllocDeallocSize = 0L;
        SlabSizes = new HashMap<Integer, Integer>();
    }
}

