/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.libs.common;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.libs.common.StackElementArray;

public class DLightLibsCommonLogger {
    private static final Logger instance = Logger.getLogger("dlight.libs.common.logger");
    private static boolean assertionsEnabled = false;
    private static volatile Throwable lastAssertion;
    private static final Set<StackElementArray> toStringStacks;

    public static Throwable getLastAssertion() {
        return lastAssertion;
    }

    public static boolean isDebugMode() {
        return assertionsEnabled;
    }

    private DLightLibsCommonLogger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (assertionsEnabled && !value) {
            instance.log(Level.INFO, message);
        }
    }

    public static void assertTrue(boolean value) {
        if (assertionsEnabled && !value) {
            String message = "Assertion error";
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (assertionsEnabled && !value) {
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertFalse(boolean value) {
        if (assertionsEnabled && value) {
            String message = "Assertion error";
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertFalse(boolean value, String message) {
        if (assertionsEnabled && value) {
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once, int stackCompareSize) {
        if (assertionsEnabled && (!once || StackElementArray.addStackIfNew(cause.getStackTrace(), toStringStacks, stackCompareSize))) {
            lastAssertion = cause;
            instance.log(level, cause.getMessage(), lastAssertion);
        }
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once) {
        DLightLibsCommonLogger.printStackTraceOnce(cause, level, once, 6);
    }

    public static void assertNonUiThread(String message, Level level, boolean once) {
        if (assertionsEnabled && SwingUtilities.isEventDispatchThread() && (!once || StackElementArray.addStackIfNew(toStringStacks, 8))) {
            lastAssertion = new Exception(message);
            instance.log(level, message, lastAssertion);
        }
    }

    public static void assertNonUiThread() {
        DLightLibsCommonLogger.assertNonUiThread("Should not be called from UI thread", Level.SEVERE, false);
    }

    public static void assertNonUiThreadOnce(Level level) {
        DLightLibsCommonLogger.assertNonUiThread("Should not be called from UI thread", level, true);
    }

    public static void finest(Exception exception) {
        instance.log(Level.FINEST, "FYI:", exception);
    }

    static {
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        toStringStacks = assertionsEnabled ? StackElementArray.createSet() : null;
    }
}

