/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.IdentifierTable;
import org.clang.basic.LangOptions;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;

public final class Builtin {

    public static class Context {
        private ArrayRef<Info> TSRecords = new ArrayRef();
        private ArrayRef<Info> AuxTSRecords = new ArrayRef();

        public void InitializeTarget(TargetInfo Target, TargetInfo AuxTarget) {
            assert (this.TSRecords.empty()) : "Already initialized target?";
            this.TSRecords.$assignMove(Target.getTargetBuiltins());
            if (AuxTarget != null) {
                this.AuxTSRecords.$assignMove(AuxTarget.getTargetBuiltins());
            }
        }

        public void initializeBuiltins(IdentifierTable Table, LangOptions LangOpts) {
            int i;
            for (i = ID.NotBuiltin.getValue() + 1; i != ID.FirstTSBuiltin.getValue(); ++i) {
                if (!this.builtinIsSupported(TargetsStatics.BuiltinInfo[i], LangOpts)) continue;
                Table.get(new StringRef(TargetsStatics.BuiltinInfo[i].Name)).setBuiltinID(i);
            }
            int e = this.TSRecords.size();
            for (i = 0; i != e; ++i) {
                if (!this.builtinIsSupported((Info)this.TSRecords.$at(i), LangOpts)) continue;
                Table.get(new StringRef(((Info)this.TSRecords.$at((int)i)).Name)).setBuiltinID(i + ID.FirstTSBuiltin.getValue());
            }
            e = this.AuxTSRecords.size();
            for (i = 0; i != e; ++i) {
                Table.get(new StringRef(((Info)this.AuxTSRecords.$at((int)i)).Name)).setBuiltinID(i + ID.FirstTSBuiltin.getValue() + this.TSRecords.size());
            }
        }

        public char.ptr getName(int ID2) {
            return this.getRecord((int)ID2).Name;
        }

        public char.ptr getTypeString(int ID2) {
            return this.getRecord((int)ID2).Type;
        }

        public boolean isTSBuiltin(int ID2) {
            return Unsigned.$greatereq_uint((int)ID2, (int)ID.FirstTSBuiltin.getValue());
        }

        public boolean isPure(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)85).$noteq(null);
        }

        public boolean isConst(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)99).$noteq(null);
        }

        public boolean isNoThrow(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)110).$noteq(null);
        }

        public boolean isNoReturn(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)114).$noteq(null);
        }

        public boolean isReturnsTwice(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)106).$noteq(null);
        }

        public boolean isUnevaluated(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)117).$noteq(null);
        }

        public boolean isLibFunction(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)70).$noteq(null);
        }

        public boolean isPredefinedLibFunction(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)102).$noteq(null);
        }

        public boolean isPredefinedRuntimeFunction(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)105).$noteq(null);
        }

        public boolean hasCustomTypechecking(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)116).$noteq(null);
        }

        public boolean hasPtrArgsOrResult(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Type, (byte)42).$noteq(null);
        }

        public void forgetBuiltin(int ID2, IdentifierTable Table) {
            Table.get(new StringRef(this.getRecord((int)ID2).Name)).setBuiltinID(0);
        }

        public char.ptr getHeaderName(int ID2) {
            return this.getRecord((int)ID2).HeaderName;
        }

        public boolean isPrintfLike(int ID2, uint.ref FormatIdx, bool.ref HasVAListArg) {
            return this.isLike(ID2, FormatIdx, HasVAListArg, NativePointer.$((String)"pP"));
        }

        public boolean isScanfLike(int ID2, uint.ref FormatIdx, bool.ref HasVAListArg) {
            return this.isLike(ID2, FormatIdx, HasVAListArg, NativePointer.$((String)"sS"));
        }

        public boolean isConstWithoutErrno(int ID2) {
            return std.strchr((char.ptr)this.getRecord((int)ID2).Attributes, (byte)101).$noteq(null);
        }

        public char.ptr getRequiredFeatures(int ID2) {
            return this.getRecord((int)ID2).Features;
        }

        public boolean isAuxBuiltinID(int ID2) {
            return Unsigned.$greatereq_uint((int)ID2, (int)(ID.FirstTSBuiltin.getValue() + this.TSRecords.size()));
        }

        public int getAuxBuiltinID(int ID2) {
            return ID2 - this.TSRecords.size();
        }

        public static boolean isBuiltinFunc(char.ptr Name) {
            StringRef FuncName = new StringRef(Name);
            for (int i = ID.NotBuiltin.getValue() + 1; i != ID.FirstTSBuiltin.getValue(); ++i) {
                if (!FuncName.equals(TargetsStatics.BuiltinInfo[i].Name)) continue;
                return std.strchr((char.ptr)TargetsStatics.BuiltinInfo[i].Attributes, (byte)102).$noteq(null);
            }
            return false;
        }

        private Info getRecord(int ID2) {
            if (Unsigned.$less_uint((int)ID2, (int)ID.FirstTSBuiltin.getValue())) {
                return TargetsStatics.BuiltinInfo[ID2];
            }
            assert (Unsigned.$less_uint((int)(ID2 - ID.FirstTSBuiltin.getValue()), (int)(this.TSRecords.size() + this.AuxTSRecords.size()))) : "Invalid builtin ID!";
            if (this.isAuxBuiltinID(ID2)) {
                return (Info)this.AuxTSRecords.$at(this.getAuxBuiltinID(ID2) - ID.FirstTSBuiltin.getValue());
            }
            return (Info)this.TSRecords.$at(ID2 - ID.FirstTSBuiltin.getValue());
        }

        private boolean builtinIsSupported(Info BuiltinInfo, LangOptions LangOpts) {
            boolean BuiltinsUnsupported = (LangOpts.NoBuiltin || LangOpts.isNoBuiltinFunc(BuiltinInfo.Name)) && std.strchr((char.ptr)BuiltinInfo.Attributes, (byte)102) != null;
            boolean MathBuiltinsUnsupported = LangOpts.NoMathBuiltin && BuiltinInfo.HeaderName != null && new StringRef(BuiltinInfo.HeaderName).equals("math.h");
            boolean GnuModeUnsupported = !LangOpts.GNUMode && (BuiltinInfo.Langs & 1) != 0;
            boolean MSModeUnsupported = !LangOpts.MicrosoftExt && (BuiltinInfo.Langs & 0x10) != 0;
            boolean ObjCUnsupported = !LangOpts.ObjC1 && BuiltinInfo.Langs == 8;
            boolean OclCUnsupported = LangOpts.OpenCLVersion != 200 && BuiltinInfo.Langs == 32;
            return !BuiltinsUnsupported && !MathBuiltinsUnsupported && !OclCUnsupported && !GnuModeUnsupported && !MSModeUnsupported && !ObjCUnsupported;
        }

        private boolean isLike(int ID2, uint.ref FormatIdx, bool.ref HasVAListArg, char.ptr Fmt) {
            assert (Fmt != null) : "Not passed a format string";
            assert (std.strlen((char.ptr)Fmt) == 2) : "Format string needs to be two characters long";
            assert (std.toupper((int)Fmt.$at(0)) == Fmt.$at(1)) : "Format string is not in the form \"xX\"";
            char.ptr Like = Native.$tryClone((char.ptr)std.strpbrk((char.ptr)this.getRecord((int)ID2).Attributes, (char.ptr)Fmt));
            if (Like == null) {
                return false;
            }
            HasVAListArg.$set(Like.$star() == Fmt.$at(1));
            Like.$preInc();
            assert (Like.$star() == 58) : "Format specifier must be followed by a ':'";
            Like.$preInc();
            assert (std.strchr((char.ptr)Like, (byte)58) != null) : "Format specifier must end with a ':'";
            FormatIdx.$set(Unsigned.$long2uint((long)std.strtol((char.ptr)Like, (type.ptr)null, (int)10)));
            return true;
        }

        public String toString() {
            return "TSRecords=" + this.TSRecords + ", AuxTSRecords=" + this.AuxTSRecords;
        }
    }

    public static class Info {
        public final char.ptr Name;
        public final char.ptr Type;
        public final char.ptr Attributes;
        public final char.ptr HeaderName;
        public final int Langs;
        public final char.ptr Features;

        public Info(Object Name, Object Type2, Object Attributes, Object HeaderName, int Langs, Object Features) {
            assert (Name != null);
            this.Name = Info.param2constPtr(Name);
            this.Type = Info.param2constPtr(Type2);
            this.Attributes = Info.param2constPtr(Attributes);
            this.HeaderName = Info.param2constPtr(HeaderName);
            this.Langs = Langs;
            this.Features = Info.param2constPtr(Features);
        }

        private static char.ptr param2constPtr(Object param) {
            if (param == null) {
                return null;
            }
            if (param instanceof String) {
                return NativePointer.create_const_char$ptr((CharSequence)((String)param), (int)0);
            }
            assert (param instanceof char.ptr) : "must be char$ptr " + param.getClass();
            return Native.$toConst((char.ptr)((char.ptr)param));
        }

        public String toString() {
            return "Name=" + this.Name + ", Type=" + this.Type + ", Attributes=" + this.Attributes + ", HeaderName=" + this.HeaderName + ", Langs=" + this.Langs + ", Features=" + this.Features;
        }
    }

    public static final class ID
    extends Enum<ID>
    implements Native.ComparableLower {
        public static final /* enum */ ID NotBuiltin = new ID(0);
        public static final /* enum */ ID BI__builtin_atan2 = new ID(NotBuiltin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atan2f = new ID(BI__builtin_atan2.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atan2l = new ID(BI__builtin_atan2f.getValue() + 1);
        public static final /* enum */ ID BI__builtin_abs = new ID(BI__builtin_atan2l.getValue() + 1);
        public static final /* enum */ ID BI__builtin_copysign = new ID(BI__builtin_abs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_copysignf = new ID(BI__builtin_copysign.getValue() + 1);
        public static final /* enum */ ID BI__builtin_copysignl = new ID(BI__builtin_copysignf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fabs = new ID(BI__builtin_copysignl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fabsf = new ID(BI__builtin_fabs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fabsl = new ID(BI__builtin_fabsf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmod = new ID(BI__builtin_fabsl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmodf = new ID(BI__builtin_fmod.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmodl = new ID(BI__builtin_fmodf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_frexp = new ID(BI__builtin_fmodl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_frexpf = new ID(BI__builtin_frexp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_frexpl = new ID(BI__builtin_frexpf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_huge_val = new ID(BI__builtin_frexpl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_huge_valf = new ID(BI__builtin_huge_val.getValue() + 1);
        public static final /* enum */ ID BI__builtin_huge_vall = new ID(BI__builtin_huge_valf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_inf = new ID(BI__builtin_huge_vall.getValue() + 1);
        public static final /* enum */ ID BI__builtin_inff = new ID(BI__builtin_inf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_infl = new ID(BI__builtin_inff.getValue() + 1);
        public static final /* enum */ ID BI__builtin_labs = new ID(BI__builtin_infl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llabs = new ID(BI__builtin_labs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ldexp = new ID(BI__builtin_llabs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ldexpf = new ID(BI__builtin_ldexp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ldexpl = new ID(BI__builtin_ldexpf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_modf = new ID(BI__builtin_ldexpl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_modff = new ID(BI__builtin_modf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_modfl = new ID(BI__builtin_modff.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nan = new ID(BI__builtin_modfl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nanf = new ID(BI__builtin_nan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nanl = new ID(BI__builtin_nanf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nans = new ID(BI__builtin_nanl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nansf = new ID(BI__builtin_nans.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nansl = new ID(BI__builtin_nansf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_powi = new ID(BI__builtin_nansl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_powif = new ID(BI__builtin_powi.getValue() + 1);
        public static final /* enum */ ID BI__builtin_powil = new ID(BI__builtin_powif.getValue() + 1);
        public static final /* enum */ ID BI__builtin_pow = new ID(BI__builtin_powil.getValue() + 1);
        public static final /* enum */ ID BI__builtin_powf = new ID(BI__builtin_pow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_powl = new ID(BI__builtin_powf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acos = new ID(BI__builtin_powl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acosf = new ID(BI__builtin_acos.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acosl = new ID(BI__builtin_acosf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acosh = new ID(BI__builtin_acosl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acoshf = new ID(BI__builtin_acosh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_acoshl = new ID(BI__builtin_acoshf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asin = new ID(BI__builtin_acoshl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asinf = new ID(BI__builtin_asin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asinl = new ID(BI__builtin_asinf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asinh = new ID(BI__builtin_asinl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asinhf = new ID(BI__builtin_asinh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_asinhl = new ID(BI__builtin_asinhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atan = new ID(BI__builtin_asinhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atanf = new ID(BI__builtin_atan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atanl = new ID(BI__builtin_atanf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atanh = new ID(BI__builtin_atanl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atanhf = new ID(BI__builtin_atanh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_atanhl = new ID(BI__builtin_atanhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cbrt = new ID(BI__builtin_atanhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cbrtf = new ID(BI__builtin_cbrt.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cbrtl = new ID(BI__builtin_cbrtf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ceil = new ID(BI__builtin_cbrtl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ceilf = new ID(BI__builtin_ceil.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ceill = new ID(BI__builtin_ceilf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cos = new ID(BI__builtin_ceill.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cosf = new ID(BI__builtin_cos.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cosh = new ID(BI__builtin_cosf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_coshf = new ID(BI__builtin_cosh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_coshl = new ID(BI__builtin_coshf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cosl = new ID(BI__builtin_coshl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erf = new ID(BI__builtin_cosl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erff = new ID(BI__builtin_erf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erfl = new ID(BI__builtin_erff.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erfc = new ID(BI__builtin_erfl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erfcf = new ID(BI__builtin_erfc.getValue() + 1);
        public static final /* enum */ ID BI__builtin_erfcl = new ID(BI__builtin_erfcf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_exp = new ID(BI__builtin_erfcl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expf = new ID(BI__builtin_exp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expl = new ID(BI__builtin_expf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_exp2 = new ID(BI__builtin_expl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_exp2f = new ID(BI__builtin_exp2.getValue() + 1);
        public static final /* enum */ ID BI__builtin_exp2l = new ID(BI__builtin_exp2f.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expm1 = new ID(BI__builtin_exp2l.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expm1f = new ID(BI__builtin_expm1.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expm1l = new ID(BI__builtin_expm1f.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fdim = new ID(BI__builtin_expm1l.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fdimf = new ID(BI__builtin_fdim.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fdiml = new ID(BI__builtin_fdimf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_floor = new ID(BI__builtin_fdiml.getValue() + 1);
        public static final /* enum */ ID BI__builtin_floorf = new ID(BI__builtin_floor.getValue() + 1);
        public static final /* enum */ ID BI__builtin_floorl = new ID(BI__builtin_floorf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fma = new ID(BI__builtin_floorl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmaf = new ID(BI__builtin_fma.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmal = new ID(BI__builtin_fmaf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmax = new ID(BI__builtin_fmal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmaxf = new ID(BI__builtin_fmax.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmaxl = new ID(BI__builtin_fmaxf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fmin = new ID(BI__builtin_fmaxl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fminf = new ID(BI__builtin_fmin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fminl = new ID(BI__builtin_fminf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_hypot = new ID(BI__builtin_fminl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_hypotf = new ID(BI__builtin_hypot.getValue() + 1);
        public static final /* enum */ ID BI__builtin_hypotl = new ID(BI__builtin_hypotf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ilogb = new ID(BI__builtin_hypotl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ilogbf = new ID(BI__builtin_ilogb.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ilogbl = new ID(BI__builtin_ilogbf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lgamma = new ID(BI__builtin_ilogbl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lgammaf = new ID(BI__builtin_lgamma.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lgammal = new ID(BI__builtin_lgammaf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llrint = new ID(BI__builtin_lgammal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llrintf = new ID(BI__builtin_llrint.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llrintl = new ID(BI__builtin_llrintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llround = new ID(BI__builtin_llrintl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llroundf = new ID(BI__builtin_llround.getValue() + 1);
        public static final /* enum */ ID BI__builtin_llroundl = new ID(BI__builtin_llroundf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log = new ID(BI__builtin_llroundl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log10 = new ID(BI__builtin_log.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log10f = new ID(BI__builtin_log10.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log10l = new ID(BI__builtin_log10f.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log1p = new ID(BI__builtin_log10l.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log1pf = new ID(BI__builtin_log1p.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log1pl = new ID(BI__builtin_log1pf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log2 = new ID(BI__builtin_log1pl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log2f = new ID(BI__builtin_log2.getValue() + 1);
        public static final /* enum */ ID BI__builtin_log2l = new ID(BI__builtin_log2f.getValue() + 1);
        public static final /* enum */ ID BI__builtin_logb = new ID(BI__builtin_log2l.getValue() + 1);
        public static final /* enum */ ID BI__builtin_logbf = new ID(BI__builtin_logb.getValue() + 1);
        public static final /* enum */ ID BI__builtin_logbl = new ID(BI__builtin_logbf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_logf = new ID(BI__builtin_logbl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_logl = new ID(BI__builtin_logf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lrint = new ID(BI__builtin_logl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lrintf = new ID(BI__builtin_lrint.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lrintl = new ID(BI__builtin_lrintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lround = new ID(BI__builtin_lrintl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lroundf = new ID(BI__builtin_lround.getValue() + 1);
        public static final /* enum */ ID BI__builtin_lroundl = new ID(BI__builtin_lroundf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nearbyint = new ID(BI__builtin_lroundl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nearbyintf = new ID(BI__builtin_nearbyint.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nearbyintl = new ID(BI__builtin_nearbyintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nextafter = new ID(BI__builtin_nearbyintl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nextafterf = new ID(BI__builtin_nextafter.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nextafterl = new ID(BI__builtin_nextafterf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nexttoward = new ID(BI__builtin_nextafterl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nexttowardf = new ID(BI__builtin_nexttoward.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nexttowardl = new ID(BI__builtin_nexttowardf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remainder = new ID(BI__builtin_nexttowardl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remainderf = new ID(BI__builtin_remainder.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remainderl = new ID(BI__builtin_remainderf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remquo = new ID(BI__builtin_remainderl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remquof = new ID(BI__builtin_remquo.getValue() + 1);
        public static final /* enum */ ID BI__builtin_remquol = new ID(BI__builtin_remquof.getValue() + 1);
        public static final /* enum */ ID BI__builtin_rint = new ID(BI__builtin_remquol.getValue() + 1);
        public static final /* enum */ ID BI__builtin_rintf = new ID(BI__builtin_rint.getValue() + 1);
        public static final /* enum */ ID BI__builtin_rintl = new ID(BI__builtin_rintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_round = new ID(BI__builtin_rintl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_roundf = new ID(BI__builtin_round.getValue() + 1);
        public static final /* enum */ ID BI__builtin_roundl = new ID(BI__builtin_roundf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalbln = new ID(BI__builtin_roundl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalblnf = new ID(BI__builtin_scalbln.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalblnl = new ID(BI__builtin_scalblnf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalbn = new ID(BI__builtin_scalblnl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalbnf = new ID(BI__builtin_scalbn.getValue() + 1);
        public static final /* enum */ ID BI__builtin_scalbnl = new ID(BI__builtin_scalbnf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sin = new ID(BI__builtin_scalbnl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sinf = new ID(BI__builtin_sin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sinh = new ID(BI__builtin_sinf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sinhf = new ID(BI__builtin_sinh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sinhl = new ID(BI__builtin_sinhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sinl = new ID(BI__builtin_sinhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sqrt = new ID(BI__builtin_sinl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sqrtf = new ID(BI__builtin_sqrt.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sqrtl = new ID(BI__builtin_sqrtf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tan = new ID(BI__builtin_sqrtl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tanf = new ID(BI__builtin_tan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tanh = new ID(BI__builtin_tanf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tanhf = new ID(BI__builtin_tanh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tanhl = new ID(BI__builtin_tanhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tanl = new ID(BI__builtin_tanhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tgamma = new ID(BI__builtin_tanl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tgammaf = new ID(BI__builtin_tgamma.getValue() + 1);
        public static final /* enum */ ID BI__builtin_tgammal = new ID(BI__builtin_tgammaf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_trunc = new ID(BI__builtin_tgammal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_truncf = new ID(BI__builtin_trunc.getValue() + 1);
        public static final /* enum */ ID BI__builtin_truncl = new ID(BI__builtin_truncf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cabs = new ID(BI__builtin_truncl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cabsf = new ID(BI__builtin_cabs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cabsl = new ID(BI__builtin_cabsf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacos = new ID(BI__builtin_cabsl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacosf = new ID(BI__builtin_cacos.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacosh = new ID(BI__builtin_cacosf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacoshf = new ID(BI__builtin_cacosh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacoshl = new ID(BI__builtin_cacoshf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cacosl = new ID(BI__builtin_cacoshl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_carg = new ID(BI__builtin_cacosl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cargf = new ID(BI__builtin_carg.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cargl = new ID(BI__builtin_cargf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casin = new ID(BI__builtin_cargl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casinf = new ID(BI__builtin_casin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casinh = new ID(BI__builtin_casinf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casinhf = new ID(BI__builtin_casinh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casinhl = new ID(BI__builtin_casinhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_casinl = new ID(BI__builtin_casinhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catan = new ID(BI__builtin_casinl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catanf = new ID(BI__builtin_catan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catanh = new ID(BI__builtin_catanf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catanhf = new ID(BI__builtin_catanh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catanhl = new ID(BI__builtin_catanhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_catanl = new ID(BI__builtin_catanhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccos = new ID(BI__builtin_catanl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccosf = new ID(BI__builtin_ccos.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccosl = new ID(BI__builtin_ccosf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccosh = new ID(BI__builtin_ccosl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccoshf = new ID(BI__builtin_ccosh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ccoshl = new ID(BI__builtin_ccoshf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cexp = new ID(BI__builtin_ccoshl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cexpf = new ID(BI__builtin_cexp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cexpl = new ID(BI__builtin_cexpf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cimag = new ID(BI__builtin_cexpl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cimagf = new ID(BI__builtin_cimag.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cimagl = new ID(BI__builtin_cimagf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_conj = new ID(BI__builtin_cimagl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_conjf = new ID(BI__builtin_conj.getValue() + 1);
        public static final /* enum */ ID BI__builtin_conjl = new ID(BI__builtin_conjf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clog = new ID(BI__builtin_conjl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clogf = new ID(BI__builtin_clog.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clogl = new ID(BI__builtin_clogf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cproj = new ID(BI__builtin_clogl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cprojf = new ID(BI__builtin_cproj.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cprojl = new ID(BI__builtin_cprojf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cpow = new ID(BI__builtin_cprojl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cpowf = new ID(BI__builtin_cpow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_cpowl = new ID(BI__builtin_cpowf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_creal = new ID(BI__builtin_cpowl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_crealf = new ID(BI__builtin_creal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_creall = new ID(BI__builtin_crealf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csin = new ID(BI__builtin_creall.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csinf = new ID(BI__builtin_csin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csinl = new ID(BI__builtin_csinf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csinh = new ID(BI__builtin_csinl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csinhf = new ID(BI__builtin_csinh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csinhl = new ID(BI__builtin_csinhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csqrt = new ID(BI__builtin_csinhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csqrtf = new ID(BI__builtin_csqrt.getValue() + 1);
        public static final /* enum */ ID BI__builtin_csqrtl = new ID(BI__builtin_csqrtf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctan = new ID(BI__builtin_csqrtl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctanf = new ID(BI__builtin_ctan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctanl = new ID(BI__builtin_ctanf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctanh = new ID(BI__builtin_ctanl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctanhf = new ID(BI__builtin_ctanh.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctanhl = new ID(BI__builtin_ctanhf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isgreater = new ID(BI__builtin_ctanhl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isgreaterequal = new ID(BI__builtin_isgreater.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isless = new ID(BI__builtin_isgreaterequal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_islessequal = new ID(BI__builtin_isless.getValue() + 1);
        public static final /* enum */ ID BI__builtin_islessgreater = new ID(BI__builtin_islessequal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isunordered = new ID(BI__builtin_islessgreater.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fpclassify = new ID(BI__builtin_isunordered.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isfinite = new ID(BI__builtin_fpclassify.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isinf = new ID(BI__builtin_isfinite.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isinf_sign = new ID(BI__builtin_isinf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isnan = new ID(BI__builtin_isinf_sign.getValue() + 1);
        public static final /* enum */ ID BI__builtin_isnormal = new ID(BI__builtin_isnan.getValue() + 1);
        public static final /* enum */ ID BI__builtin_signbit = new ID(BI__builtin_isnormal.getValue() + 1);
        public static final /* enum */ ID BI__builtin_signbitf = new ID(BI__builtin_signbit.getValue() + 1);
        public static final /* enum */ ID BI__builtin_signbitl = new ID(BI__builtin_signbitf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_canonicalize = new ID(BI__builtin_signbitl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_canonicalizef = new ID(BI__builtin_canonicalize.getValue() + 1);
        public static final /* enum */ ID BI__builtin_canonicalizel = new ID(BI__builtin_canonicalizef.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clzs = new ID(BI__builtin_canonicalizel.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clz = new ID(BI__builtin_clzs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clzl = new ID(BI__builtin_clz.getValue() + 1);
        public static final /* enum */ ID BI__builtin_clzll = new ID(BI__builtin_clzl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctzs = new ID(BI__builtin_clzll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctz = new ID(BI__builtin_ctzs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctzl = new ID(BI__builtin_ctz.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ctzll = new ID(BI__builtin_ctzl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ffs = new ID(BI__builtin_ctzll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ffsl = new ID(BI__builtin_ffs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ffsll = new ID(BI__builtin_ffsl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_parity = new ID(BI__builtin_ffsll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_parityl = new ID(BI__builtin_parity.getValue() + 1);
        public static final /* enum */ ID BI__builtin_parityll = new ID(BI__builtin_parityl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_popcount = new ID(BI__builtin_parityll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_popcountl = new ID(BI__builtin_popcount.getValue() + 1);
        public static final /* enum */ ID BI__builtin_popcountll = new ID(BI__builtin_popcountl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bswap16 = new ID(BI__builtin_popcountll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bswap32 = new ID(BI__builtin_bswap16.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bswap64 = new ID(BI__builtin_bswap32.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bitreverse8 = new ID(BI__builtin_bswap64.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bitreverse16 = new ID(BI__builtin_bitreverse8.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bitreverse32 = new ID(BI__builtin_bitreverse16.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bitreverse64 = new ID(BI__builtin_bitreverse32.getValue() + 1);
        public static final /* enum */ ID BI__builtin_constant_p = new ID(BI__builtin_bitreverse64.getValue() + 1);
        public static final /* enum */ ID BI__builtin_classify_type = new ID(BI__builtin_constant_p.getValue() + 1);
        public static final /* enum */ ID BI__builtin___CFStringMakeConstantString = new ID(BI__builtin_classify_type.getValue() + 1);
        public static final /* enum */ ID BI__builtin___NSStringMakeConstantString = new ID(BI__builtin___CFStringMakeConstantString.getValue() + 1);
        public static final /* enum */ ID BI__builtin_va_start = new ID(BI__builtin___NSStringMakeConstantString.getValue() + 1);
        public static final /* enum */ ID BI__builtin_va_end = new ID(BI__builtin_va_start.getValue() + 1);
        public static final /* enum */ ID BI__builtin_va_copy = new ID(BI__builtin_va_end.getValue() + 1);
        public static final /* enum */ ID BI__builtin_stdarg_start = new ID(BI__builtin_va_copy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_assume_aligned = new ID(BI__builtin_stdarg_start.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bcmp = new ID(BI__builtin_assume_aligned.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bcopy = new ID(BI__builtin_bcmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_bzero = new ID(BI__builtin_bcopy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_fprintf = new ID(BI__builtin_bzero.getValue() + 1);
        public static final /* enum */ ID BI__builtin_memchr = new ID(BI__builtin_fprintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_memcmp = new ID(BI__builtin_memchr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_memcpy = new ID(BI__builtin_memcmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_memmove = new ID(BI__builtin_memcpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_mempcpy = new ID(BI__builtin_memmove.getValue() + 1);
        public static final /* enum */ ID BI__builtin_memset = new ID(BI__builtin_mempcpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_printf = new ID(BI__builtin_memset.getValue() + 1);
        public static final /* enum */ ID BI__builtin_stpcpy = new ID(BI__builtin_printf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_stpncpy = new ID(BI__builtin_stpcpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strcasecmp = new ID(BI__builtin_stpncpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strcat = new ID(BI__builtin_strcasecmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strchr = new ID(BI__builtin_strcat.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strcmp = new ID(BI__builtin_strchr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strcpy = new ID(BI__builtin_strcmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strcspn = new ID(BI__builtin_strcpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strdup = new ID(BI__builtin_strcspn.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strlen = new ID(BI__builtin_strdup.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strncasecmp = new ID(BI__builtin_strlen.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strncat = new ID(BI__builtin_strncasecmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strncmp = new ID(BI__builtin_strncat.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strncpy = new ID(BI__builtin_strncmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strndup = new ID(BI__builtin_strncpy.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strpbrk = new ID(BI__builtin_strndup.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strrchr = new ID(BI__builtin_strpbrk.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strspn = new ID(BI__builtin_strrchr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_strstr = new ID(BI__builtin_strspn.getValue() + 1);
        public static final /* enum */ ID BI__builtin_return_address = new ID(BI__builtin_strstr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_extract_return_addr = new ID(BI__builtin_return_address.getValue() + 1);
        public static final /* enum */ ID BI__builtin_frame_address = new ID(BI__builtin_extract_return_addr.getValue() + 1);
        public static final /* enum */ ID BI__builtin___clear_cache = new ID(BI__builtin_frame_address.getValue() + 1);
        public static final /* enum */ ID BI__builtin_flt_rounds = new ID(BI__builtin___clear_cache.getValue() + 1);
        public static final /* enum */ ID BI__builtin_setjmp = new ID(BI__builtin_flt_rounds.getValue() + 1);
        public static final /* enum */ ID BI__builtin_longjmp = new ID(BI__builtin_setjmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_unwind_init = new ID(BI__builtin_longjmp.getValue() + 1);
        public static final /* enum */ ID BI__builtin_eh_return_data_regno = new ID(BI__builtin_unwind_init.getValue() + 1);
        public static final /* enum */ ID BI__builtin_snprintf = new ID(BI__builtin_eh_return_data_regno.getValue() + 1);
        public static final /* enum */ ID BI__builtin_vsprintf = new ID(BI__builtin_snprintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_vsnprintf = new ID(BI__builtin_vsprintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_thread_pointer = new ID(BI__builtin_vsnprintf.getValue() + 1);
        public static final /* enum */ ID BI__builtin_eh_return = new ID(BI__builtin_thread_pointer.getValue() + 1);
        public static final /* enum */ ID BI__builtin_frob_return_addr = new ID(BI__builtin_eh_return.getValue() + 1);
        public static final /* enum */ ID BI__builtin_dwarf_cfa = new ID(BI__builtin_frob_return_addr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_init_dwarf_reg_size_table = new ID(BI__builtin_dwarf_cfa.getValue() + 1);
        public static final /* enum */ ID BI__builtin_dwarf_sp_column = new ID(BI__builtin_init_dwarf_reg_size_table.getValue() + 1);
        public static final /* enum */ ID BI__builtin_extend_pointer = new ID(BI__builtin_dwarf_sp_column.getValue() + 1);
        public static final /* enum */ ID BI__builtin_object_size = new ID(BI__builtin_extend_pointer.getValue() + 1);
        public static final /* enum */ ID BI__builtin___memcpy_chk = new ID(BI__builtin_object_size.getValue() + 1);
        public static final /* enum */ ID BI__builtin___memccpy_chk = new ID(BI__builtin___memcpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___memmove_chk = new ID(BI__builtin___memccpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___mempcpy_chk = new ID(BI__builtin___memmove_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___memset_chk = new ID(BI__builtin___mempcpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___stpcpy_chk = new ID(BI__builtin___memset_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strcat_chk = new ID(BI__builtin___stpcpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strcpy_chk = new ID(BI__builtin___strcat_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strlcat_chk = new ID(BI__builtin___strcpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strlcpy_chk = new ID(BI__builtin___strlcat_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strncat_chk = new ID(BI__builtin___strlcpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___strncpy_chk = new ID(BI__builtin___strncat_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___stpncpy_chk = new ID(BI__builtin___strncpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___snprintf_chk = new ID(BI__builtin___stpncpy_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___sprintf_chk = new ID(BI__builtin___snprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___vsnprintf_chk = new ID(BI__builtin___sprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___vsprintf_chk = new ID(BI__builtin___vsnprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___fprintf_chk = new ID(BI__builtin___vsprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___printf_chk = new ID(BI__builtin___fprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___vfprintf_chk = new ID(BI__builtin___printf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin___vprintf_chk = new ID(BI__builtin___vfprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin_unpredictable = new ID(BI__builtin___vprintf_chk.getValue() + 1);
        public static final /* enum */ ID BI__builtin_expect = new ID(BI__builtin_unpredictable.getValue() + 1);
        public static final /* enum */ ID BI__builtin_prefetch = new ID(BI__builtin_expect.getValue() + 1);
        public static final /* enum */ ID BI__builtin_readcyclecounter = new ID(BI__builtin_prefetch.getValue() + 1);
        public static final /* enum */ ID BI__builtin_trap = new ID(BI__builtin_readcyclecounter.getValue() + 1);
        public static final /* enum */ ID BI__builtin_debugtrap = new ID(BI__builtin_trap.getValue() + 1);
        public static final /* enum */ ID BI__builtin_unreachable = new ID(BI__builtin_debugtrap.getValue() + 1);
        public static final /* enum */ ID BI__builtin_shufflevector = new ID(BI__builtin_unreachable.getValue() + 1);
        public static final /* enum */ ID BI__builtin_convertvector = new ID(BI__builtin_shufflevector.getValue() + 1);
        public static final /* enum */ ID BI__builtin_alloca = new ID(BI__builtin_convertvector.getValue() + 1);
        public static final /* enum */ ID BI__builtin_call_with_static_chain = new ID(BI__builtin_alloca.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add = new ID(BI__builtin_call_with_static_chain.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add_1 = new ID(BI__sync_fetch_and_add.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add_2 = new ID(BI__sync_fetch_and_add_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add_4 = new ID(BI__sync_fetch_and_add_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add_8 = new ID(BI__sync_fetch_and_add_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_add_16 = new ID(BI__sync_fetch_and_add_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub = new ID(BI__sync_fetch_and_add_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub_1 = new ID(BI__sync_fetch_and_sub.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub_2 = new ID(BI__sync_fetch_and_sub_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub_4 = new ID(BI__sync_fetch_and_sub_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub_8 = new ID(BI__sync_fetch_and_sub_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_sub_16 = new ID(BI__sync_fetch_and_sub_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or = new ID(BI__sync_fetch_and_sub_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or_1 = new ID(BI__sync_fetch_and_or.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or_2 = new ID(BI__sync_fetch_and_or_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or_4 = new ID(BI__sync_fetch_and_or_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or_8 = new ID(BI__sync_fetch_and_or_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_or_16 = new ID(BI__sync_fetch_and_or_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and = new ID(BI__sync_fetch_and_or_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and_1 = new ID(BI__sync_fetch_and_and.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and_2 = new ID(BI__sync_fetch_and_and_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and_4 = new ID(BI__sync_fetch_and_and_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and_8 = new ID(BI__sync_fetch_and_and_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_and_16 = new ID(BI__sync_fetch_and_and_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor = new ID(BI__sync_fetch_and_and_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor_1 = new ID(BI__sync_fetch_and_xor.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor_2 = new ID(BI__sync_fetch_and_xor_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor_4 = new ID(BI__sync_fetch_and_xor_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor_8 = new ID(BI__sync_fetch_and_xor_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_xor_16 = new ID(BI__sync_fetch_and_xor_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand = new ID(BI__sync_fetch_and_xor_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand_1 = new ID(BI__sync_fetch_and_nand.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand_2 = new ID(BI__sync_fetch_and_nand_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand_4 = new ID(BI__sync_fetch_and_nand_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand_8 = new ID(BI__sync_fetch_and_nand_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_nand_16 = new ID(BI__sync_fetch_and_nand_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch = new ID(BI__sync_fetch_and_nand_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch_1 = new ID(BI__sync_add_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch_2 = new ID(BI__sync_add_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch_4 = new ID(BI__sync_add_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch_8 = new ID(BI__sync_add_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_add_and_fetch_16 = new ID(BI__sync_add_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch = new ID(BI__sync_add_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch_1 = new ID(BI__sync_sub_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch_2 = new ID(BI__sync_sub_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch_4 = new ID(BI__sync_sub_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch_8 = new ID(BI__sync_sub_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_sub_and_fetch_16 = new ID(BI__sync_sub_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch = new ID(BI__sync_sub_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch_1 = new ID(BI__sync_or_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch_2 = new ID(BI__sync_or_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch_4 = new ID(BI__sync_or_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch_8 = new ID(BI__sync_or_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_or_and_fetch_16 = new ID(BI__sync_or_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch = new ID(BI__sync_or_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch_1 = new ID(BI__sync_and_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch_2 = new ID(BI__sync_and_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch_4 = new ID(BI__sync_and_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch_8 = new ID(BI__sync_and_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_and_and_fetch_16 = new ID(BI__sync_and_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch = new ID(BI__sync_and_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch_1 = new ID(BI__sync_xor_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch_2 = new ID(BI__sync_xor_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch_4 = new ID(BI__sync_xor_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch_8 = new ID(BI__sync_xor_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_xor_and_fetch_16 = new ID(BI__sync_xor_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch = new ID(BI__sync_xor_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch_1 = new ID(BI__sync_nand_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch_2 = new ID(BI__sync_nand_and_fetch_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch_4 = new ID(BI__sync_nand_and_fetch_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch_8 = new ID(BI__sync_nand_and_fetch_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_nand_and_fetch_16 = new ID(BI__sync_nand_and_fetch_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap = new ID(BI__sync_nand_and_fetch_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap_1 = new ID(BI__sync_bool_compare_and_swap.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap_2 = new ID(BI__sync_bool_compare_and_swap_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap_4 = new ID(BI__sync_bool_compare_and_swap_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap_8 = new ID(BI__sync_bool_compare_and_swap_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_bool_compare_and_swap_16 = new ID(BI__sync_bool_compare_and_swap_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap = new ID(BI__sync_bool_compare_and_swap_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap_1 = new ID(BI__sync_val_compare_and_swap.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap_2 = new ID(BI__sync_val_compare_and_swap_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap_4 = new ID(BI__sync_val_compare_and_swap_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap_8 = new ID(BI__sync_val_compare_and_swap_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_val_compare_and_swap_16 = new ID(BI__sync_val_compare_and_swap_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set = new ID(BI__sync_val_compare_and_swap_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set_1 = new ID(BI__sync_lock_test_and_set.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set_2 = new ID(BI__sync_lock_test_and_set_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set_4 = new ID(BI__sync_lock_test_and_set_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set_8 = new ID(BI__sync_lock_test_and_set_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_test_and_set_16 = new ID(BI__sync_lock_test_and_set_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release = new ID(BI__sync_lock_test_and_set_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release_1 = new ID(BI__sync_lock_release.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release_2 = new ID(BI__sync_lock_release_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release_4 = new ID(BI__sync_lock_release_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release_8 = new ID(BI__sync_lock_release_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_lock_release_16 = new ID(BI__sync_lock_release_8.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap = new ID(BI__sync_lock_release_16.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap_1 = new ID(BI__sync_swap.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap_2 = new ID(BI__sync_swap_1.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap_4 = new ID(BI__sync_swap_2.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap_8 = new ID(BI__sync_swap_4.getValue() + 1);
        public static final /* enum */ ID BI__sync_swap_16 = new ID(BI__sync_swap_8.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_init = new ID(BI__sync_swap_16.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_load = new ID(BI__c11_atomic_init.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_store = new ID(BI__c11_atomic_load.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_exchange = new ID(BI__c11_atomic_store.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_compare_exchange_strong = new ID(BI__c11_atomic_exchange.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_compare_exchange_weak = new ID(BI__c11_atomic_compare_exchange_strong.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_fetch_add = new ID(BI__c11_atomic_compare_exchange_weak.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_fetch_sub = new ID(BI__c11_atomic_fetch_add.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_fetch_and = new ID(BI__c11_atomic_fetch_sub.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_fetch_or = new ID(BI__c11_atomic_fetch_and.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_fetch_xor = new ID(BI__c11_atomic_fetch_or.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_thread_fence = new ID(BI__c11_atomic_fetch_xor.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_signal_fence = new ID(BI__c11_atomic_thread_fence.getValue() + 1);
        public static final /* enum */ ID BI__c11_atomic_is_lock_free = new ID(BI__c11_atomic_signal_fence.getValue() + 1);
        public static final /* enum */ ID BI__atomic_load = new ID(BI__c11_atomic_is_lock_free.getValue() + 1);
        public static final /* enum */ ID BI__atomic_load_n = new ID(BI__atomic_load.getValue() + 1);
        public static final /* enum */ ID BI__atomic_store = new ID(BI__atomic_load_n.getValue() + 1);
        public static final /* enum */ ID BI__atomic_store_n = new ID(BI__atomic_store.getValue() + 1);
        public static final /* enum */ ID BI__atomic_exchange = new ID(BI__atomic_store_n.getValue() + 1);
        public static final /* enum */ ID BI__atomic_exchange_n = new ID(BI__atomic_exchange.getValue() + 1);
        public static final /* enum */ ID BI__atomic_compare_exchange = new ID(BI__atomic_exchange_n.getValue() + 1);
        public static final /* enum */ ID BI__atomic_compare_exchange_n = new ID(BI__atomic_compare_exchange.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_add = new ID(BI__atomic_compare_exchange_n.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_sub = new ID(BI__atomic_fetch_add.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_and = new ID(BI__atomic_fetch_sub.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_or = new ID(BI__atomic_fetch_and.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_xor = new ID(BI__atomic_fetch_or.getValue() + 1);
        public static final /* enum */ ID BI__atomic_fetch_nand = new ID(BI__atomic_fetch_xor.getValue() + 1);
        public static final /* enum */ ID BI__atomic_add_fetch = new ID(BI__atomic_fetch_nand.getValue() + 1);
        public static final /* enum */ ID BI__atomic_sub_fetch = new ID(BI__atomic_add_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_and_fetch = new ID(BI__atomic_sub_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_or_fetch = new ID(BI__atomic_and_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_xor_fetch = new ID(BI__atomic_or_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_nand_fetch = new ID(BI__atomic_xor_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_test_and_set = new ID(BI__atomic_nand_fetch.getValue() + 1);
        public static final /* enum */ ID BI__atomic_clear = new ID(BI__atomic_test_and_set.getValue() + 1);
        public static final /* enum */ ID BI__atomic_thread_fence = new ID(BI__atomic_clear.getValue() + 1);
        public static final /* enum */ ID BI__atomic_signal_fence = new ID(BI__atomic_thread_fence.getValue() + 1);
        public static final /* enum */ ID BI__atomic_always_lock_free = new ID(BI__atomic_signal_fence.getValue() + 1);
        public static final /* enum */ ID BI__atomic_is_lock_free = new ID(BI__atomic_always_lock_free.getValue() + 1);
        public static final /* enum */ ID BI__sync_synchronize = new ID(BI__atomic_is_lock_free.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_min = new ID(BI__sync_synchronize.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_max = new ID(BI__sync_fetch_and_min.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_umin = new ID(BI__sync_fetch_and_max.getValue() + 1);
        public static final /* enum */ ID BI__sync_fetch_and_umax = new ID(BI__sync_fetch_and_umin.getValue() + 1);
        public static final /* enum */ ID BI__builtin_abort = new ID(BI__sync_fetch_and_umax.getValue() + 1);
        public static final /* enum */ ID BI__builtin_index = new ID(BI__builtin_abort.getValue() + 1);
        public static final /* enum */ ID BI__builtin_rindex = new ID(BI__builtin_index.getValue() + 1);
        public static final /* enum */ ID BI_alloca = new ID(BI__builtin_rindex.getValue() + 1);
        public static final /* enum */ ID BI__assume = new ID(BI_alloca.getValue() + 1);
        public static final /* enum */ ID BI__debugbreak = new ID(BI__assume.getValue() + 1);
        public static final /* enum */ ID BI__exception_code = new ID(BI__debugbreak.getValue() + 1);
        public static final /* enum */ ID BI_exception_code = new ID(BI__exception_code.getValue() + 1);
        public static final /* enum */ ID BI__exception_info = new ID(BI_exception_code.getValue() + 1);
        public static final /* enum */ ID BI_exception_info = new ID(BI__exception_info.getValue() + 1);
        public static final /* enum */ ID BI__abnormal_termination = new ID(BI_exception_info.getValue() + 1);
        public static final /* enum */ ID BI_abnormal_termination = new ID(BI__abnormal_termination.getValue() + 1);
        public static final /* enum */ ID BI__GetExceptionInfo = new ID(BI_abnormal_termination.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedCompareExchange = new ID(BI__GetExceptionInfo.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedCompareExchangePointer = new ID(BI_InterlockedCompareExchange.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedDecrement = new ID(BI_InterlockedCompareExchangePointer.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedExchangeAdd = new ID(BI_InterlockedDecrement.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedExchange = new ID(BI_InterlockedExchangeAdd.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedExchangePointer = new ID(BI_InterlockedExchange.getValue() + 1);
        public static final /* enum */ ID BI_InterlockedIncrement = new ID(BI_InterlockedExchangePointer.getValue() + 1);
        public static final /* enum */ ID BI__noop = new ID(BI_InterlockedIncrement.getValue() + 1);
        public static final /* enum */ ID BI__readfsdword = new ID(BI__noop.getValue() + 1);
        public static final /* enum */ ID BI__va_start = new ID(BI__readfsdword.getValue() + 1);
        public static final /* enum */ ID BI_setjmpex = new ID(BI__va_start.getValue() + 1);
        public static final /* enum */ ID BIabort = new ID(BI_setjmpex.getValue() + 1);
        public static final /* enum */ ID BIcalloc = new ID(BIabort.getValue() + 1);
        public static final /* enum */ ID BIexit = new ID(BIcalloc.getValue() + 1);
        public static final /* enum */ ID BI_Exit = new ID(BIexit.getValue() + 1);
        public static final /* enum */ ID BImalloc = new ID(BI_Exit.getValue() + 1);
        public static final /* enum */ ID BIrealloc = new ID(BImalloc.getValue() + 1);
        public static final /* enum */ ID BImemcpy = new ID(BIrealloc.getValue() + 1);
        public static final /* enum */ ID BImemcmp = new ID(BImemcpy.getValue() + 1);
        public static final /* enum */ ID BImemmove = new ID(BImemcmp.getValue() + 1);
        public static final /* enum */ ID BIstrcpy = new ID(BImemmove.getValue() + 1);
        public static final /* enum */ ID BIstrncpy = new ID(BIstrcpy.getValue() + 1);
        public static final /* enum */ ID BIstrcmp = new ID(BIstrncpy.getValue() + 1);
        public static final /* enum */ ID BIstrncmp = new ID(BIstrcmp.getValue() + 1);
        public static final /* enum */ ID BIstrcat = new ID(BIstrncmp.getValue() + 1);
        public static final /* enum */ ID BIstrncat = new ID(BIstrcat.getValue() + 1);
        public static final /* enum */ ID BIstrxfrm = new ID(BIstrncat.getValue() + 1);
        public static final /* enum */ ID BImemchr = new ID(BIstrxfrm.getValue() + 1);
        public static final /* enum */ ID BIstrchr = new ID(BImemchr.getValue() + 1);
        public static final /* enum */ ID BIstrcspn = new ID(BIstrchr.getValue() + 1);
        public static final /* enum */ ID BIstrpbrk = new ID(BIstrcspn.getValue() + 1);
        public static final /* enum */ ID BIstrrchr = new ID(BIstrpbrk.getValue() + 1);
        public static final /* enum */ ID BIstrspn = new ID(BIstrrchr.getValue() + 1);
        public static final /* enum */ ID BIstrstr = new ID(BIstrspn.getValue() + 1);
        public static final /* enum */ ID BIstrtok = new ID(BIstrstr.getValue() + 1);
        public static final /* enum */ ID BImemset = new ID(BIstrtok.getValue() + 1);
        public static final /* enum */ ID BIstrerror = new ID(BImemset.getValue() + 1);
        public static final /* enum */ ID BIstrlen = new ID(BIstrerror.getValue() + 1);
        public static final /* enum */ ID BIprintf = new ID(BIstrlen.getValue() + 1);
        public static final /* enum */ ID BIfprintf = new ID(BIprintf.getValue() + 1);
        public static final /* enum */ ID BIsnprintf = new ID(BIfprintf.getValue() + 1);
        public static final /* enum */ ID BIsprintf = new ID(BIsnprintf.getValue() + 1);
        public static final /* enum */ ID BIvprintf = new ID(BIsprintf.getValue() + 1);
        public static final /* enum */ ID BIvfprintf = new ID(BIvprintf.getValue() + 1);
        public static final /* enum */ ID BIvsnprintf = new ID(BIvfprintf.getValue() + 1);
        public static final /* enum */ ID BIvsprintf = new ID(BIvsnprintf.getValue() + 1);
        public static final /* enum */ ID BIscanf = new ID(BIvsprintf.getValue() + 1);
        public static final /* enum */ ID BIfscanf = new ID(BIscanf.getValue() + 1);
        public static final /* enum */ ID BIsscanf = new ID(BIfscanf.getValue() + 1);
        public static final /* enum */ ID BIvscanf = new ID(BIsscanf.getValue() + 1);
        public static final /* enum */ ID BIvfscanf = new ID(BIvscanf.getValue() + 1);
        public static final /* enum */ ID BIvsscanf = new ID(BIvfscanf.getValue() + 1);
        public static final /* enum */ ID BIisalnum = new ID(BIvsscanf.getValue() + 1);
        public static final /* enum */ ID BIisalpha = new ID(BIisalnum.getValue() + 1);
        public static final /* enum */ ID BIisblank = new ID(BIisalpha.getValue() + 1);
        public static final /* enum */ ID BIiscntrl = new ID(BIisblank.getValue() + 1);
        public static final /* enum */ ID BIisdigit = new ID(BIiscntrl.getValue() + 1);
        public static final /* enum */ ID BIisgraph = new ID(BIisdigit.getValue() + 1);
        public static final /* enum */ ID BIislower = new ID(BIisgraph.getValue() + 1);
        public static final /* enum */ ID BIisprint = new ID(BIislower.getValue() + 1);
        public static final /* enum */ ID BIispunct = new ID(BIisprint.getValue() + 1);
        public static final /* enum */ ID BIisspace = new ID(BIispunct.getValue() + 1);
        public static final /* enum */ ID BIisupper = new ID(BIisspace.getValue() + 1);
        public static final /* enum */ ID BIisxdigit = new ID(BIisupper.getValue() + 1);
        public static final /* enum */ ID BItolower = new ID(BIisxdigit.getValue() + 1);
        public static final /* enum */ ID BItoupper = new ID(BItolower.getValue() + 1);
        public static final /* enum */ ID BIsetjmp = new ID(BItoupper.getValue() + 1);
        public static final /* enum */ ID BIlongjmp = new ID(BIsetjmp.getValue() + 1);
        public static final /* enum */ ID BIalloca = new ID(BIlongjmp.getValue() + 1);
        public static final /* enum */ ID BIstpcpy = new ID(BIalloca.getValue() + 1);
        public static final /* enum */ ID BIstpncpy = new ID(BIstpcpy.getValue() + 1);
        public static final /* enum */ ID BIstrdup = new ID(BIstpncpy.getValue() + 1);
        public static final /* enum */ ID BIstrndup = new ID(BIstrdup.getValue() + 1);
        public static final /* enum */ ID BIindex = new ID(BIstrndup.getValue() + 1);
        public static final /* enum */ ID BIrindex = new ID(BIindex.getValue() + 1);
        public static final /* enum */ ID BIbzero = new ID(BIrindex.getValue() + 1);
        public static final /* enum */ ID BIstrcasecmp = new ID(BIbzero.getValue() + 1);
        public static final /* enum */ ID BIstrncasecmp = new ID(BIstrcasecmp.getValue() + 1);
        public static final /* enum */ ID BI_exit = new ID(BIstrncasecmp.getValue() + 1);
        public static final /* enum */ ID BIvfork = new ID(BI_exit.getValue() + 1);
        public static final /* enum */ ID BI_setjmp = new ID(BIvfork.getValue() + 1);
        public static final /* enum */ ID BI__sigsetjmp = new ID(BI_setjmp.getValue() + 1);
        public static final /* enum */ ID BIsigsetjmp = new ID(BI__sigsetjmp.getValue() + 1);
        public static final /* enum */ ID BIsetjmp_syscall = new ID(BIsigsetjmp.getValue() + 1);
        public static final /* enum */ ID BIsavectx = new ID(BIsetjmp_syscall.getValue() + 1);
        public static final /* enum */ ID BIqsetjmp = new ID(BIsavectx.getValue() + 1);
        public static final /* enum */ ID BIgetcontext = new ID(BIqsetjmp.getValue() + 1);
        public static final /* enum */ ID BI_longjmp = new ID(BIgetcontext.getValue() + 1);
        public static final /* enum */ ID BIsiglongjmp = new ID(BI_longjmp.getValue() + 1);
        public static final /* enum */ ID BIstrlcpy = new ID(BIsiglongjmp.getValue() + 1);
        public static final /* enum */ ID BIstrlcat = new ID(BIstrlcpy.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSend = new ID(BIstrlcat.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSend_fpret = new ID(BIobjc_msgSend.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSend_fp2ret = new ID(BIobjc_msgSend_fpret.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSend_stret = new ID(BIobjc_msgSend_fp2ret.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSendSuper = new ID(BIobjc_msgSend_stret.getValue() + 1);
        public static final /* enum */ ID BIobjc_msgSendSuper_stret = new ID(BIobjc_msgSendSuper.getValue() + 1);
        public static final /* enum */ ID BIobjc_getClass = new ID(BIobjc_msgSendSuper_stret.getValue() + 1);
        public static final /* enum */ ID BIobjc_getMetaClass = new ID(BIobjc_getClass.getValue() + 1);
        public static final /* enum */ ID BIobjc_enumerationMutation = new ID(BIobjc_getMetaClass.getValue() + 1);
        public static final /* enum */ ID BIobjc_read_weak = new ID(BIobjc_enumerationMutation.getValue() + 1);
        public static final /* enum */ ID BIobjc_assign_weak = new ID(BIobjc_read_weak.getValue() + 1);
        public static final /* enum */ ID BIobjc_assign_ivar = new ID(BIobjc_assign_weak.getValue() + 1);
        public static final /* enum */ ID BIobjc_assign_global = new ID(BIobjc_assign_ivar.getValue() + 1);
        public static final /* enum */ ID BIobjc_assign_strongCast = new ID(BIobjc_assign_global.getValue() + 1);
        public static final /* enum */ ID BIobjc_exception_extract = new ID(BIobjc_assign_strongCast.getValue() + 1);
        public static final /* enum */ ID BIobjc_exception_try_enter = new ID(BIobjc_exception_extract.getValue() + 1);
        public static final /* enum */ ID BIobjc_exception_try_exit = new ID(BIobjc_exception_try_enter.getValue() + 1);
        public static final /* enum */ ID BIobjc_exception_match = new ID(BIobjc_exception_try_exit.getValue() + 1);
        public static final /* enum */ ID BIobjc_exception_throw = new ID(BIobjc_exception_match.getValue() + 1);
        public static final /* enum */ ID BIobjc_sync_enter = new ID(BIobjc_exception_throw.getValue() + 1);
        public static final /* enum */ ID BIobjc_sync_exit = new ID(BIobjc_sync_enter.getValue() + 1);
        public static final /* enum */ ID BI__builtin_objc_memmove_collectable = new ID(BIobjc_sync_exit.getValue() + 1);
        public static final /* enum */ ID BINSLog = new ID(BI__builtin_objc_memmove_collectable.getValue() + 1);
        public static final /* enum */ ID BINSLogv = new ID(BINSLog.getValue() + 1);
        public static final /* enum */ ID BIatan2 = new ID(BINSLogv.getValue() + 1);
        public static final /* enum */ ID BIatan2f = new ID(BIatan2.getValue() + 1);
        public static final /* enum */ ID BIatan2l = new ID(BIatan2f.getValue() + 1);
        public static final /* enum */ ID BIabs = new ID(BIatan2l.getValue() + 1);
        public static final /* enum */ ID BIlabs = new ID(BIabs.getValue() + 1);
        public static final /* enum */ ID BIllabs = new ID(BIlabs.getValue() + 1);
        public static final /* enum */ ID BIcopysign = new ID(BIllabs.getValue() + 1);
        public static final /* enum */ ID BIcopysignf = new ID(BIcopysign.getValue() + 1);
        public static final /* enum */ ID BIcopysignl = new ID(BIcopysignf.getValue() + 1);
        public static final /* enum */ ID BIfabs = new ID(BIcopysignl.getValue() + 1);
        public static final /* enum */ ID BIfabsf = new ID(BIfabs.getValue() + 1);
        public static final /* enum */ ID BIfabsl = new ID(BIfabsf.getValue() + 1);
        public static final /* enum */ ID BIfmod = new ID(BIfabsl.getValue() + 1);
        public static final /* enum */ ID BIfmodf = new ID(BIfmod.getValue() + 1);
        public static final /* enum */ ID BIfmodl = new ID(BIfmodf.getValue() + 1);
        public static final /* enum */ ID BIfrexp = new ID(BIfmodl.getValue() + 1);
        public static final /* enum */ ID BIfrexpf = new ID(BIfrexp.getValue() + 1);
        public static final /* enum */ ID BIfrexpl = new ID(BIfrexpf.getValue() + 1);
        public static final /* enum */ ID BIldexp = new ID(BIfrexpl.getValue() + 1);
        public static final /* enum */ ID BIldexpf = new ID(BIldexp.getValue() + 1);
        public static final /* enum */ ID BIldexpl = new ID(BIldexpf.getValue() + 1);
        public static final /* enum */ ID BImodf = new ID(BIldexpl.getValue() + 1);
        public static final /* enum */ ID BImodff = new ID(BImodf.getValue() + 1);
        public static final /* enum */ ID BImodfl = new ID(BImodff.getValue() + 1);
        public static final /* enum */ ID BInan = new ID(BImodfl.getValue() + 1);
        public static final /* enum */ ID BInanf = new ID(BInan.getValue() + 1);
        public static final /* enum */ ID BInanl = new ID(BInanf.getValue() + 1);
        public static final /* enum */ ID BIpow = new ID(BInanl.getValue() + 1);
        public static final /* enum */ ID BIpowf = new ID(BIpow.getValue() + 1);
        public static final /* enum */ ID BIpowl = new ID(BIpowf.getValue() + 1);
        public static final /* enum */ ID BIacos = new ID(BIpowl.getValue() + 1);
        public static final /* enum */ ID BIacosf = new ID(BIacos.getValue() + 1);
        public static final /* enum */ ID BIacosl = new ID(BIacosf.getValue() + 1);
        public static final /* enum */ ID BIacosh = new ID(BIacosl.getValue() + 1);
        public static final /* enum */ ID BIacoshf = new ID(BIacosh.getValue() + 1);
        public static final /* enum */ ID BIacoshl = new ID(BIacoshf.getValue() + 1);
        public static final /* enum */ ID BIasin = new ID(BIacoshl.getValue() + 1);
        public static final /* enum */ ID BIasinf = new ID(BIasin.getValue() + 1);
        public static final /* enum */ ID BIasinl = new ID(BIasinf.getValue() + 1);
        public static final /* enum */ ID BIasinh = new ID(BIasinl.getValue() + 1);
        public static final /* enum */ ID BIasinhf = new ID(BIasinh.getValue() + 1);
        public static final /* enum */ ID BIasinhl = new ID(BIasinhf.getValue() + 1);
        public static final /* enum */ ID BIatan = new ID(BIasinhl.getValue() + 1);
        public static final /* enum */ ID BIatanf = new ID(BIatan.getValue() + 1);
        public static final /* enum */ ID BIatanl = new ID(BIatanf.getValue() + 1);
        public static final /* enum */ ID BIatanh = new ID(BIatanl.getValue() + 1);
        public static final /* enum */ ID BIatanhf = new ID(BIatanh.getValue() + 1);
        public static final /* enum */ ID BIatanhl = new ID(BIatanhf.getValue() + 1);
        public static final /* enum */ ID BIcbrt = new ID(BIatanhl.getValue() + 1);
        public static final /* enum */ ID BIcbrtf = new ID(BIcbrt.getValue() + 1);
        public static final /* enum */ ID BIcbrtl = new ID(BIcbrtf.getValue() + 1);
        public static final /* enum */ ID BIceil = new ID(BIcbrtl.getValue() + 1);
        public static final /* enum */ ID BIceilf = new ID(BIceil.getValue() + 1);
        public static final /* enum */ ID BIceill = new ID(BIceilf.getValue() + 1);
        public static final /* enum */ ID BIcos = new ID(BIceill.getValue() + 1);
        public static final /* enum */ ID BIcosf = new ID(BIcos.getValue() + 1);
        public static final /* enum */ ID BIcosl = new ID(BIcosf.getValue() + 1);
        public static final /* enum */ ID BIcosh = new ID(BIcosl.getValue() + 1);
        public static final /* enum */ ID BIcoshf = new ID(BIcosh.getValue() + 1);
        public static final /* enum */ ID BIcoshl = new ID(BIcoshf.getValue() + 1);
        public static final /* enum */ ID BIerf = new ID(BIcoshl.getValue() + 1);
        public static final /* enum */ ID BIerff = new ID(BIerf.getValue() + 1);
        public static final /* enum */ ID BIerfl = new ID(BIerff.getValue() + 1);
        public static final /* enum */ ID BIerfc = new ID(BIerfl.getValue() + 1);
        public static final /* enum */ ID BIerfcf = new ID(BIerfc.getValue() + 1);
        public static final /* enum */ ID BIerfcl = new ID(BIerfcf.getValue() + 1);
        public static final /* enum */ ID BIexp = new ID(BIerfcl.getValue() + 1);
        public static final /* enum */ ID BIexpf = new ID(BIexp.getValue() + 1);
        public static final /* enum */ ID BIexpl = new ID(BIexpf.getValue() + 1);
        public static final /* enum */ ID BIexp2 = new ID(BIexpl.getValue() + 1);
        public static final /* enum */ ID BIexp2f = new ID(BIexp2.getValue() + 1);
        public static final /* enum */ ID BIexp2l = new ID(BIexp2f.getValue() + 1);
        public static final /* enum */ ID BIexpm1 = new ID(BIexp2l.getValue() + 1);
        public static final /* enum */ ID BIexpm1f = new ID(BIexpm1.getValue() + 1);
        public static final /* enum */ ID BIexpm1l = new ID(BIexpm1f.getValue() + 1);
        public static final /* enum */ ID BIfdim = new ID(BIexpm1l.getValue() + 1);
        public static final /* enum */ ID BIfdimf = new ID(BIfdim.getValue() + 1);
        public static final /* enum */ ID BIfdiml = new ID(BIfdimf.getValue() + 1);
        public static final /* enum */ ID BIfloor = new ID(BIfdiml.getValue() + 1);
        public static final /* enum */ ID BIfloorf = new ID(BIfloor.getValue() + 1);
        public static final /* enum */ ID BIfloorl = new ID(BIfloorf.getValue() + 1);
        public static final /* enum */ ID BIfma = new ID(BIfloorl.getValue() + 1);
        public static final /* enum */ ID BIfmaf = new ID(BIfma.getValue() + 1);
        public static final /* enum */ ID BIfmal = new ID(BIfmaf.getValue() + 1);
        public static final /* enum */ ID BIfmax = new ID(BIfmal.getValue() + 1);
        public static final /* enum */ ID BIfmaxf = new ID(BIfmax.getValue() + 1);
        public static final /* enum */ ID BIfmaxl = new ID(BIfmaxf.getValue() + 1);
        public static final /* enum */ ID BIfmin = new ID(BIfmaxl.getValue() + 1);
        public static final /* enum */ ID BIfminf = new ID(BIfmin.getValue() + 1);
        public static final /* enum */ ID BIfminl = new ID(BIfminf.getValue() + 1);
        public static final /* enum */ ID BIhypot = new ID(BIfminl.getValue() + 1);
        public static final /* enum */ ID BIhypotf = new ID(BIhypot.getValue() + 1);
        public static final /* enum */ ID BIhypotl = new ID(BIhypotf.getValue() + 1);
        public static final /* enum */ ID BIilogb = new ID(BIhypotl.getValue() + 1);
        public static final /* enum */ ID BIilogbf = new ID(BIilogb.getValue() + 1);
        public static final /* enum */ ID BIilogbl = new ID(BIilogbf.getValue() + 1);
        public static final /* enum */ ID BIlgamma = new ID(BIilogbl.getValue() + 1);
        public static final /* enum */ ID BIlgammaf = new ID(BIlgamma.getValue() + 1);
        public static final /* enum */ ID BIlgammal = new ID(BIlgammaf.getValue() + 1);
        public static final /* enum */ ID BIllrint = new ID(BIlgammal.getValue() + 1);
        public static final /* enum */ ID BIllrintf = new ID(BIllrint.getValue() + 1);
        public static final /* enum */ ID BIllrintl = new ID(BIllrintf.getValue() + 1);
        public static final /* enum */ ID BIllround = new ID(BIllrintl.getValue() + 1);
        public static final /* enum */ ID BIllroundf = new ID(BIllround.getValue() + 1);
        public static final /* enum */ ID BIllroundl = new ID(BIllroundf.getValue() + 1);
        public static final /* enum */ ID BIlog = new ID(BIllroundl.getValue() + 1);
        public static final /* enum */ ID BIlogf = new ID(BIlog.getValue() + 1);
        public static final /* enum */ ID BIlogl = new ID(BIlogf.getValue() + 1);
        public static final /* enum */ ID BIlog10 = new ID(BIlogl.getValue() + 1);
        public static final /* enum */ ID BIlog10f = new ID(BIlog10.getValue() + 1);
        public static final /* enum */ ID BIlog10l = new ID(BIlog10f.getValue() + 1);
        public static final /* enum */ ID BIlog1p = new ID(BIlog10l.getValue() + 1);
        public static final /* enum */ ID BIlog1pf = new ID(BIlog1p.getValue() + 1);
        public static final /* enum */ ID BIlog1pl = new ID(BIlog1pf.getValue() + 1);
        public static final /* enum */ ID BIlog2 = new ID(BIlog1pl.getValue() + 1);
        public static final /* enum */ ID BIlog2f = new ID(BIlog2.getValue() + 1);
        public static final /* enum */ ID BIlog2l = new ID(BIlog2f.getValue() + 1);
        public static final /* enum */ ID BIlogb = new ID(BIlog2l.getValue() + 1);
        public static final /* enum */ ID BIlogbf = new ID(BIlogb.getValue() + 1);
        public static final /* enum */ ID BIlogbl = new ID(BIlogbf.getValue() + 1);
        public static final /* enum */ ID BIlrint = new ID(BIlogbl.getValue() + 1);
        public static final /* enum */ ID BIlrintf = new ID(BIlrint.getValue() + 1);
        public static final /* enum */ ID BIlrintl = new ID(BIlrintf.getValue() + 1);
        public static final /* enum */ ID BIlround = new ID(BIlrintl.getValue() + 1);
        public static final /* enum */ ID BIlroundf = new ID(BIlround.getValue() + 1);
        public static final /* enum */ ID BIlroundl = new ID(BIlroundf.getValue() + 1);
        public static final /* enum */ ID BInearbyint = new ID(BIlroundl.getValue() + 1);
        public static final /* enum */ ID BInearbyintf = new ID(BInearbyint.getValue() + 1);
        public static final /* enum */ ID BInearbyintl = new ID(BInearbyintf.getValue() + 1);
        public static final /* enum */ ID BInextafter = new ID(BInearbyintl.getValue() + 1);
        public static final /* enum */ ID BInextafterf = new ID(BInextafter.getValue() + 1);
        public static final /* enum */ ID BInextafterl = new ID(BInextafterf.getValue() + 1);
        public static final /* enum */ ID BInexttoward = new ID(BInextafterl.getValue() + 1);
        public static final /* enum */ ID BInexttowardf = new ID(BInexttoward.getValue() + 1);
        public static final /* enum */ ID BInexttowardl = new ID(BInexttowardf.getValue() + 1);
        public static final /* enum */ ID BIremainder = new ID(BInexttowardl.getValue() + 1);
        public static final /* enum */ ID BIremainderf = new ID(BIremainder.getValue() + 1);
        public static final /* enum */ ID BIremainderl = new ID(BIremainderf.getValue() + 1);
        public static final /* enum */ ID BIrint = new ID(BIremainderl.getValue() + 1);
        public static final /* enum */ ID BIrintf = new ID(BIrint.getValue() + 1);
        public static final /* enum */ ID BIrintl = new ID(BIrintf.getValue() + 1);
        public static final /* enum */ ID BIround = new ID(BIrintl.getValue() + 1);
        public static final /* enum */ ID BIroundf = new ID(BIround.getValue() + 1);
        public static final /* enum */ ID BIroundl = new ID(BIroundf.getValue() + 1);
        public static final /* enum */ ID BIscalbln = new ID(BIroundl.getValue() + 1);
        public static final /* enum */ ID BIscalblnf = new ID(BIscalbln.getValue() + 1);
        public static final /* enum */ ID BIscalblnl = new ID(BIscalblnf.getValue() + 1);
        public static final /* enum */ ID BIscalbn = new ID(BIscalblnl.getValue() + 1);
        public static final /* enum */ ID BIscalbnf = new ID(BIscalbn.getValue() + 1);
        public static final /* enum */ ID BIscalbnl = new ID(BIscalbnf.getValue() + 1);
        public static final /* enum */ ID BIsin = new ID(BIscalbnl.getValue() + 1);
        public static final /* enum */ ID BIsinf = new ID(BIsin.getValue() + 1);
        public static final /* enum */ ID BIsinl = new ID(BIsinf.getValue() + 1);
        public static final /* enum */ ID BIsinh = new ID(BIsinl.getValue() + 1);
        public static final /* enum */ ID BIsinhf = new ID(BIsinh.getValue() + 1);
        public static final /* enum */ ID BIsinhl = new ID(BIsinhf.getValue() + 1);
        public static final /* enum */ ID BIsqrt = new ID(BIsinhl.getValue() + 1);
        public static final /* enum */ ID BIsqrtf = new ID(BIsqrt.getValue() + 1);
        public static final /* enum */ ID BIsqrtl = new ID(BIsqrtf.getValue() + 1);
        public static final /* enum */ ID BItan = new ID(BIsqrtl.getValue() + 1);
        public static final /* enum */ ID BItanf = new ID(BItan.getValue() + 1);
        public static final /* enum */ ID BItanl = new ID(BItanf.getValue() + 1);
        public static final /* enum */ ID BItanh = new ID(BItanl.getValue() + 1);
        public static final /* enum */ ID BItanhf = new ID(BItanh.getValue() + 1);
        public static final /* enum */ ID BItanhl = new ID(BItanhf.getValue() + 1);
        public static final /* enum */ ID BItgamma = new ID(BItanhl.getValue() + 1);
        public static final /* enum */ ID BItgammaf = new ID(BItgamma.getValue() + 1);
        public static final /* enum */ ID BItgammal = new ID(BItgammaf.getValue() + 1);
        public static final /* enum */ ID BItrunc = new ID(BItgammal.getValue() + 1);
        public static final /* enum */ ID BItruncf = new ID(BItrunc.getValue() + 1);
        public static final /* enum */ ID BItruncl = new ID(BItruncf.getValue() + 1);
        public static final /* enum */ ID BIcabs = new ID(BItruncl.getValue() + 1);
        public static final /* enum */ ID BIcabsf = new ID(BIcabs.getValue() + 1);
        public static final /* enum */ ID BIcabsl = new ID(BIcabsf.getValue() + 1);
        public static final /* enum */ ID BIcacos = new ID(BIcabsl.getValue() + 1);
        public static final /* enum */ ID BIcacosf = new ID(BIcacos.getValue() + 1);
        public static final /* enum */ ID BIcacosl = new ID(BIcacosf.getValue() + 1);
        public static final /* enum */ ID BIcacosh = new ID(BIcacosl.getValue() + 1);
        public static final /* enum */ ID BIcacoshf = new ID(BIcacosh.getValue() + 1);
        public static final /* enum */ ID BIcacoshl = new ID(BIcacoshf.getValue() + 1);
        public static final /* enum */ ID BIcarg = new ID(BIcacoshl.getValue() + 1);
        public static final /* enum */ ID BIcargf = new ID(BIcarg.getValue() + 1);
        public static final /* enum */ ID BIcargl = new ID(BIcargf.getValue() + 1);
        public static final /* enum */ ID BIcasin = new ID(BIcargl.getValue() + 1);
        public static final /* enum */ ID BIcasinf = new ID(BIcasin.getValue() + 1);
        public static final /* enum */ ID BIcasinl = new ID(BIcasinf.getValue() + 1);
        public static final /* enum */ ID BIcasinh = new ID(BIcasinl.getValue() + 1);
        public static final /* enum */ ID BIcasinhf = new ID(BIcasinh.getValue() + 1);
        public static final /* enum */ ID BIcasinhl = new ID(BIcasinhf.getValue() + 1);
        public static final /* enum */ ID BIcatan = new ID(BIcasinhl.getValue() + 1);
        public static final /* enum */ ID BIcatanf = new ID(BIcatan.getValue() + 1);
        public static final /* enum */ ID BIcatanl = new ID(BIcatanf.getValue() + 1);
        public static final /* enum */ ID BIcatanh = new ID(BIcatanl.getValue() + 1);
        public static final /* enum */ ID BIcatanhf = new ID(BIcatanh.getValue() + 1);
        public static final /* enum */ ID BIcatanhl = new ID(BIcatanhf.getValue() + 1);
        public static final /* enum */ ID BIccos = new ID(BIcatanhl.getValue() + 1);
        public static final /* enum */ ID BIccosf = new ID(BIccos.getValue() + 1);
        public static final /* enum */ ID BIccosl = new ID(BIccosf.getValue() + 1);
        public static final /* enum */ ID BIccosh = new ID(BIccosl.getValue() + 1);
        public static final /* enum */ ID BIccoshf = new ID(BIccosh.getValue() + 1);
        public static final /* enum */ ID BIccoshl = new ID(BIccoshf.getValue() + 1);
        public static final /* enum */ ID BIcexp = new ID(BIccoshl.getValue() + 1);
        public static final /* enum */ ID BIcexpf = new ID(BIcexp.getValue() + 1);
        public static final /* enum */ ID BIcexpl = new ID(BIcexpf.getValue() + 1);
        public static final /* enum */ ID BIcimag = new ID(BIcexpl.getValue() + 1);
        public static final /* enum */ ID BIcimagf = new ID(BIcimag.getValue() + 1);
        public static final /* enum */ ID BIcimagl = new ID(BIcimagf.getValue() + 1);
        public static final /* enum */ ID BIconj = new ID(BIcimagl.getValue() + 1);
        public static final /* enum */ ID BIconjf = new ID(BIconj.getValue() + 1);
        public static final /* enum */ ID BIconjl = new ID(BIconjf.getValue() + 1);
        public static final /* enum */ ID BIclog = new ID(BIconjl.getValue() + 1);
        public static final /* enum */ ID BIclogf = new ID(BIclog.getValue() + 1);
        public static final /* enum */ ID BIclogl = new ID(BIclogf.getValue() + 1);
        public static final /* enum */ ID BIcproj = new ID(BIclogl.getValue() + 1);
        public static final /* enum */ ID BIcprojf = new ID(BIcproj.getValue() + 1);
        public static final /* enum */ ID BIcprojl = new ID(BIcprojf.getValue() + 1);
        public static final /* enum */ ID BIcpow = new ID(BIcprojl.getValue() + 1);
        public static final /* enum */ ID BIcpowf = new ID(BIcpow.getValue() + 1);
        public static final /* enum */ ID BIcpowl = new ID(BIcpowf.getValue() + 1);
        public static final /* enum */ ID BIcreal = new ID(BIcpowl.getValue() + 1);
        public static final /* enum */ ID BIcrealf = new ID(BIcreal.getValue() + 1);
        public static final /* enum */ ID BIcreall = new ID(BIcrealf.getValue() + 1);
        public static final /* enum */ ID BIcsin = new ID(BIcreall.getValue() + 1);
        public static final /* enum */ ID BIcsinf = new ID(BIcsin.getValue() + 1);
        public static final /* enum */ ID BIcsinl = new ID(BIcsinf.getValue() + 1);
        public static final /* enum */ ID BIcsinh = new ID(BIcsinl.getValue() + 1);
        public static final /* enum */ ID BIcsinhf = new ID(BIcsinh.getValue() + 1);
        public static final /* enum */ ID BIcsinhl = new ID(BIcsinhf.getValue() + 1);
        public static final /* enum */ ID BIcsqrt = new ID(BIcsinhl.getValue() + 1);
        public static final /* enum */ ID BIcsqrtf = new ID(BIcsqrt.getValue() + 1);
        public static final /* enum */ ID BIcsqrtl = new ID(BIcsqrtf.getValue() + 1);
        public static final /* enum */ ID BIctan = new ID(BIcsqrtl.getValue() + 1);
        public static final /* enum */ ID BIctanf = new ID(BIctan.getValue() + 1);
        public static final /* enum */ ID BIctanl = new ID(BIctanf.getValue() + 1);
        public static final /* enum */ ID BIctanh = new ID(BIctanl.getValue() + 1);
        public static final /* enum */ ID BIctanhf = new ID(BIctanh.getValue() + 1);
        public static final /* enum */ ID BIctanhl = new ID(BIctanhf.getValue() + 1);
        public static final /* enum */ ID BI__sinpi = new ID(BIctanhl.getValue() + 1);
        public static final /* enum */ ID BI__sinpif = new ID(BI__sinpi.getValue() + 1);
        public static final /* enum */ ID BI__cospi = new ID(BI__sinpif.getValue() + 1);
        public static final /* enum */ ID BI__cospif = new ID(BI__cospi.getValue() + 1);
        public static final /* enum */ ID BI__tanpi = new ID(BI__cospif.getValue() + 1);
        public static final /* enum */ ID BI__tanpif = new ID(BI__tanpi.getValue() + 1);
        public static final /* enum */ ID BI__exp10 = new ID(BI__tanpif.getValue() + 1);
        public static final /* enum */ ID BI__exp10f = new ID(BI__exp10.getValue() + 1);
        public static final /* enum */ ID BI_Block_object_assign = new ID(BI__exp10f.getValue() + 1);
        public static final /* enum */ ID BI_Block_object_dispose = new ID(BI_Block_object_assign.getValue() + 1);
        public static final /* enum */ ID BI__builtin_annotation = new ID(BI_Block_object_dispose.getValue() + 1);
        public static final /* enum */ ID BI__builtin_assume = new ID(BI__builtin_annotation.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addcb = new ID(BI__builtin_assume.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addcs = new ID(BI__builtin_addcb.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addc = new ID(BI__builtin_addcs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addcl = new ID(BI__builtin_addc.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addcll = new ID(BI__builtin_addcl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_subcb = new ID(BI__builtin_addcll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_subcs = new ID(BI__builtin_subcb.getValue() + 1);
        public static final /* enum */ ID BI__builtin_subc = new ID(BI__builtin_subcs.getValue() + 1);
        public static final /* enum */ ID BI__builtin_subcl = new ID(BI__builtin_subc.getValue() + 1);
        public static final /* enum */ ID BI__builtin_subcll = new ID(BI__builtin_subcl.getValue() + 1);
        public static final /* enum */ ID BI__builtin_add_overflow = new ID(BI__builtin_subcll.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sub_overflow = new ID(BI__builtin_add_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_mul_overflow = new ID(BI__builtin_sub_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_uadd_overflow = new ID(BI__builtin_mul_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_uaddl_overflow = new ID(BI__builtin_uadd_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_uaddll_overflow = new ID(BI__builtin_uaddl_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_usub_overflow = new ID(BI__builtin_uaddll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_usubl_overflow = new ID(BI__builtin_usub_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_usubll_overflow = new ID(BI__builtin_usubl_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_umul_overflow = new ID(BI__builtin_usubll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_umull_overflow = new ID(BI__builtin_umul_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_umulll_overflow = new ID(BI__builtin_umull_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_sadd_overflow = new ID(BI__builtin_umulll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_saddl_overflow = new ID(BI__builtin_sadd_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_saddll_overflow = new ID(BI__builtin_saddl_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ssub_overflow = new ID(BI__builtin_saddll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ssubl_overflow = new ID(BI__builtin_ssub_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_ssubll_overflow = new ID(BI__builtin_ssubl_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_smul_overflow = new ID(BI__builtin_ssubll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_smull_overflow = new ID(BI__builtin_smul_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_smulll_overflow = new ID(BI__builtin_smull_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_addressof = new ID(BI__builtin_smulll_overflow.getValue() + 1);
        public static final /* enum */ ID BI__builtin_operator_new = new ID(BI__builtin_addressof.getValue() + 1);
        public static final /* enum */ ID BI__builtin_operator_delete = new ID(BI__builtin_operator_new.getValue() + 1);
        public static final /* enum */ ID BI__builtin___get_unsafe_stack_start = new ID(BI__builtin_operator_delete.getValue() + 1);
        public static final /* enum */ ID BI__builtin___get_unsafe_stack_ptr = new ID(BI__builtin___get_unsafe_stack_start.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nontemporal_store = new ID(BI__builtin___get_unsafe_stack_ptr.getValue() + 1);
        public static final /* enum */ ID BI__builtin_nontemporal_load = new ID(BI__builtin_nontemporal_store.getValue() + 1);
        public static final /* enum */ ID BIread_pipe = new ID(BI__builtin_nontemporal_load.getValue() + 1);
        public static final /* enum */ ID BIwrite_pipe = new ID(BIread_pipe.getValue() + 1);
        public static final /* enum */ ID BIreserve_read_pipe = new ID(BIwrite_pipe.getValue() + 1);
        public static final /* enum */ ID BIreserve_write_pipe = new ID(BIreserve_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIcommit_write_pipe = new ID(BIreserve_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIcommit_read_pipe = new ID(BIcommit_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIsub_group_reserve_read_pipe = new ID(BIcommit_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIsub_group_reserve_write_pipe = new ID(BIsub_group_reserve_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIsub_group_commit_read_pipe = new ID(BIsub_group_reserve_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIsub_group_commit_write_pipe = new ID(BIsub_group_commit_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIwork_group_reserve_read_pipe = new ID(BIsub_group_commit_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIwork_group_reserve_write_pipe = new ID(BIwork_group_reserve_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIwork_group_commit_read_pipe = new ID(BIwork_group_reserve_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIwork_group_commit_write_pipe = new ID(BIwork_group_commit_read_pipe.getValue() + 1);
        public static final /* enum */ ID BIget_pipe_num_packets = new ID(BIwork_group_commit_write_pipe.getValue() + 1);
        public static final /* enum */ ID BIget_pipe_max_packets = new ID(BIget_pipe_num_packets.getValue() + 1);
        public static final /* enum */ ID BIenqueue_kernel = new ID(BIget_pipe_max_packets.getValue() + 1);
        public static final /* enum */ ID BIget_kernel_work_group_size = new ID(BIenqueue_kernel.getValue() + 1);
        public static final /* enum */ ID BIget_kernel_preferred_work_group_size_multiple = new ID(BIget_kernel_work_group_size.getValue() + 1);
        public static final /* enum */ ID BIto_global = new ID(BIget_kernel_preferred_work_group_size_multiple.getValue() + 1);
        public static final /* enum */ ID BIto_local = new ID(BIto_global.getValue() + 1);
        public static final /* enum */ ID BIto_private = new ID(BIto_local.getValue() + 1);
        public static final /* enum */ ID FirstTSBuiltin = new ID(BIto_private.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ID[] $VALUES;

        public static ID[] values() {
            return (ID[])$VALUES.clone();
        }

        public static ID valueOf(String name) {
            return Enum.valueOf(ID.class, name);
        }

        public static ID valueOf(int val) {
            ID out;
            ID iD = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ID(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ID)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ID)((Object)obj)).value);
        }

        /*
         * Opcode count of 13603 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        static {
            $VALUES = new ID[]{NotBuiltin, BI__builtin_atan2, BI__builtin_atan2f, BI__builtin_atan2l, BI__builtin_abs, BI__builtin_copysign, BI__builtin_copysignf, BI__builtin_copysignl, BI__builtin_fabs, BI__builtin_fabsf, BI__builtin_fabsl, BI__builtin_fmod, BI__builtin_fmodf, BI__builtin_fmodl, BI__builtin_frexp, BI__builtin_frexpf, BI__builtin_frexpl, BI__builtin_huge_val, BI__builtin_huge_valf, BI__builtin_huge_vall, BI__builtin_inf, BI__builtin_inff, BI__builtin_infl, BI__builtin_labs, BI__builtin_llabs, BI__builtin_ldexp, BI__builtin_ldexpf, BI__builtin_ldexpl, BI__builtin_modf, BI__builtin_modff, BI__builtin_modfl, BI__builtin_nan, BI__builtin_nanf, BI__builtin_nanl, BI__builtin_nans, BI__builtin_nansf, BI__builtin_nansl, BI__builtin_powi, BI__builtin_powif, BI__builtin_powil, BI__builtin_pow, BI__builtin_powf, BI__builtin_powl, BI__builtin_acos, BI__builtin_acosf, BI__builtin_acosl, BI__builtin_acosh, BI__builtin_acoshf, BI__builtin_acoshl, BI__builtin_asin, BI__builtin_asinf, BI__builtin_asinl, BI__builtin_asinh, BI__builtin_asinhf, BI__builtin_asinhl, BI__builtin_atan, BI__builtin_atanf, BI__builtin_atanl, BI__builtin_atanh, BI__builtin_atanhf, BI__builtin_atanhl, BI__builtin_cbrt, BI__builtin_cbrtf, BI__builtin_cbrtl, BI__builtin_ceil, BI__builtin_ceilf, BI__builtin_ceill, BI__builtin_cos, BI__builtin_cosf, BI__builtin_cosh, BI__builtin_coshf, BI__builtin_coshl, BI__builtin_cosl, BI__builtin_erf, BI__builtin_erff, BI__builtin_erfl, BI__builtin_erfc, BI__builtin_erfcf, BI__builtin_erfcl, BI__builtin_exp, BI__builtin_expf, BI__builtin_expl, BI__builtin_exp2, BI__builtin_exp2f, BI__builtin_exp2l, BI__builtin_expm1, BI__builtin_expm1f, BI__builtin_expm1l, BI__builtin_fdim, BI__builtin_fdimf, BI__builtin_fdiml, BI__builtin_floor, BI__builtin_floorf, BI__builtin_floorl, BI__builtin_fma, BI__builtin_fmaf, BI__builtin_fmal, BI__builtin_fmax, BI__builtin_fmaxf, BI__builtin_fmaxl, BI__builtin_fmin, BI__builtin_fminf, BI__builtin_fminl, BI__builtin_hypot, BI__builtin_hypotf, BI__builtin_hypotl, BI__builtin_ilogb, BI__builtin_ilogbf, BI__builtin_ilogbl, BI__builtin_lgamma, BI__builtin_lgammaf, BI__builtin_lgammal, BI__builtin_llrint, BI__builtin_llrintf, BI__builtin_llrintl, BI__builtin_llround, BI__builtin_llroundf, BI__builtin_llroundl, BI__builtin_log, BI__builtin_log10, BI__builtin_log10f, BI__builtin_log10l, BI__builtin_log1p, BI__builtin_log1pf, BI__builtin_log1pl, BI__builtin_log2, BI__builtin_log2f, BI__builtin_log2l, BI__builtin_logb, BI__builtin_logbf, BI__builtin_logbl, BI__builtin_logf, BI__builtin_logl, BI__builtin_lrint, BI__builtin_lrintf, BI__builtin_lrintl, BI__builtin_lround, BI__builtin_lroundf, BI__builtin_lroundl, BI__builtin_nearbyint, BI__builtin_nearbyintf, BI__builtin_nearbyintl, BI__builtin_nextafter, BI__builtin_nextafterf, BI__builtin_nextafterl, BI__builtin_nexttoward, BI__builtin_nexttowardf, BI__builtin_nexttowardl, BI__builtin_remainder, BI__builtin_remainderf, BI__builtin_remainderl, BI__builtin_remquo, BI__builtin_remquof, BI__builtin_remquol, BI__builtin_rint, BI__builtin_rintf, BI__builtin_rintl, BI__builtin_round, BI__builtin_roundf, BI__builtin_roundl, BI__builtin_scalbln, BI__builtin_scalblnf, BI__builtin_scalblnl, BI__builtin_scalbn, BI__builtin_scalbnf, BI__builtin_scalbnl, BI__builtin_sin, BI__builtin_sinf, BI__builtin_sinh, BI__builtin_sinhf, BI__builtin_sinhl, BI__builtin_sinl, BI__builtin_sqrt, BI__builtin_sqrtf, BI__builtin_sqrtl, BI__builtin_tan, BI__builtin_tanf, BI__builtin_tanh, BI__builtin_tanhf, BI__builtin_tanhl, BI__builtin_tanl, BI__builtin_tgamma, BI__builtin_tgammaf, BI__builtin_tgammal, BI__builtin_trunc, BI__builtin_truncf, BI__builtin_truncl, BI__builtin_cabs, BI__builtin_cabsf, BI__builtin_cabsl, BI__builtin_cacos, BI__builtin_cacosf, BI__builtin_cacosh, BI__builtin_cacoshf, BI__builtin_cacoshl, BI__builtin_cacosl, BI__builtin_carg, BI__builtin_cargf, BI__builtin_cargl, BI__builtin_casin, BI__builtin_casinf, BI__builtin_casinh, BI__builtin_casinhf, BI__builtin_casinhl, BI__builtin_casinl, BI__builtin_catan, BI__builtin_catanf, BI__builtin_catanh, BI__builtin_catanhf, BI__builtin_catanhl, BI__builtin_catanl, BI__builtin_ccos, BI__builtin_ccosf, BI__builtin_ccosl, BI__builtin_ccosh, BI__builtin_ccoshf, BI__builtin_ccoshl, BI__builtin_cexp, BI__builtin_cexpf, BI__builtin_cexpl, BI__builtin_cimag, BI__builtin_cimagf, BI__builtin_cimagl, BI__builtin_conj, BI__builtin_conjf, BI__builtin_conjl, BI__builtin_clog, BI__builtin_clogf, BI__builtin_clogl, BI__builtin_cproj, BI__builtin_cprojf, BI__builtin_cprojl, BI__builtin_cpow, BI__builtin_cpowf, BI__builtin_cpowl, BI__builtin_creal, BI__builtin_crealf, BI__builtin_creall, BI__builtin_csin, BI__builtin_csinf, BI__builtin_csinl, BI__builtin_csinh, BI__builtin_csinhf, BI__builtin_csinhl, BI__builtin_csqrt, BI__builtin_csqrtf, BI__builtin_csqrtl, BI__builtin_ctan, BI__builtin_ctanf, BI__builtin_ctanl, BI__builtin_ctanh, BI__builtin_ctanhf, BI__builtin_ctanhl, BI__builtin_isgreater, BI__builtin_isgreaterequal, BI__builtin_isless, BI__builtin_islessequal, BI__builtin_islessgreater, BI__builtin_isunordered, BI__builtin_fpclassify, BI__builtin_isfinite, BI__builtin_isinf, BI__builtin_isinf_sign, BI__builtin_isnan, BI__builtin_isnormal, BI__builtin_signbit, BI__builtin_signbitf, BI__builtin_signbitl, BI__builtin_canonicalize, BI__builtin_canonicalizef, BI__builtin_canonicalizel, BI__builtin_clzs, BI__builtin_clz, BI__builtin_clzl, BI__builtin_clzll, BI__builtin_ctzs, BI__builtin_ctz, BI__builtin_ctzl, BI__builtin_ctzll, BI__builtin_ffs, BI__builtin_ffsl, BI__builtin_ffsll, BI__builtin_parity, BI__builtin_parityl, BI__builtin_parityll, BI__builtin_popcount, BI__builtin_popcountl, BI__builtin_popcountll, BI__builtin_bswap16, BI__builtin_bswap32, BI__builtin_bswap64, BI__builtin_bitreverse8, BI__builtin_bitreverse16, BI__builtin_bitreverse32, BI__builtin_bitreverse64, BI__builtin_constant_p, BI__builtin_classify_type, BI__builtin___CFStringMakeConstantString, BI__builtin___NSStringMakeConstantString, BI__builtin_va_start, BI__builtin_va_end, BI__builtin_va_copy, BI__builtin_stdarg_start, BI__builtin_assume_aligned, BI__builtin_bcmp, BI__builtin_bcopy, BI__builtin_bzero, BI__builtin_fprintf, BI__builtin_memchr, BI__builtin_memcmp, BI__builtin_memcpy, BI__builtin_memmove, BI__builtin_mempcpy, BI__builtin_memset, BI__builtin_printf, BI__builtin_stpcpy, BI__builtin_stpncpy, BI__builtin_strcasecmp, BI__builtin_strcat, BI__builtin_strchr, BI__builtin_strcmp, BI__builtin_strcpy, BI__builtin_strcspn, BI__builtin_strdup, BI__builtin_strlen, BI__builtin_strncasecmp, BI__builtin_strncat, BI__builtin_strncmp, BI__builtin_strncpy, BI__builtin_strndup, BI__builtin_strpbrk, BI__builtin_strrchr, BI__builtin_strspn, BI__builtin_strstr, BI__builtin_return_address, BI__builtin_extract_return_addr, BI__builtin_frame_address, BI__builtin___clear_cache, BI__builtin_flt_rounds, BI__builtin_setjmp, BI__builtin_longjmp, BI__builtin_unwind_init, BI__builtin_eh_return_data_regno, BI__builtin_snprintf, BI__builtin_vsprintf, BI__builtin_vsnprintf, BI__builtin_thread_pointer, BI__builtin_eh_return, BI__builtin_frob_return_addr, BI__builtin_dwarf_cfa, BI__builtin_init_dwarf_reg_size_table, BI__builtin_dwarf_sp_column, BI__builtin_extend_pointer, BI__builtin_object_size, BI__builtin___memcpy_chk, BI__builtin___memccpy_chk, BI__builtin___memmove_chk, BI__builtin___mempcpy_chk, BI__builtin___memset_chk, BI__builtin___stpcpy_chk, BI__builtin___strcat_chk, BI__builtin___strcpy_chk, BI__builtin___strlcat_chk, BI__builtin___strlcpy_chk, BI__builtin___strncat_chk, BI__builtin___strncpy_chk, BI__builtin___stpncpy_chk, BI__builtin___snprintf_chk, BI__builtin___sprintf_chk, BI__builtin___vsnprintf_chk, BI__builtin___vsprintf_chk, BI__builtin___fprintf_chk, BI__builtin___printf_chk, BI__builtin___vfprintf_chk, BI__builtin___vprintf_chk, BI__builtin_unpredictable, BI__builtin_expect, BI__builtin_prefetch, BI__builtin_readcyclecounter, BI__builtin_trap, BI__builtin_debugtrap, BI__builtin_unreachable, BI__builtin_shufflevector, BI__builtin_convertvector, BI__builtin_alloca, BI__builtin_call_with_static_chain, BI__sync_fetch_and_add, BI__sync_fetch_and_add_1, BI__sync_fetch_and_add_2, BI__sync_fetch_and_add_4, BI__sync_fetch_and_add_8, BI__sync_fetch_and_add_16, BI__sync_fetch_and_sub, BI__sync_fetch_and_sub_1, BI__sync_fetch_and_sub_2, BI__sync_fetch_and_sub_4, BI__sync_fetch_and_sub_8, BI__sync_fetch_and_sub_16, BI__sync_fetch_and_or, BI__sync_fetch_and_or_1, BI__sync_fetch_and_or_2, BI__sync_fetch_and_or_4, BI__sync_fetch_and_or_8, BI__sync_fetch_and_or_16, BI__sync_fetch_and_and, BI__sync_fetch_and_and_1, BI__sync_fetch_and_and_2, BI__sync_fetch_and_and_4, BI__sync_fetch_and_and_8, BI__sync_fetch_and_and_16, BI__sync_fetch_and_xor, BI__sync_fetch_and_xor_1, BI__sync_fetch_and_xor_2, BI__sync_fetch_and_xor_4, BI__sync_fetch_and_xor_8, BI__sync_fetch_and_xor_16, BI__sync_fetch_and_nand, BI__sync_fetch_and_nand_1, BI__sync_fetch_and_nand_2, BI__sync_fetch_and_nand_4, BI__sync_fetch_and_nand_8, BI__sync_fetch_and_nand_16, BI__sync_add_and_fetch, BI__sync_add_and_fetch_1, BI__sync_add_and_fetch_2, BI__sync_add_and_fetch_4, BI__sync_add_and_fetch_8, BI__sync_add_and_fetch_16, BI__sync_sub_and_fetch, BI__sync_sub_and_fetch_1, BI__sync_sub_and_fetch_2, BI__sync_sub_and_fetch_4, BI__sync_sub_and_fetch_8, BI__sync_sub_and_fetch_16, BI__sync_or_and_fetch, BI__sync_or_and_fetch_1, BI__sync_or_and_fetch_2, BI__sync_or_and_fetch_4, BI__sync_or_and_fetch_8, BI__sync_or_and_fetch_16, BI__sync_and_and_fetch, BI__sync_and_and_fetch_1, BI__sync_and_and_fetch_2, BI__sync_and_and_fetch_4, BI__sync_and_and_fetch_8, BI__sync_and_and_fetch_16, BI__sync_xor_and_fetch, BI__sync_xor_and_fetch_1, BI__sync_xor_and_fetch_2, BI__sync_xor_and_fetch_4, BI__sync_xor_and_fetch_8, BI__sync_xor_and_fetch_16, BI__sync_nand_and_fetch, BI__sync_nand_and_fetch_1, BI__sync_nand_and_fetch_2, BI__sync_nand_and_fetch_4, BI__sync_nand_and_fetch_8, BI__sync_nand_and_fetch_16, BI__sync_bool_compare_and_swap, BI__sync_bool_compare_and_swap_1, BI__sync_bool_compare_and_swap_2, BI__sync_bool_compare_and_swap_4, BI__sync_bool_compare_and_swap_8, BI__sync_bool_compare_and_swap_16, BI__sync_val_compare_and_swap, BI__sync_val_compare_and_swap_1, BI__sync_val_compare_and_swap_2, BI__sync_val_compare_and_swap_4, BI__sync_val_compare_and_swap_8, BI__sync_val_compare_and_swap_16, BI__sync_lock_test_and_set, BI__sync_lock_test_and_set_1, BI__sync_lock_test_and_set_2, BI__sync_lock_test_and_set_4, BI__sync_lock_test_and_set_8, BI__sync_lock_test_and_set_16, BI__sync_lock_release, BI__sync_lock_release_1, BI__sync_lock_release_2, BI__sync_lock_release_4, BI__sync_lock_release_8, BI__sync_lock_release_16, BI__sync_swap, BI__sync_swap_1, BI__sync_swap_2, BI__sync_swap_4, BI__sync_swap_8, BI__sync_swap_16, BI__c11_atomic_init, BI__c11_atomic_load, BI__c11_atomic_store, BI__c11_atomic_exchange, BI__c11_atomic_compare_exchange_strong, BI__c11_atomic_compare_exchange_weak, BI__c11_atomic_fetch_add, BI__c11_atomic_fetch_sub, BI__c11_atomic_fetch_and, BI__c11_atomic_fetch_or, BI__c11_atomic_fetch_xor, BI__c11_atomic_thread_fence, BI__c11_atomic_signal_fence, BI__c11_atomic_is_lock_free, BI__atomic_load, BI__atomic_load_n, BI__atomic_store, BI__atomic_store_n, BI__atomic_exchange, BI__atomic_exchange_n, BI__atomic_compare_exchange, BI__atomic_compare_exchange_n, BI__atomic_fetch_add, BI__atomic_fetch_sub, BI__atomic_fetch_and, BI__atomic_fetch_or, BI__atomic_fetch_xor, BI__atomic_fetch_nand, BI__atomic_add_fetch, BI__atomic_sub_fetch, BI__atomic_and_fetch, BI__atomic_or_fetch, BI__atomic_xor_fetch, BI__atomic_nand_fetch, BI__atomic_test_and_set, BI__atomic_clear, BI__atomic_thread_fence, BI__atomic_signal_fence, BI__atomic_always_lock_free, BI__atomic_is_lock_free, BI__sync_synchronize, BI__sync_fetch_and_min, BI__sync_fetch_and_max, BI__sync_fetch_and_umin, BI__sync_fetch_and_umax, BI__builtin_abort, BI__builtin_index, BI__builtin_rindex, BI_alloca, BI__assume, BI__debugbreak, BI__exception_code, BI_exception_code, BI__exception_info, BI_exception_info, BI__abnormal_termination, BI_abnormal_termination, BI__GetExceptionInfo, BI_InterlockedCompareExchange, BI_InterlockedCompareExchangePointer, BI_InterlockedDecrement, BI_InterlockedExchangeAdd, BI_InterlockedExchange, BI_InterlockedExchangePointer, BI_InterlockedIncrement, BI__noop, BI__readfsdword, BI__va_start, BI_setjmpex, BIabort, BIcalloc, BIexit, BI_Exit, BImalloc, BIrealloc, BImemcpy, BImemcmp, BImemmove, BIstrcpy, BIstrncpy, BIstrcmp, BIstrncmp, BIstrcat, BIstrncat, BIstrxfrm, BImemchr, BIstrchr, BIstrcspn, BIstrpbrk, BIstrrchr, BIstrspn, BIstrstr, BIstrtok, BImemset, BIstrerror, BIstrlen, BIprintf, BIfprintf, BIsnprintf, BIsprintf, BIvprintf, BIvfprintf, BIvsnprintf, BIvsprintf, BIscanf, BIfscanf, BIsscanf, BIvscanf, BIvfscanf, BIvsscanf, BIisalnum, BIisalpha, BIisblank, BIiscntrl, BIisdigit, BIisgraph, BIislower, BIisprint, BIispunct, BIisspace, BIisupper, BIisxdigit, BItolower, BItoupper, BIsetjmp, BIlongjmp, BIalloca, BIstpcpy, BIstpncpy, BIstrdup, BIstrndup, BIindex, BIrindex, BIbzero, BIstrcasecmp, BIstrncasecmp, BI_exit, BIvfork, BI_setjmp, BI__sigsetjmp, BIsigsetjmp, BIsetjmp_syscall, BIsavectx, BIqsetjmp, BIgetcontext, BI_longjmp, BIsiglongjmp, BIstrlcpy, BIstrlcat, BIobjc_msgSend, BIobjc_msgSend_fpret, BIobjc_msgSend_fp2ret, BIobjc_msgSend_stret, BIobjc_msgSendSuper, BIobjc_msgSendSuper_stret, BIobjc_getClass, BIobjc_getMetaClass, BIobjc_enumerationMutation, BIobjc_read_weak, BIobjc_assign_weak, BIobjc_assign_ivar, BIobjc_assign_global, BIobjc_assign_strongCast, BIobjc_exception_extract, BIobjc_exception_try_enter, BIobjc_exception_try_exit, BIobjc_exception_match, BIobjc_exception_throw, BIobjc_sync_enter, BIobjc_sync_exit, BI__builtin_objc_memmove_collectable, BINSLog, BINSLogv, BIatan2, BIatan2f, BIatan2l, BIabs, BIlabs, BIllabs, BIcopysign, BIcopysignf, BIcopysignl, BIfabs, BIfabsf, BIfabsl, BIfmod, BIfmodf, BIfmodl, BIfrexp, BIfrexpf, BIfrexpl, BIldexp, BIldexpf, BIldexpl, BImodf, BImodff, BImodfl, BInan, BInanf, BInanl, BIpow, BIpowf, BIpowl, BIacos, BIacosf, BIacosl, BIacosh, BIacoshf, BIacoshl, BIasin, BIasinf, BIasinl, BIasinh, BIasinhf, BIasinhl, BIatan, BIatanf, BIatanl, BIatanh, BIatanhf, BIatanhl, BIcbrt, BIcbrtf, BIcbrtl, BIceil, BIceilf, BIceill, BIcos, BIcosf, BIcosl, BIcosh, BIcoshf, BIcoshl, BIerf, BIerff, BIerfl, BIerfc, BIerfcf, BIerfcl, BIexp, BIexpf, BIexpl, BIexp2, BIexp2f, BIexp2l, BIexpm1, BIexpm1f, BIexpm1l, BIfdim, BIfdimf, BIfdiml, BIfloor, BIfloorf, BIfloorl, BIfma, BIfmaf, BIfmal, BIfmax, BIfmaxf, BIfmaxl, BIfmin, BIfminf, BIfminl, BIhypot, BIhypotf, BIhypotl, BIilogb, BIilogbf, BIilogbl, BIlgamma, BIlgammaf, BIlgammal, BIllrint, BIllrintf, BIllrintl, BIllround, BIllroundf, BIllroundl, BIlog, BIlogf, BIlogl, BIlog10, BIlog10f, BIlog10l, BIlog1p, BIlog1pf, BIlog1pl, BIlog2, BIlog2f, BIlog2l, BIlogb, BIlogbf, BIlogbl, BIlrint, BIlrintf, BIlrintl, BIlround, BIlroundf, BIlroundl, BInearbyint, BInearbyintf, BInearbyintl, BInextafter, BInextafterf, BInextafterl, BInexttoward, BInexttowardf, BInexttowardl, BIremainder, BIremainderf, BIremainderl, BIrint, BIrintf, BIrintl, BIround, BIroundf, BIroundl, BIscalbln, BIscalblnf, BIscalblnl, BIscalbn, BIscalbnf, BIscalbnl, BIsin, BIsinf, BIsinl, BIsinh, BIsinhf, BIsinhl, BIsqrt, BIsqrtf, BIsqrtl, BItan, BItanf, BItanl, BItanh, BItanhf, BItanhl, BItgamma, BItgammaf, BItgammal, BItrunc, BItruncf, BItruncl, BIcabs, BIcabsf, BIcabsl, BIcacos, BIcacosf, BIcacosl, BIcacosh, BIcacoshf, BIcacoshl, BIcarg, BIcargf, BIcargl, BIcasin, BIcasinf, BIcasinl, BIcasinh, BIcasinhf, BIcasinhl, BIcatan, BIcatanf, BIcatanl, BIcatanh, BIcatanhf, BIcatanhl, BIccos, BIccosf, BIccosl, BIccosh, BIccoshf, BIccoshl, BIcexp, BIcexpf, BIcexpl, BIcimag, BIcimagf, BIcimagl, BIconj, BIconjf, BIconjl, BIclog, BIclogf, BIclogl, BIcproj, BIcprojf, BIcprojl, BIcpow, BIcpowf, BIcpowl, BIcreal, BIcrealf, BIcreall, BIcsin, BIcsinf, BIcsinl, BIcsinh, BIcsinhf, BIcsinhl, BIcsqrt, BIcsqrtf, BIcsqrtl, BIctan, BIctanf, BIctanl, BIctanh, BIctanhf, BIctanhl, BI__sinpi, BI__sinpif, BI__cospi, BI__cospif, BI__tanpi, BI__tanpif, BI__exp10, BI__exp10f, BI_Block_object_assign, BI_Block_object_dispose, BI__builtin_annotation, BI__builtin_assume, BI__builtin_addcb, BI__builtin_addcs, BI__builtin_addc, BI__builtin_addcl, BI__builtin_addcll, BI__builtin_subcb, BI__builtin_subcs, BI__builtin_subc, BI__builtin_subcl, BI__builtin_subcll, BI__builtin_add_overflow, BI__builtin_sub_overflow, BI__builtin_mul_overflow, BI__builtin_uadd_overflow, BI__builtin_uaddl_overflow, BI__builtin_uaddll_overflow, BI__builtin_usub_overflow, BI__builtin_usubl_overflow, BI__builtin_usubll_overflow, BI__builtin_umul_overflow, BI__builtin_umull_overflow, BI__builtin_umulll_overflow, BI__builtin_sadd_overflow, BI__builtin_saddl_overflow, BI__builtin_saddll_overflow, BI__builtin_ssub_overflow, BI__builtin_ssubl_overflow, BI__builtin_ssubll_overflow, BI__builtin_smul_overflow, BI__builtin_smull_overflow, BI__builtin_smulll_overflow, BI__builtin_addressof, BI__builtin_operator_new, BI__builtin_operator_delete, BI__builtin___get_unsafe_stack_start, BI__builtin___get_unsafe_stack_ptr, BI__builtin_nontemporal_store, BI__builtin_nontemporal_load, BIread_pipe, BIwrite_pipe, BIreserve_read_pipe, BIreserve_write_pipe, BIcommit_write_pipe, BIcommit_read_pipe, BIsub_group_reserve_read_pipe, BIsub_group_reserve_write_pipe, BIsub_group_commit_read_pipe, BIsub_group_commit_write_pipe, BIwork_group_reserve_read_pipe, BIwork_group_reserve_write_pipe, BIwork_group_commit_read_pipe, BIwork_group_commit_write_pipe, BIget_pipe_num_packets, BIget_pipe_max_packets, BIenqueue_kernel, BIget_kernel_work_group_size, BIget_kernel_preferred_work_group_size_multiple, BIto_global, BIto_local, BIto_private, FirstTSBuiltin};
        }

        private static final class Values {
            private static final ID[] VALUES;
            private static final ID[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ID kind : ID.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ID[min < 0 ? 1 - min : 0];
                VALUES = new ID[max >= 0 ? 1 + max : 0];
                for (ID kind : ID.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ID)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ID)kind).value] = kind;
                }
            }
        }
    }
}

