/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.support.SpecialCaseList;

public class SanitizerBlacklist
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<SpecialCaseList> SCL;
    private SourceManager SM;

    public SanitizerBlacklist(std.vectorString BlacklistPaths, SourceManager SM) {
        this.SCL = SpecialCaseList.createOrDie((std.vectorString)BlacklistPaths);
        this.SM = SM;
    }

    public boolean isBlacklistedGlobal(StringRef GlobalName) {
        return this.isBlacklistedGlobal(GlobalName, new StringRef());
    }

    public boolean isBlacklistedGlobal(StringRef GlobalName, StringRef Category) {
        return ((SpecialCaseList)this.SCL.$arrow()).inSection("global", GlobalName, Category);
    }

    public boolean isBlacklistedType(StringRef MangledTypeName) {
        return this.isBlacklistedType(MangledTypeName, new StringRef());
    }

    public boolean isBlacklistedType(StringRef MangledTypeName, StringRef Category) {
        return ((SpecialCaseList)this.SCL.$arrow()).inSection("type", MangledTypeName, Category);
    }

    public boolean isBlacklistedFunction(StringRef FunctionName) {
        return ((SpecialCaseList)this.SCL.$arrow()).inSection("fun", FunctionName);
    }

    public boolean isBlacklistedFile(StringRef FileName) {
        return this.isBlacklistedFile(FileName, new StringRef());
    }

    public boolean isBlacklistedFile(StringRef FileName, StringRef Category) {
        return ((SpecialCaseList)this.SCL.$arrow()).inSection("src", FileName, Category);
    }

    public boolean isBlacklistedLocation(SourceLocation Loc) {
        return this.isBlacklistedLocation(Loc, new StringRef());
    }

    public boolean isBlacklistedLocation(SourceLocation Loc, StringRef Category) {
        return Loc.isValid() && this.isBlacklistedFile(this.SM.getFilename(this.SM.getFileLoc(Loc)), new StringRef(Category));
    }

    public void $destroy() {
        this.SCL.$destroy();
    }

    public String toString() {
        return "SCL=" + this.SCL + ", SM=" + (Object)((Object)this.SM);
    }
}

