/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.X86TargetInfo;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;

public class X86_32TargetInfo
extends X86TargetInfo
implements Destructors.ClassWithDestructor {
    public X86_32TargetInfo(Triple Triple2, TargetOptions Opts) {
        super(Triple2, Opts);
        this.LongLongAlign = (byte)32;
        this.DoubleAlign = (byte)32;
        this.LongDoubleWidth = (byte)96;
        this.LongDoubleAlign = (byte)32;
        this.SuitableAlign = Unsigned.$int2uchar((int)128);
        this.resetDataLayout(new StringRef("e-m:e-p:32:32-f64:32:64-f80:32-n8:16:32-S128"));
        this.SizeType = TargetInfo.IntType.UnsignedInt;
        this.PtrDiffType = TargetInfo.IntType.SignedInt;
        this.IntPtrType = TargetInfo.IntType.SignedInt;
        this.RegParmMax = (byte)3;
        this.RealTypeUsesObjCFPRet = (byte)(1 << TargetInfo.RealType.Float.getValue() | 1 << TargetInfo.RealType.Double.getValue() | 1 << TargetInfo.RealType.LongDouble.getValue());
        this.MaxAtomicInlineWidth = (byte)64;
        this.MaxAtomicPromoteWidth = (byte)64;
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    @Override
    public int getEHDataRegisterNumber(int RegNo) {
        if (RegNo == 0) {
            return 0;
        }
        if (RegNo == 1) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean validateOperandSize(StringRef Constraint, int Size) {
        switch (Constraint.$at(0)) {
            default: {
                break;
            }
            case 68: 
            case 81: 
            case 82: 
            case 83: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 113: {
                return Unsigned.$lesseq_uint((int)Size, (int)32);
            }
            case 65: {
                return Unsigned.$lesseq_uint((int)Size, (int)64);
            }
        }
        return super.validateOperandSize(Constraint, Size);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

