/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIAction;
import org.jdesktop.swingx.plaf.XListAddon;
import org.jdesktop.swingx.plaf.basic.core.BasicXListUI;
import org.jdesktop.swingx.renderer.AbstractRenderer;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.rollover.ListRolloverController;
import org.jdesktop.swingx.rollover.ListRolloverProducer;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.search.ListSearchable;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.sort.DefaultSortController;
import org.jdesktop.swingx.sort.ListSortController;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.StringValueRegistry;

public class JXList
extends JList {
    private static final Logger LOG = Logger.getLogger(JXList.class.getName());
    public static final String uiClassID = "XListUI";
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private ListRolloverController<JXList> linkController;
    private transient DelegatingRenderer delegatingRenderer;
    private Searchable searchable;
    private Comparator<?> comparator;
    private boolean autoCreateRowSorter;
    private RowSorter<? extends ListModel> rowSorter;
    private boolean sortable;
    private boolean sortsOnUpdates;
    private StringValueRegistry stringValueRegistry;
    private SortOrder[] sortOrderCycle;

    public JXList() {
        this(false);
    }

    public JXList(ListModel dataModel) {
        this(dataModel, false);
    }

    public JXList(Object[] listData) {
        this(listData, false);
    }

    public JXList(Vector<?> listData) {
        this(listData, false);
    }

    public JXList(boolean autoCreateRowSorter) {
        this.init(autoCreateRowSorter);
    }

    public JXList(ListModel dataModel, boolean autoCreateRowSorter) {
        super(dataModel);
        this.init(autoCreateRowSorter);
    }

    public JXList(Object[] listData, boolean autoCreateRowSorter) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(autoCreateRowSorter);
    }

    public JXList(Vector<?> listData, boolean autoCreateRowSorter) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(autoCreateRowSorter);
    }

    private void init(boolean autoCreateRowSorter) {
        this.sortOrderCycle = DefaultSortController.getDefaultSortOrderCycle();
        this.setSortable(true);
        this.setSortsOnUpdates(true);
        this.setAutoCreateRowSorter(autoCreateRowSorter);
        Action findAction = this.createFindAction();
        this.getActionMap().put("find", findAction);
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createFindAction() {
        return new UIAction("find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXList.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        Pattern pattern = Pattern.compile("^" + prefix, 2);
        return this.getSearchable().search(pattern, startIndex, bias == Position.Bias.Backward);
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.rolloverProducer.install(this);
            this.getLinkController().install(this);
        } else {
            this.rolloverProducer.release(this);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected ListRolloverController<JXList> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected ListRolloverController<JXList> createLinkController() {
        return new ListRolloverController<JXList>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new ListRolloverProducer();
    }

    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    public void setAutoCreateRowSorter(boolean autoCreateRowSorter) {
        if (this.getAutoCreateRowSorter() == autoCreateRowSorter) {
            return;
        }
        boolean oldValue = this.getAutoCreateRowSorter();
        this.autoCreateRowSorter = autoCreateRowSorter;
        if (autoCreateRowSorter) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
        this.firePropertyChange("autoCreateRowSorter", oldValue, this.getAutoCreateRowSorter());
    }

    protected RowSorter<? extends ListModel> createDefaultRowSorter() {
        return new ListSortController(this.getModel());
    }

    public RowSorter<? extends ListModel> getRowSorter() {
        return this.rowSorter;
    }

    public void setRowSorter(RowSorter<? extends ListModel> sorter) {
        RowSorter<? extends ListModel> oldRowSorter = this.getRowSorter();
        this.rowSorter = sorter;
        this.configureSorterProperties();
        this.firePropertyChange("rowSorter", oldRowSorter, sorter);
    }

    protected void configureSorterProperties() {
        if (!this.getControlsSorterProperties()) {
            return;
        }
        this.getSortController().setSortable(this.sortable);
        this.getSortController().setSortsOnUpdates(this.sortsOnUpdates);
        this.getSortController().setComparator(0, this.comparator);
        this.getSortController().setSortOrderCycle(this.getSortOrderCycle());
        this.getSortController().setStringValueProvider(this.getStringValueRegistry());
    }

    public void setSortable(boolean sortable) {
        boolean old = this.isSortable();
        this.sortable = sortable;
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortable(sortable);
        }
        this.firePropertyChange("sortable", old, this.isSortable());
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortsOnUpdates(boolean sortsOnUpdates) {
        boolean old = this.getSortsOnUpdates();
        this.sortsOnUpdates = sortsOnUpdates;
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortsOnUpdates(sortsOnUpdates);
        }
        this.firePropertyChange("sortsOnUpdates", old, this.getSortsOnUpdates());
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setSortOrderCycle(SortOrder ... cycle) {
        SortOrder[] old = this.getSortOrderCycle();
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortOrderCycle(cycle);
        }
        this.sortOrderCycle = Arrays.copyOf(cycle, cycle.length);
        this.firePropertyChange("sortOrderCycle", old, this.getSortOrderCycle());
    }

    public SortOrder[] getSortOrderCycle() {
        return Arrays.copyOf(this.sortOrderCycle, this.sortOrderCycle.length);
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<?> comparator) {
        Comparator<?> old = this.getComparator();
        this.comparator = comparator;
        this.updateSortAfterComparatorChange();
        this.firePropertyChange("comparator", old, this.getComparator());
    }

    protected void updateSortAfterComparatorChange() {
        if (this.getControlsSorterProperties()) {
            this.getSortController().setComparator(0, this.getComparator());
        }
    }

    public <R extends ListModel> void setRowFilter(RowFilter<? super R, ? super Integer> filter) {
        if (this.hasSortController()) {
            SortController<? extends ListModel> controller = this.getSortController();
            controller.setRowFilter(filter);
        }
    }

    public RowFilter<?, ?> getRowFilter() {
        return this.hasSortController() ? this.getSortController().getRowFilter() : null;
    }

    public void resetSortOrder() {
        if (this.hasSortController()) {
            this.getSortController().resetSortOrders();
        }
    }

    public void toggleSortOrder() {
        if (this.hasSortController()) {
            this.getSortController().toggleSortOrder(0);
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (this.hasSortController()) {
            this.getSortController().setSortOrder(0, sortOrder);
        }
    }

    public SortOrder getSortOrder() {
        if (this.hasSortController()) {
            return this.getSortController().getSortOrder(0);
        }
        return SortOrder.UNSORTED;
    }

    protected SortController<? extends ListModel> getSortController() {
        if (this.hasSortController()) {
            return (SortController)((Object)this.getRowSorter());
        }
        return null;
    }

    protected boolean hasSortController() {
        return this.getRowSorter() instanceof SortController;
    }

    protected boolean getControlsSorterProperties() {
        return this.hasSortController() && this.getAutoCreateRowSorter();
    }

    public Object getElementAt(int viewIndex) {
        return this.getModel().getElementAt(this.convertIndexToModel(viewIndex));
    }

    public Object getSelectedValue() {
        int i = this.getSelectedIndex();
        return i == -1 ? null : this.getElementAt(i);
    }

    @Override
    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else if (!anObject.equals(this.getSelectedValue())) {
            int c = this.getElementCount();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(this.getElementAt(i))) continue;
                this.setSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    @Override
    public Object[] getSelectedValues() {
        int[] selectedIndexes = this.getSelectedIndices();
        Object[] selectedValues = new Object[selectedIndexes.length];
        for (int i = 0; i < selectedIndexes.length; ++i) {
            selectedValues[i] = this.getElementAt(selectedIndexes[i]);
        }
        return selectedValues;
    }

    public int getElementCount() {
        return this.getRowSorter() != null ? this.getRowSorter().getViewRowCount() : this.getModel().getSize();
    }

    public int convertIndexToModel(int viewIndex) {
        return this.getRowSorter() != null ? this.getRowSorter().convertRowIndexToModel(viewIndex) : viewIndex;
    }

    public int convertIndexToView(int modelIndex) {
        return this.getRowSorter() != null ? this.getRowSorter().convertRowIndexToView(modelIndex) : modelIndex;
    }

    public void setModel(ListModel model) {
        super.setModel(model);
        if (this.getAutoCreateRowSorter()) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JXList.this.repaint();
            }
        };
    }

    protected StringValueRegistry getStringValueRegistry() {
        if (this.stringValueRegistry == null) {
            this.stringValueRegistry = this.createDefaultStringValueRegistry();
        }
        return this.stringValueRegistry;
    }

    protected StringValueRegistry createDefaultStringValueRegistry() {
        return new StringValueRegistry();
    }

    public String getStringAt(int row) {
        StringValue stringValue = this.getStringValueRegistry().getStringValue(this.convertIndexToModel(row), 0);
        return stringValue.getString(this.getElementAt(row));
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new DefaultListRenderer();
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public ListCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        boolean forceFire = this.delegatingRenderer != null;
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        this.getStringValueRegistry().setStringValue(renderer instanceof StringValue ? (StringValue)((Object)renderer) : null, 0);
        super.setCellRenderer(this.delegatingRenderer);
        if (forceFire) {
            this.firePropertyChange("cellRenderer", null, this.delegatingRenderer);
        }
    }

    public void invalidateCellSizeCache() {
        if (this.getUI() instanceof BasicXListUI) {
            ((BasicXListUI)this.getUI()).invalidateCellSizeCache();
        }
    }

    @Override
    public void updateUI() {
        if (this.getUIClassID() == super.getUIClassID()) {
            super.updateUI();
        } else {
            this.setUI((ListUI)LookAndFeelAddons.getUI(this, ListUI.class));
        }
        this.updateRendererUI();
        this.updateHighlighterUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer renderer = this.getCellRenderer();
            if (renderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
            }
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    static {
        LookAndFeelAddons.contribute(new XListAddon());
    }

    public class DelegatingRenderer
    implements ListCellRenderer,
    RolloverRenderer {
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer() {
            this(null);
        }

        public DelegatingRenderer(ListCellRenderer delegate) {
            this.setDelegateRenderer(delegate);
        }

        public void setDelegateRenderer(ListCellRenderer delegate) {
            if (delegate == null) {
                delegate = JXList.this.createDefaultCellRenderer();
            }
            this.delegateRenderer = delegate;
        }

        public ListCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public void updateUI() {
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer renderer) {
            if (renderer == null) {
                return;
            }
            Component comp = null;
            if (renderer instanceof AbstractRenderer) {
                comp = (Component)((AbstractRenderer)((Object)renderer)).getComponentProvider().getRendererComponent(null);
            } else if (renderer instanceof Component) {
                comp = (Component)((Object)renderer);
            } else {
                try {
                    comp = renderer.getListCellRendererComponent(JXList.this, null, -1, false, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (comp != null) {
                SwingUtilities.updateComponentTreeUI(comp);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (JXList.this.compoundHighlighter != null && index >= 0 && index < JXList.this.getElementCount()) {
                comp = JXList.this.compoundHighlighter.highlight(comp, JXList.this.getComponentAdapter(index));
            }
            return comp;
        }

        @Override
        public boolean isEnabled() {
            return this.delegateRenderer instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegateRenderer)).isEnabled();
        }

        @Override
        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegateRenderer)).doClick();
            }
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList component) {
            super(component);
            this.list = component;
        }

        public JXList getList() {
            return this.list;
        }

        @Override
        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        @Override
        public int getRowCount() {
            return this.list.getModel().getSize();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.list.getModel().getElementAt(row);
        }

        @Override
        public String getStringAt(int row, int column) {
            StringValue sv = this.list.getStringValueRegistry().getStringValue(row, column);
            return sv.getString(this.getValueAt(row, column));
        }

        @Override
        public Rectangle getCellBounds() {
            return this.list.getCellBounds(this.row, this.row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }

        @Override
        public int convertRowIndexToView(int rowModelIndex) {
            return this.list.convertIndexToView(rowModelIndex);
        }

        @Override
        public int convertRowIndexToModel(int rowViewIndex) {
            return this.list.convertIndexToModel(rowViewIndex);
        }
    }
}

