/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.trace.TraceXRef;
import org.netbeans.modules.cnd.modelui.trace.TestFileContainerAction;
import org.netbeans.modules.cnd.modelui.trace.TestGraphContainerAction;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelui.trace.TestReferencePanel;
import org.netbeans.modules.cnd.modelui.trace.TestReparseAction;
import org.netbeans.modules.cnd.modelui.trace.TestRepositoryStatisticsAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TestProjectReferencesAction
extends TestProjectActionBase {
    private static boolean running = false;
    private final boolean allReferences;
    private final boolean analyzeStatistics;
    private final Boolean reportUnresolved;
    private final boolean reportIndex;
    private int numThreads = 1;
    private long timeThreshold = 0L;
    private static final Map<CharSequence, Map<CharSequence, Long>> times = new HashMap<CharSequence, Map<CharSequence, Long>>();

    public static Action getSmartCompletionAnalyzerAction() {
        return (Action)SharedClassObject.findObject(SmartCompletionAnalyzerAction.class, (boolean)true);
    }

    public static Action getTestReparseAction() {
        return (Action)SharedClassObject.findObject(TestReparseAction.class, (boolean)true);
    }

    public static Action getDirectUsageReferencesAction() {
        return (Action)SharedClassObject.findObject(DirectUsageAction.class, (boolean)true);
    }

    public static Action getIndexReferencesAction() {
        return (Action)SharedClassObject.findObject(IndexUsageAction.class, (boolean)true);
    }

    public static Action getAllReferencesAction() {
        return (Action)SharedClassObject.findObject(AllUsagesAction.class, (boolean)true);
    }

    public static Action getAllReferencesPerformanceAction() {
        return (Action)SharedClassObject.findObject(AllUsagesPerformanceAction.class, (boolean)true);
    }

    public static Action getFileContainerAction() {
        return (Action)SharedClassObject.findObject(TestFileContainerAction.class, (boolean)true);
    }

    public static Action getGraphContainerAction() {
        return (Action)SharedClassObject.findObject(TestGraphContainerAction.class, (boolean)true);
    }

    public static Action getTestRepositoryStatisticsAction() {
        return (Action)SharedClassObject.findObject(TestRepositoryStatisticsAction.class, (boolean)true);
    }

    private Map<CharSequence, Long> getProjectMap(CsmProject p) {
        CharSequence name = p.getName();
        Map<CharSequence, Long> out = times.get(name);
        if (out == null) {
            out = new ConcurrentHashMap<CharSequence, Long>();
            this.loadXRefTimes(p, out);
            times.put(name, out);
        }
        return out;
    }

    private void loadXRefTimes(CsmProject p, Map<CharSequence, Long> out) throws NumberFormatException {
        Preferences props = this.getProjectPrefs(p);
        if (props != null) {
            String[] split;
            String storedTimes = props.get("xRefTimes", "");
            for (String fileTime : split = storedTimes.split("\n")) {
                int delim = fileTime.lastIndexOf("|");
                if (delim <= 0) continue;
                try {
                    out.put(CharSequences.create((CharSequence)fileTime.substring(0, delim)), Long.parseLong(fileTime.substring(delim + 1)));
                }
                catch (NumberFormatException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void saveXRefTimes(CsmProject p, Map<CharSequence, Long> out) throws NumberFormatException {
        Preferences props = this.getProjectPrefs(p);
        if (props != null) {
            StringBuilder storedTimes = new StringBuilder();
            for (Map.Entry<CharSequence, Long> entry : out.entrySet()) {
                storedTimes.append(entry.getKey()).append("|").append(entry.getValue().toString()).append("\n");
            }
            props.put("xRefTimes", storedTimes.toString());
        }
    }

    protected TestProjectReferencesAction(boolean allReferences, boolean analyzeStatistics, Boolean reportUnresolved, boolean reportIndex) {
        this.allReferences = allReferences;
        this.analyzeStatistics = analyzeStatistics;
        this.reportUnresolved = reportUnresolved;
        this.reportIndex = reportIndex;
        this.numThreads = reportUnresolved == Boolean.FALSE ? Runtime.getRuntime().availableProcessors() : 1;
    }

    public String getName() {
        String nameKey = this.analyzeStatistics ? "CTL_TestProjectSmartCCDirectUsageReferencesAction" : (this.reportUnresolved != null ? (this.reportUnresolved != false ? "CTL_TestProjectReferencesAction" : "CTL_TestProjectReferencesPerformanceAction") : (this.reportIndex ? "CTL_TestProjectIndexUsageReferencesAction" : "CTL_TestProjectDirectUsageReferencesAction"));
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)nameKey);
    }

    @Override
    protected void performAction(Collection<CsmProject> projects) {
        if (this.reportUnresolved == Boolean.FALSE) {
            boolean hasSlowInfo = false;
            if (projects != null) {
                for (CsmProject p : projects) {
                    hasSlowInfo |= !this.getProjectMap(p).isEmpty();
                }
            }
            TestReferencePanel panel = new TestReferencePanel(this.numThreads, this.timeThreshold, hasSlowInfo);
            NotifyDescriptor input = new NotifyDescriptor((Object)panel, "Test References", -1, 3, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
            Object option = DialogDisplayer.getDefault().notify(input);
            if (option == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
            this.numThreads = panel.getThreadsNumber();
            this.timeThreshold = panel.getThreshold();
            if (!panel.isCollecting()) {
                this.timeThreshold = -this.timeThreshold;
            }
        }
        if (projects != null) {
            for (CsmProject p : projects) {
                this.testProject(p);
            }
        }
    }

    private void testProject(CsmProject p) {
        Map<CharSequence, Long> filesMap;
        long passedThreshold;
        String task = (this.reportIndex ? "Indexed " : (this.allReferences ? "All " : "Direct usage ")) + "xRef - " + p.getName() + (this.analyzeStatistics ? " Statistics" : "");
        InputOutput io = IOProvider.getDefault().getIO(task, false);
        io.select();
        final AtomicBoolean canceled = new AtomicBoolean(false);
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)task, (Cancellable)new Cancellable(){

            public boolean cancel() {
                canceled.set(true);
                return true;
            }
        });
        handle.start();
        final OutputWriter out = io.getOut();
        final OutputWriter err = io.getErr();
        final long[] time = new long[2];
        time[0] = System.currentTimeMillis();
        EnumSet<CsmReferenceKind> interestedElems = this.allReferences ? CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE : EnumSet.of(CsmReferenceKind.DIRECT_USAGE);
        Map<CharSequence, Long> fileTimes = this.getProjectMap(p);
        if (this.timeThreshold > 0L) {
            fileTimes.clear();
        }
        if ((passedThreshold = this.timeThreshold) < 0L) {
            passedThreshold = 0L;
            filesMap = new ConcurrentHashMap<CharSequence, Long>(fileTimes.size());
            for (Map.Entry<CharSequence, Long> entry : fileTimes.entrySet()) {
                if (entry.getValue() <= -this.timeThreshold) continue;
                filesMap.put(entry.getKey(), entry.getValue());
            }
            err.println("analyze " + filesMap.size() + " remembered slow files only");
        } else {
            filesMap = fileTimes;
            if (passedThreshold > 0L) {
                err.println("collect files slower than " + passedThreshold + "ms");
                filesMap.clear();
            }
        }
        TraceXRef.traceProjectRefsStatistics((CsmProject)p, filesMap, (TraceXRef.StatisticsParameters)new TraceXRef.StatisticsParameters(interestedElems, this.analyzeStatistics, this.reportUnresolved == null ? true : this.reportUnresolved, this.reportIndex, this.numThreads, passedThreshold), (PrintWriter)out, (OutputWriter)err, (CsmProgressListener)new CsmProgressAdapter(){
            private volatile int handled = 0;

            public void projectFilesCounted(CsmProject project, int filesCount) {
                err.flush();
                out.println("Project " + project.getName() + " has " + filesCount + " files");
                out.flush();
                handle.switchToDeterminate(filesCount);
            }

            public synchronized void fileParsingStarted(CsmFile file) {
                handle.progress("Analyzing " + file.getName(), ++this.handled);
            }

            public void projectParsingFinished(CsmProject project) {
                time[1] = System.currentTimeMillis();
            }
        }, (AtomicBoolean)canceled);
        handle.finish();
        out.println("Analyzing " + p.getName() + " took " + (time[1] - time[0]) + "ms");
        if (this.timeThreshold > 0L) {
            this.saveXRefTimes(p, fileTimes);
            err.println(fileTimes.size() + " files which were analyzed longer than " + this.timeThreshold + "ms are remembered");
        }
        err.flush();
        out.flush();
        out.close();
        err.close();
    }

    static final class AllUsagesPerformanceAction
    extends TestProjectReferencesAction {
        AllUsagesPerformanceAction() {
            super(true, false, Boolean.FALSE, false);
        }
    }

    static final class AllUsagesAction
    extends TestProjectReferencesAction {
        AllUsagesAction() {
            super(true, false, Boolean.TRUE, false);
        }
    }

    static final class IndexUsageAction
    extends TestProjectReferencesAction {
        IndexUsageAction() {
            super(false, false, null, true);
        }
    }

    static final class DirectUsageAction
    extends TestProjectReferencesAction {
        DirectUsageAction() {
            super(false, false, null, false);
        }
    }

    static final class SmartCompletionAnalyzerAction
    extends TestProjectReferencesAction {
        SmartCompletionAnalyzerAction() {
            super(false, true, null, false);
        }
    }
}

