/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.editor.base.imports.UnusedImports;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.TokenList;
import org.netbeans.modules.java.editor.base.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class SemanticHighlighterBase
extends JavaParserResultTask {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<String> SERIALIZABLE_SIGNATURES = new HashSet<String>(Arrays.asList("writeObject(Ljava/io/ObjectOutputStream;)V", "readObject(Ljava/io/ObjectInputStream;)V", "readResolve()Ljava/lang/Object;", "writeReplace()Ljava/lang/Object;", "readObjectNoData()V"));
    private static Field signatureAccessField;

    protected SemanticHighlighterBase() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        this.cancel.set(false);
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!SemanticHighlighterBase.verifyDocument(doc)) {
            return;
        }
        this.process(info, doc);
    }

    private static boolean verifyDocument(final Document doc) {
        if (doc == null) {
            Logger.getLogger(SemanticHighlighterBase.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return false;
        }
        final boolean[] tokenSequenceNull = new boolean[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                tokenSequenceNull[0] = TokenHierarchy.get((Document)doc).tokenSequence() == null;
            }
        });
        return !tokenSequenceNull[0];
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    protected abstract boolean process(CompilationInfo var1, Document var2);

    private static boolean isInSerializableOrExternalizable(CompilationInfo info, Element e) {
        Element encl = e.getEnclosingElement();
        if (encl == null || !encl.getKind().isClass()) {
            return true;
        }
        TypeMirror m = encl.asType();
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return true;
        }
        TypeElement serEl = info.getElements().getTypeElement("java.io.Serializable");
        TypeElement extEl = info.getElements().getTypeElement("java.io.Externalizable");
        if (serEl == null || extEl == null) {
            return true;
        }
        if (info.getTypes().isSubtype(m, serEl.asType())) {
            return true;
        }
        return info.getTypes().isSubtype(m, extEl.asType());
    }

    private static String _getSignatureHack(ElementHandle<ExecutableElement> eh) {
        try {
            String[] signs;
            if (signatureAccessField == null) {
                try {
                    Field f = ElementHandle.class.getDeclaredField("signatures");
                    f.setAccessible(true);
                    signatureAccessField = f;
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return "";
                }
            }
            if ((signs = (String[])signatureAccessField.get(eh)) == null || signs.length != 3) {
                return "";
            }
            return signs[1] + signs[2];
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return "";
        }
    }

    private boolean isSerializationMethod(CompilationInfo info, ExecutableElement method) {
        if (!SemanticHighlighterBase.isInSerializableOrExternalizable(info, method)) {
            return false;
        }
        ElementHandle eh = ElementHandle.create((Element)method);
        String sign = SemanticHighlighterBase._getSignatureHack((ElementHandle<ExecutableElement>)eh);
        return SERIALIZABLE_SIGNATURES.contains(sign);
    }

    protected boolean process(CompilationInfo info, Document doc, ErrorDescriptionSetter setter) {
        ArrayList<int[]> imports;
        DetectorVisitor v = new DetectorVisitor(info, doc, this.cancel);
        IdentityHashMap<Token, ColoringAttributes.Coloring> newColoring = new IdentityHashMap<Token, ColoringAttributes.Coloring>();
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan(cu, null);
        if (this.cancel.get()) {
            return true;
        }
        boolean computeUnusedImports = "text/x-java".equals(FileUtil.getMIMEType((FileObject)info.getFileObject()));
        ArrayList<int[]> arrayList = imports = computeUnusedImports ? new ArrayList<int[]>() : null;
        if (computeUnusedImports) {
            Collection<TreePath> unusedImports = UnusedImports.process(info, this.cancel);
            if (unusedImports == null) {
                return true;
            }
            for (TreePath tree : unusedImports) {
                if (this.cancel.get()) {
                    return true;
                }
                imports.add(new int[]{(int)info.getTrees().getSourcePositions().getStartPosition(cu, tree.getLeaf()), (int)info.getTrees().getSourcePositions().getEndPosition(cu, tree.getLeaf())});
            }
        }
        for (Element decl : v.type2Uses.keySet()) {
            if (this.cancel.get()) {
                return true;
            }
            List uses = (List)v.type2Uses.get(decl);
            for (Use u : uses) {
                if (u.spec == null) continue;
                if (u.type.contains((Object)UseTypes.DECLARATION) && Utilities.isPrivateElement(decl)) {
                    if ((decl.getKind().isField() && !SemanticHighlighterBase.isSerialSpecField(info, decl) || SemanticHighlighterBase.isLocalVariableClosure(decl)) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if (!((decl.getKind() != ElementKind.CONSTRUCTOR || decl.getModifiers().contains((Object)Modifier.PRIVATE)) && decl.getKind() != ElementKind.METHOD || this.hasAllTypes(uses, EnumSet.of(UseTypes.EXECUTE)) || this.isSerializationMethod(info, (ExecutableElement)decl))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((decl.getKind().isClass() || decl.getKind().isInterface()) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.CLASS_USE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                }
                ColoringAttributes.Coloring c = SemanticHighlighterBase.collection2Coloring(u.spec);
                Token t = (Token)v.tree2Token.get(u.tree.getLeaf());
                if (t == null) continue;
                newColoring.put(t, c);
            }
        }
        if (this.cancel.get()) {
            return true;
        }
        if (computeUnusedImports) {
            setter.setHighlights(doc, imports);
        }
        setter.setColorings(doc, newColoring);
        return false;
    }

    private boolean hasAllTypes(List<Use> uses, Collection<UseTypes> types) {
        EnumSet<UseTypes> e = EnumSet.copyOf(types);
        for (Use u : uses) {
            if (types.isEmpty()) {
                return true;
            }
            types.removeAll(u.type);
        }
        return types.isEmpty();
    }

    private static ColoringAttributes.Coloring collection2Coloring(Collection<ColoringAttributes> attr) {
        ColoringAttributes.Coloring c = ColoringAttributes.empty();
        for (ColoringAttributes a : attr) {
            c = ColoringAttributes.add(c, a);
        }
        return c;
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.RESOURCE_VARIABLE || el.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    private static boolean isSerialSpecField(CompilationInfo info, Element el) {
        if (el.getModifiers().contains((Object)Modifier.FINAL) && el.getModifiers().contains((Object)Modifier.STATIC)) {
            if (!SemanticHighlighterBase.isInSerializableOrExternalizable(info, el)) {
                return false;
            }
            if (info.getTypes().getPrimitiveType(TypeKind.LONG).equals(el.asType()) && el.getSimpleName().toString().equals("serialVersionUID")) {
                return true;
            }
            if (el.getSimpleName().contentEquals("serialPersistentFields")) {
                return true;
            }
        }
        return false;
    }

    public static interface ErrorDescriptionSetter {
        public void setHighlights(Document var1, Collection<int[]> var2);

        public void setColorings(Document var1, Map<Token, ColoringAttributes.Coloring> var2);
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, EnumSet<UseTypes>> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private Map<Tree, Token> tree2Token;
        private TokenList tl;
        private long memberSelectBypass = -1L;
        private SourcePositions sourcePositions;
        private ExecutableElement recursionDetector;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo info, Document doc, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
            this.doc = doc;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.tree2Token = new IdentityHashMap<Tree, Token>();
            this.tl = new TokenList(info, doc, cancel);
            this.sourcePositions = info.getTrees().getSourcePositions();
        }

        private void firstIdentifier(String name) {
            this.tl.firstIdentifier(this.getCurrentPath(), name, this.tree2Token);
        }

        public Void visitAssignment(AssignmentTree tree, EnumSet<UseTypes> d) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree tree, EnumSet<UseTypes> d) {
            EnumSet<UseTypes> useTypes = EnumSet.of(UseTypes.WRITE);
            if (d != null) {
                useTypes.addAll(d);
            }
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), useTypes);
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitReturn(ReturnTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitReturn(tree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitSwitch(SwitchTree node, EnumSet<UseTypes> p) {
            this.scan(node.getExpression(), EnumSet.of(UseTypes.READ));
            for (CaseTree caseTree : node.getCases()) {
                this.scan(caseTree, null);
            }
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree tree, EnumSet<UseTypes> d) {
            Element el;
            long memberSelectBypassLoc = this.memberSelectBypass;
            this.memberSelectBypass = -1L;
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if ((el = this.info.getTrees().getElement(this.getCurrentPath())) != null && el.getKind().isField()) {
                this.handlePossibleIdentifier(this.getCurrentPath(), d == null ? EnumSet.of(UseTypes.READ) : d);
            }
            if (el != null && (el.getKind().isClass() || el.getKind().isInterface()) && this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitMemberSelect(tree, d);
            this.tl.moveToEnd(tree.getExpression());
            if (memberSelectBypassLoc != -1L) {
                this.tl.moveToOffset(memberSelectBypassLoc);
            }
            this.firstIdentifier(tree.getIdentifier().toString());
            return null;
        }

        private void addModifiers(Element decl, Collection<ColoringAttributes> c) {
            if (decl.getModifiers().contains((Object)Modifier.STATIC)) {
                c.add(ColoringAttributes.STATIC);
            }
            if (decl.getModifiers().contains((Object)Modifier.ABSTRACT) && !decl.getKind().isInterface()) {
                c.add(ColoringAttributes.ABSTRACT);
            }
            boolean accessModifier = false;
            if (decl.getModifiers().contains((Object)Modifier.PUBLIC)) {
                c.add(ColoringAttributes.PUBLIC);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PROTECTED)) {
                c.add(ColoringAttributes.PROTECTED);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PRIVATE)) {
                c.add(ColoringAttributes.PRIVATE);
                accessModifier = true;
            }
            if (!accessModifier && !SemanticHighlighterBase.isLocalVariableClosure(decl)) {
                c.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(decl)) {
                c.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement mdecl, boolean nct) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(mdecl, c);
            if (mdecl.getKind() == ElementKind.CONSTRUCTOR) {
                c.add(ColoringAttributes.CONSTRUCTOR);
                if (nct && mdecl.getEnclosingElement() != null && this.info.getElements().isDeprecated(mdecl.getEnclosingElement())) {
                    c.add(ColoringAttributes.DEPRECATED);
                }
            } else {
                c.add(ColoringAttributes.METHOD);
            }
            return c;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element decl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(decl, c);
            if (decl.getKind().isField()) {
                c.add(ColoringAttributes.FIELD);
                return c;
            }
            if (decl.getKind() == ElementKind.LOCAL_VARIABLE || decl.getKind() == ElementKind.RESOURCE_VARIABLE || decl.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                c.add(ColoringAttributes.LOCAL_VARIABLE);
                return c;
            }
            if (decl.getKind() == ElementKind.PARAMETER) {
                c.add(ColoringAttributes.PARAMETER);
                return c;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type) {
            this.handlePossibleIdentifier(expr, type, null, false, false);
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type, Element decl, boolean providesDecl, boolean nct) {
            if (Utilities.isKeyword(expr.getLeaf())) {
                return;
            }
            if (expr.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)expr.getLeaf().getKind())) {
                return;
            }
            decl = !providesDecl ? this.info.getTrees().getElement(expr) : decl;
            Collection<ColoringAttributes> c = null;
            if (decl != null && (decl.getKind().isField() || SemanticHighlighterBase.isLocalVariableClosure(decl))) {
                c = this.getVariableColoring(decl);
            }
            if (decl != null && decl instanceof ExecutableElement) {
                c = this.getMethodColoring((ExecutableElement)decl, nct);
            }
            if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
                if (type.contains((Object)UseTypes.READ)) {
                    type = EnumSet.copyOf(type);
                    type.remove((Object)UseTypes.READ);
                    type.add(UseTypes.CLASS_USE);
                }
                c = new ArrayList<ColoringAttributes>();
                this.addModifiers(decl, c);
                switch (decl.getKind()) {
                    case CLASS: {
                        c.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        c.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        c.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        c.add(ColoringAttributes.ENUM);
                    }
                }
            }
            if (decl != null && type.contains((Object)UseTypes.DECLARATION)) {
                if (c == null) {
                    c = new ArrayList<ColoringAttributes>();
                }
                c.add(ColoringAttributes.DECLARATION);
            }
            if (c != null) {
                this.addUse(decl, type, expr, c);
            }
        }

        private void addUse(Element decl, Collection<UseTypes> useTypes, TreePath t, Collection<ColoringAttributes> c) {
            List<Use> uses;
            if (decl == this.recursionDetector) {
                useTypes.remove((Object)UseTypes.EXECUTE);
            }
            if ((uses = this.type2Uses.get(decl)) == null) {
                uses = new ArrayList<Use>();
                this.type2Uses.put(decl, uses);
            }
            Use u = new Use(useTypes, t, c);
            uses.add(u);
        }

        public Void visitTypeCast(TypeCastTree tree, EnumSet<UseTypes> d) {
            Tree cast;
            ExpressionTree expr = tree.getExpression();
            if (expr.getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            if ((cast = tree.getType()).getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), cast), EnumSet.of(UseTypes.READ));
            }
            super.visitTypeCast(tree, d);
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitInstanceOf(tree, null);
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, EnumSet<UseTypes> d) {
            this.tl.moveBefore(tree.getImports());
            this.scan(tree.getImports(), d);
            this.tl.moveBefore(tree.getPackageAnnotations());
            this.scan(tree.getPackageAnnotations(), d);
            this.tl.moveToEnd(tree.getImports());
            this.scan(tree.getTypeDecls(), d);
            return null;
        }

        private long startOf(List<? extends Tree> trees) {
            if (trees.isEmpty()) {
                return -1L;
            }
            return this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), trees.get(0));
        }

        private void handleMethodTypeArguments(TreePath method, List<? extends Tree> tArgs) {
            this.tl.moveBefore(tArgs);
            for (Tree tree : tArgs) {
                if (!(tree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(method, tree), EnumSet.of(UseTypes.CLASS_USE));
            }
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, EnumSet<UseTypes> d) {
            List<? extends Tree> ta;
            String ident;
            ExpressionTree possibleIdent = tree.getMethodSelect();
            boolean handled = false;
            if (possibleIdent.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)possibleIdent).getName().toString()) || "this".equals(ident))) {
                Element resolved = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(resolved, EnumSet.of(UseTypes.EXECUTE), null, null);
                handled = true;
            }
            if (!handled) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), possibleIdent), EnumSet.of(UseTypes.EXECUTE));
            }
            long afterTypeArguments = (ta = tree.getTypeArguments()).isEmpty() ? -1L : this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), ta.get(ta.size() - 1));
            switch (tree.getMethodSelect().getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    this.memberSelectBypass = afterTypeArguments;
                    this.scan(tree.getMethodSelect(), EnumSet.of(UseTypes.READ));
                    this.memberSelectBypass = -1L;
                    break;
                }
                default: {
                    this.scan(tree.getMethodSelect(), EnumSet.of(UseTypes.READ));
                }
            }
            this.handleMethodTypeArguments(this.getCurrentPath(), ta);
            this.scan(tree.getTypeArguments(), null);
            if (tree.getArguments() != null) {
                for (Tree tree2 : tree.getArguments()) {
                    if (!(tree2 instanceof IdentifierTree)) continue;
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree2), EnumSet.of(UseTypes.READ));
                }
            }
            this.scan(tree.getArguments(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, EnumSet<UseTypes> d) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            if (this.memberSelectBypass != -1L) {
                this.tl.moveToOffset(this.memberSelectBypass);
                this.memberSelectBypass = -1L;
            }
            this.tl.identifierHere(tree, this.tree2Token);
            if (d != null) {
                this.handlePossibleIdentifier(this.getCurrentPath(), d);
            }
            super.visitIdentifier(tree, null);
            return null;
        }

        public Void visitMethod(MethodTree tree, EnumSet<UseTypes> d) {
            String name;
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return (Void)super.visitMethod(tree, d);
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            for (Tree tree2 : tree.getThrows()) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            EnumSet<UseTypes> paramsUseTypes = element != null && (element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getModifiers().contains((Object)Modifier.NATIVE) || !element.getModifiers().contains((Object)Modifier.PRIVATE)) ? EnumSet.of(UseTypes.WRITE, UseTypes.READ) : EnumSet.of(UseTypes.WRITE);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getTypeParameters(), null);
            this.tl.moveToEnd(tree.getTypeParameters());
            this.scan(tree.getReturnType(), EnumSet.of(UseTypes.CLASS_USE));
            this.tl.moveToEnd(tree.getReturnType());
            if (tree.getReturnType() != null) {
                name = tree.getName().toString();
            } else {
                TreePath tp;
                for (tp = this.getCurrentPath(); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
                }
                name = tp != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? ((ClassTree)tp.getLeaf()).getSimpleName().toString() : null;
            }
            if (name != null) {
                this.firstIdentifier(name);
            }
            this.scan(tree.getParameters(), paramsUseTypes);
            this.scan(tree.getThrows(), null);
            this.scan(tree.getDefaultValue(), null);
            this.recursionDetector = element != null && element.getKind() == ElementKind.METHOD ? (ExecutableElement)element : null;
            this.scan(tree.getBody(), null);
            this.recursionDetector = null;
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree tree, EnumSet<UseTypes> d) {
            super.visitExpressionStatement(tree, null);
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            super.visitParenthesized(tree, d);
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            if (tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getExpression(), null);
            this.scan(tree.getStatement(), null);
            return null;
        }

        private boolean isStar(ImportTree tree) {
            Tree qualIdent = tree.getQualifiedIdentifier();
            if (qualIdent == null || qualIdent.getKind() == Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((MemberSelectTree)qualIdent).getIdentifier().contentEquals("*");
        }

        public Void visitVariable(VariableTree tree, EnumSet<UseTypes> d) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            if (tree.getType() != null) {
                TreePath type = new TreePath(this.getCurrentPath(), tree.getType());
                if (type.getLeaf() instanceof ArrayTypeTree) {
                    type = new TreePath(type, ((ArrayTypeTree)type.getLeaf()).getType());
                }
                if (type.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(type, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            EnumSet<UseTypes> uses = null;
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (tree.getInitializer() != null) {
                uses = EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE);
                if (tree.getInitializer().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getInitializer()), EnumSet.of(UseTypes.READ));
                }
            } else {
                uses = e != null && e.getKind() == ElementKind.FIELD ? EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE) : EnumSet.of(UseTypes.DECLARATION);
            }
            if (d != null) {
                HashSet<UseTypes> ut = new HashSet<UseTypes>();
                ut.addAll(uses);
                ut.addAll(d);
                uses = EnumSet.copyOf(ut);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), uses);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getType(), null);
            int[] span = this.info.getTreeUtilities().findNameSpan(tree);
            if (span != null) {
                this.tl.moveToOffset(span[0]);
            } else {
                this.tl.moveToEnd(tree.getType());
            }
            this.firstIdentifier(tree.getName().toString());
            this.tl.moveNext();
            this.scan(tree.getInitializer(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitAnnotation(AnnotationTree tree, EnumSet<UseTypes> d) {
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getAnnotationType());
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitAnnotation(tree, EnumSet.noneOf(UseTypes.class));
            return null;
        }

        public Void visitNewClass(NewClassTree tree, EnumSet<UseTypes> d) {
            ExpressionTree ident;
            ExpressionTree exp = tree.getEnclosingExpression();
            if (exp instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), exp), EnumSet.of(UseTypes.READ));
            }
            TreePath tp = (ident = tree.getIdentifier()).getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), ident), ((ParameterizedTypeTree)((Object)ident)).getType()) : new TreePath(this.getCurrentPath(), ident);
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.EXECUTE), this.info.getTrees().getElement(this.getCurrentPath()), true, true);
            Element clazz = this.info.getTrees().getElement(tp);
            if (clazz != null) {
                this.addUse(clazz, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            for (Tree tree2 : tree.getArguments()) {
                if (!(tree2 instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree2), EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getEnclosingExpression(), null);
            this.scan(tree.getIdentifier(), null);
            this.scan(tree.getTypeArguments(), null);
            this.scan(tree.getArguments(), EnumSet.of(UseTypes.READ));
            this.scan(tree.getClassBody(), null);
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree tree, EnumSet<UseTypes> d) {
            NewClassTree nct;
            boolean alreadyHandled = false;
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                nct = (NewClassTree)this.getCurrentPath().getParentPath().getLeaf();
                boolean bl = alreadyHandled = nct.getTypeArguments().contains(tree) || nct.getIdentifier() == tree;
            }
            if (this.getCurrentPath().getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                nct = (NewClassTree)this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                Tree tree2 = this.getCurrentPath().getParentPath().getLeaf();
                boolean bl = alreadyHandled = nct.getTypeArguments().contains(tree2) || nct.getIdentifier() == tree2;
            }
            if (!alreadyHandled) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree3 : tree.getTypeArguments()) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree3);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitParameterizedType(tree, null);
            return null;
        }

        public Void visitBinary(BinaryTree tree, EnumSet<UseTypes> d) {
            TreePath tp;
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            if (left instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), left);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if (right instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), right);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            super.visitBinary(tree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitClass(ClassTree tree, EnumSet<UseTypes> d) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
                for (Tree tree2 : typeParameterTree.getBounds()) {
                    TreePath tp = new TreePath(new TreePath(this.getCurrentPath(), typeParameterTree), tree2);
                    this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                Tree extnds = tree.getExtendsClause();
                if (extnds != null) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), extnds);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
                for (Tree tree3 : tree.getImplementsClause()) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), tree3);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.firstIdentifier(tree.getSimpleName().toString());
            this.scan(tree.getTypeParameters(), null);
            this.scan(tree.getExtendsClause(), null);
            this.scan(tree.getImplementsClause(), null);
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            this.recursionDetector = null;
            this.scan(tree.getMembers(), null);
            this.recursionDetector = prevRecursionDetector;
            return null;
        }

        public Void visitUnary(UnaryTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                switch (tree.getKind()) {
                    case PREFIX_INCREMENT: 
                    case PREFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: 
                    case POSTFIX_DECREMENT: {
                        EnumSet<UseTypes> useTypes = EnumSet.of(UseTypes.WRITE);
                        if (d != null) {
                            useTypes.addAll(d);
                        }
                        this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), useTypes);
                        break;
                    }
                    default: {
                        this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
                    }
                }
            }
            super.visitUnary(tree, d);
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getExpression(), EnumSet.of(UseTypes.READ));
            this.scan(tree.getIndex(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitArrayType(ArrayTypeTree node, EnumSet<UseTypes> p) {
            if (node.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitArrayType(node, p);
        }

        public Void visitUnionType(UnionTypeTree node, EnumSet<UseTypes> p) {
            for (Tree tree : node.getTypeAlternatives()) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitUnionType(node, p);
        }

        public Void visitNewArray(NewArrayTree tree, EnumSet<UseTypes> d) {
            if (tree.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            this.scan(tree.getType(), null);
            this.scan(tree.getDimensions(), EnumSet.of(UseTypes.READ));
            this.scan(tree.getInitializers(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCatch(CatchTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getParameter(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getBlock(), null);
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree node, EnumSet<UseTypes> p) {
            return (Void)super.visitConditionalExpression(node, EnumSet.of(UseTypes.READ));
        }

        public Void visitAssert(AssertTree tree, EnumSet<UseTypes> p) {
            if (tree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            if (tree.getDetail() != null && tree.getDetail().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getDetail()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitAssert(tree, EnumSet.of(UseTypes.READ));
        }

        public Void visitCase(CaseTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitCase(tree, null);
        }

        public Void visitThrow(ThrowTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitThrow(tree, p);
        }

        public Void visitTypeParameter(TypeParameterTree tree, EnumSet<UseTypes> p) {
            for (Tree tree2 : tree.getBounds()) {
                if (tree2.getKind() != Tree.Kind.IDENTIFIER) continue;
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitTypeParameter(tree, p);
        }

        public Void visitForLoop(ForLoopTree node, EnumSet<UseTypes> p) {
            if (node.getCondition() != null && node.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getCondition()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitForLoop(node, p);
        }

        public Void visitWildcard(WildcardTree node, EnumSet<UseTypes> p) {
            if (node.getBound() != null && node.getBound().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getBound()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitWildcard(node, p);
        }

        public Void visitLambdaExpression(LambdaExpressionTree node, EnumSet<UseTypes> p) {
            this.scan(node.getParameters(), EnumSet.of(UseTypes.WRITE));
            if (node.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                this.scan(node.getBody(), EnumSet.of(UseTypes.READ));
            } else {
                this.scan(node.getBody(), p);
            }
            return null;
        }

        public Void visitMemberReference(MemberReferenceTree node, EnumSet<UseTypes> p) {
            this.scan(node.getQualifierExpression(), EnumSet.of(UseTypes.READ));
            this.tl.moveToEnd(node.getQualifierExpression());
            this.scan(node.getTypeArguments(), null);
            this.tl.moveToEnd(node.getTypeArguments());
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.EXECUTE));
            this.firstIdentifier(node.getName().toString());
            return null;
        }
    }

    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> type, TreePath tree, Collection<ColoringAttributes> spec) {
            this.type = type;
            this.tree = tree;
            this.spec = spec;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        DECLARATION,
        CLASS_USE;

    }
}

