/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompileSupport
extends CompileOptionsProvider {
    private static final String STORAGE_SUFFIX = "properties";

    public AllOptionsProvider getOptions(Item item) {
        MakeConfigurationDescriptor cd;
        MakeConfiguration makeConfiguration;
        NativeProject nativeProject = item.getNativeProject();
        Lookup.Provider project = nativeProject.getProject();
        if (project instanceof Project && (makeConfiguration = (cd = item.getFolder().getConfigurationDescriptor()).getActiveConfiguration()) != null) {
            String confName = makeConfiguration.getName();
            String itemPath = item.getAbsolutePath();
            return this.getOptions(cd, confName, itemPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRename(MakeConfigurationDescriptor cd, MakeConfiguration makeConfiguration, String newName) {
        String confName;
        FileObject nbPrivateProjectFileObject = cd.getNbPrivateProjectFileObject();
        FileObject properties = nbPrivateProjectFileObject.getFileObject((confName = makeConfiguration.getName()) + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            try {
                lock = properties.lock();
                properties.rename(lock, newName, STORAGE_SUFFIX);
            }
            catch (IOException ex) {
                BuildProjectActionHandler.logger.log(Level.WARNING, NbBundle.getMessage(CompileSupport.class, (String)"CANNOT_RENAME_COMPILE_LINES"), properties.getPath());
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(MakeConfigurationDescriptor cd, MakeConfiguration makeConfiguration) {
        String confName;
        FileObject nbPrivateProjectFileObject = cd.getNbPrivateProjectFileObject();
        FileObject properties = nbPrivateProjectFileObject.getFileObject((confName = makeConfiguration.getName()) + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            try {
                lock = properties.lock();
                properties.delete(lock);
            }
            catch (IOException ex) {
                BuildProjectActionHandler.logger.log(Level.WARNING, NbBundle.getMessage(CompileSupport.class, (String)"CANNOT_REMOVE_COMPILE_LINES"), properties.getPath());
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOptions(MakeConfigurationDescriptor cd, MakeConfiguration makeConfiguration, Iterator<String> it) {
        String confName;
        FileObject nbPrivateProjectFileObject = cd.getNbPrivateProjectFileObject();
        FileObject properties = nbPrivateProjectFileObject.getFileObject((confName = makeConfiguration.getName()) + "." + STORAGE_SUFFIX);
        if (properties == null) {
            try {
                properties = FileUtil.createData((FileObject)nbPrivateProjectFileObject, (String)(confName + "." + STORAGE_SUFFIX));
            }
            catch (IOException ex) {
                BuildProjectActionHandler.logger.log(Level.WARNING, NbBundle.getMessage(CompileSupport.class, (String)"CANNOT_SAVE_COMPILE_LINES"), nbPrivateProjectFileObject.getPath() + "/" + confName + "." + STORAGE_SUFFIX);
                return;
            }
        }
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            PrintStream outputStream = null;
            try {
                lock = properties.lock();
                outputStream = new PrintStream(properties.getOutputStream(lock), false, "UTF-8");
                while (it.hasNext()) {
                    String next = it.next();
                    if (next == null || next.length() <= 0) continue;
                    outputStream.println(next);
                }
            }
            catch (IOException ex) {
                BuildProjectActionHandler.logger.log(Level.WARNING, NbBundle.getMessage(CompileSupport.class, (String)"CANNOT_SAVE_COMPILE_LINES"), properties.getPath());
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllOptionsProvider getOptions(MakeConfigurationDescriptor cd, String confName, String itemPath) {
        FileObject nbPrivateProjectFileObject = cd.getNbPrivateProjectFileObject();
        FileObject properties = nbPrivateProjectFileObject.getFileObject(confName + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(properties.getInputStream(), "UTF-8"));
                String line = null;
                String normItemPath = null;
                if (itemPath.indexOf(92) >= 0) {
                    normItemPath = itemPath.replace('\\', '/');
                }
                while ((line = in.readLine()) != null && !(line.startsWith(itemPath) ? line.startsWith(itemPath + "=") : normItemPath != null && line.startsWith(normItemPath) && line.startsWith(normItemPath + "="))) {
                }
                if (line != null) {
                    final String resLine = line.substring(line.indexOf(61) + 1);
                    AllOptionsProvider allOptionsProvider = new AllOptionsProvider(){

                        public String getAllOptions(Tool tool) {
                            return resLine;
                        }
                    };
                    return allOptionsProvider;
                }
            }
            catch (IOException ex) {
                BuildProjectActionHandler.logger.log(Level.WARNING, NbBundle.getMessage(CompileSupport.class, (String)"CANNOT_READ_COMPILE_LINES"), properties.getPath());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

