/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsGenWSDLCookie;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ProjectFileExplorer;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JaxWsGenWSDLImpl
implements JaxWsGenWSDLCookie {
    private Project project;
    private String serviceName;

    public JaxWsGenWSDLImpl(Project project, String serviceName) {
        this.project = project;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateWSDL() throws IOException {
        ProjectFileExplorer projectExplorer = new ProjectFileExplorer();
        DialogDescriptor descriptor = new DialogDescriptor((Object)projectExplorer, NbBundle.getMessage(JaxWsGenWSDLImpl.class, (String)"TTL_GenCopyWSDL"));
        projectExplorer.setDescriptor(descriptor);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.getAccessibleContext().setAccessibleDescription(dlg.getTitle());
        dlg.setVisible(true);
        if (descriptor.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsgen-" + this.serviceName}, null);
                wsimportTask.waitFinished();
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (!projectExplorer.dontCopy()) {
                JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                AntProjectHelper helper = wss.getAntProjectHelper();
                EditableProperties props = helper.getProperties("nbproject/project.properties");
                String propValue = props.get((Object)"build.generated.sources.dir");
                PropertyEvaluator evaluator = helper.getStandardPropertyEvaluator();
                String buildGenDir = evaluator.evaluate(propValue);
                String relativePath = buildGenDir + File.separator + "jax-ws" + File.separator + "resources";
                relativePath = Pattern.compile("\\\\").matcher(relativePath).replaceAll("/");
                FileObject wsdlDir = this.project.getProjectDirectory().getFileObject(relativePath);
                if (wsdlDir != null && wsdlDir.getChildren().length > 0) {
                    FileObject[] wsdlArtifacts = wsdlDir.getChildren();
                    FileObject selectedFolder = projectExplorer.getSelectedFolder().getPrimaryFile();
                    for (int i = 0; i < wsdlArtifacts.length; ++i) {
                        boolean overwrite = true;
                        try {
                            FileObject wsdlArtifact = wsdlArtifacts[i];
                            FileObject testFO = selectedFolder.getFileObject(wsdlArtifact.getNameExt());
                            if (testFO != null) {
                                NotifyDescriptor.Confirmation notifyDescriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsGenWSDLImpl.class, (String)"MSG_FILE_EXISTS", (Object)testFO.getNameExt(), (Object)selectedFolder.getName()), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
                                if (notifyDescriptor.getValue() == NotifyDescriptor.YES_OPTION) {
                                    FileLock lock = null;
                                    try {
                                        lock = testFO.lock();
                                        testFO.delete(lock);
                                    }
                                    finally {
                                        if (lock != null) {
                                            lock.releaseLock();
                                        }
                                    }
                                } else {
                                    overwrite = false;
                                }
                            }
                            if (!overwrite) continue;
                            FileUtil.copyFile((FileObject)wsdlArtifact, (FileObject)selectedFolder, (String)wsdlArtifact.getName());
                            continue;
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                } else {
                    String mes = NbBundle.getMessage(JaxWsGenWSDLImpl.class, (String)"ERROR_WSDL_NOT_FOUND");
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        }
    }
}

