/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.api;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.indent.CppIndentTask;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class FormattingSupport {
    private FormattingSupport() {
    }

    public static String getLineIndentation(Document doc, int caretOffset) {
        int indent = new CppIndentTask(doc).getLineIndentation(caretOffset);
        StringBuilder sb = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getFormattedText(Document doc, int caretOffset, CharSequence textToFormat) {
        if (doc == null) {
            System.err.println("original document is not specified for getFormattedText");
            return textToFormat;
        }
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        if (!MIMENames.isHeaderOrCppOrC((String)mimeType)) {
            System.err.println("Unsupported MIME type of document " + doc);
            return textToFormat;
        }
        String ext = MIMEExtensions.get((String)mimeType).getDefaultExtension();
        try {
            FileSystem fs = FileUtil.createMemoryFileSystem();
            FileObject root = fs.getRoot();
            String fileName = FileUtil.findFreeFileName((FileObject)root, (String)"cnd-format", (String)ext);
            FileObject data = FileUtil.createData((FileObject)root, (String)(fileName + "." + ext));
            OutputStreamWriter writer = new OutputStreamWriter(data.getOutputStream(), "UTF8");
            try {
                ((Writer)writer).append(textToFormat);
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
            DataObject dob = DataObject.find((FileObject)data);
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                int start;
                final StyledDocument fmtDoc = ec.openDocument();
                final Reformat fmt = Reformat.get((Document)fmtDoc);
                fmt.lock();
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fmt.reformat(0, fmtDoc.getLength());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    };
                    if (fmtDoc instanceof BaseDocument) {
                        ((BaseDocument)fmtDoc).runAtomic(runnable);
                    } else {
                        runnable.run();
                    }
                }
                finally {
                    fmt.unlock();
                }
                SaveCookie save = (SaveCookie)dob.getLookup().lookup(SaveCookie.class);
                if (save != null) {
                    save.save();
                }
                String text = fmtDoc.getText(0, fmtDoc.getLength());
                StringBuilder declText = new StringBuilder();
                int len = text.length();
                int end = len - 1;
                for (start = 0; start < len && Character.isWhitespace(text.charAt(start)); ++start) {
                }
                while (end > start && Character.isWhitespace(text.charAt(end))) {
                    --end;
                }
                String indent = FormattingSupport.getLineIndentation(doc, caretOffset);
                declText.append(indent);
                for (int i = start; i <= end; ++i) {
                    char charAt = text.charAt(i);
                    if (charAt == '\n') {
                        if (i > end) continue;
                        declText.append(charAt);
                        declText.append(indent);
                        continue;
                    }
                    declText.append(charAt);
                }
                return declText.toString();
            }
            data.delete();
        }
        catch (BadLocationException fs) {
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return textToFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getIndentedText(Document doc, final int caretOffset, CharSequence textToFormat) {
        if (doc == null) {
            System.err.println("original document is not specified for getFormattedText");
            return textToFormat;
        }
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        if (!MIMENames.isHeaderOrCppOrC((String)mimeType)) {
            System.err.println("Unsupported MIME type of document " + doc);
            return textToFormat;
        }
        String ext = MIMEExtensions.get((String)mimeType).getDefaultExtension();
        try {
            FileSystem fs = FileUtil.createMemoryFileSystem();
            FileObject root = fs.getRoot();
            String fileName = FileUtil.findFreeFileName((FileObject)root, (String)"cnd-format", (String)ext);
            FileObject data = FileUtil.createData((FileObject)root, (String)(fileName + "." + ext));
            OutputStreamWriter writer = new OutputStreamWriter(data.getOutputStream(), "UTF8");
            try {
                ((Writer)writer).append(doc.getText(0, caretOffset));
                ((Writer)writer).append(textToFormat);
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
            DataObject dob = DataObject.find((FileObject)data);
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                final StyledDocument fmtDoc = ec.openDocument();
                final Indent fmt = Indent.get((Document)fmtDoc);
                fmt.lock();
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fmt.reindent(caretOffset + 1, fmtDoc.getLength());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    };
                    if (fmtDoc instanceof BaseDocument) {
                        ((BaseDocument)fmtDoc).runAtomic(runnable);
                    } else {
                        runnable.run();
                    }
                }
                finally {
                    fmt.unlock();
                }
                SaveCookie save = (SaveCookie)dob.getLookup().lookup(SaveCookie.class);
                if (save != null) {
                    save.save();
                }
                return fmtDoc.getText(caretOffset, fmtDoc.getLength() - caretOffset);
            }
            data.delete();
        }
        catch (BadLocationException fs) {
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return textToFormat;
    }
}

