/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.TemplatesPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TemplateSelector
implements ActionListener {
    private static final String KEY_AUTO_FILL = "vcstemplate.autofill";
    private static final String KEY_TEMPLATE = "vcstemplate.value";
    private static final String KEY_TEMPLATE_FILE = "vcstemplate.templatefile";
    private TemplatesPanel panel;
    private final Preferences preferences;

    public TemplateSelector(Preferences preferences) {
        this.preferences = preferences;
    }

    @Deprecated
    public boolean show() {
        return this.show(TemplatesPanel.class.getName());
    }

    public boolean show(String helpCtxId) {
        this.getPanel().autoFillInCheckBox.setSelected(this.isAutofill());
        this.getPanel().templateTextArea.setText(this.getTemplate());
        if (this.showPanel(helpCtxId)) {
            this.setAutofill(this.getPanel().autoFillInCheckBox.isSelected());
            this.setTemplate(this.getPanel().templateTextArea.getText());
            return true;
        }
        return false;
    }

    private boolean showPanel(String helpCtxId) {
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.getPanel(), NbBundle.getMessage(TemplateSelector.class, (String)"CTL_TemplateTitle"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(helpCtxId), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == DialogDescriptor.OK_OPTION;
    }

    private TemplatesPanel getPanel() {
        if (this.panel == null) {
            this.panel = new TemplatesPanel();
            this.panel.openButton.addActionListener(this);
            this.panel.saveButton.addActionListener(this);
        }
        return this.panel;
    }

    public boolean isAutofill() {
        return this.preferences.getBoolean(KEY_AUTO_FILL, false);
    }

    public String getTemplate() {
        return this.preferences.get(KEY_TEMPLATE, "");
    }

    private void setAutofill(boolean bl) {
        this.preferences.putBoolean(KEY_AUTO_FILL, bl);
    }

    private void setTemplate(String template) {
        this.preferences.put(KEY_TEMPLATE, template);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getPanel().openButton) {
            this.onOpen();
        } else if (e.getSource() == this.getPanel().saveButton) {
            this.onSave();
        }
    }

    private void onOpen() {
        File file = this.selectFile(0, NbBundle.getMessage(TemplateSelector.class, (String)"CTL_Load"));
        if (file == null) {
            return;
        }
        try {
            byte[] bytes = TemplateSelector.getFileContentsAsByteArray(file);
            if (bytes != null) {
                this.getPanel().templateTextArea.setText(new String(bytes));
            }
        }
        catch (IOException ex) {
            Utils.logError(TemplatesPanel.class, ex);
        }
        this.preferences.put(KEY_TEMPLATE_FILE, file.getAbsolutePath());
    }

    private void onSave() {
        File file = this.selectFile(1, NbBundle.getMessage(TemplateSelector.class, (String)"CTL_Save"));
        if (file == null) {
            return;
        }
        String template = this.getPanel().templateTextArea.getText();
        try {
            FileUtils.copyStreamToFile(new ByteArrayInputStream(template.getBytes()), file);
        }
        catch (IOException ex) {
            Utils.logError(TemplatesPanel.class, ex);
        }
        this.preferences.put(KEY_TEMPLATE_FILE, file.getAbsolutePath());
    }

    private File selectFile(int dialogType, String approveButtonText) {
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(TemplateSelector.class, (String)"ACSD_SelectTemplate"));
        fileChooser.setDialogTitle(NbBundle.getMessage(TemplateSelector.class, (String)"CTL_SelectTemplate"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogType(dialogType);
        File file = this.getTemplateFile();
        if (file.isFile()) {
            fileChooser.setSelectedFile(file);
        } else {
            fileChooser.setCurrentDirectory(file);
        }
        fileChooser.showDialog(this.getPanel(), approveButtonText);
        File f = fileChooser.getSelectedFile();
        return f;
    }

    private File getTemplateFile() {
        File file = null;
        String tmpFile = this.preferences.get(KEY_TEMPLATE_FILE, null);
        if (tmpFile != null) {
            file = new File(tmpFile);
        }
        if (file == null) {
            file = new File(System.getProperty("user.home"));
        }
        return file;
    }

    private static byte[] getFileContentsAsByteArray(File file) throws IOException {
        long length = file.length();
        if (length > 10240L) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(TemplateSelector.class, (String)"MSG_FileTooBig"), NbBundle.getMessage(TemplateSelector.class, (String)"LBL_FileTooBig"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
            if (DialogDisplayer.getDefault().notify(nd) != NotifyDescriptor.OK_OPTION) {
                return null;
            }
        }
        return FileUtils.getFileContentsAsByteArray(file);
    }
}

