/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.netbeans.modules.versioning.util.UndoRedoSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public abstract class VCSCommitParameters {
    private static final String PARAMETERS_CHANGED_PROPERTY = "VCSCommitParameters.changed";
    private static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private static final String LAST_COMMIT_MESSAGE = "lastCommitMessage";
    private JLabel recentLink;
    private JLabel templateLink;
    private Preferences preferences;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public VCSCommitParameters(Preferences preferences) {
        this.preferences = preferences;
    }

    public abstract JPanel getPanel();

    public abstract boolean isCommitable();

    public abstract String getErrorMessage();

    protected Preferences getPreferences() {
        return this.preferences;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    protected void fireChange() {
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public static JLabel createRecentMessagesLink(final JTextArea text, final Preferences preferences) {
        JLabel recentLink = new JLabel();
        recentLink.setIcon(new ImageIcon(VCSCommitParameters.class.getResource("/org/netbeans/modules/versioning/util/resources/recent_messages.png")));
        recentLink.setToolTipText(VCSCommitParameters.getMessage("CTL_CommitForm_RecentMessages"));
        recentLink.setCursor(Cursor.getPredefinedCursor(12));
        recentLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VCSCommitParameters.onBrowseRecentMessages(text, preferences);
            }
        });
        return recentLink;
    }

    protected JLabel getRecentMessagesLink(JTextArea text) {
        if (this.recentLink == null) {
            this.recentLink = VCSCommitParameters.createRecentMessagesLink(text, this.preferences);
        }
        return this.recentLink;
    }

    protected static JLabel createMessagesTemplateLink(final JTextArea text, final Preferences preferences, final String helpCtxId) {
        JLabel templateLink = new JLabel();
        templateLink.setIcon(new ImageIcon(VCSCommitParameters.class.getResource("/org/netbeans/modules/versioning/util/resources/load_template.png")));
        templateLink.setToolTipText(VCSCommitParameters.getMessage("CTL_CommitForm_LoadTemplate"));
        templateLink.setCursor(Cursor.getPredefinedCursor(12));
        templateLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VCSCommitParameters.onTemplate(text, preferences, helpCtxId);
            }
        });
        return templateLink;
    }

    protected JLabel getMessagesTemplateLink(JTextArea text, String helpCtxId) {
        if (this.templateLink == null) {
            this.templateLink = VCSCommitParameters.createMessagesTemplateLink(text, this.preferences, helpCtxId);
        }
        return this.templateLink;
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(VCSCommitParameters.class, (String)msgKey);
    }

    private static void onBrowseRecentMessages(JTextArea text, Preferences preferences) {
        StringSelector.RecentMessageSelector selector = new StringSelector.RecentMessageSelector(preferences);
        String message = selector.getRecentMessage(VCSCommitParameters.getMessage("CTL_CommitForm_RecentTitle"), VCSCommitParameters.getMessage("CTL_CommitForm_RecentPrompt"), VCSCommitParameters.getRecentCommitMessages(preferences));
        if (message != null) {
            text.replaceSelection(message);
        }
    }

    private static void onTemplate(JTextArea text, Preferences preferences, String helpCtxId) {
        TemplateSelector ts = new TemplateSelector(preferences);
        if (ts.show(helpCtxId)) {
            text.setText(ts.getTemplate());
        }
    }

    protected String getLastCanceledCommitMessage() {
        return this.preferences.get(LAST_COMMIT_MESSAGE, "");
    }

    protected static List<String> getRecentCommitMessages(Preferences preferences) {
        return Utils.getStringList(preferences, RECENT_COMMIT_MESSAGES);
    }

    protected Component makeVerticalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated, JPanel parent) {
        return VCSCommitPanel.makeVerticalStrut(compA, compB, relatedUnrelated, parent);
    }

    protected static Component makeHorizontalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated, JPanel parent) {
        return VCSCommitPanel.makeHorizontalStrut(compA, compB, relatedUnrelated, parent);
    }

    public static class DefaultCommitParameters
    extends VCSCommitParameters {
        private JPanel panel;
        private String commitMessage;

        public DefaultCommitParameters(Preferences preferences, String commitMessage) {
            super(preferences);
            this.commitMessage = commitMessage;
        }

        public DefaultCommitParameters(Preferences preferences) {
            super(preferences);
        }

        @Override
        public JPanel getPanel() {
            if (this.panel == null) {
                this.panel = this.createPanel();
            }
            return this.panel;
        }

        protected JPanel createPanel() {
            return new ParametersPanel();
        }

        public String getCommitMessage() {
            return ((ParametersPanel)this.getPanel()).messageTextArea.getText();
        }

        @Override
        public boolean isCommitable() {
            return true;
        }

        @Override
        public String getErrorMessage() {
            return "";
        }

        public void storeCommitMessage() {
            Utils.insert(this.getPreferences(), VCSCommitParameters.RECENT_COMMIT_MESSAGES, this.getCommitMessage().trim(), 20);
        }

        private class ParametersPanel
        extends JPanel {
            private JScrollPane scrollpane = new JScrollPane();
            private final JLabel messageLabel = new JLabel();
            private final JTextArea messageTextArea = new JTextArea();
            private UndoRedoSupport um;

            public ParametersPanel() {
                this.messageLabel.setLabelFor(this.messageTextArea);
                Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.getMessage("CTL_CommitForm_Message"));
                JLabel templateLink = DefaultCommitParameters.this.getMessagesTemplateLink(this.messageTextArea, "org.netbeans.modules.versioning.util.common.TemplatePanel");
                JLabel recentLink = DefaultCommitParameters.this.getRecentMessagesLink(this.messageTextArea);
                this.messageTextArea.setColumns(60);
                this.messageTextArea.setLineWrap(true);
                this.messageTextArea.setRows(4);
                this.messageTextArea.setTabSize(4);
                this.messageTextArea.setWrapStyleWord(true);
                this.messageTextArea.setMinimumSize(new Dimension(100, 18));
                this.scrollpane.setViewportView(this.messageTextArea);
                this.messageTextArea.getAccessibleContext().setAccessibleName(this.getMessage("ACSN_CommitForm_Message"));
                this.messageTextArea.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CommitForm_Message"));
                if (DefaultCommitParameters.this.commitMessage != null) {
                    this.messageTextArea.setText(DefaultCommitParameters.this.commitMessage);
                }
                VerticallyNonResizingPanel topPanel = new VerticallyNonResizingPanel();
                topPanel.setLayout(new BoxLayout(topPanel, 0));
                topPanel.add(this.messageLabel);
                topPanel.add(Box.createHorizontalGlue());
                topPanel.add(recentLink);
                topPanel.add(VCSCommitParameters.makeHorizontalStrut(recentLink, templateLink, LayoutStyle.ComponentPlacement.RELATED, this));
                topPanel.add(templateLink);
                this.messageLabel.setAlignmentX(0.0f);
                this.messageLabel.setAlignmentY(1.0f);
                recentLink.setAlignmentY(1.0f);
                templateLink.setAlignmentY(1.0f);
                this.setLayout(new BoxLayout(this, 1));
                topPanel.setAlignmentY(1.0f);
                this.add(topPanel);
                this.add(DefaultCommitParameters.this.makeVerticalStrut(this.messageLabel, this.scrollpane, LayoutStyle.ComponentPlacement.RELATED, this));
                this.add(this.scrollpane);
                Spellchecker.register((JTextComponent)this.messageTextArea);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                TemplateSelector ts = new TemplateSelector(DefaultCommitParameters.this.getPreferences());
                if (ts.isAutofill()) {
                    this.messageTextArea.setText(ts.getTemplate());
                } else {
                    List<String> messages;
                    String lastCommitMessage = DefaultCommitParameters.this.getLastCanceledCommitMessage();
                    if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(DefaultCommitParameters.this.getPreferences()).isAutoFill() && (messages = VCSCommitParameters.getRecentCommitMessages(DefaultCommitParameters.this.getPreferences())).size() > 0) {
                        lastCommitMessage = messages.get(0);
                    }
                    this.messageTextArea.setText(lastCommitMessage);
                }
                this.messageTextArea.selectAll();
                this.um = UndoRedoSupport.register(this.messageTextArea);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                if (this.um != null) {
                    this.um.unregister();
                    this.um = null;
                }
            }

            private String getMessage(String msgKey) {
                return NbBundle.getMessage(ParametersPanel.class, (String)msgKey);
            }
        }
    }
}

