/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.javaee.project.api.ui.UserProjectSettings;
import org.netbeans.modules.maven.j2ee.ui.wizard.Bundle;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.modules.SpecificationVersion;

public abstract class BaseWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator {
    protected transient WizardDescriptor wiz;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    protected abstract WizardDescriptor.Panel[] createPanels(ValidationGroup var1);

    protected void saveSettingsToNbConfiguration(Project project) throws IOException {
        String instanceID = (String)this.wiz.getProperty("netbeans.deployment.server.id");
        String serverID = (String)this.wiz.getProperty("netbeans.hint.deploy.server");
        String j2eeVersion = (String)this.wiz.getProperty("netbeans.hint.j2eeVersion");
        Profile j2eeProfile = Profile.fromPropertiesString((String)j2eeVersion);
        if (j2eeProfile != null) {
            JavaEEProjectSettings.setProfile((Project)project, (Profile)j2eeProfile);
        }
        if (instanceID != null) {
            UserProjectSettings.getDefault().setLastUsedServer(instanceID);
        }
        MavenProjectSupport.setServerID(project, serverID);
        JavaEEProjectSettings.setServerInstanceID((Project)project, (String)instanceID);
        MavenProjectSupport.createWebXMLIfRequired(project, serverID);
        if (j2eeVersion != null && j2eeVersion.contains("1.7")) {
            JavaPlatform platform = this.findJDK7Platform();
            AuxiliaryProperties properties = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
            if (platform == null || platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform())) {
                properties.put("netbeans.hint.jdkPlatform", null, true);
            } else {
                properties.put("netbeans.hint.jdkPlatform", platform.getDisplayName(), true);
            }
        }
    }

    private JavaPlatform findJDK7Platform() {
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        List<JavaPlatform> jdk7Platforms = this.getJdk7Platforms();
        if (jdk7Platforms.contains(defaultPlatform)) {
            return defaultPlatform;
        }
        Iterator<JavaPlatform> iterator = jdk7Platforms.iterator();
        if (iterator.hasNext()) {
            JavaPlatform platform = iterator.next();
            return platform;
        }
        return null;
    }

    private List<JavaPlatform> getJdk7Platforms() {
        ArrayList<JavaPlatform> jdk7platforms = new ArrayList<JavaPlatform>();
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            SpecificationVersion version = platform.getSpecification().getVersion();
            if (!"1.7".equals(version.toString())) continue;
            jdk7platforms.add(platform);
        }
        return jdk7platforms;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = this.createPanels(vg);
        this.updateSteps();
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
        this.listeners.clear();
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            for (ChangeListener list2 : this.listeners) {
                list2.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private void updateSteps() {
        String[] steps = new String[this.panels.length];
        String[] basicOnes = this.createSteps();
        System.arraycopy(basicOnes, 0, steps, 0, basicOnes.length);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (i >= basicOnes.length || steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private String[] createSteps() {
        return new String[]{Bundle.LBL_CreateProjectStep2ee(), Bundle.LBL_EESettings()};
    }
}

