/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.gsm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class IMSICondition {
    private static final String ORG_OSGI_UTIL_GSM_IMSI = "org.osgi.util.gsm.imsi";
    private static final String IMSI = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty(IMSICondition.ORG_OSGI_UTIL_GSM_IMSI);
        }
    });
    private static final int IMSI_LENGTH = 15;

    private IMSICondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        String imsi = conditionInfo.getArgs()[0];
        int length = imsi.length();
        if (length > 15) {
            throw new IllegalArgumentException("IMSI too long: " + imsi);
        }
        if (imsi.endsWith("*")) {
            imsi = imsi.substring(0, --length);
        } else if (length < 15) {
            throw new IllegalArgumentException("IMSI too short: " + imsi);
        }
        for (int i = 0; i < length; ++i) {
            char c = imsi.charAt(i);
            if ('0' <= c && c <= '9') continue;
            throw new IllegalArgumentException("not a valid IMSI: " + imsi);
        }
        if (IMSI == null) {
            System.err.println("The OSGi implementation of org.osgi.util.gsm.IMSICondition needs the system property org.osgi.util.gsm.imsi set.");
            return Condition.FALSE;
        }
        return IMSI.startsWith(imsi) ? Condition.TRUE : Condition.FALSE;
    }
}

